/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CallException
extends RuntimeException
implements Parcelable {
    public static final String TRANSACTION_EXCEPTION_KEY = "TelecomTransactionalExceptionKey";
    public static final int CODE_ERROR_UNKNOWN = 1;
    public static final int CODE_CANNOT_HOLD_CURRENT_ACTIVE_CALL = 2;
    public static final int CODE_CALL_IS_NOT_BEING_TRACKED = 3;
    public static final int CODE_CALL_CANNOT_BE_SET_TO_ACTIVE = 4;
    public static final int CODE_CALL_NOT_PERMITTED_AT_PRESENT_TIME = 5;
    public static final int CODE_OPERATION_TIMED_OUT = 6;
    private int mCode = 1;
    private final String mMessage;
    public static final Parcelable.Creator<CallException> CREATOR = new Parcelable.Creator<CallException>(){

        @Override
        public CallException createFromParcel(Parcel source) {
            return new CallException(source.readString8(), source.readInt());
        }

        public CallException[] newArray(int size) {
            return new CallException[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mMessage);
        dest.writeInt(this.mCode);
    }

    public CallException(String message, int code) {
        super(CallException.getMessage(message, code));
        this.mCode = code;
        this.mMessage = message;
    }

    public int getCode() {
        return this.mCode;
    }

    private static String getMessage(String message, int code) {
        if (!TextUtils.isEmpty(message)) {
            StringBuilder builder = new StringBuilder(message);
            builder.append(" (code: ");
            builder.append(code);
            builder.append(")");
            return builder.toString();
        }
        return "code: " + code;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CallErrorCode {
    }
}

