/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ims.ImsReasonInfo;
import android.text.TextUtils;
import java.util.Objects;

public class DisconnectCause
implements Parcelable {
    public static final int UNKNOWN = 0;
    public static final int ERROR = 1;
    public static final int LOCAL = 2;
    public static final int REMOTE = 3;
    public static final int CANCELED = 4;
    public static final int MISSED = 5;
    public static final int REJECTED = 6;
    public static final int BUSY = 7;
    public static final int RESTRICTED = 8;
    public static final int OTHER = 9;
    public static final int CONNECTION_MANAGER_NOT_SUPPORTED = 10;
    public static final int ANSWERED_ELSEWHERE = 11;
    public static final int CALL_PULLED = 12;
    public static final String REASON_WIFI_ON_BUT_WFC_OFF = "REASON_WIFI_ON_BUT_WFC_OFF";
    public static final String REASON_IMS_ACCESS_BLOCKED = "REASON_IMS_ACCESS_BLOCKED";
    public static final String REASON_EMULATING_SINGLE_CALL = "EMULATING_SINGLE_CALL";
    public static final String REASON_EMERGENCY_CALL_PLACED = "REASON_EMERGENCY_CALL_PLACED";
    private int mDisconnectCode;
    private CharSequence mDisconnectLabel;
    private CharSequence mDisconnectDescription;
    private String mDisconnectReason;
    private int mToneToPlay;
    private int mTelephonyDisconnectCause;
    private int mTelephonyPreciseDisconnectCause;
    private ImsReasonInfo mImsReasonInfo;
    public static final Parcelable.Creator<DisconnectCause> CREATOR = new Parcelable.Creator<DisconnectCause>(){

        @Override
        public DisconnectCause createFromParcel(Parcel source) {
            int code = source.readInt();
            CharSequence label = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            CharSequence description = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            String reason = source.readString();
            int tone = source.readInt();
            int telephonyDisconnectCause = source.readInt();
            int telephonyPreciseDisconnectCause = source.readInt();
            ImsReasonInfo imsReasonInfo = source.readParcelable(null, ImsReasonInfo.class);
            return new DisconnectCause(code, label, description, reason, tone, telephonyDisconnectCause, telephonyPreciseDisconnectCause, imsReasonInfo);
        }

        public DisconnectCause[] newArray(int size) {
            return new DisconnectCause[size];
        }
    };

    public DisconnectCause(int code) {
        this(code, null, null, null, -1);
    }

    public DisconnectCause(int code, String reason) {
        this(code, null, null, reason, -1);
    }

    public DisconnectCause(int code, CharSequence label, CharSequence description, String reason) {
        this(code, label, description, reason, -1);
    }

    public DisconnectCause(int code, CharSequence label, CharSequence description, String reason, int toneToPlay) {
        this(code, label, description, reason, toneToPlay, 36, 65535, null);
    }

    public DisconnectCause(int code, CharSequence label, CharSequence description, String reason, int toneToPlay, int telephonyDisconnectCause, int telephonyPreciseDisconnectCause, ImsReasonInfo imsReasonInfo) {
        this.mDisconnectCode = code;
        this.mDisconnectLabel = label;
        this.mDisconnectDescription = description;
        this.mDisconnectReason = reason;
        this.mToneToPlay = toneToPlay;
        this.mTelephonyDisconnectCause = telephonyDisconnectCause;
        this.mTelephonyPreciseDisconnectCause = telephonyPreciseDisconnectCause;
        this.mImsReasonInfo = imsReasonInfo;
    }

    public int getCode() {
        return this.mDisconnectCode;
    }

    public CharSequence getLabel() {
        return this.mDisconnectLabel;
    }

    public CharSequence getDescription() {
        return this.mDisconnectDescription;
    }

    public String getReason() {
        return this.mDisconnectReason;
    }

    public int getTelephonyDisconnectCause() {
        return this.mTelephonyDisconnectCause;
    }

    public int getTelephonyPreciseDisconnectCause() {
        return this.mTelephonyPreciseDisconnectCause;
    }

    public ImsReasonInfo getImsReasonInfo() {
        return this.mImsReasonInfo;
    }

    public int getTone() {
        return this.mToneToPlay;
    }

    @Override
    public void writeToParcel(Parcel destination, int flags) {
        destination.writeInt(this.mDisconnectCode);
        TextUtils.writeToParcel(this.mDisconnectLabel, destination, flags);
        TextUtils.writeToParcel(this.mDisconnectDescription, destination, flags);
        destination.writeString(this.mDisconnectReason);
        destination.writeInt(this.mToneToPlay);
        destination.writeInt(this.mTelephonyDisconnectCause);
        destination.writeInt(this.mTelephonyPreciseDisconnectCause);
        destination.writeParcelable(this.mImsReasonInfo, 0);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return Objects.hashCode(this.mDisconnectCode) + Objects.hashCode(this.mDisconnectLabel) + Objects.hashCode(this.mDisconnectDescription) + Objects.hashCode(this.mDisconnectReason) + Objects.hashCode(this.mToneToPlay) + Objects.hashCode(this.mTelephonyDisconnectCause) + Objects.hashCode(this.mTelephonyPreciseDisconnectCause) + Objects.hashCode(this.mImsReasonInfo);
    }

    public boolean equals(Object o) {
        if (o instanceof DisconnectCause) {
            DisconnectCause d = (DisconnectCause)o;
            return Objects.equals(this.mDisconnectCode, d.getCode()) && Objects.equals(this.mDisconnectLabel, d.getLabel()) && Objects.equals(this.mDisconnectDescription, d.getDescription()) && Objects.equals(this.mDisconnectReason, d.getReason()) && Objects.equals(this.mToneToPlay, d.getTone()) && Objects.equals(this.mTelephonyDisconnectCause, d.getTelephonyDisconnectCause()) && Objects.equals(this.mTelephonyPreciseDisconnectCause, d.getTelephonyPreciseDisconnectCause()) && Objects.equals(this.mImsReasonInfo, d.getImsReasonInfo());
        }
        return false;
    }

    public String toString() {
        String code = "";
        switch (this.mDisconnectCode) {
            case 0: {
                code = "UNKNOWN";
                break;
            }
            case 1: {
                code = "ERROR";
                break;
            }
            case 2: {
                code = "LOCAL";
                break;
            }
            case 3: {
                code = "REMOTE";
                break;
            }
            case 4: {
                code = "CANCELED";
                break;
            }
            case 5: {
                code = "MISSED";
                break;
            }
            case 6: {
                code = "REJECTED";
                break;
            }
            case 7: {
                code = "BUSY";
                break;
            }
            case 8: {
                code = "RESTRICTED";
                break;
            }
            case 9: {
                code = "OTHER";
                break;
            }
            case 10: {
                code = "CONNECTION_MANAGER_NOT_SUPPORTED";
                break;
            }
            case 12: {
                code = "CALL_PULLED";
                break;
            }
            case 11: {
                code = "ANSWERED_ELSEWHERE";
                break;
            }
            default: {
                code = "invalid code: " + this.mDisconnectCode;
            }
        }
        String label = this.mDisconnectLabel == null ? "" : this.mDisconnectLabel.toString();
        String description = this.mDisconnectDescription == null ? "" : this.mDisconnectDescription.toString();
        String reason = this.mDisconnectReason == null ? "" : this.mDisconnectReason;
        return "DisconnectCause [ Code: (" + code + ") Label: (" + label + ") Description: (" + description + ") Reason: (" + reason + ") Tone: (" + this.mToneToPlay + ")  TelephonyCause: " + this.mTelephonyDisconnectCause + "/" + this.mTelephonyPreciseDisconnectCause + " ImsReasonInfo: " + this.mImsReasonInfo + "]";
    }
}

