/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;

public class BinderCacheManager<T extends IInterface> {
    private final BinderInterfaceFactory<T> mBinderInterfaceFactory;
    private final AtomicReference<BinderDeathTracker> mCachedConnection;

    public BinderCacheManager(BinderInterfaceFactory<T> factory) {
        this.mBinderInterfaceFactory = factory;
        this.mCachedConnection = new AtomicReference();
    }

    public T listenOnBinder(Object runnableKey, Runnable deadRunnable) {
        if (runnableKey == null || deadRunnable == null) {
            return null;
        }
        BinderDeathTracker tracker = this.getTracker();
        if (tracker == null) {
            return null;
        }
        boolean addSucceeded = tracker.addListener(runnableKey, deadRunnable);
        return addSucceeded ? (T)tracker.getConnection() : null;
    }

    public T getBinder() {
        BinderDeathTracker tracker = this.getTracker();
        return tracker != null ? (T)tracker.getConnection() : null;
    }

    public T removeRunnable(Object runnableKey) {
        if (runnableKey == null) {
            return null;
        }
        BinderDeathTracker tracker = this.getTracker();
        if (tracker == null) {
            return null;
        }
        tracker.removeListener(runnableKey);
        return tracker.getConnection();
    }

    private BinderDeathTracker getTracker() {
        return this.mCachedConnection.updateAndGet(oldVal -> {
            BinderDeathTracker tracker = oldVal;
            if (tracker == null || !tracker.isAlive()) {
                IInterface binder = (IInterface)this.mBinderInterfaceFactory.create();
                tracker = binder != null ? new BinderDeathTracker(this, binder) : null;
            }
            return tracker != null && tracker.isAlive() ? tracker : null;
        });
    }

    public static interface BinderInterfaceFactory<T> {
        public T create();
    }

    private static class BinderDeathTracker
    implements IBinder.DeathRecipient {
        private final T mConnection;
        private final HashMap<Object, Runnable> mListeners = new HashMap();
        final /* synthetic */ BinderCacheManager this$0;

        BinderDeathTracker(T connection) {
            this.this$0 = var1_1;
            this.mConnection = connection;
            try {
                this.mConnection.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addListener(Object key, Runnable r) {
            HashMap<Object, Runnable> hashMap = this.mListeners;
            synchronized (hashMap) {
                if (!this.isAlive()) {
                    return false;
                }
                this.mListeners.put(key, r);
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(Object runnableKey) {
            HashMap<Object, Runnable> hashMap = this.mListeners;
            synchronized (hashMap) {
                this.mListeners.remove(runnableKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ArrayList<Runnable> listeners;
            HashMap<Object, Runnable> hashMap = this.mListeners;
            synchronized (hashMap) {
                listeners = new ArrayList<Runnable>(this.mListeners.values());
                this.mListeners.clear();
                try {
                    this.mConnection.asBinder().unlinkToDeath(this, 0);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            listeners.forEach(Runnable::run);
        }

        public T getConnection() {
            return this.mConnection;
        }

        public boolean isAlive() {
            return this.mConnection.asBinder().isBinderAlive();
        }
    }
}

