/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.service.carrier.CarrierIdentifier;
import android.telephony.TelephonyManager;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

@SystemApi
public class CarrierRestrictionRules
implements Parcelable {
    public static final int CARRIER_RESTRICTION_DEFAULT_NOT_ALLOWED = 0;
    public static final int CARRIER_RESTRICTION_DEFAULT_ALLOWED = 1;
    public static final int MULTISIM_POLICY_NONE = 0;
    public static final int MULTISIM_POLICY_ONE_VALID_SIM_MUST_BE_PRESENT = 1;
    private static final char WILD_CHARACTER = '?';
    private List<CarrierIdentifier> mAllowedCarriers = new ArrayList<CarrierIdentifier>();
    private List<CarrierIdentifier> mExcludedCarriers = new ArrayList<CarrierIdentifier>();
    private int mCarrierRestrictionDefault;
    private int mMultiSimPolicy;
    @TelephonyManager.CarrierRestrictionStatus
    private int mCarrierRestrictionStatus;
    public static final Parcelable.Creator<CarrierRestrictionRules> CREATOR = new Parcelable.Creator<CarrierRestrictionRules>(){

        @Override
        public CarrierRestrictionRules createFromParcel(Parcel in) {
            return new CarrierRestrictionRules(in);
        }

        public CarrierRestrictionRules[] newArray(int size) {
            return new CarrierRestrictionRules[size];
        }
    };

    private CarrierRestrictionRules() {
        this.mCarrierRestrictionDefault = 0;
        this.mMultiSimPolicy = 0;
        this.mCarrierRestrictionStatus = 0;
    }

    private CarrierRestrictionRules(Parcel in) {
        in.readTypedList(this.mAllowedCarriers, CarrierIdentifier.CREATOR);
        in.readTypedList(this.mExcludedCarriers, CarrierIdentifier.CREATOR);
        this.mCarrierRestrictionDefault = in.readInt();
        this.mMultiSimPolicy = in.readInt();
        this.mCarrierRestrictionStatus = in.readInt();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isAllCarriersAllowed() {
        return this.mAllowedCarriers.isEmpty() && this.mExcludedCarriers.isEmpty() && this.mCarrierRestrictionDefault == 1;
    }

    public List<CarrierIdentifier> getAllowedCarriers() {
        return this.mAllowedCarriers;
    }

    public List<CarrierIdentifier> getExcludedCarriers() {
        return this.mExcludedCarriers;
    }

    public int getDefaultCarrierRestriction() {
        return this.mCarrierRestrictionDefault;
    }

    public int getMultiSimPolicy() {
        return this.mMultiSimPolicy;
    }

    public List<Boolean> areCarrierIdentifiersAllowed(List<CarrierIdentifier> carrierIds) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(carrierIds.size());
        for (int i = 0; i < carrierIds.size(); ++i) {
            boolean inAllowedList = CarrierRestrictionRules.isCarrierIdInList(carrierIds.get(i), this.mAllowedCarriers);
            boolean inExcludedList = CarrierRestrictionRules.isCarrierIdInList(carrierIds.get(i), this.mExcludedCarriers);
            if (this.mCarrierRestrictionDefault == 0) {
                result.add(inAllowedList && !inExcludedList);
                continue;
            }
            result.add(!inExcludedList || inAllowedList);
        }
        if (this.mMultiSimPolicy == 1) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                boolean b = (Boolean)iterator.next();
                if (!b) continue;
                result.replaceAll(x -> true);
                break;
            }
        }
        return result;
    }

    private static boolean isCarrierIdInList(CarrierIdentifier id2, List<CarrierIdentifier> list) {
        for (CarrierIdentifier listItem : list) {
            if (!CarrierRestrictionRules.patternMatch(id2.getMcc(), listItem.getMcc()) || !CarrierRestrictionRules.patternMatch(id2.getMnc(), listItem.getMnc())) continue;
            String listItemValue = CarrierRestrictionRules.convertNullToEmpty(listItem.getSpn());
            String idValue = CarrierRestrictionRules.convertNullToEmpty(id2.getSpn());
            if (!listItemValue.isEmpty() && !CarrierRestrictionRules.patternMatch(idValue, listItemValue)) continue;
            listItemValue = CarrierRestrictionRules.convertNullToEmpty(listItem.getImsi());
            idValue = CarrierRestrictionRules.convertNullToEmpty(id2.getImsi());
            if (!CarrierRestrictionRules.patternMatch(idValue.substring(0, Math.min(idValue.length(), listItemValue.length())), listItemValue)) continue;
            listItemValue = CarrierRestrictionRules.convertNullToEmpty(listItem.getGid1());
            idValue = CarrierRestrictionRules.convertNullToEmpty(id2.getGid1());
            if (!CarrierRestrictionRules.patternMatch(idValue.substring(0, Math.min(idValue.length(), listItemValue.length())), listItemValue)) continue;
            listItemValue = CarrierRestrictionRules.convertNullToEmpty(listItem.getGid2());
            idValue = CarrierRestrictionRules.convertNullToEmpty(id2.getGid2());
            if (!CarrierRestrictionRules.patternMatch(idValue.substring(0, Math.min(idValue.length(), listItemValue.length())), listItemValue)) continue;
            return true;
        }
        return false;
    }

    private static String convertNullToEmpty(String value) {
        return Objects.toString(value, "");
    }

    private static boolean patternMatch(String str, String pattern) {
        if (str.length() != pattern.length()) {
            return false;
        }
        String lowerCaseStr = str.toLowerCase(Locale.ROOT);
        String lowerCasePattern = pattern.toLowerCase(Locale.ROOT);
        for (int i = 0; i < lowerCasePattern.length(); ++i) {
            if (lowerCasePattern.charAt(i) == lowerCaseStr.charAt(i) || lowerCasePattern.charAt(i) == '?') continue;
            return false;
        }
        return true;
    }

    public int getCarrierRestrictionStatus() {
        return this.mCarrierRestrictionStatus;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeTypedList(this.mAllowedCarriers);
        out.writeTypedList(this.mExcludedCarriers);
        out.writeInt(this.mCarrierRestrictionDefault);
        out.writeInt(this.mMultiSimPolicy);
        out.writeInt(this.mCarrierRestrictionStatus);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "CarrierRestrictionRules(allowed:" + this.mAllowedCarriers + ", excluded:" + this.mExcludedCarriers + ", default:" + this.mCarrierRestrictionDefault + ", multisim policy:" + this.mMultiSimPolicy + ")";
    }

    public static class Builder {
        private final CarrierRestrictionRules mRules = new CarrierRestrictionRules();

        public CarrierRestrictionRules build() {
            return this.mRules;
        }

        public Builder setAllCarriersAllowed() {
            this.mRules.mAllowedCarriers.clear();
            this.mRules.mExcludedCarriers.clear();
            this.mRules.mCarrierRestrictionDefault = 1;
            return this;
        }

        public Builder setAllowedCarriers(List<CarrierIdentifier> allowedCarriers) {
            this.mRules.mAllowedCarriers = new ArrayList<CarrierIdentifier>(allowedCarriers);
            return this;
        }

        public Builder setExcludedCarriers(List<CarrierIdentifier> excludedCarriers) {
            this.mRules.mExcludedCarriers = new ArrayList<CarrierIdentifier>(excludedCarriers);
            return this;
        }

        public Builder setDefaultCarrierRestriction(int carrierRestrictionDefault) {
            this.mRules.mCarrierRestrictionDefault = carrierRestrictionDefault;
            return this;
        }

        public Builder setMultiSimPolicy(int multiSimPolicy) {
            this.mRules.mMultiSimPolicy = multiSimPolicy;
            return this;
        }

        public Builder setCarrierRestrictionStatus(int carrierRestrictionStatus) {
            this.mRules.mCarrierRestrictionStatus = carrierRestrictionStatus;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CarrierRestrictionDefault {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MultiSimPolicy {
    }
}

