/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class LinkCapacityEstimate
implements Parcelable {
    public static final int INVALID = -1;
    public static final int LCE_TYPE_PRIMARY = 0;
    public static final int LCE_TYPE_SECONDARY = 1;
    public static final int LCE_TYPE_COMBINED = 2;
    private final int mType;
    private final int mDownlinkCapacityKbps;
    private final int mUplinkCapacityKbps;
    public static final Parcelable.Creator<LinkCapacityEstimate> CREATOR = new Parcelable.Creator(){

        public LinkCapacityEstimate createFromParcel(Parcel in) {
            return new LinkCapacityEstimate(in);
        }

        public LinkCapacityEstimate[] newArray(int size) {
            return new LinkCapacityEstimate[size];
        }
    };

    public LinkCapacityEstimate(int type, int downlinkCapacityKbps, int uplinkCapacityKbps) {
        this.mDownlinkCapacityKbps = downlinkCapacityKbps;
        this.mUplinkCapacityKbps = uplinkCapacityKbps;
        this.mType = type;
    }

    public LinkCapacityEstimate(Parcel in) {
        this.mDownlinkCapacityKbps = in.readInt();
        this.mUplinkCapacityKbps = in.readInt();
        this.mType = in.readInt();
    }

    public int getType() {
        return this.mType;
    }

    public int getDownlinkCapacityKbps() {
        return this.mDownlinkCapacityKbps;
    }

    public int getUplinkCapacityKbps() {
        return this.mUplinkCapacityKbps;
    }

    public String toString() {
        return "{mType=" + this.mType + ", mDownlinkCapacityKbps=" + this.mDownlinkCapacityKbps + ", mUplinkCapacityKbps=" + this.mUplinkCapacityKbps + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDownlinkCapacityKbps);
        dest.writeInt(this.mUplinkCapacityKbps);
        dest.writeInt(this.mType);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof LinkCapacityEstimate) || this.hashCode() != o.hashCode()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        LinkCapacityEstimate that = (LinkCapacityEstimate)o;
        return this.mDownlinkCapacityKbps == that.mDownlinkCapacityKbps && this.mUplinkCapacityKbps == that.mUplinkCapacityKbps && this.mType == that.mType;
    }

    public int hashCode() {
        return Objects.hash(this.mDownlinkCapacityKbps, this.mUplinkCapacityKbps, this.mType);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LceType {
    }
}

