/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.ActivityStatsTechSpecificInfo;
import android.util.Range;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class ModemActivityInfo
implements Parcelable {
    private static final int TX_POWER_LEVELS = 5;
    public static final int TX_POWER_LEVEL_0 = 0;
    public static final int TX_POWER_LEVEL_1 = 1;
    public static final int TX_POWER_LEVEL_2 = 2;
    public static final int TX_POWER_LEVEL_3 = 3;
    public static final int TX_POWER_LEVEL_4 = 4;
    private static final Range<Integer>[] TX_POWER_RANGES = new Range[]{new Range<Integer>(Integer.MIN_VALUE, 0), new Range<Integer>(0, 5), new Range<Integer>(5, 15), new Range<Integer>(15, 20), new Range<Integer>(20, Integer.MAX_VALUE)};
    private long mTimestamp;
    private int mSleepTimeMs;
    private int mIdleTimeMs;
    private int[] mTotalTxTimeMs;
    private int mTotalRxTimeMs;
    private int mSizeOfSpecificInfo;
    private ActivityStatsTechSpecificInfo[] mActivityStatsTechSpecificInfo;
    public static final Parcelable.Creator<ModemActivityInfo> CREATOR = new Parcelable.Creator<ModemActivityInfo>(){

        @Override
        public ModemActivityInfo createFromParcel(Parcel in) {
            long timestamp = in.readLong();
            int sleepTimeMs = in.readInt();
            int idleTimeMs = in.readInt();
            Parcelable[] tempSpecifiers = in.createTypedArray(ActivityStatsTechSpecificInfo.CREATOR);
            ActivityStatsTechSpecificInfo[] activityStatsTechSpecificInfo = new ActivityStatsTechSpecificInfo[tempSpecifiers.length];
            for (int i = 0; i < tempSpecifiers.length; ++i) {
                activityStatsTechSpecificInfo[i] = (ActivityStatsTechSpecificInfo)tempSpecifiers[i];
            }
            return new ModemActivityInfo(timestamp, sleepTimeMs, idleTimeMs, activityStatsTechSpecificInfo);
        }

        public ModemActivityInfo[] newArray(int size) {
            return new ModemActivityInfo[size];
        }
    };

    public static int getNumTxPowerLevels() {
        return 5;
    }

    public ModemActivityInfo(long timestamp, int sleepTimeMs, int idleTimeMs, int[] txTimeMs, int rxTimeMs) {
        Objects.requireNonNull(txTimeMs);
        if (txTimeMs.length != 5) {
            throw new IllegalArgumentException("txTimeMs must have length == TX_POWER_LEVELS");
        }
        this.mTimestamp = timestamp;
        this.mSleepTimeMs = sleepTimeMs;
        this.mIdleTimeMs = idleTimeMs;
        this.mTotalTxTimeMs = txTimeMs;
        this.mTotalRxTimeMs = rxTimeMs;
        this.mActivityStatsTechSpecificInfo = new ActivityStatsTechSpecificInfo[1];
        this.mSizeOfSpecificInfo = this.mActivityStatsTechSpecificInfo.length;
        this.mActivityStatsTechSpecificInfo[0] = new ActivityStatsTechSpecificInfo(0, 0, txTimeMs, rxTimeMs);
    }

    public ModemActivityInfo(long timestamp, long sleepTimeMs, long idleTimeMs, int[] txTimeMs, long rxTimeMs) {
        this(timestamp, (int)sleepTimeMs, (int)idleTimeMs, txTimeMs, (int)rxTimeMs);
    }

    public ModemActivityInfo(long timestamp, int sleepTimeMs, int idleTimeMs, ActivityStatsTechSpecificInfo[] activityStatsTechSpecificInfo) {
        int i;
        this.mTimestamp = timestamp;
        this.mSleepTimeMs = sleepTimeMs;
        this.mIdleTimeMs = idleTimeMs;
        this.mActivityStatsTechSpecificInfo = activityStatsTechSpecificInfo;
        this.mSizeOfSpecificInfo = this.mActivityStatsTechSpecificInfo.length;
        this.mTotalTxTimeMs = new int[5];
        for (i = 0; i < ModemActivityInfo.getNumTxPowerLevels(); ++i) {
            for (int j = 0; j < this.getSpecificInfoLength(); ++j) {
                this.mTotalTxTimeMs[i] = this.mTotalTxTimeMs[i] + (int)this.mActivityStatsTechSpecificInfo[j].getTransmitTimeMillis(i);
            }
        }
        this.mTotalRxTimeMs = 0;
        for (i = 0; i < this.getSpecificInfoLength(); ++i) {
            this.mTotalRxTimeMs += (int)this.mActivityStatsTechSpecificInfo[i].getReceiveTimeMillis();
        }
    }

    public ModemActivityInfo(long timestamp, long sleepTimeMs, long idleTimeMs, ActivityStatsTechSpecificInfo[] activityStatsTechSpecificInfo) {
        this(timestamp, (int)sleepTimeMs, (int)idleTimeMs, activityStatsTechSpecificInfo);
    }

    public String toString() {
        return "ModemActivityInfo{ mTimestamp=" + this.mTimestamp + " mSleepTimeMs=" + this.mSleepTimeMs + " mIdleTimeMs=" + this.mIdleTimeMs + " mActivityStatsTechSpecificInfo=" + Arrays.toString(this.mActivityStatsTechSpecificInfo) + "}";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.mTimestamp);
        dest.writeInt(this.mSleepTimeMs);
        dest.writeInt(this.mIdleTimeMs);
        dest.writeTypedArray(this.mActivityStatsTechSpecificInfo, flags);
    }

    public long getTimestampMillis() {
        return this.mTimestamp;
    }

    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    public long getTransmitDurationMillisAtPowerLevel(int powerLevel) {
        long txTimeMsAtPowerLevel = 0L;
        for (int i = 0; i < this.getSpecificInfoLength(); ++i) {
            txTimeMsAtPowerLevel += this.mActivityStatsTechSpecificInfo[i].getTransmitTimeMillis(powerLevel);
        }
        return txTimeMsAtPowerLevel;
    }

    public long getTransmitDurationMillisAtPowerLevel(int powerLevel, int rat) {
        for (int i = 0; i < this.getSpecificInfoLength(); ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat) continue;
            return this.mActivityStatsTechSpecificInfo[i].getTransmitTimeMillis(powerLevel);
        }
        return 0L;
    }

    public long getTransmitDurationMillisAtPowerLevel(int powerLevel, int rat, int freq) {
        for (int i = 0; i < this.getSpecificInfoLength(); ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat || this.mActivityStatsTechSpecificInfo[i].getFrequencyRange() != freq) continue;
            return this.mActivityStatsTechSpecificInfo[i].getTransmitTimeMillis(powerLevel);
        }
        return 0L;
    }

    public Range<Integer> getTransmitPowerRange(int powerLevel) {
        return TX_POWER_RANGES[powerLevel];
    }

    public int getSpecificInfoRat(int index) {
        return this.mActivityStatsTechSpecificInfo[index].getRat();
    }

    public int getSpecificInfoFrequencyRange(int index) {
        return this.mActivityStatsTechSpecificInfo[index].getFrequencyRange();
    }

    public void setTransmitTimeMillis(int[] txTimeMs) {
        this.mTotalTxTimeMs = Arrays.copyOf(txTimeMs, 5);
    }

    public void setTransmitTimeMillis(int rat, int[] txTimeMs) {
        for (int i = 0; i < this.getSpecificInfoLength(); ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat) continue;
            this.mActivityStatsTechSpecificInfo[i].setTransmitTimeMillis(txTimeMs);
        }
    }

    public void setTransmitTimeMillis(int rat, int freq, int[] txTimeMs) {
        for (int i = 0; i < this.getSpecificInfoLength(); ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat || this.mActivityStatsTechSpecificInfo[i].getFrequencyRange() != freq) continue;
            this.mActivityStatsTechSpecificInfo[i].setTransmitTimeMillis(txTimeMs);
        }
    }

    public int[] getTransmitTimeMillis() {
        return this.mTotalTxTimeMs;
    }

    public int[] getTransmitTimeMillis(int rat) {
        for (int i = 0; i < this.mActivityStatsTechSpecificInfo.length; ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat) continue;
            return this.mActivityStatsTechSpecificInfo[i].getTransmitTimeMillis();
        }
        return new int[5];
    }

    public int[] getTransmitTimeMillis(int rat, int freq) {
        for (int i = 0; i < this.mActivityStatsTechSpecificInfo.length; ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat || this.mActivityStatsTechSpecificInfo[i].getFrequencyRange() != freq) continue;
            return this.mActivityStatsTechSpecificInfo[i].getTransmitTimeMillis();
        }
        return new int[5];
    }

    public long getSleepTimeMillis() {
        return this.mSleepTimeMs;
    }

    public void setSleepTimeMillis(int sleepTimeMillis) {
        this.mSleepTimeMs = sleepTimeMillis;
    }

    public void setSleepTimeMillis(long sleepTimeMillis) {
        this.mSleepTimeMs = (int)sleepTimeMillis;
    }

    public ModemActivityInfo getDelta(ModemActivityInfo other) {
        ActivityStatsTechSpecificInfo[] mDeltaSpecificInfo = new ActivityStatsTechSpecificInfo[other.getSpecificInfoLength()];
        for (int i = 0; i < other.getSpecificInfoLength(); ++i) {
            boolean matched = false;
            for (int j = 0; j < this.getSpecificInfoLength(); ++j) {
                int rat = this.mActivityStatsTechSpecificInfo[j].getRat();
                if (rat != other.mActivityStatsTechSpecificInfo[i].getRat() || matched) continue;
                if (this.mActivityStatsTechSpecificInfo[j].getRat() == 6) {
                    if (other.mActivityStatsTechSpecificInfo[i].getFrequencyRange() != this.mActivityStatsTechSpecificInfo[j].getFrequencyRange()) continue;
                    int freq = this.mActivityStatsTechSpecificInfo[j].getFrequencyRange();
                    int[] txTimeMs = new int[5];
                    for (int lvl = 0; lvl < 5; ++lvl) {
                        txTimeMs[lvl] = (int)(other.getTransmitDurationMillisAtPowerLevel(lvl, rat, freq) - this.getTransmitDurationMillisAtPowerLevel(lvl, rat, freq));
                    }
                    matched = true;
                    mDeltaSpecificInfo[i] = new ActivityStatsTechSpecificInfo(rat, freq, txTimeMs, (int)(other.getReceiveTimeMillis(rat, freq) - this.getReceiveTimeMillis(rat, freq)));
                    continue;
                }
                int[] txTimeMs = new int[5];
                for (int lvl = 0; lvl < 5; ++lvl) {
                    txTimeMs[lvl] = (int)(other.getTransmitDurationMillisAtPowerLevel(lvl, rat) - this.getTransmitDurationMillisAtPowerLevel(lvl, rat));
                }
                matched = true;
                mDeltaSpecificInfo[i] = new ActivityStatsTechSpecificInfo(rat, 0, txTimeMs, (int)(other.getReceiveTimeMillis(rat) - this.getReceiveTimeMillis(rat)));
            }
            if (matched) continue;
            mDeltaSpecificInfo[i] = other.mActivityStatsTechSpecificInfo[i];
        }
        return new ModemActivityInfo(other.getTimestampMillis(), other.getSleepTimeMillis() - this.getSleepTimeMillis(), other.getIdleTimeMillis() - this.getIdleTimeMillis(), mDeltaSpecificInfo);
    }

    public long getIdleTimeMillis() {
        return this.mIdleTimeMs;
    }

    public void setIdleTimeMillis(int idleTimeMillis) {
        this.mIdleTimeMs = idleTimeMillis;
    }

    public void setIdleTimeMillis(long idleTimeMillis) {
        this.mIdleTimeMs = (int)idleTimeMillis;
    }

    public long getReceiveTimeMillis() {
        return this.mTotalRxTimeMs;
    }

    public long getReceiveTimeMillis(int rat) {
        for (int i = 0; i < this.mActivityStatsTechSpecificInfo.length; ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat) continue;
            return this.mActivityStatsTechSpecificInfo[i].getReceiveTimeMillis();
        }
        return 0L;
    }

    public long getReceiveTimeMillis(int rat, int freq) {
        for (int i = 0; i < this.mActivityStatsTechSpecificInfo.length; ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat || this.mActivityStatsTechSpecificInfo[i].getFrequencyRange() != freq) continue;
            return this.mActivityStatsTechSpecificInfo[i].getReceiveTimeMillis();
        }
        return 0L;
    }

    public void setReceiveTimeMillis(int rxTimeMillis) {
        this.mTotalRxTimeMs = rxTimeMillis;
    }

    public void setReceiveTimeMillis(long receiveTimeMillis) {
        this.mTotalRxTimeMs = (int)receiveTimeMillis;
    }

    public void setReceiveTimeMillis(int rat, long receiveTimeMillis) {
        for (int i = 0; i < this.mActivityStatsTechSpecificInfo.length; ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat) continue;
            this.mActivityStatsTechSpecificInfo[i].setReceiveTimeMillis(receiveTimeMillis);
        }
    }

    public void setReceiveTimeMillis(int rat, int freq, long receiveTimeMillis) {
        for (int i = 0; i < this.mActivityStatsTechSpecificInfo.length; ++i) {
            if (this.mActivityStatsTechSpecificInfo[i].getRat() != rat || this.mActivityStatsTechSpecificInfo[i].getFrequencyRange() != freq) continue;
            this.mActivityStatsTechSpecificInfo[i].setReceiveTimeMillis(receiveTimeMillis);
        }
    }

    public int getSpecificInfoLength() {
        return this.mSizeOfSpecificInfo;
    }

    public boolean isValid() {
        if (this.mActivityStatsTechSpecificInfo == null) {
            return false;
        }
        boolean isTxPowerValid = true;
        boolean isRxPowerValid = true;
        for (int i = 0; i < this.getSpecificInfoLength(); ++i) {
            if (!this.mActivityStatsTechSpecificInfo[i].isTxPowerValid()) {
                isTxPowerValid = false;
            }
            if (this.mActivityStatsTechSpecificInfo[i].isRxPowerValid()) continue;
            isRxPowerValid = false;
        }
        return isTxPowerValid && isRxPowerValid && this.getIdleTimeMillis() >= 0L && this.getSleepTimeMillis() >= 0L && !this.isEmpty();
    }

    public boolean isEmpty() {
        boolean isTxPowerEmpty = true;
        boolean isRxPowerEmpty = true;
        for (int i = 0; i < this.getSpecificInfoLength(); ++i) {
            if (!this.mActivityStatsTechSpecificInfo[i].isTxPowerEmpty()) {
                isTxPowerEmpty = false;
            }
            if (this.mActivityStatsTechSpecificInfo[i].isRxPowerEmpty()) continue;
            isRxPowerEmpty = false;
        }
        return isTxPowerEmpty && this.getIdleTimeMillis() == 0L && this.getSleepTimeMillis() == 0L && isRxPowerEmpty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModemActivityInfo that = (ModemActivityInfo)o;
        return this.mTimestamp == that.mTimestamp && this.mSleepTimeMs == that.mSleepTimeMs && this.mIdleTimeMs == that.mIdleTimeMs && this.mSizeOfSpecificInfo == that.mSizeOfSpecificInfo && Arrays.equals(this.mActivityStatsTechSpecificInfo, that.mActivityStatsTechSpecificInfo);
    }

    public int hashCode() {
        int result = Objects.hash(this.mTimestamp, this.mSleepTimeMs, this.mIdleTimeMs, this.mTotalRxTimeMs);
        result = 31 * result + Arrays.hashCode(this.mTotalTxTimeMs);
        return result;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TxPowerLevel {
    }
}

