/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class PreciseCallState
implements Parcelable {
    public static final int PRECISE_CALL_STATE_NOT_VALID = -1;
    public static final int PRECISE_CALL_STATE_IDLE = 0;
    public static final int PRECISE_CALL_STATE_ACTIVE = 1;
    public static final int PRECISE_CALL_STATE_HOLDING = 2;
    public static final int PRECISE_CALL_STATE_DIALING = 3;
    public static final int PRECISE_CALL_STATE_ALERTING = 4;
    public static final int PRECISE_CALL_STATE_INCOMING = 5;
    public static final int PRECISE_CALL_STATE_WAITING = 6;
    public static final int PRECISE_CALL_STATE_DISCONNECTED = 7;
    public static final int PRECISE_CALL_STATE_DISCONNECTING = 8;
    public static final int PRECISE_CALL_STATE_INCOMING_SETUP = 9;
    private int mRingingCallState = -1;
    private int mForegroundCallState = -1;
    private int mBackgroundCallState = -1;
    private int mDisconnectCause = -1;
    private int mPreciseDisconnectCause = -1;
    public static final Parcelable.Creator<PreciseCallState> CREATOR = new Parcelable.Creator<PreciseCallState>(){

        @Override
        public PreciseCallState createFromParcel(Parcel in) {
            return new PreciseCallState(in);
        }

        public PreciseCallState[] newArray(int size) {
            return new PreciseCallState[size];
        }
    };

    @SystemApi
    public PreciseCallState(int ringingCall, int foregroundCall, int backgroundCall, int disconnectCause, int preciseDisconnectCause) {
        this.mRingingCallState = ringingCall;
        this.mForegroundCallState = foregroundCall;
        this.mBackgroundCallState = backgroundCall;
        this.mDisconnectCause = disconnectCause;
        this.mPreciseDisconnectCause = preciseDisconnectCause;
    }

    public PreciseCallState() {
    }

    private PreciseCallState(Parcel in) {
        this.mRingingCallState = in.readInt();
        this.mForegroundCallState = in.readInt();
        this.mBackgroundCallState = in.readInt();
        this.mDisconnectCause = in.readInt();
        this.mPreciseDisconnectCause = in.readInt();
    }

    public int getRingingCallState() {
        return this.mRingingCallState;
    }

    public int getForegroundCallState() {
        return this.mForegroundCallState;
    }

    public int getBackgroundCallState() {
        return this.mBackgroundCallState;
    }

    @UnsupportedAppUsage
    public int getDisconnectCause() {
        return this.mDisconnectCause;
    }

    @UnsupportedAppUsage
    public int getPreciseDisconnectCause() {
        return this.mPreciseDisconnectCause;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mRingingCallState);
        out.writeInt(this.mForegroundCallState);
        out.writeInt(this.mBackgroundCallState);
        out.writeInt(this.mDisconnectCause);
        out.writeInt(this.mPreciseDisconnectCause);
    }

    public int hashCode() {
        return Objects.hash(this.mRingingCallState, this.mForegroundCallState, this.mForegroundCallState, this.mDisconnectCause, this.mPreciseDisconnectCause);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreciseCallState other = (PreciseCallState)obj;
        return this.mRingingCallState == other.mRingingCallState && this.mForegroundCallState == other.mForegroundCallState && this.mBackgroundCallState == other.mBackgroundCallState && this.mDisconnectCause == other.mDisconnectCause && this.mPreciseDisconnectCause == other.mPreciseDisconnectCause;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Ringing call state: " + this.mRingingCallState);
        sb.append(", Foreground call state: " + this.mForegroundCallState);
        sb.append(", Background call state: " + this.mBackgroundCallState);
        sb.append(", Disconnect cause: " + this.mDisconnectCause);
        sb.append(", Precise disconnect cause: " + this.mPreciseDisconnectCause);
        return sb.toString();
    }
}

