/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.telephony.SubscriptionManager;
import android.telephony.UiccAccessRule;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import com.android.telephony.Rlog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SubscriptionInfo
implements Parcelable {
    private static final int TEXT_SIZE = 16;
    private final int mId;
    private final String mIccId;
    private final int mSimSlotIndex;
    private final CharSequence mDisplayName;
    private final CharSequence mCarrierName;
    private final int mDisplayNameSource;
    private final int mIconTint;
    private final String mNumber;
    private final int mDataRoaming;
    private final String mMcc;
    private final String mMnc;
    private final String[] mEhplmns;
    private final String[] mHplmns;
    private final boolean mIsEmbedded;
    private final String mCardString;
    private final UiccAccessRule[] mNativeAccessRules;
    private final UiccAccessRule[] mCarrierConfigAccessRules;
    private final boolean mIsOpportunistic;
    private final ParcelUuid mGroupUuid;
    private final String mCountryIso;
    private final int mCarrierId;
    private final int mProfileClass;
    private final int mType;
    private final String mGroupOwner;
    private final boolean mAreUiccApplicationsEnabled;
    private final int mPortIndex;
    private final int mUsageSetting;
    private Bitmap mIconBitmap;
    private final int mCardId;
    private final boolean mIsGroupDisabled;
    public static final Parcelable.Creator<SubscriptionInfo> CREATOR = new Parcelable.Creator<SubscriptionInfo>(){

        @Override
        public SubscriptionInfo createFromParcel(Parcel source) {
            return new Builder().setId(source.readInt()).setIccId(source.readString()).setSimSlotIndex(source.readInt()).setDisplayName(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source)).setCarrierName(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source)).setDisplayNameSource(source.readInt()).setIconTint(source.readInt()).setNumber(source.readString()).setDataRoaming(source.readInt()).setMcc(source.readString()).setMnc(source.readString()).setCountryIso(source.readString()).setEmbedded(source.readBoolean()).setNativeAccessRules(source.createTypedArray(UiccAccessRule.CREATOR)).setCardString(source.readString()).setCardId(source.readInt()).setPortIndex(source.readInt()).setOpportunistic(source.readBoolean()).setGroupUuid(source.readString8()).setGroupDisabled(source.readBoolean()).setCarrierId(source.readInt()).setProfileClass(source.readInt()).setType(source.readInt()).setEhplmns(source.createStringArray()).setHplmns(source.createStringArray()).setGroupOwner(source.readString()).setCarrierConfigAccessRules(source.createTypedArray(UiccAccessRule.CREATOR)).setUiccApplicationsEnabled(source.readBoolean()).setUsageSetting(source.readInt()).build();
        }

        public SubscriptionInfo[] newArray(int size) {
            return new SubscriptionInfo[size];
        }
    };

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, -1, false, null, false, -1, -1, 0, null, null, true);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, boolean isOpportunistic, String groupUUID, int carrierId, int profileClass) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, -1, isOpportunistic, groupUUID, false, carrierId, profileClass, 0, null, null, true);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, String groupUUID, boolean isGroupDisabled, int carrierId, int profileClass, int subType, String groupOwner, UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, cardId, isOpportunistic, groupUUID, isGroupDisabled, carrierId, profileClass, subType, groupOwner, carrierConfigAccessRules, areUiccApplicationsEnabled, 0);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int displayNameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, String groupUUID, boolean isGroupDisabled, int carrierId, int profileClass, int subType, String groupOwner, UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled, int portIndex) {
        this(id2, iccId, simSlotIndex, displayName, carrierName, displayNameSource, iconTint, number, roaming, icon, mcc, mnc, countryIso, isEmbedded, nativeAccessRules, cardString, cardId, isOpportunistic, groupUUID, isGroupDisabled, carrierId, profileClass, subType, groupOwner, carrierConfigAccessRules, areUiccApplicationsEnabled, portIndex, 0);
    }

    @Deprecated
    public SubscriptionInfo(int id2, String iccId, int simSlotIndex, CharSequence displayName, CharSequence carrierName, int nameSource, int iconTint, String number, int roaming, Bitmap icon, String mcc, String mnc, String countryIso, boolean isEmbedded, UiccAccessRule[] nativeAccessRules, String cardString, int cardId, boolean isOpportunistic, String groupUuid, boolean isGroupDisabled, int carrierId, int profileClass, int subType, String groupOwner, UiccAccessRule[] carrierConfigAccessRules, boolean areUiccApplicationsEnabled, int portIndex, int usageSetting) {
        this.mId = id2;
        this.mIccId = iccId;
        this.mSimSlotIndex = simSlotIndex;
        this.mDisplayName = displayName;
        this.mCarrierName = carrierName;
        this.mDisplayNameSource = nameSource;
        this.mIconTint = iconTint;
        this.mNumber = number;
        this.mDataRoaming = roaming;
        this.mIconBitmap = icon;
        this.mMcc = TextUtils.emptyIfNull(mcc);
        this.mMnc = TextUtils.emptyIfNull(mnc);
        this.mHplmns = null;
        this.mEhplmns = null;
        this.mCountryIso = TextUtils.emptyIfNull(countryIso);
        this.mIsEmbedded = isEmbedded;
        this.mNativeAccessRules = nativeAccessRules;
        this.mCardString = TextUtils.emptyIfNull(cardString);
        this.mCardId = cardId;
        this.mIsOpportunistic = isOpportunistic;
        this.mGroupUuid = groupUuid == null ? null : ParcelUuid.fromString(groupUuid);
        this.mIsGroupDisabled = isGroupDisabled;
        this.mCarrierId = carrierId;
        this.mProfileClass = profileClass;
        this.mType = subType;
        this.mGroupOwner = TextUtils.emptyIfNull(groupOwner);
        this.mCarrierConfigAccessRules = carrierConfigAccessRules;
        this.mAreUiccApplicationsEnabled = areUiccApplicationsEnabled;
        this.mPortIndex = portIndex;
        this.mUsageSetting = usageSetting;
    }

    private SubscriptionInfo(Builder builder) {
        this.mId = builder.mId;
        this.mIccId = builder.mIccId;
        this.mSimSlotIndex = builder.mSimSlotIndex;
        this.mDisplayName = builder.mDisplayName;
        this.mCarrierName = builder.mCarrierName;
        this.mDisplayNameSource = builder.mDisplayNameSource;
        this.mIconTint = builder.mIconTint;
        this.mNumber = builder.mNumber;
        this.mDataRoaming = builder.mDataRoaming;
        this.mIconBitmap = builder.mIconBitmap;
        this.mMcc = builder.mMcc;
        this.mMnc = builder.mMnc;
        this.mEhplmns = builder.mEhplmns;
        this.mHplmns = builder.mHplmns;
        this.mCountryIso = builder.mCountryIso;
        this.mIsEmbedded = builder.mIsEmbedded;
        this.mNativeAccessRules = builder.mNativeAccessRules;
        this.mCardString = builder.mCardString;
        this.mCardId = builder.mCardId;
        this.mIsOpportunistic = builder.mIsOpportunistic;
        this.mGroupUuid = builder.mGroupUuid;
        this.mIsGroupDisabled = builder.mIsGroupDisabled;
        this.mCarrierId = builder.mCarrierId;
        this.mProfileClass = builder.mProfileClass;
        this.mType = builder.mType;
        this.mGroupOwner = builder.mGroupOwner;
        this.mCarrierConfigAccessRules = builder.mCarrierConfigAccessRules;
        this.mAreUiccApplicationsEnabled = builder.mAreUiccApplicationsEnabled;
        this.mPortIndex = builder.mPortIndex;
        this.mUsageSetting = builder.mUsageSetting;
    }

    public int getSubscriptionId() {
        return this.mId;
    }

    public String getIccId() {
        return this.mIccId;
    }

    public int getSimSlotIndex() {
        return this.mSimSlotIndex;
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    public CharSequence getDisplayName() {
        return this.mDisplayName;
    }

    public CharSequence getCarrierName() {
        return this.mCarrierName;
    }

    public int getDisplayNameSource() {
        return this.mDisplayNameSource;
    }

    public Bitmap createIconBitmap(Context context) {
        if (this.mIconBitmap == null) {
            this.mIconBitmap = BitmapFactory.decodeResource(context.getResources(), 17302881);
        }
        int width = this.mIconBitmap.getWidth();
        int height = this.mIconBitmap.getHeight();
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        Bitmap workingBitmap = Bitmap.createBitmap(metrics, width, height, this.mIconBitmap.getConfig());
        Canvas canvas = new Canvas(workingBitmap);
        Paint paint = new Paint();
        paint.setColorFilter(new PorterDuffColorFilter(this.mIconTint, PorterDuff.Mode.SRC_ATOP));
        canvas.drawBitmap(this.mIconBitmap, 0.0f, 0.0f, paint);
        paint.setColorFilter(null);
        paint.setAntiAlias(true);
        paint.setTypeface(Typeface.create("sans-serif", 0));
        paint.setColor(-1);
        paint.setTextSize(16.0f * metrics.density);
        String index = TextUtils.formatSimple("%d", this.mSimSlotIndex + 1);
        Rect textBound = new Rect();
        paint.getTextBounds(index, 0, 1, textBound);
        float xOffset = (float)width / 2.0f - (float)textBound.centerX();
        float yOffset = (float)height / 2.0f - (float)textBound.centerY();
        canvas.drawText(index, xOffset, yOffset, paint);
        return workingBitmap;
    }

    public int getIconTint() {
        return this.mIconTint;
    }

    @Deprecated
    public String getNumber() {
        return this.mNumber;
    }

    public int getDataRoaming() {
        return this.mDataRoaming;
    }

    @Deprecated
    public int getMcc() {
        try {
            return this.mMcc == null ? 0 : Integer.parseInt(this.mMcc);
        }
        catch (NumberFormatException e) {
            Log.w(SubscriptionInfo.class.getSimpleName(), "MCC string is not a number");
            return 0;
        }
    }

    @Deprecated
    public int getMnc() {
        try {
            return this.mMnc == null ? 0 : Integer.parseInt(this.mMnc);
        }
        catch (NumberFormatException e) {
            Log.w(SubscriptionInfo.class.getSimpleName(), "MNC string is not a number");
            return 0;
        }
    }

    public String getMccString() {
        return this.mMcc;
    }

    public String getMncString() {
        return this.mMnc;
    }

    public String getCountryIso() {
        return this.mCountryIso;
    }

    public boolean isEmbedded() {
        return this.mIsEmbedded;
    }

    public boolean isOpportunistic() {
        return this.mIsOpportunistic;
    }

    public boolean isActive() {
        return this.mSimSlotIndex >= 0 || this.mType == 1;
    }

    public ParcelUuid getGroupUuid() {
        return this.mGroupUuid;
    }

    public List<String> getEhplmns() {
        return Collections.unmodifiableList(this.mEhplmns == null ? Collections.emptyList() : Arrays.asList(this.mEhplmns));
    }

    public List<String> getHplmns() {
        return Collections.unmodifiableList(this.mHplmns == null ? Collections.emptyList() : Arrays.asList(this.mHplmns));
    }

    public String getGroupOwner() {
        return this.mGroupOwner;
    }

    @SystemApi
    public int getProfileClass() {
        return this.mProfileClass;
    }

    public int getSubscriptionType() {
        return this.mType;
    }

    @Deprecated
    public boolean canManageSubscription(Context context) {
        return this.canManageSubscription(context, context.getPackageName());
    }

    @Deprecated
    public boolean canManageSubscription(Context context, String packageName) {
        PackageInfo packageInfo;
        List<UiccAccessRule> allAccessRules = this.getAccessRules();
        if (allAccessRules == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0x8000000);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.d("SubscriptionInfo", "canManageSubscription: Unknown package: " + packageName, e);
            return false;
        }
        for (UiccAccessRule rule : allAccessRules) {
            if (rule.getCarrierPrivilegeStatus(packageInfo) != 1) continue;
            return true;
        }
        return false;
    }

    @SystemApi
    public List<UiccAccessRule> getAccessRules() {
        ArrayList<UiccAccessRule> merged = new ArrayList<UiccAccessRule>();
        if (this.mNativeAccessRules != null) {
            merged.addAll(Arrays.asList(this.mNativeAccessRules));
        }
        if (this.mCarrierConfigAccessRules != null) {
            merged.addAll(Arrays.asList(this.mCarrierConfigAccessRules));
        }
        return merged.isEmpty() ? null : Collections.unmodifiableList(merged);
    }

    public String getCardString() {
        return this.mCardString;
    }

    public int getCardId() {
        return this.mCardId;
    }

    public int getPortIndex() {
        return this.mPortIndex;
    }

    @SystemApi
    public boolean isGroupDisabled() {
        return this.mIsGroupDisabled;
    }

    @SystemApi
    public boolean areUiccApplicationsEnabled() {
        return this.mAreUiccApplicationsEnabled;
    }

    public int getUsageSetting() {
        return this.mUsageSetting;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeString(this.mIccId);
        dest.writeInt(this.mSimSlotIndex);
        TextUtils.writeToParcel(this.mDisplayName, dest, 0);
        TextUtils.writeToParcel(this.mCarrierName, dest, 0);
        dest.writeInt(this.mDisplayNameSource);
        dest.writeInt(this.mIconTint);
        dest.writeString(this.mNumber);
        dest.writeInt(this.mDataRoaming);
        dest.writeString(this.mMcc);
        dest.writeString(this.mMnc);
        dest.writeString(this.mCountryIso);
        dest.writeBoolean(this.mIsEmbedded);
        dest.writeTypedArray(this.mNativeAccessRules, flags);
        dest.writeString(this.mCardString);
        dest.writeInt(this.mCardId);
        dest.writeInt(this.mPortIndex);
        dest.writeBoolean(this.mIsOpportunistic);
        dest.writeString8(this.mGroupUuid == null ? null : this.mGroupUuid.toString());
        dest.writeBoolean(this.mIsGroupDisabled);
        dest.writeInt(this.mCarrierId);
        dest.writeInt(this.mProfileClass);
        dest.writeInt(this.mType);
        dest.writeStringArray(this.mEhplmns);
        dest.writeStringArray(this.mHplmns);
        dest.writeString(this.mGroupOwner);
        dest.writeTypedArray(this.mCarrierConfigAccessRules, flags);
        dest.writeBoolean(this.mAreUiccApplicationsEnabled);
        dest.writeInt(this.mUsageSetting);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static String getPrintableId(String id2) {
        String idToPrint = null;
        if (id2 != null) {
            idToPrint = id2.length() > 9 && !TelephonyUtils.IS_DEBUGGABLE ? id2.substring(0, 9) + Rlog.pii(false, (Object)id2.substring(9)) : id2;
        }
        return idToPrint;
    }

    public String toString() {
        String iccIdToPrint = SubscriptionInfo.getPrintableId(this.mIccId);
        String cardStringToPrint = SubscriptionInfo.getPrintableId(this.mCardString);
        return "[SubscriptionInfo: id=" + this.mId + " iccId=" + iccIdToPrint + " simSlotIndex=" + this.mSimSlotIndex + " portIndex=" + this.mPortIndex + " isEmbedded=" + this.mIsEmbedded + " carrierId=" + this.mCarrierId + " displayName=" + this.mDisplayName + " carrierName=" + this.mCarrierName + " isOpportunistic=" + this.mIsOpportunistic + " groupUuid=" + this.mGroupUuid + " groupOwner=" + this.mGroupOwner + " isGroupDisabled=" + this.mIsGroupDisabled + " displayNameSource=" + SubscriptionManager.displayNameSourceToString(this.mDisplayNameSource) + " iconTint=" + this.mIconTint + " number=" + Rlog.pii(TelephonyUtils.IS_DEBUGGABLE, (Object)this.mNumber) + " dataRoaming=" + this.mDataRoaming + " mcc=" + this.mMcc + " mnc=" + this.mMnc + " ehplmns=" + Arrays.toString(this.mEhplmns) + " hplmns=" + Arrays.toString(this.mHplmns) + " cardString=" + cardStringToPrint + " cardId=" + this.mCardId + " nativeAccessRules=" + Arrays.toString(this.mNativeAccessRules) + " carrierConfigAccessRules=" + Arrays.toString(this.mCarrierConfigAccessRules) + " countryIso=" + this.mCountryIso + " profileClass=" + this.mProfileClass + " mType=" + SubscriptionManager.subscriptionTypeToString(this.mType) + " areUiccApplicationsEnabled=" + this.mAreUiccApplicationsEnabled + " usageSetting=" + SubscriptionManager.usageSettingToString(this.mUsageSetting) + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionInfo that = (SubscriptionInfo)o;
        return this.mId == that.mId && this.mSimSlotIndex == that.mSimSlotIndex && this.mDisplayNameSource == that.mDisplayNameSource && this.mIconTint == that.mIconTint && this.mDataRoaming == that.mDataRoaming && this.mIsEmbedded == that.mIsEmbedded && this.mIsOpportunistic == that.mIsOpportunistic && this.mCarrierId == that.mCarrierId && this.mProfileClass == that.mProfileClass && this.mType == that.mType && this.mAreUiccApplicationsEnabled == that.mAreUiccApplicationsEnabled && this.mPortIndex == that.mPortIndex && this.mUsageSetting == that.mUsageSetting && this.mCardId == that.mCardId && this.mIsGroupDisabled == that.mIsGroupDisabled && this.mIccId.equals(that.mIccId) && this.mDisplayName.equals(that.mDisplayName) && this.mCarrierName.equals(that.mCarrierName) && this.mNumber.equals(that.mNumber) && Objects.equals(this.mMcc, that.mMcc) && Objects.equals(this.mMnc, that.mMnc) && Arrays.equals(this.mEhplmns, that.mEhplmns) && Arrays.equals(this.mHplmns, that.mHplmns) && this.mCardString.equals(that.mCardString) && Arrays.equals(this.mNativeAccessRules, that.mNativeAccessRules) && Arrays.equals(this.mCarrierConfigAccessRules, that.mCarrierConfigAccessRules) && Objects.equals(this.mGroupUuid, that.mGroupUuid) && this.mCountryIso.equals(that.mCountryIso) && this.mGroupOwner.equals(that.mGroupOwner);
    }

    public int hashCode() {
        int result = Objects.hash(this.mId, this.mIccId, this.mSimSlotIndex, this.mDisplayName, this.mCarrierName, this.mDisplayNameSource, this.mIconTint, this.mNumber, this.mDataRoaming, this.mMcc, this.mMnc, this.mIsEmbedded, this.mCardString, this.mIsOpportunistic, this.mGroupUuid, this.mCountryIso, this.mCarrierId, this.mProfileClass, this.mType, this.mGroupOwner, this.mAreUiccApplicationsEnabled, this.mPortIndex, this.mUsageSetting, this.mCardId, this.mIsGroupDisabled);
        result = 31 * result + Arrays.hashCode(this.mEhplmns);
        result = 31 * result + Arrays.hashCode(this.mHplmns);
        result = 31 * result + Arrays.hashCode(this.mNativeAccessRules);
        result = 31 * result + Arrays.hashCode(this.mCarrierConfigAccessRules);
        return result;
    }

    public static class Builder {
        private int mId = -1;
        private String mIccId = "";
        private int mSimSlotIndex = -1;
        private CharSequence mDisplayName = "";
        private CharSequence mCarrierName = "";
        private int mDisplayNameSource = -1;
        private int mIconTint = 0;
        private String mNumber = "";
        private int mDataRoaming = 0;
        private Bitmap mIconBitmap = null;
        private String mMcc = null;
        private String mMnc = null;
        private String[] mEhplmns = new String[0];
        private String[] mHplmns = new String[0];
        private String mCountryIso = "";
        private boolean mIsEmbedded = false;
        private UiccAccessRule[] mNativeAccessRules = null;
        private String mCardString = "";
        private int mCardId = -2;
        private boolean mIsOpportunistic = false;
        private ParcelUuid mGroupUuid = null;
        private boolean mIsGroupDisabled = false;
        private int mCarrierId = -1;
        private int mProfileClass = -1;
        private int mType = 0;
        private String mGroupOwner = "";
        private UiccAccessRule[] mCarrierConfigAccessRules = null;
        private boolean mAreUiccApplicationsEnabled = true;
        private int mPortIndex = -1;
        private int mUsageSetting = -1;

        public Builder() {
        }

        public Builder(SubscriptionInfo info) {
            this.mId = info.mId;
            this.mIccId = info.mIccId;
            this.mSimSlotIndex = info.mSimSlotIndex;
            this.mDisplayName = info.mDisplayName;
            this.mCarrierName = info.mCarrierName;
            this.mDisplayNameSource = info.mDisplayNameSource;
            this.mIconTint = info.mIconTint;
            this.mNumber = info.mNumber;
            this.mDataRoaming = info.mDataRoaming;
            this.mIconBitmap = info.mIconBitmap;
            this.mMcc = info.mMcc;
            this.mMnc = info.mMnc;
            this.mEhplmns = info.mEhplmns;
            this.mHplmns = info.mHplmns;
            this.mCountryIso = info.mCountryIso;
            this.mIsEmbedded = info.mIsEmbedded;
            this.mNativeAccessRules = info.mNativeAccessRules;
            this.mCardString = info.mCardString;
            this.mCardId = info.mCardId;
            this.mIsOpportunistic = info.mIsOpportunistic;
            this.mGroupUuid = info.mGroupUuid;
            this.mIsGroupDisabled = info.mIsGroupDisabled;
            this.mCarrierId = info.mCarrierId;
            this.mProfileClass = info.mProfileClass;
            this.mType = info.mType;
            this.mGroupOwner = info.mGroupOwner;
            this.mCarrierConfigAccessRules = info.mCarrierConfigAccessRules;
            this.mAreUiccApplicationsEnabled = info.mAreUiccApplicationsEnabled;
            this.mPortIndex = info.mPortIndex;
            this.mUsageSetting = info.mUsageSetting;
        }

        public Builder setId(int id2) {
            this.mId = id2;
            return this;
        }

        public Builder setIccId(String iccId) {
            this.mIccId = TextUtils.emptyIfNull(iccId);
            return this;
        }

        public Builder setSimSlotIndex(int simSlotIndex) {
            this.mSimSlotIndex = simSlotIndex;
            return this;
        }

        public Builder setDisplayName(CharSequence displayName) {
            this.mDisplayName = displayName == null ? "" : displayName;
            return this;
        }

        public Builder setCarrierName(CharSequence carrierName) {
            this.mCarrierName = carrierName == null ? "" : carrierName;
            return this;
        }

        public Builder setDisplayNameSource(int displayNameSource) {
            this.mDisplayNameSource = displayNameSource;
            return this;
        }

        public Builder setIconTint(int iconTint) {
            this.mIconTint = iconTint;
            return this;
        }

        public Builder setNumber(String number) {
            this.mNumber = TextUtils.emptyIfNull(number);
            return this;
        }

        public Builder setDataRoaming(int dataRoaming) {
            this.mDataRoaming = dataRoaming;
            return this;
        }

        public Builder setIcon(Bitmap iconBitmap) {
            this.mIconBitmap = iconBitmap;
            return this;
        }

        public Builder setMcc(String mcc) {
            this.mMcc = mcc;
            return this;
        }

        public Builder setMnc(String mnc) {
            this.mMnc = mnc;
            return this;
        }

        public Builder setEhplmns(String[] ehplmns) {
            this.mEhplmns = ehplmns == null ? new String[]{} : ehplmns;
            return this;
        }

        public Builder setHplmns(String[] hplmns) {
            this.mHplmns = hplmns == null ? new String[]{} : hplmns;
            return this;
        }

        public Builder setCountryIso(String countryIso) {
            this.mCountryIso = TextUtils.emptyIfNull(countryIso);
            return this;
        }

        public Builder setEmbedded(boolean isEmbedded) {
            this.mIsEmbedded = isEmbedded;
            return this;
        }

        public Builder setNativeAccessRules(UiccAccessRule[] nativeAccessRules) {
            this.mNativeAccessRules = nativeAccessRules;
            return this;
        }

        public Builder setCardString(String cardString) {
            this.mCardString = TextUtils.emptyIfNull(cardString);
            return this;
        }

        public Builder setCardId(int cardId) {
            this.mCardId = cardId;
            return this;
        }

        public Builder setOpportunistic(boolean isOpportunistic) {
            this.mIsOpportunistic = isOpportunistic;
            return this;
        }

        public Builder setGroupUuid(String groupUuid) {
            this.mGroupUuid = TextUtils.isEmpty(groupUuid) ? null : ParcelUuid.fromString(groupUuid);
            return this;
        }

        public Builder setGroupDisabled(boolean isGroupDisabled) {
            this.mIsGroupDisabled = isGroupDisabled;
            return this;
        }

        public Builder setCarrierId(int carrierId) {
            this.mCarrierId = carrierId;
            return this;
        }

        public Builder setProfileClass(int profileClass) {
            this.mProfileClass = profileClass;
            return this;
        }

        public Builder setType(int type) {
            this.mType = type;
            return this;
        }

        public Builder setGroupOwner(String groupOwner) {
            this.mGroupOwner = TextUtils.emptyIfNull(groupOwner);
            return this;
        }

        public Builder setCarrierConfigAccessRules(UiccAccessRule[] carrierConfigAccessRules) {
            this.mCarrierConfigAccessRules = carrierConfigAccessRules;
            return this;
        }

        public Builder setUiccApplicationsEnabled(boolean uiccApplicationsEnabled) {
            this.mAreUiccApplicationsEnabled = uiccApplicationsEnabled;
            return this;
        }

        public Builder setPortIndex(int portIndex) {
            this.mPortIndex = portIndex;
            return this;
        }

        public Builder setUsageSetting(int usageSetting) {
            this.mUsageSetting = usageSetting;
            return this;
        }

        public SubscriptionInfo build() {
            return new SubscriptionInfo(this);
        }
    }
}

