/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Binder;
import android.telephony.BarringInfo;
import android.telephony.CallAttributes;
import android.telephony.CallQuality;
import android.telephony.CallState;
import android.telephony.CellIdentity;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.LinkCapacityEstimate;
import android.telephony.PhoneCapability;
import android.telephony.PhysicalChannelConfig;
import android.telephony.PreciseCallState;
import android.telephony.PreciseDataConnectionState;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.emergency.EmergencyNumber;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.MediaQualityStatus;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.IPhoneStateListener;
import dalvik.system.VMRuntime;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;

public class TelephonyCallback {
    private static final String LOG_TAG = "TelephonyCallback";
    public static final String FLAG_PER_PID_REGISTRATION_LIMIT = "phone_state_listener_per_pid_registration_limit";
    public static final int DEFAULT_PER_PID_REGISTRATION_LIMIT = 50;
    public static final long PHONE_STATE_LISTENER_LIMIT_CHANGE_ID = 150880553L;
    @SystemApi
    public static final int EVENT_SERVICE_STATE_CHANGED = 1;
    @SystemApi
    public static final int EVENT_SIGNAL_STRENGTH_CHANGED = 2;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static final int EVENT_MESSAGE_WAITING_INDICATOR_CHANGED = 3;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static final int EVENT_CALL_FORWARDING_INDICATOR_CHANGED = 4;
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public static final int EVENT_CELL_LOCATION_CHANGED = 5;
    @SystemApi
    public static final int EVENT_CALL_STATE_CHANGED = 6;
    @SystemApi
    public static final int EVENT_DATA_CONNECTION_STATE_CHANGED = 7;
    @SystemApi
    public static final int EVENT_DATA_ACTIVITY_CHANGED = 8;
    @SystemApi
    public static final int EVENT_SIGNAL_STRENGTHS_CHANGED = 9;
    @SystemApi
    public static final int EVENT_ALWAYS_REPORTED_SIGNAL_STRENGTH_CHANGED = 10;
    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public static final int EVENT_CELL_INFO_CHANGED = 11;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_PRECISE_CALL_STATE_CHANGED = 12;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_PRECISE_DATA_CONNECTION_STATE_CHANGED = 13;
    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_DATA_CONNECTION_REAL_TIME_INFO_CHANGED = 14;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static final int EVENT_OEM_HOOK_RAW = 15;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static final int EVENT_SRVCC_STATE_CHANGED = 16;
    @SystemApi
    public static final int EVENT_CARRIER_NETWORK_CHANGED = 17;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static final int EVENT_VOICE_ACTIVATION_STATE_CHANGED = 18;
    @SystemApi
    public static final int EVENT_DATA_ACTIVATION_STATE_CHANGED = 19;
    @SystemApi
    public static final int EVENT_USER_MOBILE_DATA_STATE_CHANGED = 20;
    @SystemApi
    public static final int EVENT_DISPLAY_INFO_CHANGED = 21;
    @SystemApi
    public static final int EVENT_PHONE_CAPABILITY_CHANGED = 22;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static final int EVENT_ACTIVE_DATA_SUBSCRIPTION_ID_CHANGED = 23;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static final int EVENT_RADIO_POWER_STATE_CHANGED = 24;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PHONE_STATE")
    public static final int EVENT_EMERGENCY_NUMBER_LIST_CHANGED = 25;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_CALL_DISCONNECT_CAUSE_CHANGED = 26;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_CALL_ATTRIBUTES_CHANGED = 27;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_IMS_CALL_DISCONNECT_CAUSE_CHANGED = 28;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_ACTIVE_EMERGENCY_SESSION")
    public static final int EVENT_OUTGOING_EMERGENCY_CALL = 29;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_ACTIVE_EMERGENCY_SESSION")
    public static final int EVENT_OUTGOING_EMERGENCY_SMS = 30;
    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_PRECISE_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public static final int EVENT_REGISTRATION_FAILURE = 31;
    @SystemApi
    @RequiresPermission(allOf={"android.permission.READ_PRECISE_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
    public static final int EVENT_BARRING_INFO_CHANGED = 32;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_PHYSICAL_CHANNEL_CONFIG_CHANGED = 33;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_DATA_ENABLED_CHANGED = 34;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static final int EVENT_ALLOWED_NETWORK_TYPE_LIST_CHANGED = 35;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_CALL_LOG")
    public static final int EVENT_LEGACY_CALL_STATE_CHANGED = 36;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_LINK_CAPACITY_ESTIMATE_CHANGED = 37;
    public static final int EVENT_TRIGGER_NOTIFY_ANBR = 38;
    @SystemApi
    @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
    public static final int EVENT_MEDIA_QUALITY_STATUS_CHANGED = 39;
    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static final int EVENT_EMERGENCY_CALLBACK_MODE_CHANGED = 40;
    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public IPhoneStateListener callback;

    public void init(Executor executor) {
        if (executor == null) {
            throw new IllegalArgumentException("TelephonyCallback Executor must be non-null");
        }
        this.callback = new IPhoneStateListenerStub(this, executor);
    }

    private static class IPhoneStateListenerStub
    extends IPhoneStateListener.Stub {
        private WeakReference<TelephonyCallback> mTelephonyCallbackWeakRef;
        private Executor mExecutor;

        IPhoneStateListenerStub(TelephonyCallback telephonyCallback, Executor executor) {
            this.mTelephonyCallbackWeakRef = new WeakReference<TelephonyCallback>(telephonyCallback);
            this.mExecutor = executor;
        }

        @Override
        public void onServiceStateChanged(ServiceState serviceState) {
            ServiceStateListener listener = (ServiceStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onServiceStateChanged(serviceState)));
        }

        @Override
        public void onSignalStrengthChanged(int asu) {
        }

        @Override
        public void onMessageWaitingIndicatorChanged(boolean mwi) {
            MessageWaitingIndicatorListener listener = (MessageWaitingIndicatorListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onMessageWaitingIndicatorChanged(mwi)));
        }

        @Override
        public void onCallForwardingIndicatorChanged(boolean cfi) {
            CallForwardingIndicatorListener listener = (CallForwardingIndicatorListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCallForwardingIndicatorChanged(cfi)));
        }

        @Override
        public void onCellLocationChanged(CellIdentity cellIdentity) {
            CellLocation location = cellIdentity == null ? CellLocation.getEmpty() : cellIdentity.asCellLocation();
            CellLocationListener listener = (CellLocationListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCellLocationChanged(location)));
        }

        @Override
        public void onLegacyCallStateChanged(int state, String incomingNumber) {
        }

        @Override
        public void onCallStateChanged(int state) {
            CallStateListener listener = (CallStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCallStateChanged(state)));
        }

        @Override
        public void onDataConnectionStateChanged(int state, int networkType) {
            DataConnectionStateListener listener = (DataConnectionStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            if (state == 4 && VMRuntime.getRuntime().getTargetSdkVersion() < 30) {
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onDataConnectionStateChanged(2, networkType)));
            } else {
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onDataConnectionStateChanged(state, networkType)));
            }
        }

        @Override
        public void onDataActivity(int direction) {
            DataActivityListener listener = (DataActivityListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onDataActivity(direction)));
        }

        @Override
        public void onSignalStrengthsChanged(SignalStrength signalStrength) {
            SignalStrengthsListener listener = (SignalStrengthsListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onSignalStrengthsChanged(signalStrength)));
        }

        @Override
        public void onCellInfoChanged(List<CellInfo> cellInfo) {
            CellInfoListener listener = (CellInfoListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCellInfoChanged(cellInfo)));
        }

        @Override
        public void onPreciseCallStateChanged(PreciseCallState callState) {
            PreciseCallStateListener listener = (PreciseCallStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onPreciseCallStateChanged(callState)));
        }

        @Override
        public void onCallDisconnectCauseChanged(int disconnectCause, int preciseDisconnectCause) {
            CallDisconnectCauseListener listener = (CallDisconnectCauseListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCallDisconnectCauseChanged(disconnectCause, preciseDisconnectCause)));
        }

        @Override
        public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState dataConnectionState) {
            PreciseDataConnectionStateListener listener = (PreciseDataConnectionStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onPreciseDataConnectionStateChanged(dataConnectionState)));
        }

        @Override
        public void onDataConnectionRealTimeInfoChanged(DataConnectionRealTimeInfo dcRtInfo) {
        }

        @Override
        public void onSrvccStateChanged(int state) {
            SrvccStateListener listener = (SrvccStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onSrvccStateChanged(state)));
        }

        @Override
        public void onVoiceActivationStateChanged(int activationState) {
            VoiceActivationStateListener listener = (VoiceActivationStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onVoiceActivationStateChanged(activationState)));
        }

        @Override
        public void onDataActivationStateChanged(int activationState) {
            DataActivationStateListener listener = (DataActivationStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onDataActivationStateChanged(activationState)));
        }

        @Override
        public void onUserMobileDataStateChanged(boolean enabled) {
            UserMobileDataStateListener listener = (UserMobileDataStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onUserMobileDataStateChanged(enabled)));
        }

        @Override
        public void onDisplayInfoChanged(TelephonyDisplayInfo telephonyDisplayInfo) {
            DisplayInfoListener listener = (DisplayInfoListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onDisplayInfoChanged(telephonyDisplayInfo)));
        }

        @Override
        public void onOemHookRawEvent(byte[] rawData) {
        }

        @Override
        public void onCarrierNetworkChange(boolean active) {
            CarrierNetworkListener listener = (CarrierNetworkListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCarrierNetworkChange(active)));
        }

        @Override
        public void onEmergencyNumberListChanged(Map emergencyNumberList) {
            EmergencyNumberListListener listener = (EmergencyNumberListListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onEmergencyNumberListChanged(emergencyNumberList)));
        }

        @Override
        public void onOutgoingEmergencyCall(EmergencyNumber placedEmergencyNumber, int subscriptionId) {
            OutgoingEmergencyCallListener listener = (OutgoingEmergencyCallListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onOutgoingEmergencyCall(placedEmergencyNumber, subscriptionId)));
        }

        @Override
        public void onOutgoingEmergencySms(EmergencyNumber sentEmergencyNumber, int subscriptionId) {
            OutgoingEmergencySmsListener listener = (OutgoingEmergencySmsListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onOutgoingEmergencySms(sentEmergencyNumber, subscriptionId)));
        }

        @Override
        public void onPhoneCapabilityChanged(PhoneCapability capability) {
            PhoneCapabilityListener listener = (PhoneCapabilityListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onPhoneCapabilityChanged(capability)));
        }

        @Override
        public void onRadioPowerStateChanged(int state) {
            RadioPowerStateListener listener = (RadioPowerStateListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onRadioPowerStateChanged(state)));
        }

        @Override
        public void onCallStatesChanged(List<CallState> callStateList) {
            CallAttributesListener listener = (CallAttributesListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCallStatesChanged(callStateList)));
        }

        @Override
        public void onActiveDataSubIdChanged(int subId) {
            ActiveDataSubscriptionIdListener listener = (ActiveDataSubscriptionIdListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onActiveDataSubscriptionIdChanged(subId)));
        }

        @Override
        public void onImsCallDisconnectCauseChanged(ImsReasonInfo disconnectCause) {
            ImsCallDisconnectCauseListener listener = (ImsCallDisconnectCauseListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onImsCallDisconnectCauseChanged(disconnectCause)));
        }

        @Override
        public void onRegistrationFailed(CellIdentity cellIdentity, String chosenPlmn, int domain, int causeCode, int additionalCauseCode) {
            RegistrationFailedListener listener = (RegistrationFailedListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onRegistrationFailed(cellIdentity, chosenPlmn, domain, causeCode, additionalCauseCode)));
        }

        @Override
        public void onBarringInfoChanged(BarringInfo barringInfo) {
            BarringInfoListener listener = (BarringInfoListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onBarringInfoChanged(barringInfo)));
        }

        @Override
        public void onPhysicalChannelConfigChanged(List<PhysicalChannelConfig> configs) {
            PhysicalChannelConfigListener listener = (PhysicalChannelConfigListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onPhysicalChannelConfigChanged(configs)));
        }

        @Override
        public void onDataEnabledChanged(boolean enabled, int reason) {
            DataEnabledListener listener = (DataEnabledListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onDataEnabledChanged(enabled, reason)));
        }

        @Override
        public void onAllowedNetworkTypesChanged(int reason, long allowedNetworkType) {
            AllowedNetworkTypesListener listener = (AllowedNetworkTypesListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onAllowedNetworkTypesChanged(reason, allowedNetworkType)));
        }

        @Override
        public void onLinkCapacityEstimateChanged(List<LinkCapacityEstimate> linkCapacityEstimateList) {
            LinkCapacityEstimateChangedListener listener = (LinkCapacityEstimateChangedListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onLinkCapacityEstimateChanged(linkCapacityEstimateList)));
        }

        @Override
        public void onMediaQualityStatusChanged(MediaQualityStatus mediaQualityStatus) {
            MediaQualityStatusChangedListener listener = (MediaQualityStatusChangedListener)this.mTelephonyCallbackWeakRef.get();
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onMediaQualityStatusChanged(mediaQualityStatus)));
        }

        @Override
        public void onCallBackModeStarted(int type) {
            EmergencyCallbackModeListener listener = (EmergencyCallbackModeListener)this.mTelephonyCallbackWeakRef.get();
            Log.d(TelephonyCallback.LOG_TAG, "onCallBackModeStarted:type=" + type + ", listener=" + listener);
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCallBackModeStarted(type)));
        }

        @Override
        public void onCallBackModeStopped(int type, int reason) {
            EmergencyCallbackModeListener listener = (EmergencyCallbackModeListener)this.mTelephonyCallbackWeakRef.get();
            Log.d(TelephonyCallback.LOG_TAG, "onCallBackModeStopped:type=" + type + ", reason=" + reason + ", listener=" + listener);
            if (listener == null) {
                return;
            }
            Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> listener.onCallBackModeStopped(type, reason)));
        }
    }

    public static interface EmergencyCallbackModeListener {
        @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
        public void onCallBackModeStarted(int var1);

        @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
        public void onCallBackModeStopped(int var1, int var2);
    }

    @SystemApi
    public static interface MediaQualityStatusChangedListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onMediaQualityStatusChanged(MediaQualityStatus var1);
    }

    @SystemApi
    public static interface LinkCapacityEstimateChangedListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onLinkCapacityEstimateChanged(List<LinkCapacityEstimate> var1);
    }

    @SystemApi
    public static interface DataEnabledListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onDataEnabledChanged(boolean var1, int var2);
    }

    public static interface PhysicalChannelConfigListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onPhysicalChannelConfigChanged(List<PhysicalChannelConfig> var1);
    }

    public static interface BarringInfoListener {
        @RequiresPermission(allOf={"android.permission.READ_PRECISE_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
        public void onBarringInfoChanged(BarringInfo var1);
    }

    @SystemApi
    public static interface CallAttributesListener {
        @Deprecated
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        default public void onCallAttributesChanged(CallAttributes callAttributes) {
            Log.w(TelephonyCallback.LOG_TAG, "onCallAttributesChanged(List<CallState>) should be overridden.");
        }

        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        default public void onCallStatesChanged(List<CallState> callStateList) {
            if (callStateList.size() > 0) {
                int foregroundCallState = 0;
                int backgroundCallState = 0;
                int ringingCallState = 0;
                for (CallState cs : callStateList) {
                    switch (cs.getCallClassification()) {
                        case 1: {
                            foregroundCallState = cs.getCallState();
                            break;
                        }
                        case 2: {
                            backgroundCallState = cs.getCallState();
                            break;
                        }
                        case 0: {
                            ringingCallState = cs.getCallState();
                            break;
                        }
                    }
                }
                this.onCallAttributesChanged(new CallAttributes(new PreciseCallState(ringingCallState, foregroundCallState, backgroundCallState, -1, -1), callStateList.get(0).getNetworkType(), callStateList.get(0).getCallQuality()));
            } else {
                this.onCallAttributesChanged(new CallAttributes(new PreciseCallState(0, 0, 0, -1, -1), 0, new CallQuality()));
            }
        }
    }

    @SystemApi
    public static interface AllowedNetworkTypesListener {
        @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
        public void onAllowedNetworkTypesChanged(int var1, long var2);
    }

    public static interface RegistrationFailedListener {
        @RequiresPermission(allOf={"android.permission.READ_PRECISE_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
        public void onRegistrationFailed(CellIdentity var1, String var2, int var3, int var4, int var5);
    }

    public static interface CarrierNetworkListener {
        public void onCarrierNetworkChange(boolean var1);
    }

    @SystemApi
    public static interface RadioPowerStateListener {
        @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
        public void onRadioPowerStateChanged(int var1);
    }

    public static interface ActiveDataSubscriptionIdListener {
        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        public void onActiveDataSubscriptionIdChanged(int var1);
    }

    @SystemApi
    public static interface PhoneCapabilityListener {
        public void onPhoneCapabilityChanged(PhoneCapability var1);
    }

    @SystemApi
    public static interface OutgoingEmergencySmsListener {
        @RequiresPermission(value="android.permission.READ_ACTIVE_EMERGENCY_SESSION")
        public void onOutgoingEmergencySms(EmergencyNumber var1, int var2);
    }

    @SystemApi
    public static interface OutgoingEmergencyCallListener {
        @RequiresPermission(value="android.permission.READ_ACTIVE_EMERGENCY_SESSION")
        public void onOutgoingEmergencyCall(EmergencyNumber var1, int var2);
    }

    public static interface EmergencyNumberListListener {
        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        public void onEmergencyNumberListChanged(Map<Integer, List<EmergencyNumber>> var1);
    }

    public static interface DisplayInfoListener {
        public void onDisplayInfoChanged(TelephonyDisplayInfo var1);
    }

    public static interface UserMobileDataStateListener {
        public void onUserMobileDataStateChanged(boolean var1);
    }

    public static interface DataActivationStateListener {
        public void onDataActivationStateChanged(int var1);
    }

    @SystemApi
    public static interface VoiceActivationStateListener {
        @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
        public void onVoiceActivationStateChanged(int var1);
    }

    @SystemApi
    public static interface SrvccStateListener {
        @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
        public void onSrvccStateChanged(int var1);
    }

    public static interface PreciseDataConnectionStateListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onPreciseDataConnectionStateChanged(PreciseDataConnectionState var1);
    }

    public static interface ImsCallDisconnectCauseListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onImsCallDisconnectCauseChanged(ImsReasonInfo var1);
    }

    public static interface CallDisconnectCauseListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onCallDisconnectCauseChanged(int var1, int var2);
    }

    @SystemApi
    public static interface PreciseCallStateListener {
        @RequiresPermission(value="android.permission.READ_PRECISE_PHONE_STATE")
        public void onPreciseCallStateChanged(PreciseCallState var1);
    }

    public static interface CellInfoListener {
        @RequiresPermission(allOf={"android.permission.READ_PHONE_STATE", "android.permission.ACCESS_FINE_LOCATION"})
        public void onCellInfoChanged(List<CellInfo> var1);
    }

    public static interface SignalStrengthsListener {
        public void onSignalStrengthsChanged(SignalStrength var1);
    }

    public static interface DataActivityListener {
        public void onDataActivity(int var1);
    }

    public static interface DataConnectionStateListener {
        public void onDataConnectionStateChanged(int var1, int var2);
    }

    public static interface CallStateListener {
        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        public void onCallStateChanged(int var1);
    }

    public static interface CellLocationListener {
        @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
        public void onCellLocationChanged(CellLocation var1);
    }

    public static interface CallForwardingIndicatorListener {
        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        public void onCallForwardingIndicatorChanged(boolean var1);
    }

    public static interface MessageWaitingIndicatorListener {
        @RequiresPermission(value="android.permission.READ_PHONE_STATE")
        public void onMessageWaitingIndicatorChanged(boolean var1);
    }

    public static interface ServiceStateListener {
        public void onServiceStateChanged(ServiceState var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TelephonyEvent {
    }
}

