/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import java.util.Objects;

public class TelephonyDisplayInfo
implements Parcelable {
    public static final int OVERRIDE_NETWORK_TYPE_NONE = 0;
    public static final int OVERRIDE_NETWORK_TYPE_LTE_CA = 1;
    public static final int OVERRIDE_NETWORK_TYPE_LTE_ADVANCED_PRO = 2;
    public static final int OVERRIDE_NETWORK_TYPE_NR_NSA = 3;
    @Deprecated
    public static final int OVERRIDE_NETWORK_TYPE_NR_NSA_MMWAVE = 4;
    public static final int OVERRIDE_NETWORK_TYPE_NR_ADVANCED = 5;
    private final int mNetworkType;
    private final int mOverrideNetworkType;
    private final boolean mIsRoaming;
    public static final Parcelable.Creator<TelephonyDisplayInfo> CREATOR = new Parcelable.Creator<TelephonyDisplayInfo>(){

        @Override
        public TelephonyDisplayInfo createFromParcel(Parcel source) {
            return new TelephonyDisplayInfo(source);
        }

        public TelephonyDisplayInfo[] newArray(int size) {
            return new TelephonyDisplayInfo[size];
        }
    };

    @Deprecated
    public TelephonyDisplayInfo(int networkType, int overrideNetworkType) {
        this(networkType, overrideNetworkType, false);
    }

    public TelephonyDisplayInfo(int networkType, int overrideNetworkType, boolean isRoaming) {
        this.mNetworkType = networkType;
        this.mOverrideNetworkType = overrideNetworkType;
        this.mIsRoaming = isRoaming;
    }

    public TelephonyDisplayInfo(Parcel p) {
        this.mNetworkType = p.readInt();
        this.mOverrideNetworkType = p.readInt();
        this.mIsRoaming = p.readBoolean();
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    public int getOverrideNetworkType() {
        return this.mOverrideNetworkType;
    }

    public boolean isRoaming() {
        return this.mIsRoaming;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mNetworkType);
        dest.writeInt(this.mOverrideNetworkType);
        dest.writeBoolean(this.mIsRoaming);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyDisplayInfo that = (TelephonyDisplayInfo)o;
        return this.mNetworkType == that.mNetworkType && this.mOverrideNetworkType == that.mOverrideNetworkType && this.mIsRoaming == that.mIsRoaming;
    }

    public int hashCode() {
        return Objects.hash(this.mNetworkType, this.mOverrideNetworkType, this.mIsRoaming);
    }

    public static String overrideNetworkTypeToString(int type) {
        switch (type) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "LTE_CA";
            }
            case 2: {
                return "LTE_ADV_PRO";
            }
            case 3: {
                return "NR_NSA";
            }
            case 4: {
                return "NR_NSA_MMWAVE";
            }
            case 5: {
                return "NR_ADVANCED";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        return "TelephonyDisplayInfo {network=" + TelephonyManager.getNetworkTypeName(this.mNetworkType) + ", overrideNetwork=" + TelephonyDisplayInfo.overrideNetworkTypeToString(this.mOverrideNetworkType) + ", isRoaming=" + this.mIsRoaming + "}";
    }
}

