/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.SubscriptionInfo;
import android.telephony.UiccPortInfo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
public class UiccSlotInfo
implements Parcelable {
    public static final int CARD_STATE_INFO_ABSENT = 1;
    public static final int CARD_STATE_INFO_PRESENT = 2;
    public static final int CARD_STATE_INFO_ERROR = 3;
    public static final int CARD_STATE_INFO_RESTRICTED = 4;
    private final boolean mIsActive;
    private final boolean mIsEuicc;
    private final String mCardId;
    private final int mCardStateInfo;
    private final int mLogicalSlotIdx;
    private final boolean mIsExtendedApduSupported;
    private final boolean mIsRemovable;
    private final List<UiccPortInfo> mPortList;
    private boolean mLogicalSlotAccessRestricted = false;
    public static final Parcelable.Creator<UiccSlotInfo> CREATOR = new Parcelable.Creator<UiccSlotInfo>(){

        @Override
        public UiccSlotInfo createFromParcel(Parcel in) {
            return new UiccSlotInfo(in);
        }

        public UiccSlotInfo[] newArray(int size) {
            return new UiccSlotInfo[size];
        }
    };

    private UiccSlotInfo(Parcel in) {
        this.mIsActive = in.readBoolean();
        this.mIsEuicc = in.readBoolean();
        this.mCardId = in.readString8();
        this.mCardStateInfo = in.readInt();
        this.mLogicalSlotIdx = in.readInt();
        this.mIsExtendedApduSupported = in.readBoolean();
        this.mIsRemovable = in.readBoolean();
        this.mPortList = new ArrayList<UiccPortInfo>();
        in.readTypedList(this.mPortList, UiccPortInfo.CREATOR);
        this.mLogicalSlotAccessRestricted = in.readBoolean();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBoolean(this.mIsActive);
        dest.writeBoolean(this.mIsEuicc);
        dest.writeString8(this.mCardId);
        dest.writeInt(this.mCardStateInfo);
        dest.writeInt(this.mLogicalSlotIdx);
        dest.writeBoolean(this.mIsExtendedApduSupported);
        dest.writeBoolean(this.mIsRemovable);
        dest.writeTypedList(this.mPortList, flags);
        dest.writeBoolean(this.mLogicalSlotAccessRestricted);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Deprecated
    public UiccSlotInfo(boolean isActive, boolean isEuicc, String cardId, int cardStateInfo, int logicalSlotIdx, boolean isExtendedApduSupported) {
        this.mIsActive = isActive;
        this.mIsEuicc = isEuicc;
        this.mCardId = cardId;
        this.mCardStateInfo = cardStateInfo;
        this.mLogicalSlotIdx = logicalSlotIdx;
        this.mIsExtendedApduSupported = isExtendedApduSupported;
        this.mIsRemovable = false;
        this.mPortList = new ArrayList<UiccPortInfo>();
    }

    public UiccSlotInfo(boolean isEuicc, String cardId, int cardStateInfo, boolean isExtendedApduSupported, boolean isRemovable, List<UiccPortInfo> portList) {
        this.mIsEuicc = isEuicc;
        this.mCardId = cardId;
        this.mCardStateInfo = cardStateInfo;
        this.mIsExtendedApduSupported = isExtendedApduSupported;
        this.mIsRemovable = isRemovable;
        this.mPortList = portList;
        this.mIsActive = !portList.isEmpty() && portList.get(0).isActive();
        this.mLogicalSlotIdx = portList.isEmpty() ? -1 : portList.get(0).getLogicalSlotIndex();
    }

    @Deprecated
    public boolean getIsActive() {
        if (this.mLogicalSlotAccessRestricted) {
            throw new UnsupportedOperationException("getIsActive() is not supported by UiccSlotInfo. Please Use UiccPortInfo API instead");
        }
        return this.mIsActive;
    }

    public boolean getIsEuicc() {
        return this.mIsEuicc;
    }

    public String getCardId() {
        return this.mCardId;
    }

    public int getCardStateInfo() {
        return this.mCardStateInfo;
    }

    @Deprecated
    public int getLogicalSlotIdx() {
        if (this.mLogicalSlotAccessRestricted) {
            throw new UnsupportedOperationException("getLogicalSlotIdx() is not supported by UiccSlotInfo. Please use UiccPortInfo API instead");
        }
        return this.mLogicalSlotIdx;
    }

    public boolean getIsExtendedApduSupported() {
        return this.mIsExtendedApduSupported;
    }

    public boolean isRemovable() {
        return this.mIsRemovable;
    }

    public Collection<UiccPortInfo> getPorts() {
        return Collections.unmodifiableList(this.mPortList);
    }

    public void setLogicalSlotAccessRestricted(boolean logicalSlotAccessRestricted) {
        this.mLogicalSlotAccessRestricted = logicalSlotAccessRestricted;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UiccSlotInfo that = (UiccSlotInfo)obj;
        return this.mIsActive == that.mIsActive && this.mIsEuicc == that.mIsEuicc && Objects.equals(this.mCardId, that.mCardId) && this.mCardStateInfo == that.mCardStateInfo && this.mLogicalSlotIdx == that.mLogicalSlotIdx && this.mIsExtendedApduSupported == that.mIsExtendedApduSupported && this.mIsRemovable == that.mIsRemovable && Objects.equals(this.mPortList, that.mPortList);
    }

    public int hashCode() {
        return Objects.hash(this.mIsActive, this.mIsEuicc, this.mCardId, this.mCardStateInfo, this.mLogicalSlotIdx, this.mIsExtendedApduSupported, this.mIsRemovable, this.mPortList);
    }

    public String toString() {
        return "UiccSlotInfo (, mIsEuicc=" + this.mIsEuicc + ", mCardId=" + SubscriptionInfo.getPrintableId(this.mCardId) + ", cardState=" + this.mCardStateInfo + ", mIsExtendedApduSupported=" + this.mIsExtendedApduSupported + ", mIsRemovable=" + this.mIsRemovable + ", mPortList=" + this.mPortList + ", mLogicalSlotAccessRestricted=" + this.mLogicalSlotAccessRestricted + ")";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CardStateInfo {
    }
}

