/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeSet;

@SystemApi
public class MediaThreshold
implements Parcelable {
    private final int[] mRtpPacketLossRate;
    private final int[] mRtpJitter;
    private final long[] mRtpInactivityTimeMillis;
    public static final Parcelable.Creator<MediaThreshold> CREATOR = new Parcelable.Creator<MediaThreshold>(){

        @Override
        public MediaThreshold createFromParcel(Parcel in) {
            return new MediaThreshold(in);
        }

        public MediaThreshold[] newArray(int size) {
            return new MediaThreshold[size];
        }
    };

    @SystemApi
    public int[] getThresholdsRtpPacketLossRate() {
        return this.mRtpPacketLossRate;
    }

    public int[] getThresholdsRtpJitterMillis() {
        return this.mRtpJitter;
    }

    public long[] getThresholdsRtpInactivityTimeMillis() {
        return this.mRtpInactivityTimeMillis;
    }

    private MediaThreshold(int[] packetLossRateThresholds, int[] jitterThresholds, long[] inactivityTimeThresholds) {
        this.mRtpPacketLossRate = packetLossRateThresholds;
        this.mRtpJitter = jitterThresholds;
        this.mRtpInactivityTimeMillis = inactivityTimeThresholds;
    }

    private MediaThreshold(Parcel in) {
        this.mRtpPacketLossRate = in.createIntArray();
        this.mRtpJitter = in.createIntArray();
        this.mRtpInactivityTimeMillis = in.createLongArray();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.mRtpPacketLossRate);
        dest.writeIntArray(this.mRtpJitter);
        dest.writeLongArray(this.mRtpInactivityTimeMillis);
    }

    public static boolean isValidRtpPacketLossRate(int packetLossRate) {
        return packetLossRate >= 0 && packetLossRate <= 100;
    }

    public static boolean isValidJitterMillis(int jitter) {
        return jitter >= 0 && jitter <= 10000;
    }

    public static boolean isValidRtpInactivityTimeMillis(long inactivityTime) {
        return inactivityTime >= 0L && inactivityTime <= 60000L;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaThreshold that = (MediaThreshold)o;
        return Arrays.equals(this.mRtpPacketLossRate, that.mRtpPacketLossRate) && Arrays.equals(this.mRtpJitter, that.mRtpJitter) && Arrays.equals(this.mRtpInactivityTimeMillis, that.mRtpInactivityTimeMillis);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mRtpPacketLossRate), Arrays.hashCode(this.mRtpJitter), Arrays.hashCode(this.mRtpInactivityTimeMillis));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaThreshold{mRtpPacketLossRate=");
        for (int i : this.mRtpPacketLossRate) {
            sb.append(" ").append(i);
        }
        sb.append(", mRtpJitter=");
        for (int b : this.mRtpJitter) {
            sb.append(" ").append(b);
        }
        sb.append(", mRtpInactivityTimeMillis=");
        for (long i : this.mRtpInactivityTimeMillis) {
            sb.append(" ").append(i);
        }
        sb.append("}");
        return sb.toString();
    }

    public static class Builder {
        private int[] mRtpPacketLossRate = null;
        private int[] mRtpJitter = null;
        private long[] mRtpInactivityTimeMillis = null;

        public Builder setThresholdsRtpPacketLossRate(int[] packetLossRateThresholds) {
            if (packetLossRateThresholds.length > 0) {
                TreeSet<Integer> thresholds = new TreeSet<Integer>();
                int[] nArray = packetLossRateThresholds;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer value = nArray[i];
                    if (!MediaThreshold.isValidRtpPacketLossRate(value)) continue;
                    thresholds.add(value);
                }
                int[] targetArray = new int[thresholds.size()];
                int i = 0;
                Iterator iterator = thresholds.iterator();
                while (iterator.hasNext()) {
                    int element = (Integer)iterator.next();
                    targetArray[i++] = element;
                }
                this.mRtpPacketLossRate = targetArray;
            } else {
                this.mRtpPacketLossRate = packetLossRateThresholds;
            }
            return this;
        }

        public Builder setThresholdsRtpJitterMillis(int[] jitterThresholds) {
            if (jitterThresholds.length > 0) {
                TreeSet<Integer> thresholds = new TreeSet<Integer>();
                int[] nArray = jitterThresholds;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer value = nArray[i];
                    if (!MediaThreshold.isValidJitterMillis(value)) continue;
                    thresholds.add(value);
                }
                int[] targetArray = new int[thresholds.size()];
                int i = 0;
                Iterator iterator = thresholds.iterator();
                while (iterator.hasNext()) {
                    int element = (Integer)iterator.next();
                    targetArray[i++] = element;
                }
                this.mRtpJitter = targetArray;
            } else {
                this.mRtpJitter = jitterThresholds;
            }
            return this;
        }

        public Builder setThresholdsRtpInactivityTimeMillis(long[] inactivityTimeThresholds) {
            if (inactivityTimeThresholds.length > 0) {
                TreeSet<Long> thresholds = new TreeSet<Long>();
                long[] lArray = inactivityTimeThresholds;
                int n = lArray.length;
                for (int i = 0; i < n; ++i) {
                    Long value = lArray[i];
                    if (!MediaThreshold.isValidRtpInactivityTimeMillis(value)) continue;
                    thresholds.add(value);
                }
                long[] targetArray = new long[thresholds.size()];
                int i = 0;
                Iterator iterator = thresholds.iterator();
                while (iterator.hasNext()) {
                    long element = (Long)iterator.next();
                    targetArray[i++] = element;
                }
                this.mRtpInactivityTimeMillis = targetArray;
            } else {
                this.mRtpInactivityTimeMillis = inactivityTimeThresholds;
            }
            return this;
        }

        public MediaThreshold build() {
            this.mRtpPacketLossRate = this.mRtpPacketLossRate != null ? this.mRtpPacketLossRate : new int[]{};
            this.mRtpJitter = this.mRtpJitter != null ? this.mRtpJitter : new int[]{};
            this.mRtpInactivityTimeMillis = this.mRtpInactivityTimeMillis != null ? this.mRtpInactivityTimeMillis : new long[]{};
            return new MediaThreshold(this.mRtpPacketLossRate, this.mRtpJitter, this.mRtpInactivityTimeMillis);
        }
    }
}

