/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.os._Original_Build;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.android.telephony.Rlog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class RcsConfig {
    private static final String LOG_TAG = "RcsConfig";
    private static final boolean DBG = _Original_Build.IS_ENG;
    private static final String TAG_CHARACTERISTIC = "characteristic";
    private static final String TAG_PARM = "parm";
    private static final String ATTRIBUTE_TYPE = "type";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String PARM_SINGLE_REGISTRATION = "rcsVolteSingleRegistration";
    private final Characteristic mRoot;
    private Characteristic mCurrent;
    private final byte[] mData;

    public RcsConfig(byte[] data) throws IllegalArgumentException {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Empty data");
        }
        this.mCurrent = this.mRoot = new Characteristic(null, null);
        this.mData = data;
        Characteristic current = this.mRoot;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XmlPullParser xpp = factory.newPullParser();
            xpp.setInput((InputStream)inputStream, null);
            int eventType = xpp.getEventType();
            String tag = null;
            while (eventType != 1 && current != null) {
                if (eventType == 2) {
                    int count;
                    tag = xpp.getName().trim().toLowerCase(Locale.ROOT);
                    if (TAG_CHARACTERISTIC.equals(tag)) {
                        count = xpp.getAttributeCount();
                        String type = null;
                        if (count > 0) {
                            for (int i = 0; i < count; ++i) {
                                String name = xpp.getAttributeName(i).trim().toLowerCase(Locale.ROOT);
                                if (!ATTRIBUTE_TYPE.equals(name)) continue;
                                type = xpp.getAttributeValue(xpp.getAttributeNamespace(i), name).trim().toLowerCase(Locale.ROOT);
                                break;
                            }
                        }
                        Characteristic next = new Characteristic(type, current);
                        current.getSubs().add(next);
                        current = next;
                    } else if (TAG_PARM.equals(tag)) {
                        count = xpp.getAttributeCount();
                        String key = null;
                        String value = null;
                        if (count > 1) {
                            for (int i = 0; i < count; ++i) {
                                String name = xpp.getAttributeName(i).trim().toLowerCase(Locale.ROOT);
                                if (ATTRIBUTE_NAME.equals(name)) {
                                    key = xpp.getAttributeValue(xpp.getAttributeNamespace(i), name).trim().toLowerCase(Locale.ROOT);
                                    continue;
                                }
                                if (!ATTRIBUTE_VALUE.equals(name)) continue;
                                value = xpp.getAttributeValue(xpp.getAttributeNamespace(i), name).trim();
                            }
                        }
                        if (key != null && value != null) {
                            current.getParms().put(key, value);
                        }
                    }
                } else if (eventType == 3) {
                    tag = xpp.getName().trim().toLowerCase(Locale.ROOT);
                    if (TAG_CHARACTERISTIC.equals(tag)) {
                        current = current.getParent();
                    }
                    tag = null;
                }
                eventType = xpp.next();
            }
        }
        catch (IOException | XmlPullParserException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                RcsConfig.loge("error to close input stream, skip.");
            }
        }
    }

    public String getString(String tag, String defaultVal) {
        String value = this.mCurrent.getParmValue(tag.trim().toLowerCase(Locale.ROOT));
        return value != null ? value : defaultVal;
    }

    public int getInteger(String tag, int defaultVal) {
        try {
            return Integer.parseInt(this.getString(tag, null));
        }
        catch (NumberFormatException e) {
            RcsConfig.logd("error to getInteger for " + tag + " due to " + e);
            return defaultVal;
        }
    }

    public boolean getBoolean(String tag, boolean defaultVal) {
        String value = this.getString(tag, null);
        return value != null ? Boolean.parseBoolean(value) : defaultVal;
    }

    public boolean hasConfig(String tag) {
        return this.mCurrent.hasParm(tag.trim().toLowerCase(Locale.ROOT));
    }

    public Characteristic getCharacteristic(String type) {
        return this.mCurrent.getSubByType(type.trim().toLowerCase(Locale.ROOT));
    }

    public boolean hasCharacteristic(String type) {
        return this.mCurrent.getSubByType(type.trim().toLowerCase(Locale.ROOT)) != null;
    }

    public void setCurrentCharacteristic(Characteristic current) {
        if (current != null) {
            this.mCurrent = current;
        }
    }

    public boolean moveToParent() {
        if (this.mCurrent.getParent() == null) {
            return false;
        }
        this.mCurrent = this.mCurrent.getParent();
        return true;
    }

    public void moveToRoot() {
        this.mCurrent = this.mRoot;
    }

    public Characteristic getRoot() {
        return this.mRoot;
    }

    public Characteristic getCurrentCharacteristic() {
        return this.mCurrent;
    }

    public boolean isRcsVolteSingleRegistrationSupported(boolean isRoaming) {
        int val = this.getInteger(PARM_SINGLE_REGISTRATION, 1);
        return isRoaming ? val == 1 : val > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[RCS Config]");
        if (DBG) {
            sb.append("=== Root ===\n");
            sb.append(this.mRoot);
            sb.append("=== Current ===\n");
            sb.append(this.mCurrent);
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RcsConfig)) {
            return false;
        }
        RcsConfig other = (RcsConfig)obj;
        return this.mRoot.equals(other.mRoot) && this.mCurrent.equals(other.mCurrent);
    }

    public int hashCode() {
        return Objects.hash(this.mRoot, this.mCurrent);
    }

    public static byte[] compressGzip(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte[] out = null;
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
            GZIPOutputStream gzipCompressingStream = new GZIPOutputStream(outputStream);
            gzipCompressingStream.write(data);
            gzipCompressingStream.close();
            out = outputStream.toByteArray();
            outputStream.close();
        }
        catch (IOException e) {
            RcsConfig.loge("Error to compressGzip due to " + e);
        }
        return out;
    }

    public static byte[] decompressGzip(byte[] data) {
        if (data == null || data.length == 0) {
            return data;
        }
        byte[] out = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            GZIPInputStream gzipDecompressingStream = new GZIPInputStream(inputStream);
            byte[] buf = new byte[1024];
            int size = gzipDecompressingStream.read(buf);
            while (size >= 0) {
                outputStream.write(buf, 0, size);
                size = gzipDecompressingStream.read(buf);
            }
            gzipDecompressingStream.close();
            inputStream.close();
            out = outputStream.toByteArray();
            outputStream.close();
        }
        catch (IOException e) {
            RcsConfig.loge("Error to decompressGzip due to " + e);
        }
        return out;
    }

    public static void updateConfigForSub(Context cxt, int subId, byte[] config, boolean isCompressed) {
        byte[] data = isCompressed ? config : RcsConfig.compressGzip(config);
        ContentValues values = new ContentValues();
        values.put("rcs_config", data);
        cxt.getContentResolver().update(Telephony.SimInfo.CONTENT_URI, values, "_id=" + subId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadRcsConfigForSub(Context cxt, int subId, boolean isCompressed) {
        byte[] data = null;
        try (Cursor cursor = cxt.getContentResolver().query(Telephony.SimInfo.CONTENT_URI, null, "_id=" + subId, null, null);){
            if (cursor != null && cursor.moveToFirst()) {
                data = cursor.getBlob(cursor.getColumnIndexOrThrow("rcs_config"));
            }
        }
        return isCompressed ? data : RcsConfig.decompressGzip(data);
    }

    private static void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private static void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    public static class Characteristic {
        private String mType;
        private final Map<String, String> mParms = new ArrayMap<String, String>();
        private final Set<Characteristic> mSubs = new ArraySet<Characteristic>();
        private final Characteristic mParent;

        private Characteristic(String type, Characteristic parent) {
            this.mType = type;
            this.mParent = parent;
        }

        private String getType() {
            return this.mType;
        }

        private Map<String, String> getParms() {
            return this.mParms;
        }

        private Set<Characteristic> getSubs() {
            return this.mSubs;
        }

        private Characteristic getParent() {
            return this.mParent;
        }

        private Characteristic getSubByType(String type) {
            Characteristic sub;
            if (TextUtils.equals(this.mType, type)) {
                return this;
            }
            Characteristic result = null;
            Iterator<Characteristic> iterator = this.mSubs.iterator();
            while (iterator.hasNext() && (result = (sub = iterator.next()).getSubByType(type)) == null) {
            }
            return result;
        }

        private boolean hasSubByType(String type) {
            return this.getSubByType(type) != null;
        }

        private String getParmValue(String name) {
            String value;
            block1: {
                Characteristic sub;
                value = this.mParms.get(name);
                if (value != null) break block1;
                Iterator<Characteristic> iterator = this.mSubs.iterator();
                while (iterator.hasNext() && (value = (sub = iterator.next()).getParmValue(name)) == null) {
                }
            }
            return value;
        }

        boolean hasParm(String name) {
            if (this.mParms.containsKey(name)) {
                return true;
            }
            for (Characteristic sub : this.mSubs) {
                if (!sub.hasParm(name)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.mType + "]: ");
            if (DBG) {
                sb.append(this.mParms);
            }
            for (Characteristic sub : this.mSubs) {
                sb.append("\n");
                sb.append(sub.toString().replace("\n", "\n\t"));
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Characteristic)) {
                return false;
            }
            Characteristic o = (Characteristic)obj;
            return TextUtils.equals(this.mType, o.mType) && this.mParms.equals(o.mParms) && this.mSubs.equals(o.mSubs);
        }

        public int hashCode() {
            return Objects.hash(this.mType, this.mParms, this.mSubs);
        }
    }
}

