/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.telephony.BinderCacheManager;
import android.telephony.ims.DelegateRequest;
import android.telephony.ims.ImsException;
import android.telephony.ims.ImsStateCallback;
import android.telephony.ims.SipDelegateConnection;
import android.telephony.ims.SipDialogStateCallback;
import android.telephony.ims.aidl.IImsRcsController;
import android.telephony.ims.aidl.SipDelegateConnectionAidlWrapper;
import android.telephony.ims.stub.DelegateConnectionMessageCallback;
import android.telephony.ims.stub.DelegateConnectionStateCallback;
import android.util.ArrayMap;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.telephony.ITelephony;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.Executor;

@SystemApi
public class SipDelegateManager {
    public static final int MESSAGE_FAILURE_REASON_UNKNOWN = 0;
    public static final int MESSAGE_FAILURE_REASON_DELEGATE_DEAD = 1;
    public static final int MESSAGE_FAILURE_REASON_DELEGATE_CLOSED = 2;
    public static final int MESSAGE_FAILURE_REASON_INVALID_START_LINE = 3;
    public static final int MESSAGE_FAILURE_REASON_INVALID_HEADER_FIELDS = 4;
    public static final int MESSAGE_FAILURE_REASON_INVALID_BODY_CONTENT = 5;
    public static final int MESSAGE_FAILURE_REASON_INVALID_FEATURE_TAG = 6;
    public static final int MESSAGE_FAILURE_REASON_TAG_NOT_ENABLED_FOR_DELEGATE = 7;
    public static final int MESSAGE_FAILURE_REASON_NETWORK_NOT_AVAILABLE = 8;
    public static final int MESSAGE_FAILURE_REASON_NOT_REGISTERED = 9;
    public static final int MESSAGE_FAILURE_REASON_STALE_IMS_CONFIGURATION = 10;
    public static final int MESSAGE_FAILURE_REASON_INTERNAL_DELEGATE_STATE_TRANSITION = 11;
    public static final ArrayMap<Integer, String> MESSAGE_FAILURE_REASON_STRING_MAP = new ArrayMap(11);
    public static final int DENIED_REASON_UNKNOWN = 0;
    public static final int DENIED_REASON_IN_USE_BY_ANOTHER_DELEGATE = 1;
    public static final int DENIED_REASON_NOT_ALLOWED = 2;
    public static final int DENIED_REASON_SINGLE_REGISTRATION_NOT_ALLOWED = 3;
    public static final int DENIED_REASON_INVALID = 4;
    public static final int SIP_DELEGATE_DESTROY_REASON_UNKNOWN = 0;
    public static final int SIP_DELEGATE_DESTROY_REASON_SERVICE_DEAD = 1;
    public static final int SIP_DELEGATE_DESTROY_REASON_REQUESTED_BY_APP = 2;
    public static final int SIP_DELEGATE_DESTROY_REASON_USER_DISABLED_RCS = 3;
    public static final int SIP_DELEGATE_DESTROY_REASON_SUBSCRIPTION_TORN_DOWN = 4;
    private final Context mContext;
    private final int mSubId;
    private final BinderCacheManager<IImsRcsController> mBinderCache;
    private final BinderCacheManager<ITelephony> mTelephonyBinderCache;

    @VisibleForTesting
    public SipDelegateManager(Context context, int subId, BinderCacheManager<IImsRcsController> binderCache, BinderCacheManager<ITelephony> telephonyBinderCache) {
        this.mContext = context;
        this.mSubId = subId;
        this.mBinderCache = binderCache;
        this.mTelephonyBinderCache = telephonyBinderCache;
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.PERFORM_IMS_SINGLE_REGISTRATION"})
    public boolean isSupported() throws ImsException {
        try {
            IImsRcsController controller = this.mBinderCache.getBinder();
            if (controller == null) {
                throw new ImsException("Telephony server is down", 1);
            }
            return controller.isSipDelegateSupported(this.mSubId);
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @RequiresPermission(value="android.permission.PERFORM_IMS_SINGLE_REGISTRATION")
    public void createSipDelegate(DelegateRequest request, Executor executor, DelegateConnectionStateCallback dc, DelegateConnectionMessageCallback mc) throws ImsException {
        Objects.requireNonNull(request, "The DelegateRequest must not be null.");
        Objects.requireNonNull(executor, "The Executor must not be null.");
        Objects.requireNonNull(dc, "The DelegateConnectionStateCallback must not be null.");
        Objects.requireNonNull(mc, "The DelegateConnectionMessageCallback must not be null.");
        try {
            SipDelegateConnectionAidlWrapper wrapper = new SipDelegateConnectionAidlWrapper(executor, dc, mc);
            IImsRcsController controller = this.mBinderCache.listenOnBinder(wrapper, wrapper::binderDied);
            if (controller == null) {
                throw new ImsException("Telephony server is down", 1);
            }
            controller.createSipDelegate(this.mSubId, request, this.mContext.getOpPackageName(), wrapper.getStateCallbackBinder(), wrapper.getMessageCallbackBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    @RequiresPermission(value="android.permission.PERFORM_IMS_SINGLE_REGISTRATION")
    public void destroySipDelegate(SipDelegateConnection delegateConnection, int reason) {
        Objects.requireNonNull(delegateConnection, "SipDelegateConnection can not be null.");
        if (delegateConnection instanceof SipDelegateConnectionAidlWrapper) {
            SipDelegateConnectionAidlWrapper w = (SipDelegateConnectionAidlWrapper)delegateConnection;
            try {
                IImsRcsController c = this.mBinderCache.removeRunnable(w);
                c.destroySipDelegate(this.mSubId, w.getSipDelegateBinder(), reason);
            }
            catch (RemoteException e) {
                try {
                    w.getStateCallbackBinder().onDestroyed(2);
                }
                catch (RemoteException remoteException) {}
            }
        } else {
            throw new IllegalArgumentException("Unknown SipDelegateConnection implementation passed into this method");
        }
    }

    @RequiresPermission(value="android.permission.PERFORM_IMS_SINGLE_REGISTRATION")
    public void triggerFullNetworkRegistration(SipDelegateConnection connection, int sipCode, String sipReason) {
        Objects.requireNonNull(connection, "SipDelegateConnection can not be null.");
        if (connection instanceof SipDelegateConnectionAidlWrapper) {
            SipDelegateConnectionAidlWrapper w = (SipDelegateConnectionAidlWrapper)connection;
            try {
                IImsRcsController controller = this.mBinderCache.getBinder();
                controller.triggerNetworkRegistration(this.mSubId, w.getSipDelegateBinder(), sipCode, sipReason);
            }
            catch (RemoteException remoteException) {}
        } else {
            throw new IllegalArgumentException("Unknown SipDelegateConnection implementation passed into this method");
        }
    }

    @RequiresPermission(anyOf={"android.permission.READ_PRIVILEGED_PHONE_STATE", "android.permission.PERFORM_IMS_SINGLE_REGISTRATION"})
    public void registerImsStateCallback(Executor executor, ImsStateCallback callback) throws ImsException {
        Objects.requireNonNull(callback, "Must include a non-null ImsStateCallback.");
        Objects.requireNonNull(executor, "Must include a non-null Executor.");
        callback.init(executor);
        ITelephony telephony = this.mTelephonyBinderCache.listenOnBinder(callback, callback::binderDied);
        if (telephony == null) {
            throw new ImsException("Telephony server is down", 1);
        }
        try {
            telephony.registerImsStateCallback(this.mSubId, 2, callback.getCallbackBinder(), this.mContext.getOpPackageName());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException | IllegalStateException e) {
            throw new ImsException(e.getMessage(), 1);
        }
    }

    public void unregisterImsStateCallback(ImsStateCallback callback) {
        Objects.requireNonNull(callback, "Must include a non-null ImsStateCallback.");
        ITelephony telephony = this.mTelephonyBinderCache.removeRunnable(callback);
        try {
            if (telephony != null) {
                telephony.unregisterImsStateCallback(callback.getCallbackBinder());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void registerSipDialogStateCallback(Executor executor, SipDialogStateCallback callback) throws ImsException {
        Objects.requireNonNull(callback, "Must include a non-null SipDialogStateCallback.");
        Objects.requireNonNull(executor, "Must include a non-null Executor.");
        callback.attachExecutor(executor);
        try {
            IImsRcsController controller = this.mBinderCache.listenOnBinder(callback, callback::binderDied);
            if (controller == null) {
                throw new ImsException("Telephony server is down", 1);
            }
            controller.registerSipDialogStateCallback(this.mSubId, callback.getCallbackBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public void unregisterSipDialogStateCallback(SipDialogStateCallback callback) throws ImsException {
        Objects.requireNonNull(callback, "Must include a non-null SipDialogStateCallback.");
        IImsRcsController controller = this.mBinderCache.removeRunnable(callback);
        try {
            if (controller == null) {
                throw new ImsException("Telephony server is down", 1);
            }
            controller.unregisterSipDialogStateCallback(this.mSubId, callback.getCallbackBinder());
        }
        catch (ServiceSpecificException e) {
            throw new ImsException(e.getMessage(), e.errorCode);
        }
        catch (RemoteException e) {
            throw new ImsException(e.getMessage(), 1);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    static {
        MESSAGE_FAILURE_REASON_STRING_MAP.append(0, "MESSAGE_FAILURE_REASON_UNKNOWN");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(1, "MESSAGE_FAILURE_REASON_DELEGATE_DEAD");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(2, "MESSAGE_FAILURE_REASON_DELEGATE_CLOSED");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(4, "MESSAGE_FAILURE_REASON_INVALID_HEADER_FIELDS");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(5, "MESSAGE_FAILURE_REASON_INVALID_BODY_CONTENT");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(6, "MESSAGE_FAILURE_REASON_INVALID_FEATURE_TAG");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(7, "MESSAGE_FAILURE_REASON_TAG_NOT_ENABLED_FOR_DELEGATE");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(8, "MESSAGE_FAILURE_REASON_NETWORK_NOT_AVAILABLE");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(9, "MESSAGE_FAILURE_REASON_NOT_REGISTERED");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(10, "MESSAGE_FAILURE_REASON_STALE_IMS_CONFIGURATION");
        MESSAGE_FAILURE_REASON_STRING_MAP.append(11, "MESSAGE_FAILURE_REASON_INTERNAL_DELEGATE_STATE_TRANSITION");
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SipDelegateDestroyReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeniedReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MessageFailureReason {
    }
}

