/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.net.Uri;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.SipDetails;
import android.telephony.ims.aidl.IOptionsRequestCallback;
import java.util.ArrayList;
import java.util.List;

public interface ICapabilityExchangeEventListener
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.ICapabilityExchangeEventListener";

    public void onRequestPublishCapabilities(int var1) throws RemoteException;

    public void onUnpublish() throws RemoteException;

    public void onPublishUpdated(SipDetails var1) throws RemoteException;

    public void onRemoteCapabilityRequest(Uri var1, List<String> var2, IOptionsRequestCallback var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICapabilityExchangeEventListener {
        static final int TRANSACTION_onRequestPublishCapabilities = 1;
        static final int TRANSACTION_onUnpublish = 2;
        static final int TRANSACTION_onPublishUpdated = 3;
        static final int TRANSACTION_onRemoteCapabilityRequest = 4;

        public Stub() {
            this.attachInterface(this, ICapabilityExchangeEventListener.DESCRIPTOR);
        }

        public static ICapabilityExchangeEventListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ICapabilityExchangeEventListener.DESCRIPTOR);
            if (iin != null && iin instanceof ICapabilityExchangeEventListener) {
                return (ICapabilityExchangeEventListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onRequestPublishCapabilities";
                }
                case 2: {
                    return "onUnpublish";
                }
                case 3: {
                    return "onPublishUpdated";
                }
                case 4: {
                    return "onRemoteCapabilityRequest";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ICapabilityExchangeEventListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onRequestPublishCapabilities(_arg0);
                    break;
                }
                case 2: {
                    this.onUnpublish();
                    break;
                }
                case 3: {
                    SipDetails _arg0 = data.readTypedObject(SipDetails.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPublishUpdated(_arg0);
                    break;
                }
                case 4: {
                    Uri _arg0 = data.readTypedObject(Uri.CREATOR);
                    ArrayList<String> _arg1 = data.createStringArrayList();
                    IOptionsRequestCallback _arg2 = IOptionsRequestCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onRemoteCapabilityRequest(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements ICapabilityExchangeEventListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ICapabilityExchangeEventListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRequestPublishCapabilities(int publishTriggerType) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICapabilityExchangeEventListener.DESCRIPTOR);
                    _data.writeInt(publishTriggerType);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onUnpublish() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICapabilityExchangeEventListener.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPublishUpdated(SipDetails details) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICapabilityExchangeEventListener.DESCRIPTOR);
                    _data.writeTypedObject(details, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoteCapabilityRequest(Uri contactUri, List<String> remoteCapabilities, IOptionsRequestCallback cb) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ICapabilityExchangeEventListener.DESCRIPTOR);
                    _data.writeTypedObject(contactUri, 0);
                    _data.writeStringList(remoteCapabilities);
                    _data.writeStrongInterface(cb);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICapabilityExchangeEventListener {
        @Override
        public void onRequestPublishCapabilities(int publishTriggerType) throws RemoteException {
        }

        @Override
        public void onUnpublish() throws RemoteException {
        }

        @Override
        public void onPublishUpdated(SipDetails details) throws RemoteException {
        }

        @Override
        public void onRemoteCapabilityRequest(Uri contactUri, List<String> remoteCapabilities, IOptionsRequestCallback cb) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

