/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.feature.ConnectionFailureInfo;

public interface IImsTrafficSessionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.IImsTrafficSessionCallback";

    public void onReady() throws RemoteException;

    public void onError(ConnectionFailureInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IImsTrafficSessionCallback {
        static final int TRANSACTION_onReady = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IImsTrafficSessionCallback.DESCRIPTOR);
        }

        public static IImsTrafficSessionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IImsTrafficSessionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IImsTrafficSessionCallback) {
                return (IImsTrafficSessionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onReady";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IImsTrafficSessionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    this.onReady();
                    break;
                }
                case 2: {
                    ConnectionFailureInfo _arg0 = data.readTypedObject(ConnectionFailureInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IImsTrafficSessionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IImsTrafficSessionCallback.DESCRIPTOR;
            }

            @Override
            public void onReady() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsTrafficSessionCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(ConnectionFailureInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IImsTrafficSessionCallback.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IImsTrafficSessionCallback {
        @Override
        public void onReady() throws RemoteException {
        }

        @Override
        public void onError(ConnectionFailureInfo info) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

