/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.ims.DelegateRegistrationState;
import android.telephony.ims.FeatureTagState;
import android.telephony.ims.SipDelegateConfiguration;
import android.telephony.ims.SipDelegateImsConfiguration;
import android.telephony.ims.aidl.ISipDelegate;
import java.util.ArrayList;
import java.util.List;

public interface ISipDelegateConnectionStateCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.ISipDelegateConnectionStateCallback";

    public void onCreated(ISipDelegate var1) throws RemoteException;

    public void onFeatureTagStatusChanged(DelegateRegistrationState var1, List<FeatureTagState> var2) throws RemoteException;

    public void onImsConfigurationChanged(SipDelegateImsConfiguration var1) throws RemoteException;

    public void onConfigurationChanged(SipDelegateConfiguration var1) throws RemoteException;

    public void onDestroyed(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISipDelegateConnectionStateCallback {
        static final int TRANSACTION_onCreated = 1;
        static final int TRANSACTION_onFeatureTagStatusChanged = 2;
        static final int TRANSACTION_onImsConfigurationChanged = 3;
        static final int TRANSACTION_onConfigurationChanged = 4;
        static final int TRANSACTION_onDestroyed = 5;

        public Stub() {
            this.attachInterface(this, ISipDelegateConnectionStateCallback.DESCRIPTOR);
        }

        public static ISipDelegateConnectionStateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISipDelegateConnectionStateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISipDelegateConnectionStateCallback) {
                return (ISipDelegateConnectionStateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onCreated";
                }
                case 2: {
                    return "onFeatureTagStatusChanged";
                }
                case 3: {
                    return "onImsConfigurationChanged";
                }
                case 4: {
                    return "onConfigurationChanged";
                }
                case 5: {
                    return "onDestroyed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISipDelegateConnectionStateCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ISipDelegate _arg0 = ISipDelegate.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onCreated(_arg0);
                    break;
                }
                case 2: {
                    DelegateRegistrationState _arg0 = data.readTypedObject(DelegateRegistrationState.CREATOR);
                    ArrayList<FeatureTagState> _arg1 = data.createTypedArrayList(FeatureTagState.CREATOR);
                    data.enforceNoDataAvail();
                    this.onFeatureTagStatusChanged(_arg0, _arg1);
                    break;
                }
                case 3: {
                    SipDelegateImsConfiguration _arg0 = data.readTypedObject(SipDelegateImsConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onImsConfigurationChanged(_arg0);
                    break;
                }
                case 4: {
                    SipDelegateConfiguration _arg0 = data.readTypedObject(SipDelegateConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onConfigurationChanged(_arg0);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDestroyed(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements ISipDelegateConnectionStateCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISipDelegateConnectionStateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCreated(ISipDelegate c) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    _data.writeStrongInterface(c);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFeatureTagStatusChanged(DelegateRegistrationState registrationState, List<FeatureTagState> deniedFeatureTags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    _data.writeTypedObject(registrationState, 0);
                    _data.writeTypedList(deniedFeatureTags, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onImsConfigurationChanged(SipDelegateImsConfiguration registeredSipConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    _data.writeTypedObject(registeredSipConfig, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(SipDelegateConfiguration registeredSipConfig) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    _data.writeTypedObject(registeredSipConfig, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDestroyed(int reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISipDelegateConnectionStateCallback.DESCRIPTOR);
                    _data.writeInt(reason);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISipDelegateConnectionStateCallback {
        @Override
        public void onCreated(ISipDelegate c) throws RemoteException {
        }

        @Override
        public void onFeatureTagStatusChanged(DelegateRegistrationState registrationState, List<FeatureTagState> deniedFeatureTags) throws RemoteException {
        }

        @Override
        public void onImsConfigurationChanged(SipDelegateImsConfiguration registeredSipConfig) throws RemoteException {
        }

        @Override
        public void onConfigurationChanged(SipDelegateConfiguration registeredSipConfig) throws RemoteException {
        }

        @Override
        public void onDestroyed(int reason) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

