/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.SystemApi;
import android.os.Message;
import android.os.RemoteException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsCallSessionListener;
import android.telephony.ims.ImsStreamMediaProfile;
import android.telephony.ims.ImsVideoCallProvider;
import android.telephony.ims.RtpHeaderExtension;
import android.telephony.ims.aidl.IImsCallSessionListener;
import android.util.ArraySet;
import android.util.Log;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

@SystemApi
public class ImsCallSessionImplBase
implements AutoCloseable {
    private static final String LOG_TAG = "ImsCallSessionImplBase";
    public static final int USSD_MODE_NOTIFY = 0;
    public static final int USSD_MODE_REQUEST = 1;
    public static final int MEDIA_STREAM_TYPE_AUDIO = 1;
    public static final int MEDIA_STREAM_TYPE_VIDEO = 2;
    public static final int MEDIA_STREAM_DIRECTION_UPLINK = 1;
    public static final int MEDIA_STREAM_DIRECTION_DOWNLINK = 2;
    private Executor mExecutor = Runnable::run;
    private IImsCallSession mServiceImpl = new IImsCallSession.Stub(){

        @Override
        public void close() {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.close(), "close");
        }

        @Override
        public String getCallId() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.getCallId(), "getCallId");
        }

        @Override
        public ImsCallProfile getCallProfile() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.getCallProfile(), "getCallProfile");
        }

        @Override
        public ImsCallProfile getLocalCallProfile() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.getLocalCallProfile(), "getLocalCallProfile");
        }

        @Override
        public ImsCallProfile getRemoteCallProfile() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.getRemoteCallProfile(), "getRemoteCallProfile");
        }

        @Override
        public String getProperty(String name) {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.getProperty(name), "getProperty");
        }

        @Override
        public int getState() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.getState(), "getState");
        }

        @Override
        public boolean isInCall() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.isInCall(), "isInCall");
        }

        @Override
        public void setListener(IImsCallSessionListener listener) {
            ImsCallSessionListener iCSL = new ImsCallSessionListener(listener);
            iCSL.setDefaultExecutor(ImsCallSessionImplBase.this.mExecutor);
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.setListener(iCSL), "setListener");
        }

        @Override
        public void setMute(boolean muted) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.setMute(muted), "setMute");
        }

        @Override
        public void start(String callee, ImsCallProfile profile) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.start(callee, profile), "start");
        }

        @Override
        public void startConference(String[] participants, ImsCallProfile profile) throws RemoteException {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.startConference(participants, profile), "startConference");
        }

        @Override
        public void accept(int callType, ImsStreamMediaProfile profile) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.accept(callType, profile), "accept");
        }

        @Override
        public void deflect(String deflectNumber) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.deflect(deflectNumber), "deflect");
        }

        @Override
        public void reject(int reason) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.reject(reason), "reject");
        }

        @Override
        public void transfer(String number, boolean isConfirmationRequired) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.transfer(number, isConfirmationRequired), "transfer");
        }

        @Override
        public void consultativeTransfer(IImsCallSession transferToSession) {
            this.executeMethodAsync(() -> {
                ImsCallSessionImplBase otherSession = new ImsCallSessionImplBase();
                otherSession.setServiceImpl(transferToSession);
                ImsCallSessionImplBase.this.transfer(otherSession);
            }, "consultativeTransfer");
        }

        @Override
        public void terminate(int reason) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.terminate(reason), "terminate");
        }

        @Override
        public void hold(ImsStreamMediaProfile profile) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.hold(profile), "hold");
        }

        @Override
        public void resume(ImsStreamMediaProfile profile) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.resume(profile), "resume");
        }

        @Override
        public void merge() {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.merge(), "merge");
        }

        @Override
        public void update(int callType, ImsStreamMediaProfile profile) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.update(callType, profile), "update");
        }

        @Override
        public void extendToConference(String[] participants) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.extendToConference(participants), "extendToConference");
        }

        @Override
        public void inviteParticipants(String[] participants) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.inviteParticipants(participants), "inviteParticipants");
        }

        @Override
        public void removeParticipants(String[] participants) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.removeParticipants(participants), "removeParticipants");
        }

        @Override
        public void sendDtmf(char c, Message result) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.sendDtmf(c, result), "sendDtmf");
        }

        @Override
        public void startDtmf(char c) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.startDtmf(c), "startDtmf");
        }

        @Override
        public void stopDtmf() {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.stopDtmf(), "stopDtmf");
        }

        @Override
        public void sendUssd(String ussdMessage) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.sendUssd(ussdMessage), "sendUssd");
        }

        @Override
        public IImsVideoCallProvider getVideoCallProvider() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.getVideoCallProvider(), "getVideoCallProvider");
        }

        @Override
        public boolean isMultiparty() {
            return this.executeMethodAsyncForResult(() -> ImsCallSessionImplBase.this.isMultiparty(), "isMultiparty");
        }

        @Override
        public void sendRttModifyRequest(ImsCallProfile toProfile) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.sendRttModifyRequest(toProfile), "sendRttModifyRequest");
        }

        @Override
        public void sendRttModifyResponse(boolean status) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.sendRttModifyResponse(status), "sendRttModifyResponse");
        }

        @Override
        public void sendRttMessage(String rttMessage) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.sendRttMessage(rttMessage), "sendRttMessage");
        }

        @Override
        public void sendRtpHeaderExtensions(List<RtpHeaderExtension> extensions) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.sendRtpHeaderExtensions(new ArraySet<RtpHeaderExtension>(extensions)), "sendRtpHeaderExtensions");
        }

        @Override
        public void callSessionNotifyAnbr(int mediaType, int direction, int bitsPerSecond) {
            this.executeMethodAsync(() -> ImsCallSessionImplBase.this.callSessionNotifyAnbr(mediaType, direction, bitsPerSecond), "callSessionNotifyAnbr");
        }

        private void executeMethodAsync(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsCallSessionImplBase.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(ImsCallSessionImplBase.LOG_TAG, "ImsCallSessionImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), ImsCallSessionImplBase.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(ImsCallSessionImplBase.LOG_TAG, "ImsCallSessionImplBase Binder - " + errorLogName + " exception: " + e.getMessage());
                return null;
            }
        }
    };

    public void setListener(IImsCallSessionListener listener) throws RemoteException {
        this.setListener(new ImsCallSessionListener(listener));
    }

    @Deprecated
    public void setListener(ImsCallSessionListener listener) {
    }

    @Override
    public void close() {
    }

    public String getCallId() {
        return null;
    }

    public ImsCallProfile getCallProfile() {
        return null;
    }

    public ImsCallProfile getLocalCallProfile() {
        return null;
    }

    public ImsCallProfile getRemoteCallProfile() {
        return null;
    }

    public String getProperty(String name) {
        return null;
    }

    public int getState() {
        return -1;
    }

    public boolean isInCall() {
        return false;
    }

    public void setMute(boolean muted) {
    }

    public void start(String callee, ImsCallProfile profile) {
    }

    public void startConference(String[] participants, ImsCallProfile profile) {
    }

    public void accept(int callType, ImsStreamMediaProfile profile) {
    }

    public void deflect(String deflectNumber) {
    }

    public void reject(int reason) {
    }

    public void transfer(String number, boolean isConfirmationRequired) {
    }

    public void transfer(ImsCallSessionImplBase otherSession) {
    }

    public void terminate(int reason) {
    }

    public void hold(ImsStreamMediaProfile profile) {
    }

    public void resume(ImsStreamMediaProfile profile) {
    }

    public void merge() {
    }

    public void update(int callType, ImsStreamMediaProfile profile) {
    }

    public void extendToConference(String[] participants) {
    }

    public void inviteParticipants(String[] participants) {
    }

    public void removeParticipants(String[] participants) {
    }

    public void sendDtmf(char c, Message result) {
    }

    public void startDtmf(char c) {
    }

    public void stopDtmf() {
    }

    public void sendUssd(String ussdMessage) {
    }

    public IImsVideoCallProvider getVideoCallProvider() {
        ImsVideoCallProvider provider = this.getImsVideoCallProvider();
        return provider != null ? provider.getInterface() : null;
    }

    public ImsVideoCallProvider getImsVideoCallProvider() {
        return null;
    }

    public boolean isMultiparty() {
        return false;
    }

    public void sendRttModifyRequest(ImsCallProfile toProfile) {
    }

    public void sendRttModifyResponse(boolean status) {
    }

    public void sendRttMessage(String rttMessage) {
    }

    public void sendRtpHeaderExtensions(Set<RtpHeaderExtension> rtpHeaderExtensions) {
    }

    public void callSessionNotifyAnbr(int mediaType, int direction, int bitsPerSecond) {
        Log.i(LOG_TAG, "ImsCallSessionImplBase callSessionNotifyAnbr - mediaType: " + mediaType);
    }

    public IImsCallSession getServiceImpl() {
        return this.mServiceImpl;
    }

    public void setServiceImpl(IImsCallSession serviceImpl) {
        this.mServiceImpl = serviceImpl;
    }

    public void setDefaultExecutor(Executor executor) {
        this.mExecutor = executor;
    }

    public static class State {
        public static final int IDLE = 0;
        public static final int INITIATED = 1;
        public static final int NEGOTIATING = 2;
        public static final int ESTABLISHING = 3;
        public static final int ESTABLISHED = 4;
        public static final int RENEGOTIATING = 5;
        public static final int REESTABLISHING = 6;
        public static final int TERMINATING = 7;
        public static final int TERMINATED = 8;
        public static final int INVALID = -1;

        public static String toString(int state) {
            switch (state) {
                case 0: {
                    return "IDLE";
                }
                case 1: {
                    return "INITIATED";
                }
                case 2: {
                    return "NEGOTIATING";
                }
                case 3: {
                    return "ESTABLISHING";
                }
                case 4: {
                    return "ESTABLISHED";
                }
                case 5: {
                    return "RENEGOTIATING";
                }
                case 6: {
                    return "REESTABLISHING";
                }
                case 7: {
                    return "TERMINATING";
                }
                case 8: {
                    return "TERMINATED";
                }
            }
            return "UNKNOWN";
        }

        private State() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaStreamDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MediaStreamType {
    }
}

