/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.satellite.PointingInfo;

public interface ISatelliteTransmissionUpdateCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.satellite.ISatelliteTransmissionUpdateCallback";

    public void onSendDatagramStateChanged(int var1, int var2, int var3) throws RemoteException;

    public void onReceiveDatagramStateChanged(int var1, int var2, int var3) throws RemoteException;

    public void onSatellitePositionChanged(PointingInfo var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISatelliteTransmissionUpdateCallback {
        static final int TRANSACTION_onSendDatagramStateChanged = 1;
        static final int TRANSACTION_onReceiveDatagramStateChanged = 2;
        static final int TRANSACTION_onSatellitePositionChanged = 3;

        public Stub() {
            this.attachInterface(this, ISatelliteTransmissionUpdateCallback.DESCRIPTOR);
        }

        public static ISatelliteTransmissionUpdateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISatelliteTransmissionUpdateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISatelliteTransmissionUpdateCallback) {
                return (ISatelliteTransmissionUpdateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onSendDatagramStateChanged";
                }
                case 2: {
                    return "onReceiveDatagramStateChanged";
                }
                case 3: {
                    return "onSatellitePositionChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISatelliteTransmissionUpdateCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onSendDatagramStateChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onReceiveDatagramStateChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    PointingInfo _arg0 = data.readTypedObject(PointingInfo.CREATOR);
                    data.enforceNoDataAvail();
                    this.onSatellitePositionChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ISatelliteTransmissionUpdateCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISatelliteTransmissionUpdateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSendDatagramStateChanged(int state, int sendPendingCount, int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISatelliteTransmissionUpdateCallback.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(sendPendingCount);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceiveDatagramStateChanged(int state, int receivePendingCount, int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISatelliteTransmissionUpdateCallback.DESCRIPTOR);
                    _data.writeInt(state);
                    _data.writeInt(receivePendingCount);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSatellitePositionChanged(PointingInfo pointingInfo) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISatelliteTransmissionUpdateCallback.DESCRIPTOR);
                    _data.writeTypedObject(pointingInfo, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISatelliteTransmissionUpdateCallback {
        @Override
        public void onSendDatagramStateChanged(int state, int sendPendingCount, int errorCode) throws RemoteException {
        }

        @Override
        public void onReceiveDatagramStateChanged(int state, int receivePendingCount, int errorCode) throws RemoteException {
        }

        @Override
        public void onSatellitePositionChanged(PointingInfo pointingInfo) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

