/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ICancellationSignal;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.telephony.TelephonyFrameworkInitializer;
import android.telephony.satellite.ISatelliteDatagramCallback;
import android.telephony.satellite.ISatelliteProvisionStateCallback;
import android.telephony.satellite.ISatelliteStateCallback;
import android.telephony.satellite.ISatelliteTransmissionUpdateCallback;
import android.telephony.satellite.PointingInfo;
import android.telephony.satellite.SatelliteCapabilities;
import android.telephony.satellite.SatelliteDatagram;
import android.telephony.satellite.SatelliteDatagramCallback;
import android.telephony.satellite.SatelliteProvisionStateCallback;
import android.telephony.satellite.SatelliteStateCallback;
import android.telephony.satellite.SatelliteTransmissionUpdateCallback;
import com.android.internal.telephony.IIntegerConsumer;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.IVoidConsumer;
import com.android.telephony.Rlog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class SatelliteManager {
    private static final String TAG = "SatelliteManager";
    private static final ConcurrentHashMap<SatelliteDatagramCallback, ISatelliteDatagramCallback> sSatelliteDatagramCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteProvisionStateCallback, ISatelliteProvisionStateCallback> sSatelliteProvisionStateCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteStateCallback, ISatelliteStateCallback> sSatelliteStateCallbackMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<SatelliteTransmissionUpdateCallback, ISatelliteTransmissionUpdateCallback> sSatelliteTransmissionUpdateCallbackMap = new ConcurrentHashMap();
    private final int mSubId;
    private final Context mContext;
    public static final String KEY_SATELLITE_ENABLED = "satellite_enabled";
    public static final String KEY_DEMO_MODE_ENABLED = "demo_mode_enabled";
    public static final String KEY_SATELLITE_SUPPORTED = "satellite_supported";
    public static final String KEY_SATELLITE_CAPABILITIES = "satellite_capabilities";
    public static final String KEY_SATELLITE_PROVISIONED = "satellite_provisioned";
    public static final String KEY_SATELLITE_COMMUNICATION_ALLOWED = "satellite_communication_allowed";
    public static final String KEY_SATELLITE_NEXT_VISIBILITY = "satellite_next_visibility";
    public static final int SATELLITE_ERROR_NONE = 0;
    public static final int SATELLITE_ERROR = 1;
    public static final int SATELLITE_SERVER_ERROR = 2;
    public static final int SATELLITE_SERVICE_ERROR = 3;
    public static final int SATELLITE_MODEM_ERROR = 4;
    public static final int SATELLITE_NETWORK_ERROR = 5;
    public static final int SATELLITE_INVALID_TELEPHONY_STATE = 6;
    public static final int SATELLITE_INVALID_MODEM_STATE = 7;
    public static final int SATELLITE_INVALID_ARGUMENTS = 8;
    public static final int SATELLITE_REQUEST_FAILED = 9;
    public static final int SATELLITE_RADIO_NOT_AVAILABLE = 10;
    public static final int SATELLITE_REQUEST_NOT_SUPPORTED = 11;
    public static final int SATELLITE_NO_RESOURCES = 12;
    public static final int SATELLITE_SERVICE_NOT_PROVISIONED = 13;
    public static final int SATELLITE_SERVICE_PROVISION_IN_PROGRESS = 14;
    public static final int SATELLITE_REQUEST_ABORTED = 15;
    public static final int SATELLITE_ACCESS_BARRED = 16;
    public static final int SATELLITE_NETWORK_TIMEOUT = 17;
    public static final int SATELLITE_NOT_REACHABLE = 18;
    public static final int SATELLITE_NOT_AUTHORIZED = 19;
    public static final int SATELLITE_NOT_SUPPORTED = 20;
    public static final int SATELLITE_REQUEST_IN_PROGRESS = 21;
    public static final int SATELLITE_MODEM_BUSY = 22;
    public static final int NT_RADIO_TECHNOLOGY_UNKNOWN = 0;
    public static final int NT_RADIO_TECHNOLOGY_NB_IOT_NTN = 1;
    public static final int NT_RADIO_TECHNOLOGY_NR_NTN = 2;
    public static final int NT_RADIO_TECHNOLOGY_EMTC_NTN = 3;
    public static final int NT_RADIO_TECHNOLOGY_PROPRIETARY = 4;
    public static final int DEVICE_HOLD_POSITION_UNKNOWN = 0;
    public static final int DEVICE_HOLD_POSITION_PORTRAIT = 1;
    public static final int DEVICE_HOLD_POSITION_LANDSCAPE_LEFT = 2;
    public static final int DEVICE_HOLD_POSITION_LANDSCAPE_RIGHT = 3;
    public static final int DISPLAY_MODE_UNKNOWN = 0;
    public static final int DISPLAY_MODE_FIXED = 1;
    public static final int DISPLAY_MODE_OPENED = 2;
    public static final int DISPLAY_MODE_CLOSED = 3;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_IDLE = 0;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_SENDING = 1;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_SEND_SUCCESS = 2;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_SEND_FAILED = 3;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVING = 4;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVE_SUCCESS = 5;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVE_NONE = 6;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_RECEIVE_FAILED = 7;
    public static final int SATELLITE_DATAGRAM_TRANSFER_STATE_UNKNOWN = -1;
    public static final int SATELLITE_MODEM_STATE_IDLE = 0;
    public static final int SATELLITE_MODEM_STATE_LISTENING = 1;
    public static final int SATELLITE_MODEM_STATE_DATAGRAM_TRANSFERRING = 2;
    public static final int SATELLITE_MODEM_STATE_DATAGRAM_RETRYING = 3;
    public static final int SATELLITE_MODEM_STATE_OFF = 4;
    public static final int SATELLITE_MODEM_STATE_UNAVAILABLE = 5;
    public static final int SATELLITE_MODEM_STATE_UNKNOWN = -1;
    public static final int DATAGRAM_TYPE_UNKNOWN = 0;
    public static final int DATAGRAM_TYPE_SOS_MESSAGE = 1;
    public static final int DATAGRAM_TYPE_LOCATION_SHARING = 2;

    public SatelliteManager(Context context) {
        this(context, Integer.MAX_VALUE);
    }

    private SatelliteManager(Context context, int subId) {
        this.mContext = context;
        this.mSubId = subId;
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestSatelliteEnabled(boolean enableSatellite, boolean enableDemoMode, final Executor executor, final Consumer<Integer> resultListener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                }
            };
            telephony.requestSatelliteEnabled(this.mSubId, enableSatellite, enableDemoMode, errorCallback);
        }
        catch (RemoteException ex) {
            Rlog.e(TAG, "requestSatelliteEnabled() RemoteException: ", ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsSatelliteEnabled(final Executor executor, final OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_ENABLED)) {
                            boolean isSatelliteEnabled = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_ENABLED);
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteEnabled)));
                        } else {
                            SatelliteManager.loge("KEY_SATELLITE_ENABLED does not exist.");
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        }
                    } else {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                    }
                }
            };
            telephony.requestIsSatelliteEnabled(this.mSubId, receiver);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsSatelliteEnabled() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsDemoModeEnabled(final Executor executor, final OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        if (resultData.containsKey(SatelliteManager.KEY_DEMO_MODE_ENABLED)) {
                            boolean isDemoModeEnabled = resultData.getBoolean(SatelliteManager.KEY_DEMO_MODE_ENABLED);
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isDemoModeEnabled)));
                        } else {
                            SatelliteManager.loge("KEY_DEMO_MODE_ENABLED does not exist.");
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        }
                    } else {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                    }
                }
            };
            telephony.requestIsDemoModeEnabled(this.mSubId, receiver);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsDemoModeEnabled() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    public void requestIsSatelliteSupported(final Executor executor, final OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_SUPPORTED)) {
                            boolean isSatelliteSupported = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_SUPPORTED);
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteSupported)));
                        } else {
                            SatelliteManager.loge("KEY_SATELLITE_SUPPORTED does not exist.");
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        }
                    } else {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                    }
                }
            };
            telephony.requestIsSatelliteSupported(this.mSubId, receiver);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsSatelliteSupported() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestSatelliteCapabilities(final Executor executor, final OutcomeReceiver<SatelliteCapabilities, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_CAPABILITIES)) {
                            SatelliteCapabilities capabilities = resultData.getParcelable(SatelliteManager.KEY_SATELLITE_CAPABILITIES, SatelliteCapabilities.class);
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(capabilities)));
                        } else {
                            SatelliteManager.loge("KEY_SATELLITE_CAPABILITIES does not exist.");
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        }
                    } else {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                    }
                }
            };
            telephony.requestSatelliteCapabilities(this.mSubId, receiver);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestSatelliteCapabilities() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void startSatelliteTransmissionUpdates(final Executor executor, final Consumer<Integer> resultListener, final SatelliteTransmissionUpdateCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                }
            };
            ISatelliteTransmissionUpdateCallback.Stub internalCallback = new ISatelliteTransmissionUpdateCallback.Stub(){

                @Override
                public void onSatellitePositionChanged(PointingInfo pointingInfo) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatellitePositionChanged(pointingInfo)));
                }

                @Override
                public void onSendDatagramStateChanged(int state, int sendPendingCount, int errorCode) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSendDatagramStateChanged(state, sendPendingCount, errorCode)));
                }

                @Override
                public void onReceiveDatagramStateChanged(int state, int receivePendingCount, int errorCode) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onReceiveDatagramStateChanged(state, receivePendingCount, errorCode)));
                }
            };
            sSatelliteTransmissionUpdateCallbackMap.put(callback, internalCallback);
            telephony.startSatelliteTransmissionUpdates(this.mSubId, errorCallback, internalCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("startSatelliteTransmissionUpdates() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void stopSatelliteTransmissionUpdates(SatelliteTransmissionUpdateCallback callback, final Executor executor, final Consumer<Integer> resultListener) {
        block5: {
            Objects.requireNonNull(callback);
            Objects.requireNonNull(executor);
            Objects.requireNonNull(resultListener);
            ISatelliteTransmissionUpdateCallback internalCallback = sSatelliteTransmissionUpdateCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(){

                            @Override
                            public void accept(int result) {
                                executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                            }
                        };
                        telephony.stopSatelliteTransmissionUpdates(this.mSubId, errorCallback, internalCallback);
                    } else {
                        SatelliteManager.loge("stopSatelliteTransmissionUpdates: No internal callback.");
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(8)));
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("stopSatelliteTransmissionUpdates() RemoteException: " + ex);
                ex.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void provisionSatelliteService(String token, byte[] provisionData, CancellationSignal cancellationSignal, final Executor executor, final Consumer<Integer> resultListener) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        Objects.requireNonNull(provisionData);
        ICancellationSignal cancelRemote = null;
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                }
            };
            cancelRemote = telephony.provisionSatelliteService(this.mSubId, token, provisionData, errorCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("provisionSatelliteService() RemoteException=" + ex);
            ex.rethrowFromSystemServer();
        }
        if (cancellationSignal != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void deprovisionSatelliteService(String token, final Executor executor, final Consumer<Integer> resultListener) {
        Objects.requireNonNull(token);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            IIntegerConsumer.Stub errorCallback = new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                }
            };
            telephony.deprovisionSatelliteService(this.mSubId, token, errorCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("deprovisionSatelliteService() RemoteException=" + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForSatelliteProvisionStateChanged(final Executor executor, final SatelliteProvisionStateCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteProvisionStateCallback.Stub internalCallback = new ISatelliteProvisionStateCallback.Stub(){

                    @Override
                    public void onSatelliteProvisionStateChanged(boolean provisioned) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteProvisionStateChanged(provisioned)));
                    }
                };
                sSatelliteProvisionStateCallbackMap.put(callback, internalCallback);
                return telephony.registerForSatelliteProvisionStateChanged(this.mSubId, internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForSatelliteProvisionStateChanged() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
            return 9;
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForSatelliteProvisionStateChanged(SatelliteProvisionStateCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteProvisionStateCallback internalCallback = sSatelliteProvisionStateCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForSatelliteProvisionStateChanged(this.mSubId, internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForSatelliteProvisionStateChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForSatelliteProvisionStateChanged() RemoteException: " + ex);
                ex.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsSatelliteProvisioned(final Executor executor, final OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_PROVISIONED)) {
                            boolean isSatelliteProvisioned = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_PROVISIONED);
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteProvisioned)));
                        } else {
                            SatelliteManager.loge("KEY_SATELLITE_PROVISIONED does not exist.");
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        }
                    } else {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                    }
                }
            };
            telephony.requestIsSatelliteProvisioned(this.mSubId, receiver);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsSatelliteProvisioned() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForSatelliteModemStateChanged(final Executor executor, final SatelliteStateCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteStateCallback.Stub internalCallback = new ISatelliteStateCallback.Stub(){

                    @Override
                    public void onSatelliteModemStateChanged(int state) {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteModemStateChanged(state)));
                    }
                };
                sSatelliteStateCallbackMap.put(callback, internalCallback);
                return telephony.registerForSatelliteModemStateChanged(this.mSubId, internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForSatelliteModemStateChanged() RemoteException:" + ex);
            ex.rethrowFromSystemServer();
            return 9;
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForSatelliteModemStateChanged(SatelliteStateCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteStateCallback internalCallback = sSatelliteStateCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForSatelliteModemStateChanged(this.mSubId, internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForSatelliteModemStateChanged: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForSatelliteModemStateChanged() RemoteException:" + ex);
                ex.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public int registerForSatelliteDatagram(final Executor executor, final SatelliteDatagramCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony != null) {
                ISatelliteDatagramCallback.Stub internalCallback = new ISatelliteDatagramCallback.Stub(){

                    @Override
                    public void onSatelliteDatagramReceived(long datagramId, SatelliteDatagram datagram, int pendingCount, final IVoidConsumer internalAck) {
                        Consumer<Void> externalAck = new Consumer<Void>(){

                            @Override
                            public void accept(Void result) {
                                try {
                                    internalAck.accept();
                                }
                                catch (RemoteException e) {
                                    SatelliteManager.logd("onSatelliteDatagramReceived RemoteException: " + e);
                                }
                            }
                        };
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onSatelliteDatagramReceived(datagramId, datagram, pendingCount, externalAck)));
                    }
                };
                sSatelliteDatagramCallbackMap.put(callback, internalCallback);
                return telephony.registerForSatelliteDatagram(this.mSubId, internalCallback);
            }
            throw new IllegalStateException("telephony service is null.");
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("registerForSatelliteDatagram() RemoteException:" + ex);
            ex.rethrowFromSystemServer();
            return 9;
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void unregisterForSatelliteDatagram(SatelliteDatagramCallback callback) {
        block5: {
            Objects.requireNonNull(callback);
            ISatelliteDatagramCallback internalCallback = sSatelliteDatagramCallbackMap.remove(callback);
            try {
                ITelephony telephony = SatelliteManager.getITelephony();
                if (telephony != null) {
                    if (internalCallback != null) {
                        telephony.unregisterForSatelliteDatagram(this.mSubId, internalCallback);
                    } else {
                        SatelliteManager.loge("unregisterForSatelliteDatagram: No internal callback.");
                    }
                    break block5;
                }
                throw new IllegalStateException("telephony service is null.");
            }
            catch (RemoteException ex) {
                SatelliteManager.loge("unregisterForSatelliteDatagram() RemoteException:" + ex);
                ex.rethrowFromSystemServer();
            }
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void pollPendingSatelliteDatagrams(final Executor executor, final Consumer<Integer> resultListener) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                }
            };
            telephony.pollPendingSatelliteDatagrams(this.mSubId, internalCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("pollPendingSatelliteDatagrams() RemoteException:" + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void sendSatelliteDatagram(int datagramType, SatelliteDatagram datagram, boolean needFullScreenPointingUI, final Executor executor, final Consumer<Integer> resultListener) {
        Objects.requireNonNull(datagram);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(resultListener);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            IIntegerConsumer.Stub internalCallback = new IIntegerConsumer.Stub(){

                @Override
                public void accept(int result) {
                    executor.execute(() -> Binder.withCleanCallingIdentity(() -> resultListener.accept(result)));
                }
            };
            telephony.sendSatelliteDatagram(this.mSubId, datagramType, datagram, needFullScreenPointingUI, internalCallback);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("sendSatelliteDatagram() RemoteException:" + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestIsSatelliteCommunicationAllowedForCurrentLocation(final Executor executor, final OutcomeReceiver<Boolean, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_COMMUNICATION_ALLOWED)) {
                            boolean isSatelliteCommunicationAllowed = resultData.getBoolean(SatelliteManager.KEY_SATELLITE_COMMUNICATION_ALLOWED);
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(isSatelliteCommunicationAllowed)));
                        } else {
                            SatelliteManager.loge("KEY_SATELLITE_COMMUNICATION_ALLOWED does not exist.");
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        }
                    } else {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                    }
                }
            };
            telephony.requestIsSatelliteCommunicationAllowedForCurrentLocation(this.mSubId, receiver);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestIsSatelliteCommunicationAllowedForCurrentLocation() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void requestTimeForNextSatelliteVisibility(final Executor executor, final OutcomeReceiver<Duration, SatelliteException> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                protected void onReceiveResult(int resultCode, Bundle resultData) {
                    if (resultCode == 0) {
                        if (resultData.containsKey(SatelliteManager.KEY_SATELLITE_NEXT_VISIBILITY)) {
                            int nextVisibilityDuration = resultData.getInt(SatelliteManager.KEY_SATELLITE_NEXT_VISIBILITY);
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onResult(Duration.ofSeconds(nextVisibilityDuration))));
                        } else {
                            SatelliteManager.loge("KEY_SATELLITE_NEXT_VISIBILITY does not exist.");
                            executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(9))));
                        }
                    } else {
                        executor.execute(() -> Binder.withCleanCallingIdentity(() -> callback.onError(new SatelliteException(resultCode))));
                    }
                }
            };
            telephony.requestTimeForNextSatelliteVisibility(this.mSubId, receiver);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("requestTimeForNextSatelliteVisibility() RemoteException: " + ex);
            ex.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.SATELLITE_COMMUNICATION")
    public void onDeviceAlignedWithSatellite(boolean isAligned) {
        try {
            ITelephony telephony = SatelliteManager.getITelephony();
            if (telephony == null) {
                throw new IllegalStateException("telephony service is null.");
            }
            telephony.onDeviceAlignedWithSatellite(this.mSubId, isAligned);
        }
        catch (RemoteException ex) {
            SatelliteManager.loge("informDeviceAlignedToSatellite() RemoteException:" + ex);
            ex.rethrowFromSystemServer();
        }
    }

    private static ITelephony getITelephony() {
        ITelephony binder = ITelephony.Stub.asInterface(TelephonyFrameworkInitializer.getTelephonyServiceManager().getTelephonyServiceRegisterer().get());
        if (binder == null) {
            throw new RuntimeException("Could not find Telephony Service.");
        }
        return binder;
    }

    private static void logd(String log) {
        Rlog.d(TAG, log);
    }

    private static void loge(String log) {
        Rlog.e(TAG, log);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DatagramType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteModemState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteDatagramTransferState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DisplayMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceHoldPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NTRadioTechnology {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SatelliteError {
    }

    public static class SatelliteException
    extends Exception {
        private final int mErrorCode;

        public SatelliteException(int errorCode) {
            this.mErrorCode = errorCode;
        }

        public int getErrorCode() {
            return this.mErrorCode;
        }
    }
}

