/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.TemporaryBuffer;
import android.graphics.text.GraphemeBreak;
import android.text.AutoGrowArray;
import android.text.SegmentFinder;
import android.text.TextPaint;
import android.text.TextUtils;

public class GraphemeClusterSegmentFinder
extends SegmentFinder {
    private static AutoGrowArray.FloatArray sTempAdvances = null;
    private final boolean[] mIsGraphemeBreak;

    public GraphemeClusterSegmentFinder(CharSequence text, TextPaint textPaint) {
        if (sTempAdvances == null) {
            sTempAdvances = new AutoGrowArray.FloatArray(text.length());
        } else if (sTempAdvances.size() < text.length()) {
            sTempAdvances.resize(text.length());
        }
        this.mIsGraphemeBreak = new boolean[text.length()];
        float[] advances = sTempAdvances.getRawArray();
        char[] chars = TemporaryBuffer.obtain(text.length());
        TextUtils.getChars(text, 0, text.length(), chars, 0);
        textPaint.getTextWidths(chars, 0, text.length(), advances);
        GraphemeBreak.isGraphemeBreak(advances, chars, 0, text.length(), this.mIsGraphemeBreak);
        TemporaryBuffer.recycle(chars);
    }

    private int previousBoundary(int offset) {
        if (offset <= 0) {
            return -1;
        }
        while (--offset > 0 && !this.mIsGraphemeBreak[offset]) {
        }
        return offset;
    }

    private int nextBoundary(int offset) {
        if (offset >= this.mIsGraphemeBreak.length) {
            return -1;
        }
        while (++offset < this.mIsGraphemeBreak.length && !this.mIsGraphemeBreak[offset]) {
        }
        return offset;
    }

    @Override
    public int previousStartBoundary(int offset) {
        return this.previousBoundary(offset);
    }

    @Override
    public int previousEndBoundary(int offset) {
        if (offset == 0) {
            return -1;
        }
        int boundary = this.previousBoundary(offset);
        if (boundary == -1 || this.previousBoundary(boundary) == -1) {
            return -1;
        }
        return boundary;
    }

    @Override
    public int nextStartBoundary(int offset) {
        if (offset == this.mIsGraphemeBreak.length) {
            return -1;
        }
        int boundary = this.nextBoundary(offset);
        if (boundary == -1 || this.nextBoundary(boundary) == -1) {
            return -1;
        }
        return boundary;
    }

    @Override
    public int nextEndBoundary(int offset) {
        return this.nextBoundary(offset);
    }
}

