/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.graphics.Paint;
import android.util.Pair;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class Highlights {
    private final List<Pair<Paint, int[]>> mHighlights;

    private Highlights(List<Pair<Paint, int[]>> highlights) {
        this.mHighlights = highlights;
    }

    @IntRange(from=0L)
    public int getSize() {
        return this.mHighlights.size();
    }

    @NonNull
    public Paint getPaint(@IntRange(from=0L) int index) {
        return (Paint)this.mHighlights.get((int)index).first;
    }

    @NonNull
    public int[] getRanges(int index) {
        return (int[])this.mHighlights.get((int)index).second;
    }

    public static class Builder {
        private final List<Pair<Paint, int[]>> mHighlights = new ArrayList<Pair<Paint, int[]>>();

        @NonNull
        public Builder addRange(@NonNull Paint paint, @IntRange(from=0L) int start, @IntRange(from=0L) int end) {
            if (start > end) {
                throw new IllegalArgumentException("start must not be larger than end: " + start + ", " + end);
            }
            Objects.requireNonNull(paint);
            int[] range = new int[]{start, end};
            this.mHighlights.add(new Pair<Paint, int[]>(paint, range));
            return this;
        }

        @NonNull
        public Builder addRanges(@NonNull Paint paint, int ... ranges) {
            if (ranges.length % 2 == 1) {
                throw new IllegalArgumentException("Flatten ranges must have even numbered elements");
            }
            for (int j = 0; j < ranges.length / 2; ++j) {
                int start = ranges[j * 2];
                int end = ranges[j * 2 + 1];
                if (start <= end) continue;
                throw new IllegalArgumentException("Reverse range found in the flatten range: " + Arrays.toString(ranges));
            }
            Objects.requireNonNull(paint);
            this.mHighlights.add(new Pair<Paint, int[]>(paint, ranges));
            return this;
        }

        @NonNull
        public Highlights build() {
            return new Highlights(this.mHighlights);
        }
    }
}

