/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import androidx.annotation.NonNull;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

public abstract class SegmentFinder {
    public static final int DONE = -1;

    public abstract int previousStartBoundary(int var1);

    public abstract int previousEndBoundary(int var1);

    public abstract int nextStartBoundary(int var1);

    public abstract int nextEndBoundary(int var1);

    public static class PrescribedSegmentFinder
    extends SegmentFinder {
        private final int[] mSegments;

        public PrescribedSegmentFinder(@NonNull int[] segments) {
            PrescribedSegmentFinder.checkSegmentsValid(segments);
            this.mSegments = segments;
        }

        @Override
        public int previousStartBoundary(int offset) {
            return this.findPrevious(offset, true);
        }

        @Override
        public int previousEndBoundary(int offset) {
            return this.findPrevious(offset, false);
        }

        @Override
        public int nextStartBoundary(int offset) {
            return this.findNext(offset, true);
        }

        @Override
        public int nextEndBoundary(int offset) {
            return this.findNext(offset, false);
        }

        private int findNext(int offset, boolean isStart) {
            boolean indexIsStart;
            if (offset < 0) {
                return -1;
            }
            if (this.mSegments.length < 1 || offset > this.mSegments[this.mSegments.length - 1]) {
                return -1;
            }
            if (offset < this.mSegments[0]) {
                return isStart ? this.mSegments[0] : this.mSegments[1];
            }
            int index = Arrays.binarySearch(this.mSegments, offset);
            if (index >= 0) {
                if (index + 1 < this.mSegments.length && this.mSegments[index + 1] == offset) {
                    ++index;
                }
                ++index;
            } else {
                index = -(index + 1);
            }
            if (index >= this.mSegments.length) {
                return -1;
            }
            boolean bl = indexIsStart = index % 2 == 0;
            if (isStart != indexIsStart) {
                return index + 1 < this.mSegments.length ? this.mSegments[index + 1] : -1;
            }
            return this.mSegments[index];
        }

        private int findPrevious(int offset, boolean isStart) {
            boolean indexIsStart;
            if (this.mSegments.length < 1 || offset < this.mSegments[0]) {
                return -1;
            }
            if (offset > this.mSegments[this.mSegments.length - 1]) {
                return isStart ? this.mSegments[this.mSegments.length - 2] : this.mSegments[this.mSegments.length - 1];
            }
            int index = Arrays.binarySearch(this.mSegments, offset);
            if (index >= 0) {
                if (index > 0 && this.mSegments[index - 1] == offset) {
                    --index;
                }
                --index;
            } else {
                index = -(index + 1) - 1;
            }
            if (index < 0) {
                return -1;
            }
            boolean bl = indexIsStart = index % 2 == 0;
            if (isStart != indexIsStart) {
                return index > 0 ? this.mSegments[index - 1] : -1;
            }
            return this.mSegments[index];
        }

        private static void checkSegmentsValid(int[] segments) {
            Objects.requireNonNull(segments);
            Preconditions.checkArgument(segments.length % 2 == 0, "the length of segments must be even");
            if (segments.length == 0) {
                return;
            }
            int lastSegmentEnd = Integer.MIN_VALUE;
            for (int index = 0; index < segments.length; index += 2) {
                if (segments[index] < lastSegmentEnd) {
                    throw new IllegalArgumentException("segments can't overlap");
                }
                if (segments[index] >= segments[index + 1]) {
                    throw new IllegalArgumentException("the segment range can't be empty");
                }
                lastSegmentEnd = segments[index + 1];
            }
        }
    }
}

