/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.icu.util.ULocale;
import android.text.SegmentFinder;
import android.text.method.WordIterator;

public class WordSegmentFinder
extends SegmentFinder {
    private final CharSequence mText;
    private final WordIterator mWordIterator;

    public WordSegmentFinder(CharSequence text, ULocale locale) {
        this.mText = text;
        this.mWordIterator = new WordIterator(locale);
        this.mWordIterator.setCharSequence(text, 0, text.length());
    }

    public WordSegmentFinder(CharSequence text, WordIterator wordIterator) {
        this.mText = text;
        this.mWordIterator = wordIterator;
    }

    @Override
    public int previousStartBoundary(int offset) {
        int boundary = offset;
        do {
            if ((boundary = this.mWordIterator.prevBoundary(boundary)) != -1) continue;
            return -1;
        } while (Character.isWhitespace(this.mText.charAt(boundary)));
        return boundary;
    }

    @Override
    public int previousEndBoundary(int offset) {
        int boundary = offset;
        do {
            if ((boundary = this.mWordIterator.prevBoundary(boundary)) != -1 && boundary != 0) continue;
            return -1;
        } while (Character.isWhitespace(this.mText.charAt(boundary - 1)));
        return boundary;
    }

    @Override
    public int nextStartBoundary(int offset) {
        int boundary = offset;
        do {
            if ((boundary = this.mWordIterator.nextBoundary(boundary)) != -1 && boundary != this.mText.length()) continue;
            return -1;
        } while (Character.isWhitespace(this.mText.charAt(boundary)));
        return boundary;
    }

    @Override
    public int nextEndBoundary(int offset) {
        int boundary = offset;
        do {
            if ((boundary = this.mWordIterator.nextBoundary(boundary)) != -1) continue;
            return -1;
        } while (Character.isWhitespace(this.mText.charAt(boundary - 1)));
        return boundary;
    }
}

