/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.compat.annotation.UnsupportedAppUsage;
import android.icu.lang.UCharacter;
import android.icu.text.BreakIterator;
import android.icu.util.ULocale;
import android.text.CharSequenceCharacterIterator;
import android.text.Selection;
import android.text.TextUtils;
import com.android.layoutlib.bridge.android.AndroidLocale;
import java.util.Locale;

public class WordIterator
implements Selection.PositionIterator {
    private static final int WINDOW_WIDTH = 50;
    private int mStart;
    private int mEnd;
    private CharSequence mCharSeq;
    private final BreakIterator mIterator;

    public WordIterator() {
        this(AndroidLocale.getDefault());
    }

    @UnsupportedAppUsage
    public WordIterator(Locale locale) {
        this.mIterator = BreakIterator.getWordInstance(locale);
    }

    public WordIterator(ULocale locale) {
        this.mIterator = BreakIterator.getWordInstance(locale);
    }

    @UnsupportedAppUsage
    public void setCharSequence(CharSequence charSequence, int start, int end) {
        if (0 > start || end > charSequence.length()) {
            throw new IndexOutOfBoundsException("input indexes are outside the CharSequence");
        }
        this.mCharSeq = charSequence;
        this.mStart = Math.max(0, start - 50);
        this.mEnd = Math.min(charSequence.length(), end + 50);
        this.mIterator.setText(new CharSequenceCharacterIterator(charSequence, this.mStart, this.mEnd));
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int preceding(int offset) {
        this.checkOffsetIsValid(offset);
        while ((offset = this.mIterator.preceding(offset)) != -1 && !this.isOnLetterOrDigit(offset)) {
        }
        return offset;
    }

    @Override
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int following(int offset) {
        this.checkOffsetIsValid(offset);
        while ((offset = this.mIterator.following(offset)) != -1 && !this.isAfterLetterOrDigit(offset)) {
        }
        return offset;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.mIterator.isBoundary(offset);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int nextBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.mIterator.following(offset);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int prevBoundary(int offset) {
        this.checkOffsetIsValid(offset);
        return this.mIterator.preceding(offset);
    }

    @UnsupportedAppUsage
    public int getBeginning(int offset) {
        return this.getBeginning(offset, false);
    }

    @UnsupportedAppUsage
    public int getEnd(int offset) {
        return this.getEnd(offset, false);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getPrevWordBeginningOnTwoWordsBoundary(int offset) {
        return this.getBeginning(offset, true);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getNextWordEndOnTwoWordBoundary(int offset) {
        return this.getEnd(offset, true);
    }

    private int getBeginning(int offset, boolean getPrevWordBeginningOnTwoWordsBoundary) {
        this.checkOffsetIsValid(offset);
        if (this.isOnLetterOrDigit(offset)) {
            if (!(!this.mIterator.isBoundary(offset) || this.isAfterLetterOrDigit(offset) && getPrevWordBeginningOnTwoWordsBoundary)) {
                return offset;
            }
            return this.mIterator.preceding(offset);
        }
        if (this.isAfterLetterOrDigit(offset)) {
            return this.mIterator.preceding(offset);
        }
        return -1;
    }

    private int getEnd(int offset, boolean getNextWordEndOnTwoWordBoundary) {
        this.checkOffsetIsValid(offset);
        if (this.isAfterLetterOrDigit(offset)) {
            if (!(!this.mIterator.isBoundary(offset) || this.isOnLetterOrDigit(offset) && getNextWordEndOnTwoWordBoundary)) {
                return offset;
            }
            return this.mIterator.following(offset);
        }
        if (this.isOnLetterOrDigit(offset)) {
            return this.mIterator.following(offset);
        }
        return -1;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getPunctuationBeginning(int offset) {
        this.checkOffsetIsValid(offset);
        while (offset != -1 && !this.isPunctuationStartBoundary(offset)) {
            offset = this.prevBoundary(offset);
        }
        return offset;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public int getPunctuationEnd(int offset) {
        this.checkOffsetIsValid(offset);
        while (offset != -1 && !this.isPunctuationEndBoundary(offset)) {
            offset = this.nextBoundary(offset);
        }
        return offset;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isAfterPunctuation(int offset) {
        if (this.mStart < offset && offset <= this.mEnd) {
            int codePoint = Character.codePointBefore(this.mCharSeq, offset);
            return TextUtils.isPunctuation(codePoint);
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public boolean isOnPunctuation(int offset) {
        if (this.mStart <= offset && offset < this.mEnd) {
            int codePoint = Character.codePointAt(this.mCharSeq, offset);
            return TextUtils.isPunctuation(codePoint);
        }
        return false;
    }

    public static boolean isMidWordPunctuation(Locale locale, int codePoint) {
        int wb = UCharacter.getIntPropertyValue(codePoint, 4116);
        return wb == 4 || wb == 11 || wb == 15;
    }

    private boolean isPunctuationStartBoundary(int offset) {
        return this.isOnPunctuation(offset) && !this.isAfterPunctuation(offset);
    }

    private boolean isPunctuationEndBoundary(int offset) {
        return !this.isOnPunctuation(offset) && this.isAfterPunctuation(offset);
    }

    private boolean isAfterLetterOrDigit(int offset) {
        int codePoint;
        return this.mStart < offset && offset <= this.mEnd && Character.isLetterOrDigit(codePoint = Character.codePointBefore(this.mCharSeq, offset));
    }

    private boolean isOnLetterOrDigit(int offset) {
        int codePoint;
        return this.mStart <= offset && offset < this.mEnd && Character.isLetterOrDigit(codePoint = Character.codePointAt(this.mCharSeq, offset));
    }

    private void checkOffsetIsValid(int offset) {
        if (this.mStart > offset || offset > this.mEnd) {
            throw new IllegalArgumentException("Invalid offset: " + offset + ". Valid range is [" + this.mStart + ", " + this.mEnd + "]");
        }
    }
}

