/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.Spanned;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;

public class DrawableMarginSpan
implements LeadingMarginSpan,
LineHeightSpan {
    private static final int STANDARD_PAD_WIDTH = 0;
    private final Drawable mDrawable;
    private final int mPad;

    public DrawableMarginSpan(Drawable drawable2) {
        this(drawable2, 0);
    }

    public DrawableMarginSpan(Drawable drawable2, int pad) {
        this.mDrawable = drawable2;
        this.mPad = pad;
    }

    @Override
    public int getLeadingMargin(boolean first) {
        return this.mDrawable.getIntrinsicWidth() + this.mPad;
    }

    @Override
    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
        int st = ((Spanned)text).getSpanStart(this);
        int ix = x;
        int itop = layout2.getLineTop(layout2.getLineForOffset(st));
        int dw = this.mDrawable.getIntrinsicWidth();
        int dh = this.mDrawable.getIntrinsicHeight();
        this.mDrawable.setBounds(ix, itop, ix + dw, itop + dh);
        this.mDrawable.draw(c);
    }

    @Override
    public void chooseHeight(CharSequence text, int start, int end, int istartv, int v, Paint.FontMetricsInt fm) {
        if (end == ((Spanned)text).getSpanEnd(this)) {
            int ht = this.mDrawable.getIntrinsicHeight();
            int need = ht - (v + fm.descent - fm.ascent - istartv);
            if (need > 0) {
                fm.descent += need;
            }
            if ((need = ht - (v + fm.bottom - fm.top - istartv)) > 0) {
                fm.bottom += need;
            }
        }
    }

    public String toString() {
        return "DrawableMarginSpan{drawable=" + this.mDrawable + ", padding=" + this.mPad + '}';
    }

    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public int getPadding() {
        return this.mPad;
    }
}

