/*
 * Decompiled with CFR 0.152.
 */
package android.text.style;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Parcel;
import android.text.Layout;
import android.text.ParcelableSpan;
import android.text.style.LeadingMarginSpan;

public class QuoteSpan
implements LeadingMarginSpan,
ParcelableSpan {
    public static final int STANDARD_STRIPE_WIDTH_PX = 2;
    public static final int STANDARD_GAP_WIDTH_PX = 2;
    public static final int STANDARD_COLOR = -16776961;
    private final int mColor;
    private final int mStripeWidth;
    private final int mGapWidth;

    public QuoteSpan() {
        this(-16776961, 2, 2);
    }

    public QuoteSpan(int color2) {
        this(color2, 2, 2);
    }

    public QuoteSpan(int color2, int stripeWidth, int gapWidth) {
        this.mColor = color2;
        this.mStripeWidth = stripeWidth;
        this.mGapWidth = gapWidth;
    }

    public QuoteSpan(Parcel src) {
        this.mColor = src.readInt();
        this.mStripeWidth = src.readInt();
        this.mGapWidth = src.readInt();
    }

    @Override
    public int getSpanTypeId() {
        return this.getSpanTypeIdInternal();
    }

    @Override
    public int getSpanTypeIdInternal() {
        return 9;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.writeToParcelInternal(dest, flags);
    }

    @Override
    public void writeToParcelInternal(Parcel dest, int flags) {
        dest.writeInt(this.mColor);
        dest.writeInt(this.mStripeWidth);
        dest.writeInt(this.mGapWidth);
    }

    public int getColor() {
        return this.mColor;
    }

    public int getStripeWidth() {
        return this.mStripeWidth;
    }

    public int getGapWidth() {
        return this.mGapWidth;
    }

    @Override
    public int getLeadingMargin(boolean first) {
        return this.mStripeWidth + this.mGapWidth;
    }

    @Override
    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
        Paint.Style style2 = p.getStyle();
        int color2 = p.getColor();
        p.setStyle(Paint.Style.FILL);
        p.setColor(this.mColor);
        c.drawRect(x, top, x + dir * this.mStripeWidth, bottom, p);
        p.setStyle(style2);
        p.setColor(color2);
    }

    public String toString() {
        return "QuoteSpan{color=" + String.format("#%08X", this.getColor()) + ", stripeWidth=" + this.getStripeWidth() + ", gapWidth=" + this.getGapWidth() + '}';
    }
}

