/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ResolvingAttributeSet;
import android.util.XmlPullAttributes;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.UnresolvedResourceValue;
import com.android.layoutlib.bridge.android.XmlPullParserResolver;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.ResourceType;
import java.util.Map;
import java.util.function.Function;
import org.xmlpull.v1.XmlPullParser;

public class BridgeXmlPullAttributes
extends XmlPullAttributes
implements ResolvingAttributeSet {
    private final BridgeContext mContext;
    private final ResourceNamespace mXmlFileResourceNamespace;
    private final ResourceNamespace.Resolver mResourceNamespaceResolver;
    private final Function<String, Map<String, Integer>> mFrameworkEnumValueSupplier;
    private final EnumValueSupplier mProjectEnumValueSupplier;

    BridgeXmlPullAttributes(XmlPullParser parser, BridgeContext context, ResourceNamespace xmlFileResourceNamespace, Function<String, Map<String, Integer>> frameworkEnumValueSupplier, EnumValueSupplier projectEnumValueSupplier) {
        super(parser);
        this.mContext = context;
        this.mFrameworkEnumValueSupplier = frameworkEnumValueSupplier;
        this.mProjectEnumValueSupplier = projectEnumValueSupplier;
        this.mXmlFileResourceNamespace = xmlFileResourceNamespace;
        this.mResourceNamespaceResolver = new XmlPullParserResolver(this.mParser, context.getLayoutlibCallback().getImplicitNamespaces());
    }

    public BridgeXmlPullAttributes(XmlPullParser parser, BridgeContext context, ResourceNamespace xmlFileResourceNamespace) {
        this(parser, context, xmlFileResourceNamespace, Bridge::getEnumValues, (ns, attrName) -> {
            ResourceValue attr2 = context.getRenderResources().getUnresolvedResource(ResourceReference.attr((ResourceNamespace)ns, (String)attrName));
            return attr2 instanceof AttrResourceValue ? ((AttrResourceValue)attr2).getAttributeValues() : null;
        });
    }

    @Override
    public int getAttributeNameResource(int index) {
        String name = this.getAttributeName(index);
        String ns = this.mParser.getAttributeNamespace(index);
        if ("http://schemas.android.com/apk/res/android".equals(ns)) {
            return Bridge.getResourceId(ResourceType.ATTR, name);
        }
        ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)ns);
        if (namespace != null) {
            return this.mContext.getLayoutlibCallback().getOrGenerateResourceId(ResourceReference.attr((ResourceNamespace)namespace, (String)name));
        }
        return 0;
    }

    @Override
    public int getAttributeListValue(String namespace, String attribute, String[] options, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToList(value, options, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public boolean getAttributeBooleanValue(String namespace, String attribute, boolean defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value == null) {
            return defaultValue;
        }
        return this.resolveResourceValue(value, defaultValue);
    }

    @Override
    public int getAttributeIntValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value == null) {
            return defaultValue;
        }
        ResourceValue r = this.getResourceValue(value);
        if (r != null) {
            value = r.getValue();
        }
        if (value.charAt(0) == '#') {
            return ResourceHelper.getColor(value);
        }
        try {
            return XmlUtils.convertValueToInt(value, defaultValue);
        }
        catch (NumberFormatException e) {
            Integer enumValue;
            Map<String, Integer> enumValues = null;
            if ("http://schemas.android.com/apk/res/android".equals(namespace)) {
                enumValues = this.mFrameworkEnumValueSupplier.apply(attribute);
            } else {
                ResourceNamespace attrNamespace = ResourceNamespace.fromNamespaceUri((String)namespace);
                if (attrNamespace != null) {
                    enumValues = this.mProjectEnumValueSupplier.getEnumValues(attrNamespace, attribute);
                }
            }
            Integer n = enumValue = enumValues != null ? enumValues.get(value) : null;
            if (enumValue != null) {
                return enumValue;
            }
            throw e;
        }
    }

    @Override
    public int getAttributeUnsignedIntValue(String namespace, String attribute, int defaultValue) {
        String value = this.getAttributeValue(namespace, attribute);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToUnsignedInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public float getAttributeFloatValue(String namespace, String attribute, float defaultValue) {
        String s = this.getAttributeValue(namespace, attribute);
        if (s != null) {
            ResourceValue r = this.getResourceValue(s);
            if (r != null) {
                s = r.getValue();
            }
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeListValue(int index, String[] options, int defaultValue) {
        return XmlUtils.convertValueToList(this.getAttributeValue(index), options, defaultValue);
    }

    @Override
    public boolean getAttributeBooleanValue(int index, boolean defaultValue) {
        String value = this.getAttributeValue(index);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToBoolean(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public int getAttributeResourceValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        return this.resolveResourceValue(value, defaultValue);
    }

    @Override
    public int getAttributeIntValue(int index, int defaultValue) {
        return this.getAttributeIntValue(this.mParser.getAttributeNamespace(index), this.getAttributeName(index), defaultValue);
    }

    @Override
    public int getAttributeUnsignedIntValue(int index, int defaultValue) {
        String value = this.getAttributeValue(index);
        if (value != null) {
            ResourceValue r = this.getResourceValue(value);
            if (r != null) {
                value = r.getValue();
            }
            return XmlUtils.convertValueToUnsignedInt(value, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public float getAttributeFloatValue(int index, float defaultValue) {
        String s = this.getAttributeValue(index);
        if (s != null) {
            ResourceValue r = this.getResourceValue(s);
            if (r != null) {
                s = r.getValue();
            }
            return Float.parseFloat(s);
        }
        return defaultValue;
    }

    @Override
    public ResourceValue getResolvedAttributeValue(String namespace, String name) {
        String s = this.getAttributeValue(namespace, name);
        return s == null ? null : this.getResourceValue(s);
    }

    private ResourceValue getResourceValue(String value) {
        return this.mContext.getRenderResources().resolveResValue((ResourceValue)new UnresolvedResourceValue(value, this.mXmlFileResourceNamespace, this.mResourceNamespaceResolver));
    }

    private int resolveResourceValue(String value, int defaultValue) {
        ResourceValue resource = this.getResourceValue(value);
        if (resource != null) {
            return resource.isFramework() ? Bridge.getResourceId(resource.getResourceType(), resource.getName()) : this.mContext.getLayoutlibCallback().getOrGenerateResourceId(resource.asReference());
        }
        return defaultValue;
    }

    static interface EnumValueSupplier {
        public Map<String, Integer> getEnumValues(ResourceNamespace var1, String var2);
    }
}

