/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import libcore.util.EmptyArray;

public class IntArray
implements Cloneable {
    private static final int MIN_CAPACITY_INCREMENT = 12;
    private int[] mValues;
    private int mSize;

    private IntArray(int[] array2, int size) {
        this.mValues = array2;
        this.mSize = Preconditions.checkArgumentInRange(size, 0, array2.length, "size");
    }

    public IntArray() {
        this(0);
    }

    public IntArray(int initialCapacity) {
        this.mValues = initialCapacity == 0 ? EmptyArray.INT : ArrayUtils.newUnpaddedIntArray(initialCapacity);
        this.mSize = 0;
    }

    public static IntArray wrap(int[] array2) {
        return new IntArray(array2, array2.length);
    }

    public static IntArray fromArray(int[] array2, int size) {
        return IntArray.wrap(Arrays.copyOf(array2, size));
    }

    public void resize(int newSize) {
        Preconditions.checkArgumentNonnegative(newSize);
        if (newSize <= this.mValues.length) {
            Arrays.fill(this.mValues, newSize, this.mValues.length, 0);
        } else {
            this.ensureCapacity(newSize - this.mSize);
        }
        this.mSize = newSize;
    }

    public void add(int value) {
        this.add(this.mSize, value);
    }

    public void add(int index, int value) {
        this.ensureCapacity(1);
        int rightSegment = this.mSize - index;
        ++this.mSize;
        ArrayUtils.checkBounds(this.mSize, index);
        if (rightSegment != 0) {
            System.arraycopy(this.mValues, index, this.mValues, index + 1, rightSegment);
        }
        this.mValues[index] = value;
    }

    public int binarySearch(int value) {
        return ContainerHelpers.binarySearch(this.mValues, this.mSize, value);
    }

    public void addAll(IntArray values) {
        int count = values.mSize;
        this.ensureCapacity(count);
        System.arraycopy(values.mValues, 0, this.mValues, this.mSize, count);
        this.mSize += count;
    }

    public void addAll(int[] values) {
        int count = values.length;
        this.ensureCapacity(count);
        System.arraycopy(values, 0, this.mValues, this.mSize, count);
        this.mSize += count;
    }

    private void ensureCapacity(int count) {
        int currentSize = this.mSize;
        int minCapacity = currentSize + count;
        if (minCapacity >= this.mValues.length) {
            int targetCap = currentSize + (currentSize < 6 ? 12 : currentSize >> 1);
            int newCapacity = targetCap > minCapacity ? targetCap : minCapacity;
            int[] newValues = ArrayUtils.newUnpaddedIntArray(newCapacity);
            System.arraycopy(this.mValues, 0, newValues, 0, currentSize);
            this.mValues = newValues;
        }
    }

    public void clear() {
        this.mSize = 0;
    }

    public IntArray clone() {
        return new IntArray((int[])this.mValues.clone(), this.mSize);
    }

    public int get(int index) {
        ArrayUtils.checkBounds(this.mSize, index);
        return this.mValues[index];
    }

    public void set(int index, int value) {
        ArrayUtils.checkBounds(this.mSize, index);
        this.mValues[index] = value;
    }

    public int indexOf(int value) {
        int n = this.mSize;
        for (int i = 0; i < n; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    public void remove(int index) {
        ArrayUtils.checkBounds(this.mSize, index);
        System.arraycopy(this.mValues, index + 1, this.mValues, index, this.mSize - index - 1);
        --this.mSize;
    }

    public int size() {
        return this.mSize;
    }

    public int[] toArray() {
        return Arrays.copyOf(this.mValues, this.mSize);
    }

    public String toString() {
        int iMax = this.mSize - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(this.mValues[i]);
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }
}

