/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.app.ActivityManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import libcore.util.HexEncoding;

public class PackageUtils {
    private static final int LOW_RAM_BUFFER_SIZE_BYTES = 1000;
    private static final int HIGH_RAM_BUFFER_SIZE_BYTES = 1000000;

    private PackageUtils() {
    }

    public static String[] computeSignaturesSha256Digests(Signature[] signatures) {
        return PackageUtils.computeSignaturesSha256Digests(signatures, null);
    }

    public static String[] computeSignaturesSha256Digests(Signature[] signatures, String separator) {
        int signatureCount = signatures.length;
        String[] digests = new String[signatureCount];
        for (int i = 0; i < signatureCount; ++i) {
            digests[i] = PackageUtils.computeSha256Digest(signatures[i].toByteArray(), separator);
        }
        return digests;
    }

    public static String computeSignaturesSha256Digest(Signature[] signatures) {
        if (signatures.length == 1) {
            return PackageUtils.computeSha256Digest(signatures[0].toByteArray(), null);
        }
        String[] sha256Digests = PackageUtils.computeSignaturesSha256Digests(signatures, null);
        return PackageUtils.computeSignaturesSha256Digest(sha256Digests);
    }

    public static String computeSignaturesSha256Digest(String[] sha256Digests) {
        if (sha256Digests.length == 1) {
            return sha256Digests[0];
        }
        Arrays.sort(sha256Digests);
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        for (String sha256Digest : sha256Digests) {
            try {
                bytes.write(sha256Digest.getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return PackageUtils.computeSha256Digest(bytes.toByteArray(), null);
    }

    public static byte[] computeSha256DigestBytes(byte[] data) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA256");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        messageDigest.update(data);
        return messageDigest.digest();
    }

    public static String computeSha256Digest(byte[] data) {
        return PackageUtils.computeSha256Digest(data, null);
    }

    public static String computeSha256Digest(byte[] data, String separator) {
        byte[] sha256DigestBytes = PackageUtils.computeSha256DigestBytes(data);
        if (sha256DigestBytes == null) {
            return null;
        }
        if (separator == null) {
            return HexEncoding.encodeToString(sha256DigestBytes, true);
        }
        int length = sha256DigestBytes.length;
        Object[] pieces = new String[length];
        for (int index = 0; index < length; ++index) {
            pieces[index] = HexEncoding.encodeToString(sha256DigestBytes[index], true);
        }
        return TextUtils.join((CharSequence)separator, pieces);
    }

    public static byte[] createLargeFileBuffer() {
        int bufferSize = ActivityManager.isLowRamDeviceStatic() ? 1000 : 1000000;
        return new byte[bufferSize];
    }

    public static byte[] computeSha256DigestForLargeFileAsBytes(String filePath, byte[] fileBuffer) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA256");
            messageDigest.reset();
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        File f = new File(filePath);
        try {
            DigestInputStream digestInputStream = new DigestInputStream(new FileInputStream(f), messageDigest);
            while (digestInputStream.read(fileBuffer) != -1) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return messageDigest.digest();
    }

    public static String computeSha256DigestForLargeFile(String filePath, byte[] fileBuffer) {
        return PackageUtils.computeSha256DigestForLargeFile(filePath, fileBuffer, null);
    }

    public static String computeSha256DigestForLargeFile(String filePath, byte[] fileBuffer, String separator) {
        byte[] resultBytes = PackageUtils.computeSha256DigestForLargeFileAsBytes(filePath, fileBuffer);
        if (separator == null) {
            return HexEncoding.encodeToString(resultBytes, false);
        }
        int length = resultBytes.length;
        Object[] pieces = new String[length];
        for (int index = 0; index < length; ++index) {
            pieces[index] = HexEncoding.encodeToString(resultBytes[index], true);
        }
        return TextUtils.join((CharSequence)separator, pieces);
    }
}

