/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.LongSparseArray;
import android.util.Slog;

public class TimeSparseArray<E>
extends LongSparseArray<E> {
    private static final String TAG = TimeSparseArray.class.getSimpleName();
    private boolean mWtfReported;

    public int closestIndexOnOrAfter(long time) {
        int size;
        int result = size = this.size();
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            long key = this.keyAt(mid);
            if (time > key) {
                lo = mid + 1;
                continue;
            }
            if (time < key) {
                hi = mid - 1;
                result = mid;
                continue;
            }
            return mid;
        }
        return result;
    }

    @Override
    public void put(long key, E value) {
        if (this.indexOfKey(key) >= 0 && !this.mWtfReported) {
            Slog.wtf(TAG, "Overwriting value " + this.get(key) + " by " + value);
            this.mWtfReported = true;
        }
        super.put(key, value);
    }

    public int closestIndexOnOrBefore(long time) {
        int index = this.closestIndexOnOrAfter(time);
        if (index < this.size() && this.keyAt(index) == time) {
            return index;
        }
        return index - 1;
    }
}

