/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.RangingReport;
import android.uwb.SessionHandle;
import android.uwb.UwbAddress;
import androidx.annotation.RequiresApi;
import com.android.x.uwb.com.android.modules.utils.build.SdkLevel;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class RangingSession
implements AutoCloseable {
    private final String mTag = "Uwb.RangingSession[" + this + "]";
    private final SessionHandle mSessionHandle;
    private final IUwbAdapter mAdapter;
    private final Executor mExecutor;
    private final Callback mCallback;
    private final String mChipId;
    private State mState = State.INIT;

    public RangingSession(Executor executor, Callback callback, IUwbAdapter adapter, SessionHandle sessionHandle) {
        this(executor, callback, adapter, sessionHandle, null);
    }

    public RangingSession(Executor executor, Callback callback, IUwbAdapter adapter, SessionHandle sessionHandle, String chipId) {
        this.mExecutor = executor;
        this.mCallback = callback;
        this.mAdapter = adapter;
        this.mSessionHandle = sessionHandle;
        this.mChipId = chipId;
    }

    public boolean isOpen() {
        return this.mState == State.IDLE || this.mState == State.ACTIVE;
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void start(PersistableBundle params) {
        if (this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "start - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.startRanging(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void reconfigure(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "reconfigure - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.reconfigureRanging(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void stop() {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "stop - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.stopRanging(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void close() {
        if (this.mState == State.CLOSED) {
            this.mExecutor.execute(() -> this.mCallback.onClosed(1, new PersistableBundle()));
            return;
        }
        Log.v(this.mTag, "close - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.closeRanging(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void addControlee(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "addControlee - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.addControlee(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void removeControlee(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "removeControlee - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.removeControlee(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void pause(PersistableBundle params) {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "pause - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.pause(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void resume(PersistableBundle params) {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "resume - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.resume(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void sendData(UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) {
        if (this.mState != State.ACTIVE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "sendData - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.sendData(this.mSessionHandle, remoteDeviceAddress, params, data);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void updateRangingRoundsDtTag(PersistableBundle params) {
        if (this.mState != State.ACTIVE && this.mState != State.IDLE) {
            throw new IllegalStateException();
        }
        Log.v(this.mTag, "onRangingRoundsUpdateDtTag - sessionHandle: " + this.mSessionHandle);
        try {
            this.mAdapter.updateRangingRoundsDtTag(this.mSessionHandle, params);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int queryMaxDataSizeBytes() {
        if (!this.isOpen()) {
            throw new IllegalStateException("Ranging session is not open");
        }
        Log.v(this.mTag, "QueryMaxDataSizeBytes - sessionHandle: " + this.mSessionHandle);
        try {
            return this.mAdapter.queryMaxDataSizeBytes(this.mSessionHandle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void onRangingOpened() {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingOpened invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingOpened - sessionHandle: " + this.mSessionHandle);
        this.mState = State.IDLE;
        this.executeCallback(() -> this.mCallback.onOpened(this));
    }

    public void onRangingOpenFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingOpenFailed invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingOpenFailed - sessionHandle: " + this.mSessionHandle);
        this.mState = State.CLOSED;
        this.executeCallback(() -> this.mCallback.onOpenFailed(reason, params));
    }

    public void onRangingStarted(PersistableBundle parameters) {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingStarted invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingStarted - sessionHandle: " + this.mSessionHandle);
        this.mState = State.ACTIVE;
        this.executeCallback(() -> this.mCallback.onStarted(parameters));
    }

    public void onRangingStartFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingStartFailed invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingStartFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onStartFailed(reason, params));
    }

    public void onRangingReconfigured(PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingReconfigured invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingReconfigured - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onReconfigured(params));
    }

    public void onRangingReconfigureFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingReconfigureFailed invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingReconfigureFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onReconfigureFailed(reason, params));
    }

    public void onRangingStopped(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingStopped invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingStopped - sessionHandle: " + this.mSessionHandle);
        this.mState = State.IDLE;
        this.executeCallback(() -> this.mCallback.onStopped(reason, params));
    }

    public void onRangingStopFailed(int reason, PersistableBundle params) {
        if (this.mState == State.CLOSED) {
            Log.w(this.mTag, "onRangingStopFailed invoked for a closed session");
            return;
        }
        Log.v(this.mTag, "onRangingStopFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onStopFailed(reason, params));
    }

    public void onRangingClosed(int reason, PersistableBundle parameters) {
        this.mState = State.CLOSED;
        Log.v(this.mTag, "onRangingClosed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onClosed(reason, parameters));
    }

    public void onRangingResult(RangingReport report) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onRangingResult invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onRangingResult - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onReportReceived(report));
    }

    public void onControleeAdded(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onControleeAdded invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onControleeAdded - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onControleeAdded(params));
    }

    public void onControleeAddFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onControleeAddFailed invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onControleeAddFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onControleeAddFailed(reason, params));
    }

    public void onControleeRemoved(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onControleeRemoved invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onControleeRemoved - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onControleeRemoved(params));
    }

    public void onControleeRemoveFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onControleeRemoveFailed invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onControleeRemoveFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onControleeRemoveFailed(reason, params));
    }

    public void onRangingPaused(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onRangingPaused invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onRangingPaused - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onPaused(params));
    }

    public void onRangingPauseFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onRangingPauseFailed invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onRangingPauseFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onPauseFailed(reason, params));
    }

    public void onRangingResumed(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onRangingResumed invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onRangingResumed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onResumed(params));
    }

    public void onRangingResumeFailed(int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onRangingResumeFailed invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onRangingResumeFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onResumeFailed(reason, params));
    }

    public void onDataSent(UwbAddress remoteDeviceAddress, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onDataSent invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onDataSent - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onDataSent(remoteDeviceAddress, params));
    }

    public void onDataSendFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onDataSendFailed invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onDataSendFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onDataSendFailed(remoteDeviceAddress, reason, params));
    }

    public void onDataReceived(UwbAddress remoteDeviceAddress, PersistableBundle params, byte[] data) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onDataReceived invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onDataReceived - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onDataReceived(remoteDeviceAddress, params, data));
    }

    public void onDataReceiveFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onDataReceiveFailed invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onDataReceiveFailed - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onDataReceiveFailed(remoteDeviceAddress, reason, params));
    }

    public void onServiceDiscovered(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onServiceDiscovered invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onServiceDiscovered - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onServiceDiscovered(params));
    }

    public void onServiceConnected(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onServiceConnected invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onServiceConnected - sessionHandle: " + this.mSessionHandle);
        this.executeCallback(() -> this.mCallback.onServiceConnected(params));
    }

    public void onRangingRoundsUpdateDtTagStatus(PersistableBundle params) {
        if (!this.isOpen()) {
            Log.w(this.mTag, "onDlTDoARangingRoundsUpdateStatus invoked for non-open session");
            return;
        }
        Log.v(this.mTag, "onDlTDoARangingRoundsUpdateStatus - sessionHandle: " + this.mSessionHandle);
        if (SdkLevel.isAtLeastU()) {
            this.executeCallback(() -> this.mCallback.onRangingRoundsUpdateDtTagStatus(params));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCallback(Runnable runnable) {
        long identity = Binder.clearCallingIdentity();
        try {
            this.mExecutor.execute(runnable);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void updatePose(PersistableBundle parameters) {
        try {
            this.mAdapter.updatePose(this.mSessionHandle, parameters);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface Callback {
        public static final int REASON_UNKNOWN = 0;
        public static final int REASON_LOCAL_REQUEST = 1;
        public static final int REASON_REMOTE_REQUEST = 2;
        public static final int REASON_BAD_PARAMETERS = 3;
        public static final int REASON_GENERIC_ERROR = 4;
        public static final int REASON_MAX_SESSIONS_REACHED = 5;
        public static final int REASON_SYSTEM_POLICY = 6;
        public static final int REASON_PROTOCOL_SPECIFIC_ERROR = 7;
        public static final int REASON_MAX_RR_RETRY_REACHED = 9;
        public static final int REASON_SERVICE_DISCOVERY_FAILURE = 10;
        public static final int REASON_SERVICE_CONNECTION_FAILURE = 11;
        public static final int REASON_SE_NOT_SUPPORTED = 12;
        public static final int REASON_SE_INTERACTION_FAILURE = 13;
        public static final int REASON_INSUFFICIENT_SLOTS_PER_RR = 14;
        public static final int REASON_SYSTEM_REGULATION = 15;
        public static final int CONTROLEE_FAILURE_REASON_MAX_CONTROLEE_REACHED = 0;
        public static final int DATA_FAILURE_REASON_DATA_SIZE_TOO_LARGE = 10;

        public void onOpened(RangingSession var1);

        public void onOpenFailed(int var1, PersistableBundle var2);

        public void onStarted(PersistableBundle var1);

        public void onStartFailed(int var1, PersistableBundle var2);

        public void onReconfigured(PersistableBundle var1);

        public void onReconfigureFailed(int var1, PersistableBundle var2);

        public void onStopped(int var1, PersistableBundle var2);

        public void onStopFailed(int var1, PersistableBundle var2);

        public void onClosed(int var1, PersistableBundle var2);

        public void onReportReceived(RangingReport var1);

        default public void onControleeAdded(PersistableBundle parameters) {
        }

        default public void onControleeAddFailed(int reason, PersistableBundle parameters) {
        }

        default public void onControleeRemoved(PersistableBundle parameters) {
        }

        default public void onControleeRemoveFailed(int reason, PersistableBundle parameters) {
        }

        default public void onPaused(PersistableBundle parameters) {
        }

        default public void onPauseFailed(int reason, PersistableBundle parameters) {
        }

        default public void onResumed(PersistableBundle parameters) {
        }

        default public void onResumeFailed(int reason, PersistableBundle parameters) {
        }

        default public void onDataSent(UwbAddress remoteDeviceAddress, PersistableBundle parameters) {
        }

        default public void onDataSendFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) {
        }

        default public void onDataReceived(UwbAddress remoteDeviceAddress, PersistableBundle parameters, byte[] data) {
        }

        default public void onDataReceiveFailed(UwbAddress remoteDeviceAddress, int reason, PersistableBundle parameters) {
        }

        default public void onServiceDiscovered(PersistableBundle parameters) {
        }

        default public void onServiceConnected(PersistableBundle parameters) {
        }

        @RequiresApi(value=34)
        default public void onRangingRoundsUpdateDtTagStatus(PersistableBundle parameters) {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DataFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ControleeFailureReason {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Reason {
        }
    }

    private static enum State {
        INIT,
        IDLE,
        ACTIVE,
        CLOSED;

    }
}

