/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.Binder;
import android.os.CancellationSignal;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.AdapterStateListener;
import android.uwb.IOnUwbActivityEnergyInfoListener;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbAdfProvisionStateCallbacks;
import android.uwb.RangingManager;
import android.uwb.RangingReport;
import android.uwb.RangingSession;
import android.uwb.UwbActivityEnergyInfo;
import android.uwb.UwbOemExtensionCallbackListener;
import android.uwb.UwbVendorUciCallbackListener;
import androidx.annotation.RequiresApi;
import com.android.internal.annotations.GuardedBy;
import com.android.x.uwb.com.android.internal.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
public class UwbManager {
    private static final String TAG = "UwbManager";
    private final Context mContext;
    private final IUwbAdapter mUwbAdapter;
    private final AdapterStateListener mAdapterStateListener;
    private final RangingManager mRangingManager;
    private final UwbVendorUciCallbackListener mUwbVendorUciCallbackListener;
    private final UwbOemExtensionCallbackListener mUwbOemExtensionCallbackListener;
    public static final int VENDOR_SET_SESSION_CONFIGURATION_SUCCESS = 0;
    public static final int VENDOR_SET_SESSION_CONFIGURATION_FAILURE = 1;
    public static final int REMOVE_SERVICE_PROFILE_SUCCESS = 0;
    public static final int REMOVE_SERVICE_PROFILE_ERROR_UNKNOWN_SERVICE = 1;
    public static final int REMOVE_SERVICE_PROFILE_ERROR_INTERNAL = 2;
    public static final int REMOVE_PROFILE_ADF_SUCCESS = 0;
    public static final int REMOVE_PROFILE_ADF_ERROR_UNKNOWN_SERVICE = 1;
    public static final int REMOVE_PROFILE_ADF_ERROR_INTERNAL = 2;
    public static final int SEND_VENDOR_UCI_SUCCESS = 0;
    public static final int SEND_VENDOR_UCI_ERROR_HW = 1;
    public static final int SEND_VENDOR_UCI_ERROR_OFF = 2;
    public static final int SEND_VENDOR_UCI_ERROR_INVALID_ARGS = 3;
    public static final int SEND_VENDOR_UCI_ERROR_INVALID_GID = 4;
    public static final int MESSAGE_TYPE_COMMAND = 1;
    public static final int MESSAGE_TYPE_TEST_1 = 4;
    public static final int MESSAGE_TYPE_TEST_2 = 5;

    public UwbManager(Context ctx, IUwbAdapter adapter) {
        this.mContext = ctx;
        this.mUwbAdapter = adapter;
        this.mAdapterStateListener = new AdapterStateListener(adapter);
        this.mRangingManager = new RangingManager(adapter);
        this.mUwbVendorUciCallbackListener = new UwbVendorUciCallbackListener(adapter);
        this.mUwbOemExtensionCallbackListener = new UwbOemExtensionCallbackListener(adapter);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerAdapterStateCallback(Executor executor, AdapterStateCallback callback) {
        this.mAdapterStateListener.register(executor, callback);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void unregisterAdapterStateCallback(AdapterStateCallback callback) {
        this.mAdapterStateListener.unregister(callback);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerUwbVendorUciCallback(Executor executor, UwbVendorUciCallback callback) {
        this.mUwbVendorUciCallbackListener.register(executor, callback);
    }

    public void unregisterUwbVendorUciCallback(UwbVendorUciCallback callback) {
        this.mUwbVendorUciCallbackListener.unregister(callback);
    }

    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void registerUwbOemExtensionCallback(Executor executor, UwbOemExtensionCallback callback) {
        this.mUwbOemExtensionCallbackListener.register(executor, callback);
    }

    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void unregisterUwbOemExtensionCallback(UwbOemExtensionCallback callback) {
        this.mUwbOemExtensionCallbackListener.unregister(callback);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getSpecificationInfo() {
        return this.getSpecificationInfoInternal(null);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getSpecificationInfo(String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.getSpecificationInfoInternal(chipId);
    }

    private PersistableBundle getSpecificationInfoInternal(String chipId) {
        try {
            return this.mUwbAdapter.getSpecificationInfo(chipId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public long elapsedRealtimeResolutionNanos() {
        return this.elapsedRealtimeResolutionNanosInternal(null);
    }

    @SuppressLint(value={"MethodNameUnits"})
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public long elapsedRealtimeResolutionNanos(String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.elapsedRealtimeResolutionNanosInternal(chipId);
    }

    private long elapsedRealtimeResolutionNanosInternal(String chipId) {
        try {
            return this.mUwbAdapter.getTimestampResolutionNanos(chipId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.UWB_PRIVILEGED", "android.permission.UWB_RANGING"})
    public CancellationSignal openRangingSession(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks) {
        return this.openRangingSessionInternal(parameters, executor, callbacks, null);
    }

    @RequiresPermission(allOf={"android.permission.UWB_PRIVILEGED", "android.permission.UWB_RANGING"})
    public CancellationSignal openRangingSession(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks, @SuppressLint(value={"ListenerLast"}) String chipId) {
        Preconditions.checkNotNull(chipId);
        return this.openRangingSessionInternal(parameters, executor, callbacks, chipId);
    }

    private CancellationSignal openRangingSessionInternal(PersistableBundle parameters, Executor executor, RangingSession.Callback callbacks, String chipId) {
        return this.mRangingManager.openSession(this.mContext.getAttributionSource(), parameters, executor, callbacks, chipId);
    }

    public int getAdapterState() {
        return this.mAdapterStateListener.getAdapterState();
    }

    public boolean isUwbEnabled() {
        int adapterState = this.getAdapterState();
        return adapterState == 2 || adapterState == 1;
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void setUwbEnabled(boolean enabled) {
        this.mAdapterStateListener.setEnabled(enabled);
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public List<PersistableBundle> getChipInfos() {
        try {
            return this.mUwbAdapter.getChipInfos();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public String getDefaultChipId() {
        try {
            return this.mUwbAdapter.getDefaultChipId();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle addServiceProfile(PersistableBundle parameters) {
        try {
            return this.mUwbAdapter.addServiceProfile(parameters);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int removeServiceProfile(PersistableBundle parameters) {
        try {
            return this.mUwbAdapter.removeServiceProfile(parameters);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getAllServiceProfiles() {
        try {
            return this.mUwbAdapter.getAllServiceProfiles();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getAdfProvisioningAuthorities(PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.getAdfProvisioningAuthorities(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public PersistableBundle getAdfCertificateInfo(PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.getAdfCertificateAndInfo(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void provisionProfileAdfByScript(PersistableBundle serviceProfileBundle, Executor executor, AdfProvisionStateCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor must not be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null");
        }
        AdfProvisionStateCallback.AdfProvisionStateCallbackProxy proxy = callback.getProxy();
        proxy.initProxy(executor, callback);
        try {
            this.mUwbAdapter.provisionProfileAdfByScript(serviceProfileBundle, proxy);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int removeProfileAdf(PersistableBundle serviceProfileBundle) {
        try {
            return this.mUwbAdapter.removeProfileAdf(serviceProfileBundle);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int sendVendorUciMessage(int gid, int oid, byte[] payload) {
        Objects.requireNonNull(payload, "Payload must not be null");
        try {
            return this.mUwbAdapter.sendVendorUciMessage(1, gid, oid, payload);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresApi(value=34)
    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public int sendVendorUciMessage(int mt, int gid, int oid, byte[] payload) {
        Objects.requireNonNull(payload, "Payload must not be null");
        try {
            return this.mUwbAdapter.sendVendorUciMessage(mt, gid, oid, payload);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.UWB_PRIVILEGED")
    public void getUwbActivityEnergyInfoAsync(Executor executor, Consumer<UwbActivityEnergyInfo> listener) {
        Objects.requireNonNull(executor, "executor cannot be null");
        Objects.requireNonNull(listener, "listener cannot be null");
        try {
            this.mUwbAdapter.getUwbActivityEnergyInfoAsync(new OnUwbActivityEnergyInfoProxy(executor, listener));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface AdapterStateCallback {
        public static final int STATE_CHANGED_REASON_SESSION_STARTED = 0;
        public static final int STATE_CHANGED_REASON_ALL_SESSIONS_CLOSED = 1;
        public static final int STATE_CHANGED_REASON_SYSTEM_POLICY = 2;
        public static final int STATE_CHANGED_REASON_SYSTEM_BOOT = 3;
        public static final int STATE_CHANGED_REASON_ERROR_UNKNOWN = 4;
        public static final int STATE_CHANGED_REASON_SYSTEM_REGULATION = 5;
        public static final int STATE_DISABLED = 0;
        public static final int STATE_ENABLED_INACTIVE = 1;
        public static final int STATE_ENABLED_ACTIVE = 2;

        public void onStateChanged(int var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface State {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StateChangedReason {
        }
    }

    public static interface UwbVendorUciCallback {
        public void onVendorUciResponse(int var1, int var2, byte[] var3);

        public void onVendorUciNotification(int var1, int var2, byte[] var3);
    }

    @RequiresApi(value=34)
    public static interface UwbOemExtensionCallback {
        public void onSessionStatusNotificationReceived(PersistableBundle var1);

        public void onDeviceStatusNotificationReceived(PersistableBundle var1);

        public int onSessionConfigurationComplete(PersistableBundle var1);

        public RangingReport onRangingReportReceived(RangingReport var1);

        public boolean onCheckPointedTarget(PersistableBundle var1);
    }

    public static abstract class AdfProvisionStateCallback {
        private final AdfProvisionStateCallbackProxy mAdfProvisionStateCallbackProxy = new AdfProvisionStateCallbackProxy();
        public static final int REASON_INVALID_OID = 1;
        public static final int REASON_SE_FAILURE = 2;
        public static final int REASON_UNKNOWN = 3;

        public abstract void onProfileAdfsProvisioned(PersistableBundle var1);

        public abstract void onProfileAdfsProvisionFailed(int var1, PersistableBundle var2);

        AdfProvisionStateCallbackProxy getProxy() {
            return this.mAdfProvisionStateCallbackProxy;
        }

        private static class AdfProvisionStateCallbackProxy
        extends IUwbAdfProvisionStateCallbacks.Stub {
            private final Object mLock = new Object();
            @GuardedBy(value={"mLock"})
            private Executor mExecutor = null;
            @GuardedBy(value={"mLock"})
            private AdfProvisionStateCallback mCallback = null;

            AdfProvisionStateCallbackProxy() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void initProxy(Executor executor, AdfProvisionStateCallback callback) {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = executor;
                    this.mCallback = callback;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void cleanUpProxy() {
                Object object = this.mLock;
                synchronized (object) {
                    this.mExecutor = null;
                    this.mCallback = null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProfileAdfsProvisioned(PersistableBundle params) {
                AdfProvisionStateCallback callback;
                Executor executor;
                Log.v(UwbManager.TAG, "AdfProvisionStateCallbackProxy: onProfileAdfsProvisioned : " + params);
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (callback == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onProfileAdfsProvisioned(params));
                this.cleanUpProxy();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onProfileAdfsProvisionFailed(int reason, PersistableBundle params) {
                AdfProvisionStateCallback callback;
                Executor executor;
                Log.v(UwbManager.TAG, "AdfProvisionStateCallbackProxy: onProfileAdfsProvisionFailed : " + reason + ", " + params);
                Object object = this.mLock;
                synchronized (object) {
                    executor = this.mExecutor;
                    callback = this.mCallback;
                }
                if (callback == null || executor == null) {
                    return;
                }
                Binder.clearCallingIdentity();
                executor.execute(() -> callback.onProfileAdfsProvisionFailed(reason, params));
                this.cleanUpProxy();
            }
        }

        @Retention(value=RetentionPolicy.SOURCE)
        static @interface Reason {
        }
    }

    private static class OnUwbActivityEnergyInfoProxy
    extends IOnUwbActivityEnergyInfoListener.Stub {
        private final Object mLock = new Object();
        @GuardedBy(value={"mLock"})
        private Executor mExecutor;
        @GuardedBy(value={"mLock"})
        private Consumer<UwbActivityEnergyInfo> mListener;

        OnUwbActivityEnergyInfoProxy(Executor executor, Consumer<UwbActivityEnergyInfo> listener) {
            this.mExecutor = executor;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUwbActivityEnergyInfo(UwbActivityEnergyInfo info) {
            Consumer<UwbActivityEnergyInfo> listener;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mListener == null) {
                    return;
                }
                executor = this.mExecutor;
                listener = this.mListener;
                this.mExecutor = null;
                this.mListener = null;
            }
            Binder.clearCallingIdentity();
            executor.execute(() -> listener.accept(info));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface MessageType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SendVendorUciStatus {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RemoveProfileAdf {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface RemoveServiceProfile {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface VendorConfigStatus {
    }
}

