/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.os.Binder;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbOemExtensionCallback;
import android.uwb.RangingReport;
import android.uwb.UwbManager;
import com.android.x.uwb.com.android.modules.utils.build.SdkLevel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class UwbOemExtensionCallbackListener
extends IUwbOemExtensionCallback.Stub {
    private static final String TAG = "Uwb.UwbOemExtensionCallback";
    private static final int OEM_EXTENSION_RESPONSE_THRESHOLD_MS = 2000;
    private final IUwbAdapter mAdapter;
    private Executor mExecutor = null;
    private UwbManager.UwbOemExtensionCallback mCallback = null;

    public UwbOemExtensionCallbackListener(IUwbAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Executor executor, UwbManager.UwbOemExtensionCallback callback) {
        UwbOemExtensionCallbackListener uwbOemExtensionCallbackListener = this;
        synchronized (uwbOemExtensionCallbackListener) {
            if (this.mCallback != null) {
                Log.e(TAG, "Callback already registered. Unregister existing callback beforeregistering");
                throw new IllegalArgumentException();
            }
            try {
                this.mAdapter.registerOemExtensionCallback(this);
                this.mExecutor = executor;
                this.mCallback = callback;
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to register Oem extension callback");
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UwbManager.UwbOemExtensionCallback callback) {
        UwbOemExtensionCallbackListener uwbOemExtensionCallbackListener = this;
        synchronized (uwbOemExtensionCallbackListener) {
            if (this.mCallback == null || this.mCallback != callback) {
                Log.e(TAG, "Callback not registered");
                throw new IllegalArgumentException();
            }
            try {
                this.mAdapter.unregisterOemExtensionCallback(this);
                this.mCallback = null;
                this.mExecutor = null;
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to unregister Oem extension callback");
                throw e.rethrowFromSystemServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSessionStatusNotificationReceived(PersistableBundle sessionStatusBundle) throws RemoteException {
        UwbOemExtensionCallbackListener uwbOemExtensionCallbackListener = this;
        synchronized (uwbOemExtensionCallbackListener) {
            long identity = Binder.clearCallingIdentity();
            try {
                if (SdkLevel.isAtLeastU()) {
                    this.mExecutor.execute(() -> this.mCallback.onSessionStatusNotificationReceived(sessionStatusBundle));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDeviceStatusNotificationReceived(PersistableBundle deviceStateBundle) throws RemoteException {
        UwbOemExtensionCallbackListener uwbOemExtensionCallbackListener = this;
        synchronized (uwbOemExtensionCallbackListener) {
            long identity = Binder.clearCallingIdentity();
            try {
                if (SdkLevel.isAtLeastU()) {
                    this.mExecutor.execute(() -> this.mCallback.onDeviceStatusNotificationReceived(deviceStateBundle));
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int onSessionConfigurationReceived(PersistableBundle openSessionBundle) throws RemoteException {
        UwbOemExtensionCallbackListener uwbOemExtensionCallbackListener = this;
        synchronized (uwbOemExtensionCallbackListener) {
            int status = 0;
            long identity = Binder.clearCallingIdentity();
            try {
                if (SdkLevel.isAtLeastU()) {
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    FutureTask<Integer> p = new FutureTask<Integer>(() -> this.mCallback.onSessionConfigurationComplete(openSessionBundle));
                    executor.submit(p);
                    try {
                        status = p.get(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        Log.w(TAG, "Failed to get response for session config from vendor - status : TIMEOUT");
                        e.printStackTrace();
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return status;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public RangingReport onRangingReportReceived(RangingReport rangingReport) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onCheckPointedTarget(PersistableBundle pointedTargetBundle) throws RemoteException {
        UwbOemExtensionCallbackListener uwbOemExtensionCallbackListener = this;
        synchronized (uwbOemExtensionCallbackListener) {
            long identity = Binder.clearCallingIdentity();
            boolean result = false;
            try {
                if (SdkLevel.isAtLeastU()) {
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    FutureTask<Boolean> getCheckPointedTarget = new FutureTask<Boolean>(() -> this.mCallback.onCheckPointedTarget(pointedTargetBundle));
                    executor.submit(getCheckPointedTarget);
                    try {
                        result = getCheckPointedTarget.get(2000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        e.printStackTrace();
                    }
                    catch (TimeoutException e) {
                        Log.w(TAG, "Check pointed target failed: TIMEOUT");
                        e.printStackTrace();
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return result;
        }
    }

    private /* synthetic */ RangingReport lambda$onRangingReportReceived$3(RangingReport rangingReport) throws Exception {
        return this.mCallback.onRangingReportReceived(rangingReport);
    }
}

