/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.os.Binder;
import android.os.RemoteException;
import android.util.Log;
import android.uwb.IUwbAdapter;
import android.uwb.IUwbVendorUciCallback;
import android.uwb.UwbManager;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;

public class UwbVendorUciCallbackListener
extends IUwbVendorUciCallback.Stub {
    private static final String TAG = "Uwb.UwbVendorUciCallbacks";
    private final IUwbAdapter mAdapter;
    private boolean mIsRegistered = false;
    private final Map<UwbManager.UwbVendorUciCallback, Executor> mCallbackMap = new HashMap<UwbManager.UwbVendorUciCallback, Executor>();

    public UwbVendorUciCallbackListener(IUwbAdapter adapter) {
        this.mAdapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Executor executor, UwbManager.UwbVendorUciCallback callback) {
        UwbVendorUciCallbackListener uwbVendorUciCallbackListener = this;
        synchronized (uwbVendorUciCallbackListener) {
            if (this.mCallbackMap.containsKey(callback)) {
                return;
            }
            this.mCallbackMap.put(callback, executor);
            if (!this.mIsRegistered) {
                try {
                    this.mAdapter.registerVendorExtensionCallback(this);
                    this.mIsRegistered = true;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to register adapter state callback");
                    this.mCallbackMap.remove(callback);
                    throw e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(UwbManager.UwbVendorUciCallback callback) {
        UwbVendorUciCallbackListener uwbVendorUciCallbackListener = this;
        synchronized (uwbVendorUciCallbackListener) {
            if (!this.mCallbackMap.containsKey(callback) || !this.mIsRegistered) {
                return;
            }
            if (this.mCallbackMap.size() == 1) {
                try {
                    this.mAdapter.unregisterVendorExtensionCallback(this);
                    this.mIsRegistered = false;
                    this.mCallbackMap.remove(callback);
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to unregister AdapterStateCallback with service");
                    throw e.rethrowFromSystemServer();
                }
            } else {
                this.mCallbackMap.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVendorResponseReceived(int gid, int oid, byte[] payload) throws RemoteException {
        UwbVendorUciCallbackListener uwbVendorUciCallbackListener = this;
        synchronized (uwbVendorUciCallbackListener) {
            long identity = Binder.clearCallingIdentity();
            try {
                for (UwbManager.UwbVendorUciCallback callback : this.mCallbackMap.keySet()) {
                    Executor executor = this.mCallbackMap.get(callback);
                    executor.execute(() -> callback.onVendorUciResponse(gid, oid, payload));
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVendorNotificationReceived(int gid, int oid, byte[] payload) throws RemoteException {
        UwbVendorUciCallbackListener uwbVendorUciCallbackListener = this;
        synchronized (uwbVendorUciCallbackListener) {
            long identity = Binder.clearCallingIdentity();
            try {
                for (UwbManager.UwbVendorUciCallback callback : this.mCallbackMap.keySet()) {
                    Executor executor = this.mCallbackMap.get(callback);
                    executor.execute(() -> callback.onVendorUciNotification(gid, oid, payload));
                }
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

