/*
 * Decompiled with CFR 0.152.
 */
package android.uwb.util;

import android.os.PersistableBundle;
import java.util.Arrays;
import java.util.Objects;
import java.util.TreeSet;

public class PersistableBundleUtils {
    public static int getHashCode(PersistableBundle bundle) {
        if (bundle == null) {
            return -1;
        }
        int iterativeHashcode = 0;
        TreeSet<String> treeSet = new TreeSet<String>(bundle.keySet());
        for (String key : treeSet) {
            Object val = bundle.get(key);
            if (val instanceof PersistableBundle) {
                iterativeHashcode = Objects.hash(iterativeHashcode, key, PersistableBundleUtils.getHashCode((PersistableBundle)val));
                continue;
            }
            iterativeHashcode = Objects.hash(iterativeHashcode, key, val);
        }
        return iterativeHashcode;
    }

    public static boolean isEqual(PersistableBundle left, PersistableBundle right) {
        if (Objects.equals(left, right)) {
            return true;
        }
        if (Objects.isNull(left) != Objects.isNull(right)) {
            return false;
        }
        if (!left.keySet().equals(right.keySet())) {
            return false;
        }
        for (String key : left.keySet()) {
            Object rightVal;
            Object leftVal = left.get(key);
            if (Objects.equals(leftVal, rightVal = right.get(key))) continue;
            if (Objects.isNull(leftVal) != Objects.isNull(rightVal)) {
                return false;
            }
            if (!Objects.equals(leftVal.getClass(), rightVal.getClass())) {
                return false;
            }
            if (!(leftVal instanceof PersistableBundle ? !PersistableBundleUtils.isEqual((PersistableBundle)leftVal, (PersistableBundle)rightVal) : (leftVal.getClass().isArray() ? (leftVal instanceof boolean[] ? !Arrays.equals((boolean[])leftVal, (boolean[])rightVal) : (leftVal instanceof double[] ? !Arrays.equals((double[])leftVal, (double[])rightVal) : (leftVal instanceof int[] ? !Arrays.equals((int[])leftVal, (int[])rightVal) : (leftVal instanceof long[] ? !Arrays.equals((long[])leftVal, (long[])rightVal) : !Arrays.equals((Object[])leftVal, (Object[])rightVal))))) : !Objects.equals(leftVal, rightVal)))) continue;
            return false;
        }
        return true;
    }
}

