/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.view.Display;
import android.view.IWindowSession;
import android.view.LayoutlibRenderer;
import android.view.ThreadedRenderer;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewRootImpl;
import android.view.ViewRootImpl_Accessor;
import android.view.WindowLayout;
import android.view.WindowManagerImpl;

public class AttachInfo_Accessor {
    public static LayoutlibRenderer setAttachInfo(ViewGroup view) {
        Context context = view.getContext();
        WindowManagerImpl wm = (WindowManagerImpl)context.getSystemService("window");
        wm.setBaseRootView(view);
        Display display = wm.getDefaultDisplay();
        ViewRootImpl root = new ViewRootImpl(context, display, new IWindowSession.Default(), new WindowLayout());
        LayoutlibRenderer renderer = new LayoutlibRenderer(context, false, "layoutlib-renderer");
        View.AttachInfo info = root.mAttachInfo;
        info.mThreadedRenderer = renderer;
        info.mHasWindowFocus = true;
        info.mWindowVisibility = 0;
        info.mInTouchMode = false;
        info.mHardwareAccelerated = true;
        info.mApplicationScale = 1.0f;
        ViewRootImpl_Accessor.setChild(root, view);
        view.assignParent(root);
        view.dispatchAttachedToWindow(info, 0);
        return renderer;
    }

    public static void dispatchOnPreDraw(View view) {
        view.mAttachInfo.mTreeObserver.dispatchOnPreDraw();
    }

    public static void detachFromWindow(View view) {
        if (view != null) {
            View.AttachInfo attachInfo = view.mAttachInfo;
            view.dispatchDetachedFromWindow();
            if (attachInfo != null) {
                ThreadedRenderer rootRenderer;
                ViewRootImpl_Accessor.detachFromWindow(attachInfo.mViewRootImpl);
                ThreadedRenderer threadedRenderer = attachInfo.mThreadedRenderer;
                if (threadedRenderer != null) {
                    threadedRenderer.destroy();
                }
                if ((rootRenderer = attachInfo.mViewRootImpl.mAttachInfo.mThreadedRenderer) != null) {
                    rootRenderer.destroy();
                }
            }
        }
    }

    public static ViewRootImpl getRootView(View view) {
        return view.mAttachInfo != null ? view.mAttachInfo.mViewRootImpl : null;
    }
}

