/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.inputmethod.InputMethodManager;
import android.widget.TextView;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HandwritingInitiator {
    private final int mHandwritingSlop;
    private final long mHandwritingTimeoutInMillis;
    private State mState;
    private final HandwritingAreaTracker mHandwritingAreasTracker = new HandwritingAreaTracker();
    @VisibleForTesting
    public WeakReference<View> mConnectedView = null;
    private int mConnectionCount = 0;
    private final InputMethodManager mImm;
    private WeakReference<View> mCachedHoverTarget = null;
    private boolean mShowHoverIconForConnectedView = true;

    @VisibleForTesting
    public HandwritingInitiator(ViewConfiguration viewConfiguration, InputMethodManager inputMethodManager) {
        this.mHandwritingSlop = viewConfiguration.getScaledHandwritingSlop();
        this.mHandwritingTimeoutInMillis = ViewConfiguration.getLongPressTimeout();
        this.mImm = inputMethodManager;
    }

    @VisibleForTesting
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int maskedAction = motionEvent.getActionMasked();
        switch (maskedAction) {
            case 0: 
            case 5: {
                this.mState = null;
                int actionIndex = motionEvent.getActionIndex();
                int toolType = motionEvent.getToolType(actionIndex);
                if (toolType != 2 && toolType != 4) {
                    return false;
                }
                this.mState = new State(motionEvent);
                break;
            }
            case 6: {
                int pointerId = motionEvent.getPointerId(motionEvent.getActionIndex());
                if (this.mState == null || pointerId != this.mState.mStylusPointerId) {
                    return false;
                }
            }
            case 1: 
            case 3: {
                if (this.mState != null) {
                    this.mState.mShouldInitHandwriting = false;
                    if (!this.mState.mHasInitiatedHandwriting && !this.mState.mHasPreparedHandwritingDelegation) {
                        this.mShowHoverIconForConnectedView = true;
                    }
                }
                return false;
            }
            case 2: {
                float y;
                if (this.mState == null) {
                    return false;
                }
                if (!this.mState.mShouldInitHandwriting || this.mState.mExceedHandwritingSlop) {
                    return this.mState.mHasInitiatedHandwriting || this.mState.mHasPreparedHandwritingDelegation;
                }
                long timeElapsed = motionEvent.getEventTime() - this.mState.mStylusDownTimeInMillis;
                if (timeElapsed > this.mHandwritingTimeoutInMillis) {
                    this.mState.mShouldInitHandwriting = false;
                    return this.mState.mHasInitiatedHandwriting || this.mState.mHasPreparedHandwritingDelegation;
                }
                int pointerIndex = motionEvent.findPointerIndex(this.mState.mStylusPointerId);
                float x = motionEvent.getX(pointerIndex);
                if (this.largerThanTouchSlop(x, y = motionEvent.getY(pointerIndex), this.mState.mStylusDownX, this.mState.mStylusDownY)) {
                    this.mState.mExceedHandwritingSlop = true;
                    View candidateView = this.findBestCandidateView(this.mState.mStylusDownX, this.mState.mStylusDownY);
                    if (candidateView != null) {
                        if (candidateView == this.getConnectedView()) {
                            if (!candidateView.hasFocus()) {
                                HandwritingInitiator.requestFocusWithoutReveal(candidateView);
                            }
                            this.startHandwriting(candidateView);
                        } else if (candidateView.getHandwritingDelegatorCallback() != null) {
                            String delegatePackageName = candidateView.getAllowedHandwritingDelegatePackageName();
                            if (delegatePackageName == null) {
                                delegatePackageName = candidateView.getContext().getOpPackageName();
                            }
                            this.mImm.prepareStylusHandwritingDelegation(candidateView, delegatePackageName);
                            candidateView.getHandwritingDelegatorCallback().run();
                            this.mState.mHasPreparedHandwritingDelegation = true;
                        } else {
                            HandwritingInitiator.requestFocusWithoutReveal(candidateView);
                        }
                    }
                }
                return this.mState.mHasInitiatedHandwriting || this.mState.mHasPreparedHandwritingDelegation;
            }
        }
        return false;
    }

    private View getConnectedView() {
        if (this.mConnectedView == null) {
            return null;
        }
        return (View)this.mConnectedView.get();
    }

    private void clearConnectedView() {
        this.mConnectedView = null;
        this.mConnectionCount = 0;
    }

    public void onDelegateViewFocused(View view) {
        if (view == this.getConnectedView() && this.tryAcceptStylusHandwritingDelegation(view)) {
            this.mShowHoverIconForConnectedView = false;
        }
    }

    public void onInputConnectionCreated(View view) {
        if (!view.isAutoHandwritingEnabled()) {
            this.clearConnectedView();
            return;
        }
        View connectedView = this.getConnectedView();
        if (connectedView == view) {
            ++this.mConnectionCount;
        } else {
            this.mConnectedView = new WeakReference<View>(view);
            this.mConnectionCount = 1;
            this.mShowHoverIconForConnectedView = true;
            if (view.isHandwritingDelegate() && this.tryAcceptStylusHandwritingDelegation(view)) {
                this.mShowHoverIconForConnectedView = false;
                return;
            }
            if (this.mState != null && this.mState.mShouldInitHandwriting) {
                this.tryStartHandwriting();
            }
        }
    }

    public void onInputConnectionClosed(View view) {
        View connectedView = this.getConnectedView();
        if (connectedView == null) {
            return;
        }
        if (connectedView == view) {
            --this.mConnectionCount;
            if (this.mConnectionCount == 0) {
                this.clearConnectedView();
            }
        } else {
            this.clearConnectedView();
        }
    }

    private void tryStartHandwriting() {
        if (!this.mState.mExceedHandwritingSlop) {
            return;
        }
        View connectedView = this.getConnectedView();
        if (connectedView == null) {
            return;
        }
        if (!connectedView.isAutoHandwritingEnabled()) {
            this.clearConnectedView();
            return;
        }
        Rect handwritingArea = HandwritingInitiator.getViewHandwritingArea(connectedView);
        if (HandwritingInitiator.isInHandwritingArea(handwritingArea, this.mState.mStylusDownX, this.mState.mStylusDownY, connectedView)) {
            this.startHandwriting(connectedView);
        } else {
            this.mState.mShouldInitHandwriting = false;
        }
    }

    @VisibleForTesting
    public void startHandwriting(View view) {
        this.mImm.startStylusHandwriting(view);
        this.mState.mHasInitiatedHandwriting = true;
        this.mState.mShouldInitHandwriting = false;
        this.mShowHoverIconForConnectedView = false;
        if (view instanceof TextView) {
            ((TextView)view).hideHint();
        }
    }

    @VisibleForTesting
    public boolean tryAcceptStylusHandwritingDelegation(View view) {
        String delegatorPackageName = view.getAllowedHandwritingDelegatorPackageName();
        if (delegatorPackageName == null) {
            delegatorPackageName = view.getContext().getOpPackageName();
        }
        if (this.mImm.acceptStylusHandwritingDelegation(view, delegatorPackageName)) {
            if (this.mState != null) {
                this.mState.mHasInitiatedHandwriting = true;
                this.mState.mShouldInitHandwriting = false;
            }
            if (view instanceof TextView) {
                ((TextView)view).hideHint();
            }
            return true;
        }
        return false;
    }

    public void updateHandwritingAreasForView(View view) {
        this.mHandwritingAreasTracker.updateHandwritingAreaForView(view);
    }

    private static boolean shouldTriggerStylusHandwritingForView(View view) {
        if (!view.isAutoHandwritingEnabled()) {
            return false;
        }
        return view.isStylusHandwritingAvailable();
    }

    public PointerIcon onResolvePointerIcon(Context context, MotionEvent event) {
        View hoverView = this.findHoverView(event);
        if (hoverView == null) {
            return null;
        }
        if (this.mShowHoverIconForConnectedView) {
            return PointerIcon.getSystemIcon(context, 1022);
        }
        if (hoverView != this.getConnectedView()) {
            this.mShowHoverIconForConnectedView = true;
            return PointerIcon.getSystemIcon(context, 1022);
        }
        return null;
    }

    private View getCachedHoverTarget() {
        if (this.mCachedHoverTarget == null) {
            return null;
        }
        return (View)this.mCachedHoverTarget.get();
    }

    private View findHoverView(MotionEvent event) {
        if (!event.isStylusPointer() || !event.isHoverEvent()) {
            return null;
        }
        if (event.getActionMasked() == 9 || event.getActionMasked() == 7) {
            Rect handwritingArea;
            float hoverX = event.getX(event.getActionIndex());
            float hoverY = event.getY(event.getActionIndex());
            View cachedHoverTarget = this.getCachedHoverTarget();
            if (cachedHoverTarget != null && HandwritingInitiator.isInHandwritingArea(handwritingArea = HandwritingInitiator.getViewHandwritingArea(cachedHoverTarget), hoverX, hoverY, cachedHoverTarget) && HandwritingInitiator.shouldTriggerStylusHandwritingForView(cachedHoverTarget)) {
                return cachedHoverTarget;
            }
            View candidateView = this.findBestCandidateView(hoverX, hoverY);
            if (candidateView != null) {
                this.mCachedHoverTarget = new WeakReference<View>(candidateView);
                return candidateView;
            }
        }
        this.mCachedHoverTarget = null;
        return null;
    }

    private static void requestFocusWithoutReveal(View view) {
        if (view.getRevealOnFocusHint()) {
            view.setRevealOnFocusHint(false);
            view.requestFocus();
            view.setRevealOnFocusHint(true);
        } else {
            view.requestFocus();
        }
    }

    private View findBestCandidateView(float x, float y) {
        Rect handwritingArea;
        View connectedView = this.getConnectedView();
        if (connectedView != null && HandwritingInitiator.isInHandwritingArea(handwritingArea = HandwritingInitiator.getViewHandwritingArea(connectedView), x, y, connectedView) && HandwritingInitiator.shouldTriggerStylusHandwritingForView(connectedView)) {
            return connectedView;
        }
        float minDistance = Float.MAX_VALUE;
        View bestCandidate = null;
        List<HandwritableViewInfo> handwritableViewInfos = this.mHandwritingAreasTracker.computeViewInfos();
        for (HandwritableViewInfo viewInfo : handwritableViewInfos) {
            View view = viewInfo.getView();
            Rect handwritingArea2 = viewInfo.getHandwritingArea();
            if (!HandwritingInitiator.isInHandwritingArea(handwritingArea2, x, y, view) || !HandwritingInitiator.shouldTriggerStylusHandwritingForView(view)) continue;
            float distance = HandwritingInitiator.distance(handwritingArea2, x, y);
            if (distance == 0.0f) {
                return view;
            }
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            bestCandidate = view;
        }
        return bestCandidate;
    }

    private static float distance(Rect rect, float x, float y) {
        if (HandwritingInitiator.contains(rect, x, y, 0.0f, 0.0f, 0.0f, 0.0f)) {
            return 0.0f;
        }
        float xDistance = x >= (float)rect.left && x < (float)rect.right ? 0.0f : (x < (float)rect.left ? (float)rect.left - x : x - (float)rect.right);
        float yDistance = y >= (float)rect.top && y < (float)rect.bottom ? 0.0f : (y < (float)rect.top ? (float)rect.top - y : y - (float)rect.bottom);
        return xDistance * xDistance + yDistance * yDistance;
    }

    private static Rect getViewHandwritingArea(View view) {
        ViewParent viewParent = view.getParent();
        if (viewParent != null && view.isAttachedToWindow() && view.isAggregatedVisible()) {
            Rect localHandwritingArea = view.getHandwritingArea();
            Rect globalHandwritingArea = new Rect();
            if (localHandwritingArea != null) {
                globalHandwritingArea.set(localHandwritingArea);
            } else {
                globalHandwritingArea.set(0, 0, view.getWidth(), view.getHeight());
            }
            if (viewParent.getChildVisibleRect(view, globalHandwritingArea, null)) {
                return globalHandwritingArea;
            }
        }
        return null;
    }

    private static boolean isInHandwritingArea(Rect handwritingArea, float x, float y, View view) {
        if (handwritingArea == null) {
            return false;
        }
        return HandwritingInitiator.contains(handwritingArea, x, y, view.getHandwritingBoundsOffsetLeft(), view.getHandwritingBoundsOffsetTop(), view.getHandwritingBoundsOffsetRight(), view.getHandwritingBoundsOffsetBottom());
    }

    private static boolean contains(Rect rect, float x, float y, float offsetLeft, float offsetTop, float offsetRight, float offsetBottom) {
        return x >= (float)rect.left - offsetLeft && x < (float)rect.right + offsetRight && y >= (float)rect.top - offsetTop && y < (float)rect.bottom + offsetBottom;
    }

    private boolean largerThanTouchSlop(float x1, float y1, float x2, float y2) {
        float dx = x1 - x2;
        float dy = y1 - y2;
        return dx * dx + dy * dy > (float)(this.mHandwritingSlop * this.mHandwritingSlop);
    }

    private static boolean isViewActive(View view) {
        return view != null && view.isAttachedToWindow() && view.isAggregatedVisible() && view.isAutoHandwritingEnabled();
    }

    @VisibleForTesting
    public static class HandwritingAreaTracker {
        private final List<HandwritableViewInfo> mHandwritableViewInfos = new ArrayList<HandwritableViewInfo>();

        public void updateHandwritingAreaForView(View view) {
            Iterator<HandwritableViewInfo> iterator = this.mHandwritableViewInfos.iterator();
            boolean found = false;
            while (iterator.hasNext()) {
                HandwritableViewInfo handwritableViewInfo = iterator.next();
                View curView = handwritableViewInfo.getView();
                if (!HandwritingInitiator.isViewActive(curView)) {
                    iterator.remove();
                }
                if (curView != view) continue;
                found = true;
                handwritableViewInfo.mIsDirty = true;
            }
            if (!found && HandwritingInitiator.isViewActive(view)) {
                this.mHandwritableViewInfos.add(new HandwritableViewInfo(view));
            }
        }

        public List<HandwritableViewInfo> computeViewInfos() {
            this.mHandwritableViewInfos.removeIf(viewInfo -> !viewInfo.update());
            return this.mHandwritableViewInfos;
        }
    }

    private static class State {
        private boolean mShouldInitHandwriting;
        private boolean mHasInitiatedHandwriting;
        private boolean mHasPreparedHandwritingDelegation;
        private boolean mExceedHandwritingSlop;
        private final int mStylusPointerId;
        private final long mStylusDownTimeInMillis;
        private final float mStylusDownX;
        private final float mStylusDownY;

        private State(MotionEvent motionEvent) {
            int actionIndex = motionEvent.getActionIndex();
            this.mStylusPointerId = motionEvent.getPointerId(actionIndex);
            this.mStylusDownTimeInMillis = motionEvent.getEventTime();
            this.mStylusDownX = motionEvent.getX(actionIndex);
            this.mStylusDownY = motionEvent.getY(actionIndex);
            this.mShouldInitHandwriting = true;
            this.mHasInitiatedHandwriting = false;
            this.mHasPreparedHandwritingDelegation = false;
            this.mExceedHandwritingSlop = false;
        }
    }

    @VisibleForTesting
    public static class HandwritableViewInfo {
        final WeakReference<View> mViewRef;
        Rect mHandwritingArea = null;
        @VisibleForTesting
        public boolean mIsDirty = true;

        @VisibleForTesting
        public HandwritableViewInfo(View view) {
            this.mViewRef = new WeakReference<View>(view);
        }

        public View getView() {
            return (View)this.mViewRef.get();
        }

        public Rect getHandwritingArea() {
            return this.mHandwritingArea;
        }

        public boolean update() {
            View view = this.getView();
            if (!HandwritingInitiator.isViewActive(view)) {
                return false;
            }
            if (!this.mIsDirty) {
                return true;
            }
            Rect handwritingArea = view.getHandwritingArea();
            if (handwritingArea == null) {
                return false;
            }
            ViewParent parent = view.getParent();
            if (parent != null) {
                if (this.mHandwritingArea == null) {
                    this.mHandwritingArea = new Rect();
                }
                this.mHandwritingArea.set(handwritingArea);
                if (!parent.getChildVisibleRect(view, this.mHandwritingArea, null)) {
                    this.mHandwritingArea = null;
                }
            }
            this.mIsDirty = false;
            return true;
        }
    }
}

