/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.inputmethod.ImeTracker;

public interface IDisplayWindowInsetsController
extends IInterface {
    public static final String DESCRIPTOR = "android.view.IDisplayWindowInsetsController";

    public void topFocusedWindowChanged(ComponentName var1, int var2) throws RemoteException;

    public void insetsChanged(InsetsState var1) throws RemoteException;

    public void insetsControlChanged(InsetsState var1, InsetsSourceControl[] var2) throws RemoteException;

    public void showInsets(int var1, boolean var2, ImeTracker.Token var3) throws RemoteException;

    public void hideInsets(int var1, boolean var2, ImeTracker.Token var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDisplayWindowInsetsController {
        static final int TRANSACTION_topFocusedWindowChanged = 1;
        static final int TRANSACTION_insetsChanged = 2;
        static final int TRANSACTION_insetsControlChanged = 3;
        static final int TRANSACTION_showInsets = 4;
        static final int TRANSACTION_hideInsets = 5;

        public Stub() {
            this.attachInterface(this, IDisplayWindowInsetsController.DESCRIPTOR);
        }

        public static IDisplayWindowInsetsController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IDisplayWindowInsetsController.DESCRIPTOR);
            if (iin != null && iin instanceof IDisplayWindowInsetsController) {
                return (IDisplayWindowInsetsController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "topFocusedWindowChanged";
                }
                case 2: {
                    return "insetsChanged";
                }
                case 3: {
                    return "insetsControlChanged";
                }
                case 4: {
                    return "showInsets";
                }
                case 5: {
                    return "hideInsets";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IDisplayWindowInsetsController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    ComponentName _arg0 = data.readTypedObject(ComponentName.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.topFocusedWindowChanged(_arg0, _arg1);
                    break;
                }
                case 2: {
                    InsetsState _arg0 = data.readTypedObject(InsetsState.CREATOR);
                    data.enforceNoDataAvail();
                    this.insetsChanged(_arg0);
                    break;
                }
                case 3: {
                    InsetsState _arg0 = data.readTypedObject(InsetsState.CREATOR);
                    InsetsSourceControl[] _arg1 = data.createTypedArray(InsetsSourceControl.CREATOR);
                    data.enforceNoDataAvail();
                    this.insetsControlChanged(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.showInsets(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    ImeTracker.Token _arg2 = data.readTypedObject(ImeTracker.Token.CREATOR);
                    data.enforceNoDataAvail();
                    this.hideInsets(_arg0, _arg1, _arg2);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IDisplayWindowInsetsController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IDisplayWindowInsetsController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void topFocusedWindowChanged(ComponentName component, int requestedVisibleTypes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeTypedObject(component, 0);
                    _data.writeInt(requestedVisibleTypes);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsChanged(InsetsState insetsState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeTypedObject(insetsState, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeTypedObject(insetsState, 0);
                    _data.writeTypedArray(activeControls, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeBoolean(fromIme);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IDisplayWindowInsetsController.DESCRIPTOR);
                    _data.writeInt(types);
                    _data.writeBoolean(fromIme);
                    _data.writeTypedObject(statsToken, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDisplayWindowInsetsController {
        @Override
        public void topFocusedWindowChanged(ComponentName component, int requestedVisibleTypes) throws RemoteException {
        }

        @Override
        public void insetsChanged(InsetsState insetsState) throws RemoteException {
        }

        @Override
        public void insetsControlChanged(InsetsState insetsState, InsetsSourceControl[] activeControls) throws RemoteException {
        }

        @Override
        public void showInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public void hideInsets(int types, boolean fromIme, ImeTracker.Token statsToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

