/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IDockedStackListener
extends IInterface {
    public void onDividerVisibilityChanged(boolean var1) throws RemoteException;

    public void onDockedStackExistsChanged(boolean var1) throws RemoteException;

    public void onDockedStackMinimizedChanged(boolean var1, long var2, boolean var4) throws RemoteException;

    public void onAdjustedForImeChanged(boolean var1, long var2) throws RemoteException;

    public void onDockSideChanged(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IDockedStackListener {
        public static final String DESCRIPTOR = "android.view.IDockedStackListener";
        static final int TRANSACTION_onDividerVisibilityChanged = 1;
        static final int TRANSACTION_onDockedStackExistsChanged = 2;
        static final int TRANSACTION_onDockedStackMinimizedChanged = 3;
        static final int TRANSACTION_onAdjustedForImeChanged = 4;
        static final int TRANSACTION_onDockSideChanged = 5;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IDockedStackListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IDockedStackListener) {
                return (IDockedStackListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDividerVisibilityChanged";
                }
                case 2: {
                    return "onDockedStackExistsChanged";
                }
                case 3: {
                    return "onDockedStackMinimizedChanged";
                }
                case 4: {
                    return "onAdjustedForImeChanged";
                }
                case 5: {
                    return "onDockSideChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onDividerVisibilityChanged(_arg0);
                    break;
                }
                case 2: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onDockedStackExistsChanged(_arg0);
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    long _arg1 = data.readLong();
                    boolean _arg2 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onDockedStackMinimizedChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    long _arg1 = data.readLong();
                    data.enforceNoDataAvail();
                    this.onAdjustedForImeChanged(_arg0, _arg1);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDockSideChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IDockedStackListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDividerVisibilityChanged(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visible);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDockedStackExistsChanged(boolean exists) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(exists);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDockedStackMinimizedChanged(boolean minimized, long animDuration, boolean isHomeStackResizable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(minimized);
                    _data.writeLong(animDuration);
                    _data.writeBoolean(isHomeStackResizable);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAdjustedForImeChanged(boolean adjustedForIme, long animDuration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(adjustedForIme);
                    _data.writeLong(animDuration);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDockSideChanged(int newDockSide) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(newDockSide);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IDockedStackListener {
        @Override
        public void onDividerVisibilityChanged(boolean visible) throws RemoteException {
        }

        @Override
        public void onDockedStackExistsChanged(boolean exists) throws RemoteException {
        }

        @Override
        public void onDockedStackMinimizedChanged(boolean minimized, long animDuration, boolean isHomeStackResizable) throws RemoteException {
        }

        @Override
        public void onAdjustedForImeChanged(boolean adjustedForIme, long animDuration) throws RemoteException {
        }

        @Override
        public void onDockSideChanged(int newDockSide) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

