/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.view.SurfaceControl;
import android.window.PictureInPictureSurfaceTransaction;
import android.window.TaskSnapshot;

public interface IRecentsAnimationController
extends IInterface {
    public TaskSnapshot screenshotTask(int var1) throws RemoteException;

    public void setFinishTaskTransaction(int var1, PictureInPictureSurfaceTransaction var2, SurfaceControl var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IRecentsAnimationController.aidl:60:1:60:25")
    public void finish(boolean var1, boolean var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IRecentsAnimationController.aidl:70:1:70:25")
    public void setInputConsumerEnabled(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IRecentsAnimationController.aidl:79:1:79:25")
    public void setAnimationTargetsBehindSystemBars(boolean var1) throws RemoteException;

    public void cleanupScreenshot() throws RemoteException;

    public void setDeferCancelUntilNextTransition(boolean var1, boolean var2) throws RemoteException;

    public void setWillFinishToHome(boolean var1) throws RemoteException;

    public boolean removeTask(int var1) throws RemoteException;

    public void detachNavigationBarFromApp(boolean var1) throws RemoteException;

    public void animateNavigationBarToApp(long var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRecentsAnimationController {
        public static final String DESCRIPTOR = "android.view.IRecentsAnimationController";
        static final int TRANSACTION_screenshotTask = 1;
        static final int TRANSACTION_setFinishTaskTransaction = 2;
        static final int TRANSACTION_finish = 3;
        static final int TRANSACTION_setInputConsumerEnabled = 4;
        static final int TRANSACTION_setAnimationTargetsBehindSystemBars = 5;
        static final int TRANSACTION_cleanupScreenshot = 6;
        static final int TRANSACTION_setDeferCancelUntilNextTransition = 7;
        static final int TRANSACTION_setWillFinishToHome = 8;
        static final int TRANSACTION_removeTask = 9;
        static final int TRANSACTION_detachNavigationBarFromApp = 10;
        static final int TRANSACTION_animateNavigationBarToApp = 11;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IRecentsAnimationController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IRecentsAnimationController) {
                return (IRecentsAnimationController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "screenshotTask";
                }
                case 2: {
                    return "setFinishTaskTransaction";
                }
                case 3: {
                    return "finish";
                }
                case 4: {
                    return "setInputConsumerEnabled";
                }
                case 5: {
                    return "setAnimationTargetsBehindSystemBars";
                }
                case 6: {
                    return "cleanupScreenshot";
                }
                case 7: {
                    return "setDeferCancelUntilNextTransition";
                }
                case 8: {
                    return "setWillFinishToHome";
                }
                case 9: {
                    return "removeTask";
                }
                case 10: {
                    return "detachNavigationBarFromApp";
                }
                case 11: {
                    return "animateNavigationBarToApp";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    TaskSnapshot _result = this.screenshotTask(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    PictureInPictureSurfaceTransaction _arg1 = data.readTypedObject(PictureInPictureSurfaceTransaction.CREATOR);
                    SurfaceControl _arg2 = data.readTypedObject(SurfaceControl.CREATOR);
                    data.enforceNoDataAvail();
                    this.setFinishTaskTransaction(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.finish(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInputConsumerEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setAnimationTargetsBehindSystemBars(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    this.cleanupScreenshot();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    boolean _arg0 = data.readBoolean();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDeferCancelUntilNextTransition(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setWillFinishToHome(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.removeTask(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 10: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.detachNavigationBarFromApp(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.animateNavigationBarToApp(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 10;
        }

        private static class Proxy
        implements IRecentsAnimationController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TaskSnapshot screenshotTask(int taskId) throws RemoteException {
                TaskSnapshot _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(TaskSnapshot.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFinishTaskTransaction(int taskId, PictureInPictureSurfaceTransaction finishTransaction, SurfaceControl overlay) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeTypedObject(finishTransaction, 0);
                    _data.writeTypedObject(overlay, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finish(boolean moveHomeToTop, boolean sendUserLeaveHint) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(moveHomeToTop);
                    _data.writeBoolean(sendUserLeaveHint);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInputConsumerEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationTargetsBehindSystemBars(boolean behindSystemBars) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(behindSystemBars);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cleanupScreenshot() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeferCancelUntilNextTransition(boolean defer, boolean screenshot) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(defer);
                    _data.writeBoolean(screenshot);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWillFinishToHome(boolean willFinishToHome) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(willFinishToHome);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeTask(int taskId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detachNavigationBarFromApp(boolean moveHomeToTop) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(moveHomeToTop);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void animateNavigationBarToApp(long duration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(duration);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRecentsAnimationController {
        @Override
        public TaskSnapshot screenshotTask(int taskId) throws RemoteException {
            return null;
        }

        @Override
        public void setFinishTaskTransaction(int taskId, PictureInPictureSurfaceTransaction finishTransaction, SurfaceControl overlay) throws RemoteException {
        }

        @Override
        public void finish(boolean moveHomeToTop, boolean sendUserLeaveHint) throws RemoteException {
        }

        @Override
        public void setInputConsumerEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void setAnimationTargetsBehindSystemBars(boolean behindSystemBars) throws RemoteException {
        }

        @Override
        public void cleanupScreenshot() throws RemoteException {
        }

        @Override
        public void setDeferCancelUntilNextTransition(boolean defer, boolean screenshot) throws RemoteException {
        }

        @Override
        public void setWillFinishToHome(boolean willFinishToHome) throws RemoteException {
        }

        @Override
        public boolean removeTask(int taskId) throws RemoteException {
            return false;
        }

        @Override
        public void detachNavigationBarFromApp(boolean moveHomeToTop) throws RemoteException {
        }

        @Override
        public void animateNavigationBarToApp(long duration) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

