/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.RequiresPermission;
import android.app.IAssistDataReceiver;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import android.view.DisplayInfo;
import android.view.IAppTransitionAnimationSpecsFuture;
import android.view.ICrossWindowBlurEnabledListener;
import android.view.IDisplayChangeWindowController;
import android.view.IDisplayFoldListener;
import android.view.IDisplayWindowInsetsController;
import android.view.IDisplayWindowListener;
import android.view.IOnKeyguardExitResult;
import android.view.IPinnedTaskListener;
import android.view.IRotationWatcher;
import android.view.IScrollCaptureResponseListener;
import android.view.ISystemGestureExclusionListener;
import android.view.IWallpaperVisibilityListener;
import android.view.IWindow;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InsetsState;
import android.view.RemoteAnimationAdapter;
import android.view.SurfaceControl;
import android.view.TaskTransitionSpec;
import android.view.WindowContentFrameStats;
import android.view.displayhash.DisplayHash;
import android.view.displayhash.VerifiedDisplayHash;
import android.window.AddToSurfaceSyncGroupResult;
import android.window.ISurfaceSyncGroupCompletedListener;
import android.window.ITaskFpsCallback;
import android.window.ScreenCapture;
import com.android.internal.os.IResultReceiver;
import com.android.internal.policy.IKeyguardDismissCallback;
import com.android.internal.policy.IKeyguardLockedStateListener;
import com.android.internal.policy.IShortcutService;
import java.util.ArrayList;
import java.util.List;

public interface IWindowManager
extends IInterface {
    public static final int FIXED_TO_USER_ROTATION_DEFAULT = 0;
    public static final int FIXED_TO_USER_ROTATION_DISABLED = 1;
    public static final int FIXED_TO_USER_ROTATION_ENABLED = 2;

    public boolean startViewServer(int var1) throws RemoteException;

    public boolean stopViewServer() throws RemoteException;

    public boolean isViewServerRunning() throws RemoteException;

    public IWindowSession openSession(IWindowSessionCallback var1) throws RemoteException;

    public boolean useBLAST() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:111:1:111:25")
    public void getInitialDisplaySize(int var1, Point var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:113:1:113:25")
    public void getBaseDisplaySize(int var1, Point var2) throws RemoteException;

    public void setForcedDisplaySize(int var1, int var2, int var3) throws RemoteException;

    public void clearForcedDisplaySize(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:117:1:117:25")
    public int getInitialDisplayDensity(int var1) throws RemoteException;

    public int getBaseDisplayDensity(int var1) throws RemoteException;

    public int getDisplayIdByUniqueId(String var1) throws RemoteException;

    public void setForcedDisplayDensityForUser(int var1, int var2, int var3) throws RemoteException;

    public void clearForcedDisplayDensityForUser(int var1, int var2) throws RemoteException;

    public void setForcedDisplayScalingMode(int var1, int var2) throws RemoteException;

    public void setEventDispatching(boolean var1) throws RemoteException;

    public boolean isWindowToken(IBinder var1) throws RemoteException;

    public void addWindowToken(IBinder var1, int var2, int var3, Bundle var4) throws RemoteException;

    public void removeWindowToken(IBinder var1, int var2) throws RemoteException;

    public void setDisplayChangeWindowController(IDisplayChangeWindowController var1) throws RemoteException;

    public SurfaceControl addShellRoot(int var1, IWindow var2, int var3) throws RemoteException;

    public void setShellRootAccessibilityWindow(int var1, int var2, IWindow var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:177:1:177:25")
    public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture var1, IRemoteCallback var2, boolean var3, int var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:181:1:181:25")
    public void overridePendingAppTransitionRemote(RemoteAnimationAdapter var1, int var2) throws RemoteException;

    @Deprecated
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:189:1:189:69")
    public void endProlongedAnimations() throws RemoteException;

    public void startFreezingScreen(int var1, int var2) throws RemoteException;

    public void stopFreezingScreen() throws RemoteException;

    @Deprecated
    public void disableKeyguard(IBinder var1, String var2, int var3) throws RemoteException;

    @Deprecated
    public void reenableKeyguard(IBinder var1, int var2) throws RemoteException;

    public void exitKeyguardSecurely(IOnKeyguardExitResult var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:201:1:201:25")
    public boolean isKeyguardLocked() throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:203:1:203:69")
    public boolean isKeyguardSecure(int var1) throws RemoteException;

    public void dismissKeyguard(IKeyguardDismissCallback var1, CharSequence var2) throws RemoteException;

    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void addKeyguardLockedStateListener(IKeyguardLockedStateListener var1) throws RemoteException;

    @RequiresPermission(value="android.permission.SUBSCRIBE_TO_KEYGUARD_LOCKED_STATE")
    public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener var1) throws RemoteException;

    public void setSwitchingUser(boolean var1) throws RemoteException;

    public void closeSystemDialogs(String var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:221:1:221:25")
    public float getAnimationScale(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:223:1:223:69")
    public float[] getAnimationScales() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:225:1:225:25")
    public void setAnimationScale(int var1, float var2) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:227:1:227:69")
    public void setAnimationScales(float[] var1) throws RemoteException;

    public float getCurrentAnimatorScale() throws RemoteException;

    public void setInTouchMode(boolean var1, int var2) throws RemoteException;

    public void setInTouchModeOnAllDisplays(boolean var1) throws RemoteException;

    public boolean isInTouchMode(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=28, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:250:1:250:44")
    public void showStrictModeViolation(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:257:1:257:69")
    public void setStrictModeVisualIndicatorPreference(String var1) throws RemoteException;

    public void refreshScreenCaptureDisabled() throws RemoteException;

    public int getDefaultDisplayRotation() throws RemoteException;

    public int watchRotation(IRotationWatcher var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:284:1:284:25")
    public void removeRotationWatcher(IRotationWatcher var1) throws RemoteException;

    public int registerProposedRotationListener(IBinder var1, IRotationWatcher var2) throws RemoteException;

    public int getPreferredOptionsPanelGravity(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:303:1:303:25")
    public void freezeRotation(int var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:310:1:310:25")
    public void thawRotation() throws RemoteException;

    public boolean isRotationFrozen() throws RemoteException;

    public void freezeDisplayRotation(int var1, int var2) throws RemoteException;

    public void thawDisplayRotation(int var1) throws RemoteException;

    public boolean isDisplayRotationFrozen(int var1) throws RemoteException;

    public void setFixedToUserRotation(int var1, int var2) throws RemoteException;

    public void setIgnoreOrientationRequest(int var1, boolean var2) throws RemoteException;

    public Bitmap screenshotWallpaper() throws RemoteException;

    public SurfaceControl mirrorWallpaperSurface(int var1) throws RemoteException;

    public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener var1, int var2) throws RemoteException;

    public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener var1, int var2) throws RemoteException;

    public boolean requestAssistScreenshot(IAssistDataReceiver var1) throws RemoteException;

    public void hideTransientBars(int var1) throws RemoteException;

    public void setRecentsVisibility(boolean var1) throws RemoteException;

    public void updateStaticPrivacyIndicatorBounds(int var1, Rect[] var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:420:1:420:25")
    public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:428:1:428:25")
    public boolean hasNavigationBar(int var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:434:1:434:69")
    public void lockNow(Bundle var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:440:1:440:25")
    public boolean isSafeModeEnabled() throws RemoteException;

    public boolean clearWindowContentFrameStats(IBinder var1) throws RemoteException;

    public WindowContentFrameStats getWindowContentFrameStats(IBinder var1) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:462:1:462:25")
    public int getDockedStackSide() throws RemoteException;

    public void registerPinnedTaskListener(int var1, IPinnedTaskListener var2) throws RemoteException;

    public void requestAppKeyboardShortcuts(IResultReceiver var1, int var2) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:480:1:480:25")
    public void getStableInsets(int var1, Rect var2) throws RemoteException;

    public void registerShortcutKey(long var1, IShortcutService var3) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:493:1:493:25")
    public void createInputConsumer(IBinder var1, String var2, int var3, InputChannel var4) throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="frameworks/base/core/java/android/view/IWindowManager.aidl:501:1:501:25")
    public boolean destroyInputConsumer(String var1, int var2) throws RemoteException;

    public Region getCurrentImeTouchRegion() throws RemoteException;

    public void registerDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public void unregisterDisplayFoldListener(IDisplayFoldListener var1) throws RemoteException;

    public int[] registerDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void unregisterDisplayWindowListener(IDisplayWindowListener var1) throws RemoteException;

    public void startWindowTrace() throws RemoteException;

    public void stopWindowTrace() throws RemoteException;

    public void saveWindowTraceToFile() throws RemoteException;

    public boolean isWindowTraceEnabled() throws RemoteException;

    public void startTransitionTrace() throws RemoteException;

    public void stopTransitionTrace() throws RemoteException;

    public boolean isTransitionTraceEnabled() throws RemoteException;

    public int getWindowingMode(int var1) throws RemoteException;

    public void setWindowingMode(int var1, int var2) throws RemoteException;

    public int getRemoveContentMode(int var1) throws RemoteException;

    public void setRemoveContentMode(int var1, int var2) throws RemoteException;

    public boolean shouldShowWithInsecureKeyguard(int var1) throws RemoteException;

    public void setShouldShowWithInsecureKeyguard(int var1, boolean var2) throws RemoteException;

    public boolean shouldShowSystemDecors(int var1) throws RemoteException;

    public void setShouldShowSystemDecors(int var1, boolean var2) throws RemoteException;

    public int getDisplayImePolicy(int var1) throws RemoteException;

    public void setDisplayImePolicy(int var1, int var2) throws RemoteException;

    public void syncInputTransactions(boolean var1) throws RemoteException;

    public boolean isLayerTracing() throws RemoteException;

    public void setLayerTracing(boolean var1) throws RemoteException;

    public boolean mirrorDisplay(int var1, SurfaceControl var2) throws RemoteException;

    public void setDisplayWindowInsetsController(int var1, IDisplayWindowInsetsController var2) throws RemoteException;

    public void updateDisplayWindowRequestedVisibleTypes(int var1, int var2) throws RemoteException;

    public boolean getWindowInsets(int var1, IBinder var2, InsetsState var3) throws RemoteException;

    public List<DisplayInfo> getPossibleDisplayInfo(int var1) throws RemoteException;

    public void showGlobalActions() throws RemoteException;

    public void setLayerTracingFlags(int var1) throws RemoteException;

    public void setActiveTransactionTracing(boolean var1) throws RemoteException;

    public void requestScrollCapture(int var1, IBinder var2, int var3, IScrollCaptureResponseListener var4) throws RemoteException;

    public void holdLock(IBinder var1, int var2) throws RemoteException;

    public String[] getSupportedDisplayHashAlgorithms() throws RemoteException;

    public VerifiedDisplayHash verifyDisplayHash(DisplayHash var1) throws RemoteException;

    public void setDisplayHashThrottlingEnabled(boolean var1) throws RemoteException;

    public Configuration attachWindowContextToDisplayArea(IBinder var1, int var2, int var3, Bundle var4) throws RemoteException;

    public void attachWindowContextToWindowToken(IBinder var1, IBinder var2) throws RemoteException;

    public Configuration attachToDisplayContent(IBinder var1, int var2) throws RemoteException;

    public void detachWindowContextFromWindowContainer(IBinder var1) throws RemoteException;

    public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener var1) throws RemoteException;

    public boolean isTaskSnapshotSupported() throws RemoteException;

    public int getImeDisplayId() throws RemoteException;

    public void setTaskSnapshotEnabled(boolean var1) throws RemoteException;

    public void setTaskTransitionSpec(TaskTransitionSpec var1) throws RemoteException;

    public void clearTaskTransitionSpec() throws RemoteException;

    public void registerTaskFpsCallback(int var1, ITaskFpsCallback var2) throws RemoteException;

    public void unregisterTaskFpsCallback(ITaskFpsCallback var1) throws RemoteException;

    public Bitmap snapshotTaskForRecents(int var1) throws RemoteException;

    public void setRecentsAppBehindSystemBars(boolean var1) throws RemoteException;

    public int getLetterboxBackgroundColorInArgb() throws RemoteException;

    public boolean isLetterboxBackgroundMultiColored() throws RemoteException;

    public void captureDisplay(int var1, ScreenCapture.CaptureArgs var2, ScreenCapture.ScreenCaptureListener var3) throws RemoteException;

    public boolean isGlobalKey(int var1) throws RemoteException;

    public boolean addToSurfaceSyncGroup(IBinder var1, boolean var2, ISurfaceSyncGroupCompletedListener var3, AddToSurfaceSyncGroupResult var4) throws RemoteException;

    public void markSurfaceSyncGroupReady(IBinder var1) throws RemoteException;

    public List<ComponentName> notifyScreenshotListeners(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWindowManager {
        public static final String DESCRIPTOR = "android.view.IWindowManager";
        static final int TRANSACTION_startViewServer = 1;
        static final int TRANSACTION_stopViewServer = 2;
        static final int TRANSACTION_isViewServerRunning = 3;
        static final int TRANSACTION_openSession = 4;
        static final int TRANSACTION_useBLAST = 5;
        static final int TRANSACTION_getInitialDisplaySize = 6;
        static final int TRANSACTION_getBaseDisplaySize = 7;
        static final int TRANSACTION_setForcedDisplaySize = 8;
        static final int TRANSACTION_clearForcedDisplaySize = 9;
        static final int TRANSACTION_getInitialDisplayDensity = 10;
        static final int TRANSACTION_getBaseDisplayDensity = 11;
        static final int TRANSACTION_getDisplayIdByUniqueId = 12;
        static final int TRANSACTION_setForcedDisplayDensityForUser = 13;
        static final int TRANSACTION_clearForcedDisplayDensityForUser = 14;
        static final int TRANSACTION_setForcedDisplayScalingMode = 15;
        static final int TRANSACTION_setEventDispatching = 16;
        static final int TRANSACTION_isWindowToken = 17;
        static final int TRANSACTION_addWindowToken = 18;
        static final int TRANSACTION_removeWindowToken = 19;
        static final int TRANSACTION_setDisplayChangeWindowController = 20;
        static final int TRANSACTION_addShellRoot = 21;
        static final int TRANSACTION_setShellRootAccessibilityWindow = 22;
        static final int TRANSACTION_overridePendingAppTransitionMultiThumbFuture = 23;
        static final int TRANSACTION_overridePendingAppTransitionRemote = 24;
        static final int TRANSACTION_endProlongedAnimations = 25;
        static final int TRANSACTION_startFreezingScreen = 26;
        static final int TRANSACTION_stopFreezingScreen = 27;
        static final int TRANSACTION_disableKeyguard = 28;
        static final int TRANSACTION_reenableKeyguard = 29;
        static final int TRANSACTION_exitKeyguardSecurely = 30;
        static final int TRANSACTION_isKeyguardLocked = 31;
        static final int TRANSACTION_isKeyguardSecure = 32;
        static final int TRANSACTION_dismissKeyguard = 33;
        static final int TRANSACTION_addKeyguardLockedStateListener = 34;
        static final int TRANSACTION_removeKeyguardLockedStateListener = 35;
        static final int TRANSACTION_setSwitchingUser = 36;
        static final int TRANSACTION_closeSystemDialogs = 37;
        static final int TRANSACTION_getAnimationScale = 38;
        static final int TRANSACTION_getAnimationScales = 39;
        static final int TRANSACTION_setAnimationScale = 40;
        static final int TRANSACTION_setAnimationScales = 41;
        static final int TRANSACTION_getCurrentAnimatorScale = 42;
        static final int TRANSACTION_setInTouchMode = 43;
        static final int TRANSACTION_setInTouchModeOnAllDisplays = 44;
        static final int TRANSACTION_isInTouchMode = 45;
        static final int TRANSACTION_showStrictModeViolation = 46;
        static final int TRANSACTION_setStrictModeVisualIndicatorPreference = 47;
        static final int TRANSACTION_refreshScreenCaptureDisabled = 48;
        static final int TRANSACTION_getDefaultDisplayRotation = 49;
        static final int TRANSACTION_watchRotation = 50;
        static final int TRANSACTION_removeRotationWatcher = 51;
        static final int TRANSACTION_registerProposedRotationListener = 52;
        static final int TRANSACTION_getPreferredOptionsPanelGravity = 53;
        static final int TRANSACTION_freezeRotation = 54;
        static final int TRANSACTION_thawRotation = 55;
        static final int TRANSACTION_isRotationFrozen = 56;
        static final int TRANSACTION_freezeDisplayRotation = 57;
        static final int TRANSACTION_thawDisplayRotation = 58;
        static final int TRANSACTION_isDisplayRotationFrozen = 59;
        static final int TRANSACTION_setFixedToUserRotation = 60;
        static final int TRANSACTION_setIgnoreOrientationRequest = 61;
        static final int TRANSACTION_screenshotWallpaper = 62;
        static final int TRANSACTION_mirrorWallpaperSurface = 63;
        static final int TRANSACTION_registerWallpaperVisibilityListener = 64;
        static final int TRANSACTION_unregisterWallpaperVisibilityListener = 65;
        static final int TRANSACTION_registerSystemGestureExclusionListener = 66;
        static final int TRANSACTION_unregisterSystemGestureExclusionListener = 67;
        static final int TRANSACTION_requestAssistScreenshot = 68;
        static final int TRANSACTION_hideTransientBars = 69;
        static final int TRANSACTION_setRecentsVisibility = 70;
        static final int TRANSACTION_updateStaticPrivacyIndicatorBounds = 71;
        static final int TRANSACTION_setNavBarVirtualKeyHapticFeedbackEnabled = 72;
        static final int TRANSACTION_hasNavigationBar = 73;
        static final int TRANSACTION_lockNow = 74;
        static final int TRANSACTION_isSafeModeEnabled = 75;
        static final int TRANSACTION_clearWindowContentFrameStats = 76;
        static final int TRANSACTION_getWindowContentFrameStats = 77;
        static final int TRANSACTION_getDockedStackSide = 78;
        static final int TRANSACTION_registerPinnedTaskListener = 79;
        static final int TRANSACTION_requestAppKeyboardShortcuts = 80;
        static final int TRANSACTION_getStableInsets = 81;
        static final int TRANSACTION_registerShortcutKey = 82;
        static final int TRANSACTION_createInputConsumer = 83;
        static final int TRANSACTION_destroyInputConsumer = 84;
        static final int TRANSACTION_getCurrentImeTouchRegion = 85;
        static final int TRANSACTION_registerDisplayFoldListener = 86;
        static final int TRANSACTION_unregisterDisplayFoldListener = 87;
        static final int TRANSACTION_registerDisplayWindowListener = 88;
        static final int TRANSACTION_unregisterDisplayWindowListener = 89;
        static final int TRANSACTION_startWindowTrace = 90;
        static final int TRANSACTION_stopWindowTrace = 91;
        static final int TRANSACTION_saveWindowTraceToFile = 92;
        static final int TRANSACTION_isWindowTraceEnabled = 93;
        static final int TRANSACTION_startTransitionTrace = 94;
        static final int TRANSACTION_stopTransitionTrace = 95;
        static final int TRANSACTION_isTransitionTraceEnabled = 96;
        static final int TRANSACTION_getWindowingMode = 97;
        static final int TRANSACTION_setWindowingMode = 98;
        static final int TRANSACTION_getRemoveContentMode = 99;
        static final int TRANSACTION_setRemoveContentMode = 100;
        static final int TRANSACTION_shouldShowWithInsecureKeyguard = 101;
        static final int TRANSACTION_setShouldShowWithInsecureKeyguard = 102;
        static final int TRANSACTION_shouldShowSystemDecors = 103;
        static final int TRANSACTION_setShouldShowSystemDecors = 104;
        static final int TRANSACTION_getDisplayImePolicy = 105;
        static final int TRANSACTION_setDisplayImePolicy = 106;
        static final int TRANSACTION_syncInputTransactions = 107;
        static final int TRANSACTION_isLayerTracing = 108;
        static final int TRANSACTION_setLayerTracing = 109;
        static final int TRANSACTION_mirrorDisplay = 110;
        static final int TRANSACTION_setDisplayWindowInsetsController = 111;
        static final int TRANSACTION_updateDisplayWindowRequestedVisibleTypes = 112;
        static final int TRANSACTION_getWindowInsets = 113;
        static final int TRANSACTION_getPossibleDisplayInfo = 114;
        static final int TRANSACTION_showGlobalActions = 115;
        static final int TRANSACTION_setLayerTracingFlags = 116;
        static final int TRANSACTION_setActiveTransactionTracing = 117;
        static final int TRANSACTION_requestScrollCapture = 118;
        static final int TRANSACTION_holdLock = 119;
        static final int TRANSACTION_getSupportedDisplayHashAlgorithms = 120;
        static final int TRANSACTION_verifyDisplayHash = 121;
        static final int TRANSACTION_setDisplayHashThrottlingEnabled = 122;
        static final int TRANSACTION_attachWindowContextToDisplayArea = 123;
        static final int TRANSACTION_attachWindowContextToWindowToken = 124;
        static final int TRANSACTION_attachToDisplayContent = 125;
        static final int TRANSACTION_detachWindowContextFromWindowContainer = 126;
        static final int TRANSACTION_registerCrossWindowBlurEnabledListener = 127;
        static final int TRANSACTION_unregisterCrossWindowBlurEnabledListener = 128;
        static final int TRANSACTION_isTaskSnapshotSupported = 129;
        static final int TRANSACTION_getImeDisplayId = 130;
        static final int TRANSACTION_setTaskSnapshotEnabled = 131;
        static final int TRANSACTION_setTaskTransitionSpec = 132;
        static final int TRANSACTION_clearTaskTransitionSpec = 133;
        static final int TRANSACTION_registerTaskFpsCallback = 134;
        static final int TRANSACTION_unregisterTaskFpsCallback = 135;
        static final int TRANSACTION_snapshotTaskForRecents = 136;
        static final int TRANSACTION_setRecentsAppBehindSystemBars = 137;
        static final int TRANSACTION_getLetterboxBackgroundColorInArgb = 138;
        static final int TRANSACTION_isLetterboxBackgroundMultiColored = 139;
        static final int TRANSACTION_captureDisplay = 140;
        static final int TRANSACTION_isGlobalKey = 141;
        static final int TRANSACTION_addToSurfaceSyncGroup = 142;
        static final int TRANSACTION_markSurfaceSyncGroupReady = 143;
        static final int TRANSACTION_notifyScreenshotListeners = 144;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWindowManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWindowManager) {
                return (IWindowManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startViewServer";
                }
                case 2: {
                    return "stopViewServer";
                }
                case 3: {
                    return "isViewServerRunning";
                }
                case 4: {
                    return "openSession";
                }
                case 5: {
                    return "useBLAST";
                }
                case 6: {
                    return "getInitialDisplaySize";
                }
                case 7: {
                    return "getBaseDisplaySize";
                }
                case 8: {
                    return "setForcedDisplaySize";
                }
                case 9: {
                    return "clearForcedDisplaySize";
                }
                case 10: {
                    return "getInitialDisplayDensity";
                }
                case 11: {
                    return "getBaseDisplayDensity";
                }
                case 12: {
                    return "getDisplayIdByUniqueId";
                }
                case 13: {
                    return "setForcedDisplayDensityForUser";
                }
                case 14: {
                    return "clearForcedDisplayDensityForUser";
                }
                case 15: {
                    return "setForcedDisplayScalingMode";
                }
                case 16: {
                    return "setEventDispatching";
                }
                case 17: {
                    return "isWindowToken";
                }
                case 18: {
                    return "addWindowToken";
                }
                case 19: {
                    return "removeWindowToken";
                }
                case 20: {
                    return "setDisplayChangeWindowController";
                }
                case 21: {
                    return "addShellRoot";
                }
                case 22: {
                    return "setShellRootAccessibilityWindow";
                }
                case 23: {
                    return "overridePendingAppTransitionMultiThumbFuture";
                }
                case 24: {
                    return "overridePendingAppTransitionRemote";
                }
                case 25: {
                    return "endProlongedAnimations";
                }
                case 26: {
                    return "startFreezingScreen";
                }
                case 27: {
                    return "stopFreezingScreen";
                }
                case 28: {
                    return "disableKeyguard";
                }
                case 29: {
                    return "reenableKeyguard";
                }
                case 30: {
                    return "exitKeyguardSecurely";
                }
                case 31: {
                    return "isKeyguardLocked";
                }
                case 32: {
                    return "isKeyguardSecure";
                }
                case 33: {
                    return "dismissKeyguard";
                }
                case 34: {
                    return "addKeyguardLockedStateListener";
                }
                case 35: {
                    return "removeKeyguardLockedStateListener";
                }
                case 36: {
                    return "setSwitchingUser";
                }
                case 37: {
                    return "closeSystemDialogs";
                }
                case 38: {
                    return "getAnimationScale";
                }
                case 39: {
                    return "getAnimationScales";
                }
                case 40: {
                    return "setAnimationScale";
                }
                case 41: {
                    return "setAnimationScales";
                }
                case 42: {
                    return "getCurrentAnimatorScale";
                }
                case 43: {
                    return "setInTouchMode";
                }
                case 44: {
                    return "setInTouchModeOnAllDisplays";
                }
                case 45: {
                    return "isInTouchMode";
                }
                case 46: {
                    return "showStrictModeViolation";
                }
                case 47: {
                    return "setStrictModeVisualIndicatorPreference";
                }
                case 48: {
                    return "refreshScreenCaptureDisabled";
                }
                case 49: {
                    return "getDefaultDisplayRotation";
                }
                case 50: {
                    return "watchRotation";
                }
                case 51: {
                    return "removeRotationWatcher";
                }
                case 52: {
                    return "registerProposedRotationListener";
                }
                case 53: {
                    return "getPreferredOptionsPanelGravity";
                }
                case 54: {
                    return "freezeRotation";
                }
                case 55: {
                    return "thawRotation";
                }
                case 56: {
                    return "isRotationFrozen";
                }
                case 57: {
                    return "freezeDisplayRotation";
                }
                case 58: {
                    return "thawDisplayRotation";
                }
                case 59: {
                    return "isDisplayRotationFrozen";
                }
                case 60: {
                    return "setFixedToUserRotation";
                }
                case 61: {
                    return "setIgnoreOrientationRequest";
                }
                case 62: {
                    return "screenshotWallpaper";
                }
                case 63: {
                    return "mirrorWallpaperSurface";
                }
                case 64: {
                    return "registerWallpaperVisibilityListener";
                }
                case 65: {
                    return "unregisterWallpaperVisibilityListener";
                }
                case 66: {
                    return "registerSystemGestureExclusionListener";
                }
                case 67: {
                    return "unregisterSystemGestureExclusionListener";
                }
                case 68: {
                    return "requestAssistScreenshot";
                }
                case 69: {
                    return "hideTransientBars";
                }
                case 70: {
                    return "setRecentsVisibility";
                }
                case 71: {
                    return "updateStaticPrivacyIndicatorBounds";
                }
                case 72: {
                    return "setNavBarVirtualKeyHapticFeedbackEnabled";
                }
                case 73: {
                    return "hasNavigationBar";
                }
                case 74: {
                    return "lockNow";
                }
                case 75: {
                    return "isSafeModeEnabled";
                }
                case 76: {
                    return "clearWindowContentFrameStats";
                }
                case 77: {
                    return "getWindowContentFrameStats";
                }
                case 78: {
                    return "getDockedStackSide";
                }
                case 79: {
                    return "registerPinnedTaskListener";
                }
                case 80: {
                    return "requestAppKeyboardShortcuts";
                }
                case 81: {
                    return "getStableInsets";
                }
                case 82: {
                    return "registerShortcutKey";
                }
                case 83: {
                    return "createInputConsumer";
                }
                case 84: {
                    return "destroyInputConsumer";
                }
                case 85: {
                    return "getCurrentImeTouchRegion";
                }
                case 86: {
                    return "registerDisplayFoldListener";
                }
                case 87: {
                    return "unregisterDisplayFoldListener";
                }
                case 88: {
                    return "registerDisplayWindowListener";
                }
                case 89: {
                    return "unregisterDisplayWindowListener";
                }
                case 90: {
                    return "startWindowTrace";
                }
                case 91: {
                    return "stopWindowTrace";
                }
                case 92: {
                    return "saveWindowTraceToFile";
                }
                case 93: {
                    return "isWindowTraceEnabled";
                }
                case 94: {
                    return "startTransitionTrace";
                }
                case 95: {
                    return "stopTransitionTrace";
                }
                case 96: {
                    return "isTransitionTraceEnabled";
                }
                case 97: {
                    return "getWindowingMode";
                }
                case 98: {
                    return "setWindowingMode";
                }
                case 99: {
                    return "getRemoveContentMode";
                }
                case 100: {
                    return "setRemoveContentMode";
                }
                case 101: {
                    return "shouldShowWithInsecureKeyguard";
                }
                case 102: {
                    return "setShouldShowWithInsecureKeyguard";
                }
                case 103: {
                    return "shouldShowSystemDecors";
                }
                case 104: {
                    return "setShouldShowSystemDecors";
                }
                case 105: {
                    return "getDisplayImePolicy";
                }
                case 106: {
                    return "setDisplayImePolicy";
                }
                case 107: {
                    return "syncInputTransactions";
                }
                case 108: {
                    return "isLayerTracing";
                }
                case 109: {
                    return "setLayerTracing";
                }
                case 110: {
                    return "mirrorDisplay";
                }
                case 111: {
                    return "setDisplayWindowInsetsController";
                }
                case 112: {
                    return "updateDisplayWindowRequestedVisibleTypes";
                }
                case 113: {
                    return "getWindowInsets";
                }
                case 114: {
                    return "getPossibleDisplayInfo";
                }
                case 115: {
                    return "showGlobalActions";
                }
                case 116: {
                    return "setLayerTracingFlags";
                }
                case 117: {
                    return "setActiveTransactionTracing";
                }
                case 118: {
                    return "requestScrollCapture";
                }
                case 119: {
                    return "holdLock";
                }
                case 120: {
                    return "getSupportedDisplayHashAlgorithms";
                }
                case 121: {
                    return "verifyDisplayHash";
                }
                case 122: {
                    return "setDisplayHashThrottlingEnabled";
                }
                case 123: {
                    return "attachWindowContextToDisplayArea";
                }
                case 124: {
                    return "attachWindowContextToWindowToken";
                }
                case 125: {
                    return "attachToDisplayContent";
                }
                case 126: {
                    return "detachWindowContextFromWindowContainer";
                }
                case 127: {
                    return "registerCrossWindowBlurEnabledListener";
                }
                case 128: {
                    return "unregisterCrossWindowBlurEnabledListener";
                }
                case 129: {
                    return "isTaskSnapshotSupported";
                }
                case 130: {
                    return "getImeDisplayId";
                }
                case 131: {
                    return "setTaskSnapshotEnabled";
                }
                case 132: {
                    return "setTaskTransitionSpec";
                }
                case 133: {
                    return "clearTaskTransitionSpec";
                }
                case 134: {
                    return "registerTaskFpsCallback";
                }
                case 135: {
                    return "unregisterTaskFpsCallback";
                }
                case 136: {
                    return "snapshotTaskForRecents";
                }
                case 137: {
                    return "setRecentsAppBehindSystemBars";
                }
                case 138: {
                    return "getLetterboxBackgroundColorInArgb";
                }
                case 139: {
                    return "isLetterboxBackgroundMultiColored";
                }
                case 140: {
                    return "captureDisplay";
                }
                case 141: {
                    return "isGlobalKey";
                }
                case 142: {
                    return "addToSurfaceSyncGroup";
                }
                case 143: {
                    return "markSurfaceSyncGroupReady";
                }
                case 144: {
                    return "notifyScreenshotListeners";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.startViewServer(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 2: {
                    boolean _result = this.stopViewServer();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 3: {
                    boolean _result = this.isViewServerRunning();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 4: {
                    IWindowSessionCallback _arg0 = IWindowSessionCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    IWindowSession _result = this.openSession(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    boolean _result = this.useBLAST();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    data.enforceNoDataAvail();
                    this.getInitialDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    Point _arg1 = new Point();
                    data.enforceNoDataAvail();
                    this.getBaseDisplaySize(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplaySize(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearForcedDisplaySize(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getInitialDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 11: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getBaseDisplayDensity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 12: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    int _result = this.getDisplayIdByUniqueId(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplayDensityForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.clearForcedDisplayDensityForUser(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setForcedDisplayScalingMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setEventDispatching(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.isWindowToken(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 18: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.addWindowToken(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.removeWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    IDisplayChangeWindowController _arg0 = IDisplayChangeWindowController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setDisplayChangeWindowController(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    int _arg0 = data.readInt();
                    IWindow _arg1 = IWindow.Stub.asInterface(data.readStrongBinder());
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    SurfaceControl _result = this.addShellRoot(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 22: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    IWindow _arg2 = IWindow.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setShellRootAccessibilityWindow(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    IAppTransitionAnimationSpecsFuture _arg0 = IAppTransitionAnimationSpecsFuture.Stub.asInterface(data.readStrongBinder());
                    IRemoteCallback _arg1 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _arg2 = data.readBoolean();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overridePendingAppTransitionMultiThumbFuture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    RemoteAnimationAdapter _arg0 = data.readTypedObject(RemoteAnimationAdapter.CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.overridePendingAppTransitionRemote(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    this.endProlongedAnimations();
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.startFreezingScreen(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    this.stopFreezingScreen();
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.disableKeyguard(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 29: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.reenableKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    IOnKeyguardExitResult _arg0 = IOnKeyguardExitResult.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.exitKeyguardSecurely(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    boolean _result = this.isKeyguardLocked();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 32: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isKeyguardSecure(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 33: {
                    IKeyguardDismissCallback _arg0 = IKeyguardDismissCallback.Stub.asInterface(data.readStrongBinder());
                    CharSequence _arg1 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    data.enforceNoDataAvail();
                    this.dismissKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 34: {
                    IKeyguardLockedStateListener _arg0 = IKeyguardLockedStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addKeyguardLockedStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 35: {
                    IKeyguardLockedStateListener _arg0 = IKeyguardLockedStateListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeKeyguardLockedStateListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 36: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setSwitchingUser(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 37: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.closeSystemDialogs(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 38: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    float _result = this.getAnimationScale(_arg0);
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 39: {
                    float[] _result = this.getAnimationScales();
                    reply.writeNoException();
                    reply.writeFloatArray(_result);
                    break;
                }
                case 40: {
                    int _arg0 = data.readInt();
                    float _arg1 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.setAnimationScale(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 41: {
                    float[] _arg0 = data.createFloatArray();
                    data.enforceNoDataAvail();
                    this.setAnimationScales(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 42: {
                    float _result = this.getCurrentAnimatorScale();
                    reply.writeNoException();
                    reply.writeFloat(_result);
                    break;
                }
                case 43: {
                    boolean _arg0 = data.readBoolean();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setInTouchMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 44: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setInTouchModeOnAllDisplays(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 45: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isInTouchMode(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 46: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.showStrictModeViolation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 47: {
                    String _arg0 = data.readString();
                    data.enforceNoDataAvail();
                    this.setStrictModeVisualIndicatorPreference(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 48: {
                    this.refreshScreenCaptureDisabled();
                    reply.writeNoException();
                    break;
                }
                case 49: {
                    int _result = this.getDefaultDisplayRotation();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 50: {
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.watchRotation(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 51: {
                    IRotationWatcher _arg0 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeRotationWatcher(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 52: {
                    IBinder _arg0 = data.readStrongBinder();
                    IRotationWatcher _arg1 = IRotationWatcher.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int _result = this.registerProposedRotationListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 53: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getPreferredOptionsPanelGravity(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 54: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.freezeRotation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 55: {
                    this.thawRotation();
                    reply.writeNoException();
                    break;
                }
                case 56: {
                    boolean _result = this.isRotationFrozen();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 57: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.freezeDisplayRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 58: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.thawDisplayRotation(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 59: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isDisplayRotationFrozen(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 60: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setFixedToUserRotation(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 61: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIgnoreOrientationRequest(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 62: {
                    Bitmap _result = this.screenshotWallpaper();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 63: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    SurfaceControl _result = this.mirrorWallpaperSurface(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 64: {
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.registerWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 65: {
                    IWallpaperVisibilityListener _arg0 = IWallpaperVisibilityListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterWallpaperVisibilityListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 66: {
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.registerSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 67: {
                    ISystemGestureExclusionListener _arg0 = ISystemGestureExclusionListener.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.unregisterSystemGestureExclusionListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 68: {
                    IAssistDataReceiver _arg0 = IAssistDataReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.requestAssistScreenshot(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 69: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.hideTransientBars(_arg0);
                    break;
                }
                case 70: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecentsVisibility(_arg0);
                    break;
                }
                case 71: {
                    int _arg0 = data.readInt();
                    Rect[] _arg1 = data.createTypedArray(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.updateStaticPrivacyIndicatorBounds(_arg0, _arg1);
                    break;
                }
                case 72: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setNavBarVirtualKeyHapticFeedbackEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 73: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.hasNavigationBar(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 74: {
                    Bundle _arg0 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.lockNow(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 75: {
                    boolean _result = this.isSafeModeEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 76: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    boolean _result = this.clearWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 77: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    WindowContentFrameStats _result = this.getWindowContentFrameStats(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 78: {
                    int _result = this.getDockedStackSide();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 79: {
                    int _arg0 = data.readInt();
                    IPinnedTaskListener _arg1 = IPinnedTaskListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerPinnedTaskListener(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 80: {
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.requestAppKeyboardShortcuts(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 81: {
                    int _arg0 = data.readInt();
                    Rect _arg1 = new Rect();
                    data.enforceNoDataAvail();
                    this.getStableInsets(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 82: {
                    long _arg0 = data.readLong();
                    IShortcutService _arg1 = IShortcutService.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerShortcutKey(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 83: {
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    InputChannel _arg3 = new InputChannel();
                    data.enforceNoDataAvail();
                    this.createInputConsumer(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_arg3, 1);
                    break;
                }
                case 84: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.destroyInputConsumer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 85: {
                    Region _result = this.getCurrentImeTouchRegion();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 86: {
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 87: {
                    IDisplayFoldListener _arg0 = IDisplayFoldListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterDisplayFoldListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 88: {
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    int[] _result = this.registerDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    reply.writeIntArray(_result);
                    break;
                }
                case 89: {
                    IDisplayWindowListener _arg0 = IDisplayWindowListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterDisplayWindowListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 90: {
                    this.startWindowTrace();
                    reply.writeNoException();
                    break;
                }
                case 91: {
                    this.stopWindowTrace();
                    reply.writeNoException();
                    break;
                }
                case 92: {
                    this.saveWindowTraceToFile();
                    reply.writeNoException();
                    break;
                }
                case 93: {
                    boolean _result = this.isWindowTraceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 94: {
                    this.startTransitionTrace();
                    reply.writeNoException();
                    break;
                }
                case 95: {
                    this.stopTransitionTrace();
                    reply.writeNoException();
                    break;
                }
                case 96: {
                    boolean _result = this.isTransitionTraceEnabled();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 97: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getWindowingMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 98: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setWindowingMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 99: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getRemoveContentMode(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 100: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setRemoveContentMode(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 101: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldShowWithInsecureKeyguard(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 102: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldShowWithInsecureKeyguard(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 103: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.shouldShowSystemDecors(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 104: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setShouldShowSystemDecors(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 105: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    int _result = this.getDisplayImePolicy(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 106: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setDisplayImePolicy(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 107: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.syncInputTransactions(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 108: {
                    boolean _result = this.isLayerTracing();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 109: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setLayerTracing(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 110: {
                    int _arg0 = data.readInt();
                    SurfaceControl _arg1 = new SurfaceControl();
                    data.enforceNoDataAvail();
                    boolean _result = this.mirrorDisplay(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg1, 1);
                    break;
                }
                case 111: {
                    int _arg0 = data.readInt();
                    IDisplayWindowInsetsController _arg1 = IDisplayWindowInsetsController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setDisplayWindowInsetsController(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 112: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateDisplayWindowRequestedVisibleTypes(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 113: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    InsetsState _arg2 = new InsetsState();
                    data.enforceNoDataAvail();
                    boolean _result = this.getWindowInsets(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg2, 1);
                    break;
                }
                case 114: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<DisplayInfo> _result = this.getPossibleDisplayInfo(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                case 115: {
                    this.showGlobalActions();
                    reply.writeNoException();
                    break;
                }
                case 116: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setLayerTracingFlags(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 117: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setActiveTransactionTracing(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 118: {
                    int _arg0 = data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    int _arg2 = data.readInt();
                    IScrollCaptureResponseListener _arg3 = IScrollCaptureResponseListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.requestScrollCapture(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 119: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.holdLock(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 120: {
                    String[] _result = this.getSupportedDisplayHashAlgorithms();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    break;
                }
                case 121: {
                    DisplayHash _arg0 = data.readTypedObject(DisplayHash.CREATOR);
                    data.enforceNoDataAvail();
                    VerifiedDisplayHash _result = this.verifyDisplayHash(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 122: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDisplayHashThrottlingEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 123: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    Bundle _arg3 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    Configuration _result = this.attachWindowContextToDisplayArea(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 124: {
                    IBinder _arg0 = data.readStrongBinder();
                    IBinder _arg1 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.attachWindowContextToWindowToken(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 125: {
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    Configuration _result = this.attachToDisplayContent(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 126: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.detachWindowContextFromWindowContainer(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 127: {
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    boolean _result = this.registerCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 128: {
                    ICrossWindowBlurEnabledListener _arg0 = ICrossWindowBlurEnabledListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterCrossWindowBlurEnabledListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 129: {
                    boolean _result = this.isTaskSnapshotSupported();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 130: {
                    int _result = this.getImeDisplayId();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 131: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setTaskSnapshotEnabled(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 132: {
                    TaskTransitionSpec _arg0 = data.readTypedObject(TaskTransitionSpec.CREATOR);
                    data.enforceNoDataAvail();
                    this.setTaskTransitionSpec(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 133: {
                    this.clearTaskTransitionSpec();
                    reply.writeNoException();
                    break;
                }
                case 134: {
                    int _arg0 = data.readInt();
                    ITaskFpsCallback _arg1 = ITaskFpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerTaskFpsCallback(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 135: {
                    ITaskFpsCallback _arg0 = ITaskFpsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.unregisterTaskFpsCallback(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 136: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    Bitmap _result = this.snapshotTaskForRecents(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 137: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setRecentsAppBehindSystemBars(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 138: {
                    int _result = this.getLetterboxBackgroundColorInArgb();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 139: {
                    boolean _result = this.isLetterboxBackgroundMultiColored();
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 140: {
                    int _arg0 = data.readInt();
                    ScreenCapture.CaptureArgs _arg1 = data.readTypedObject(ScreenCapture.CaptureArgs.CREATOR);
                    ScreenCapture.ScreenCaptureListener _arg2 = data.readTypedObject(ScreenCapture.ScreenCaptureListener.CREATOR);
                    data.enforceNoDataAvail();
                    this.captureDisplay(_arg0, _arg1, _arg2);
                    break;
                }
                case 141: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    boolean _result = this.isGlobalKey(_arg0);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    break;
                }
                case 142: {
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _arg1 = data.readBoolean();
                    ISurfaceSyncGroupCompletedListener _arg2 = ISurfaceSyncGroupCompletedListener.Stub.asInterface(data.readStrongBinder());
                    AddToSurfaceSyncGroupResult _arg3 = new AddToSurfaceSyncGroupResult();
                    data.enforceNoDataAvail();
                    boolean _result = this.addToSurfaceSyncGroup(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeBoolean(_result);
                    reply.writeTypedObject(_arg3, 1);
                    break;
                }
                case 143: {
                    IBinder _arg0 = data.readStrongBinder();
                    data.enforceNoDataAvail();
                    this.markSurfaceSyncGroupReady(_arg0);
                    break;
                }
                case 144: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    List<ComponentName> _result = this.notifyScreenshotListeners(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result, 1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 143;
        }

        private static class Proxy
        implements IWindowManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startViewServer(int port) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(port);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopViewServer() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isViewServerRunning() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
                IWindowSession _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = IWindowSession.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean useBLAST() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        size.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(width);
                    _data.writeInt(height);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplaySize(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInitialDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getBaseDisplayDensity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayIdByUniqueId(String uniqueId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(uniqueId);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(density);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEventDispatching(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowToken(IBinder binder) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayChangeWindowController(IDisplayChangeWindowController controller) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(controller);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(client);
                    _data.writeInt(shellRootLayer);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(shellRootLayer);
                    _data.writeStrongInterface(target);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(specsFuture);
                    _data.writeStrongInterface(startedCallback);
                    _data.writeBoolean(scaleUp);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(remoteAnimationAdapter, 0);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void endProlongedAnimations() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startFreezingScreen(int exitAnim, int enterAnim) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(exitAnim);
                    _data.writeInt(enterAnim);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopFreezingScreen() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(tag);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardLocked() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isKeyguardSecure(int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    if (message != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(message, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setSwitchingUser(boolean switching) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(switching);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void closeSystemDialogs(String reason) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(reason);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getAnimationScale(int which) throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float[] getAnimationScales() throws RemoteException {
                float[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createFloatArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScale(int which, float scale) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(which);
                    _data.writeFloat(scale);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAnimationScales(float[] scales) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeFloatArray(scales);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public float getCurrentAnimatorScale() throws RemoteException {
                float _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readFloat();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchMode(boolean inTouch, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inTouch);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setInTouchModeOnAllDisplays(boolean inTouch) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(inTouch);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isInTouchMode(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showStrictModeViolation(boolean on) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(on);
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(enabled);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshScreenCaptureDisabled() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDefaultDisplayRotation() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(watcher);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(watcher);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int registerProposedRotationListener(IBinder contextToken, IRotationWatcher listener) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(contextToken);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeRotation(int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawRotation() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isRotationFrozen() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void freezeDisplayRotation(int displayId, int rotation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(rotation);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void thawDisplayRotation(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(fixedToUserRotation);
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(ignoreOrientationRequest);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap screenshotWallpaper() throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bitmap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SurfaceControl mirrorWallpaperSurface(int displayId) throws RemoteException {
                SurfaceControl _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(SurfaceControl.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void hideTransientBars(int displayId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean bl = this.mRemote.transact(69, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsVisibility(boolean visible) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(visible);
                    boolean bl = this.mRemote.transact(70, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedArray(staticBounds, 0);
                    boolean bl = this.mRemote.transact(71, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNavigationBar(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void lockNow(Bundle options) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isSafeModeEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
                WindowContentFrameStats _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(WindowContentFrameStats.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDockedStackSide() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(receiver);
                    _data.writeInt(deviceId);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        outInsets.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(shortcutCode);
                    _data.writeStrongInterface(keySubscriber);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        inputChannel.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean destroyInputConsumer(String name, int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Region getCurrentImeTouchRegion() throws RemoteException {
                Region _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Region.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int[] registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                int[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createIntArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWindowTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void saveWindowTraceToFile() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWindowTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startTransitionTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopTransitionTrace() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTransitionTraceEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWindowingMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWindowingMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRemoveContentMode(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(shouldShow);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeBoolean(shouldShow);
                    boolean _status = this.mRemote.transact(104, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getDisplayImePolicy(int displayId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(105, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(imePolicy);
                    boolean _status = this.mRemote.transact(106, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(waitForAnimations);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLayerTracing() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracing(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        outSurfaceControl.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongInterface(displayWindowInsetsController);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDisplayWindowRequestedVisibleTypes(int displayId, int requestedVisibleTypes) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeInt(requestedVisibleTypes);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean getWindowInsets(int displayId, IBinder token, InsetsState outInsetsState) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        outInsetsState.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<DisplayInfo> getPossibleDisplayInfo(int displayId) throws RemoteException {
                ArrayList<DisplayInfo> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(DisplayInfo.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void showGlobalActions() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setLayerTracingFlags(int flags) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(flags);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setActiveTransactionTracing(boolean active) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(active);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeStrongBinder(behindClient);
                    _data.writeInt(taskId);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void holdLock(IBinder token, int durationMs) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(token);
                    _data.writeInt(durationMs);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
                VerifiedDisplayHash _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(displayHash, 0);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(VerifiedDisplayHash.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enable);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Configuration attachWindowContextToDisplayArea(IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
                Configuration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(type);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(options, 0);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Configuration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void attachWindowContextToWindowToken(IBinder clientToken, IBinder token) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeStrongBinder(token);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Configuration attachToDisplayContent(IBinder clientToken, int displayId) throws RemoteException {
                Configuration _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Configuration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void detachWindowContextFromWindowContainer(IBinder clientToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(clientToken);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(128, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isTaskSnapshotSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getImeDisplayId() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskSnapshotEnabled(boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(enabled);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTaskTransitionSpec(TaskTransitionSpec spec) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(spec, 0);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearTaskTransitionSpec() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTaskFpsCallback(int taskId, ITaskFpsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTaskFpsCallback(ITaskFpsCallback listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(135, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Bitmap snapshotTaskForRecents(int taskId) throws RemoteException {
                Bitmap _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(taskId);
                    boolean _status = this.mRemote.transact(136, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Bitmap.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecentsAppBehindSystemBars(boolean behindSystemBars) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeBoolean(behindSystemBars);
                    boolean _status = this.mRemote.transact(137, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getLetterboxBackgroundColorInArgb() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(138, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isLetterboxBackgroundMultiColored() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(139, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void captureDisplay(int displayId, ScreenCapture.CaptureArgs captureArgs, ScreenCapture.ScreenCaptureListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    _data.writeTypedObject(captureArgs, 0);
                    _data.writeTypedObject(listener, 0);
                    boolean bl = this.mRemote.transact(140, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isGlobalKey(int keyCode) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(keyCode);
                    boolean _status = this.mRemote.transact(141, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addToSurfaceSyncGroup(IBinder syncGroupToken, boolean parentSyncGroupMerge, ISurfaceSyncGroupCompletedListener completedListener, AddToSurfaceSyncGroupResult addToSurfaceSyncGroupResult) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(syncGroupToken);
                    _data.writeBoolean(parentSyncGroupMerge);
                    _data.writeStrongInterface(completedListener);
                    boolean _status = this.mRemote.transact(142, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readBoolean();
                    if (0 != _reply.readInt()) {
                        addToSurfaceSyncGroupResult.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void markSurfaceSyncGroupReady(IBinder syncGroupToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(syncGroupToken);
                    boolean bl = this.mRemote.transact(143, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ComponentName> notifyScreenshotListeners(int displayId) throws RemoteException {
                ArrayList<ComponentName> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(displayId);
                    boolean _status = this.mRemote.transact(144, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ComponentName.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWindowManager {
        @Override
        public boolean startViewServer(int port) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopViewServer() throws RemoteException {
            return false;
        }

        @Override
        public boolean isViewServerRunning() throws RemoteException {
            return false;
        }

        @Override
        public IWindowSession openSession(IWindowSessionCallback callback) throws RemoteException {
            return null;
        }

        @Override
        public boolean useBLAST() throws RemoteException {
            return false;
        }

        @Override
        public void getInitialDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void getBaseDisplaySize(int displayId, Point size) throws RemoteException {
        }

        @Override
        public void setForcedDisplaySize(int displayId, int width, int height) throws RemoteException {
        }

        @Override
        public void clearForcedDisplaySize(int displayId) throws RemoteException {
        }

        @Override
        public int getInitialDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int getBaseDisplayDensity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public int getDisplayIdByUniqueId(String uniqueId) throws RemoteException {
            return 0;
        }

        @Override
        public void setForcedDisplayDensityForUser(int displayId, int density, int userId) throws RemoteException {
        }

        @Override
        public void clearForcedDisplayDensityForUser(int displayId, int userId) throws RemoteException {
        }

        @Override
        public void setForcedDisplayScalingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public void setEventDispatching(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isWindowToken(IBinder binder) throws RemoteException {
            return false;
        }

        @Override
        public void addWindowToken(IBinder token, int type, int displayId, Bundle options) throws RemoteException {
        }

        @Override
        public void removeWindowToken(IBinder token, int displayId) throws RemoteException {
        }

        @Override
        public void setDisplayChangeWindowController(IDisplayChangeWindowController controller) throws RemoteException {
        }

        @Override
        public SurfaceControl addShellRoot(int displayId, IWindow client, int shellRootLayer) throws RemoteException {
            return null;
        }

        @Override
        public void setShellRootAccessibilityWindow(int displayId, int shellRootLayer, IWindow target) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionMultiThumbFuture(IAppTransitionAnimationSpecsFuture specsFuture, IRemoteCallback startedCallback, boolean scaleUp, int displayId) throws RemoteException {
        }

        @Override
        public void overridePendingAppTransitionRemote(RemoteAnimationAdapter remoteAnimationAdapter, int displayId) throws RemoteException {
        }

        @Override
        public void endProlongedAnimations() throws RemoteException {
        }

        @Override
        public void startFreezingScreen(int exitAnim, int enterAnim) throws RemoteException {
        }

        @Override
        public void stopFreezingScreen() throws RemoteException {
        }

        @Override
        public void disableKeyguard(IBinder token, String tag, int userId) throws RemoteException {
        }

        @Override
        public void reenableKeyguard(IBinder token, int userId) throws RemoteException {
        }

        @Override
        public void exitKeyguardSecurely(IOnKeyguardExitResult callback) throws RemoteException {
        }

        @Override
        public boolean isKeyguardLocked() throws RemoteException {
            return false;
        }

        @Override
        public boolean isKeyguardSecure(int userId) throws RemoteException {
            return false;
        }

        @Override
        public void dismissKeyguard(IKeyguardDismissCallback callback, CharSequence message) throws RemoteException {
        }

        @Override
        public void addKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
        }

        @Override
        public void removeKeyguardLockedStateListener(IKeyguardLockedStateListener listener) throws RemoteException {
        }

        @Override
        public void setSwitchingUser(boolean switching) throws RemoteException {
        }

        @Override
        public void closeSystemDialogs(String reason) throws RemoteException {
        }

        @Override
        public float getAnimationScale(int which) throws RemoteException {
            return 0.0f;
        }

        @Override
        public float[] getAnimationScales() throws RemoteException {
            return null;
        }

        @Override
        public void setAnimationScale(int which, float scale) throws RemoteException {
        }

        @Override
        public void setAnimationScales(float[] scales) throws RemoteException {
        }

        @Override
        public float getCurrentAnimatorScale() throws RemoteException {
            return 0.0f;
        }

        @Override
        public void setInTouchMode(boolean inTouch, int displayId) throws RemoteException {
        }

        @Override
        public void setInTouchModeOnAllDisplays(boolean inTouch) throws RemoteException {
        }

        @Override
        public boolean isInTouchMode(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void showStrictModeViolation(boolean on) throws RemoteException {
        }

        @Override
        public void setStrictModeVisualIndicatorPreference(String enabled) throws RemoteException {
        }

        @Override
        public void refreshScreenCaptureDisabled() throws RemoteException {
        }

        @Override
        public int getDefaultDisplayRotation() throws RemoteException {
            return 0;
        }

        @Override
        public int watchRotation(IRotationWatcher watcher, int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void removeRotationWatcher(IRotationWatcher watcher) throws RemoteException {
        }

        @Override
        public int registerProposedRotationListener(IBinder contextToken, IRotationWatcher listener) throws RemoteException {
            return 0;
        }

        @Override
        public int getPreferredOptionsPanelGravity(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void freezeRotation(int rotation) throws RemoteException {
        }

        @Override
        public void thawRotation() throws RemoteException {
        }

        @Override
        public boolean isRotationFrozen() throws RemoteException {
            return false;
        }

        @Override
        public void freezeDisplayRotation(int displayId, int rotation) throws RemoteException {
        }

        @Override
        public void thawDisplayRotation(int displayId) throws RemoteException {
        }

        @Override
        public boolean isDisplayRotationFrozen(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setFixedToUserRotation(int displayId, int fixedToUserRotation) throws RemoteException {
        }

        @Override
        public void setIgnoreOrientationRequest(int displayId, boolean ignoreOrientationRequest) throws RemoteException {
        }

        @Override
        public Bitmap screenshotWallpaper() throws RemoteException {
            return null;
        }

        @Override
        public SurfaceControl mirrorWallpaperSurface(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public boolean registerWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterWallpaperVisibilityListener(IWallpaperVisibilityListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void registerSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public void unregisterSystemGestureExclusionListener(ISystemGestureExclusionListener listener, int displayId) throws RemoteException {
        }

        @Override
        public boolean requestAssistScreenshot(IAssistDataReceiver receiver) throws RemoteException {
            return false;
        }

        @Override
        public void hideTransientBars(int displayId) throws RemoteException {
        }

        @Override
        public void setRecentsVisibility(boolean visible) throws RemoteException {
        }

        @Override
        public void updateStaticPrivacyIndicatorBounds(int displayId, Rect[] staticBounds) throws RemoteException {
        }

        @Override
        public void setNavBarVirtualKeyHapticFeedbackEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean hasNavigationBar(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void lockNow(Bundle options) throws RemoteException {
        }

        @Override
        public boolean isSafeModeEnabled() throws RemoteException {
            return false;
        }

        @Override
        public boolean clearWindowContentFrameStats(IBinder token) throws RemoteException {
            return false;
        }

        @Override
        public WindowContentFrameStats getWindowContentFrameStats(IBinder token) throws RemoteException {
            return null;
        }

        @Override
        public int getDockedStackSide() throws RemoteException {
            return 0;
        }

        @Override
        public void registerPinnedTaskListener(int displayId, IPinnedTaskListener listener) throws RemoteException {
        }

        @Override
        public void requestAppKeyboardShortcuts(IResultReceiver receiver, int deviceId) throws RemoteException {
        }

        @Override
        public void getStableInsets(int displayId, Rect outInsets) throws RemoteException {
        }

        @Override
        public void registerShortcutKey(long shortcutCode, IShortcutService keySubscriber) throws RemoteException {
        }

        @Override
        public void createInputConsumer(IBinder token, String name, int displayId, InputChannel inputChannel) throws RemoteException {
        }

        @Override
        public boolean destroyInputConsumer(String name, int displayId) throws RemoteException {
            return false;
        }

        @Override
        public Region getCurrentImeTouchRegion() throws RemoteException {
            return null;
        }

        @Override
        public void registerDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public void unregisterDisplayFoldListener(IDisplayFoldListener listener) throws RemoteException {
        }

        @Override
        public int[] registerDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
            return null;
        }

        @Override
        public void unregisterDisplayWindowListener(IDisplayWindowListener listener) throws RemoteException {
        }

        @Override
        public void startWindowTrace() throws RemoteException {
        }

        @Override
        public void stopWindowTrace() throws RemoteException {
        }

        @Override
        public void saveWindowTraceToFile() throws RemoteException {
        }

        @Override
        public boolean isWindowTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void startTransitionTrace() throws RemoteException {
        }

        @Override
        public void stopTransitionTrace() throws RemoteException {
        }

        @Override
        public boolean isTransitionTraceEnabled() throws RemoteException {
            return false;
        }

        @Override
        public int getWindowingMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setWindowingMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public int getRemoveContentMode(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setRemoveContentMode(int displayId, int mode) throws RemoteException {
        }

        @Override
        public boolean shouldShowWithInsecureKeyguard(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowWithInsecureKeyguard(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public boolean shouldShowSystemDecors(int displayId) throws RemoteException {
            return false;
        }

        @Override
        public void setShouldShowSystemDecors(int displayId, boolean shouldShow) throws RemoteException {
        }

        @Override
        public int getDisplayImePolicy(int displayId) throws RemoteException {
            return 0;
        }

        @Override
        public void setDisplayImePolicy(int displayId, int imePolicy) throws RemoteException {
        }

        @Override
        public void syncInputTransactions(boolean waitForAnimations) throws RemoteException {
        }

        @Override
        public boolean isLayerTracing() throws RemoteException {
            return false;
        }

        @Override
        public void setLayerTracing(boolean enabled) throws RemoteException {
        }

        @Override
        public boolean mirrorDisplay(int displayId, SurfaceControl outSurfaceControl) throws RemoteException {
            return false;
        }

        @Override
        public void setDisplayWindowInsetsController(int displayId, IDisplayWindowInsetsController displayWindowInsetsController) throws RemoteException {
        }

        @Override
        public void updateDisplayWindowRequestedVisibleTypes(int displayId, int requestedVisibleTypes) throws RemoteException {
        }

        @Override
        public boolean getWindowInsets(int displayId, IBinder token, InsetsState outInsetsState) throws RemoteException {
            return false;
        }

        @Override
        public List<DisplayInfo> getPossibleDisplayInfo(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void showGlobalActions() throws RemoteException {
        }

        @Override
        public void setLayerTracingFlags(int flags) throws RemoteException {
        }

        @Override
        public void setActiveTransactionTracing(boolean active) throws RemoteException {
        }

        @Override
        public void requestScrollCapture(int displayId, IBinder behindClient, int taskId, IScrollCaptureResponseListener listener) throws RemoteException {
        }

        @Override
        public void holdLock(IBinder token, int durationMs) throws RemoteException {
        }

        @Override
        public String[] getSupportedDisplayHashAlgorithms() throws RemoteException {
            return null;
        }

        @Override
        public VerifiedDisplayHash verifyDisplayHash(DisplayHash displayHash) throws RemoteException {
            return null;
        }

        @Override
        public void setDisplayHashThrottlingEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public Configuration attachWindowContextToDisplayArea(IBinder clientToken, int type, int displayId, Bundle options) throws RemoteException {
            return null;
        }

        @Override
        public void attachWindowContextToWindowToken(IBinder clientToken, IBinder token) throws RemoteException {
        }

        @Override
        public Configuration attachToDisplayContent(IBinder clientToken, int displayId) throws RemoteException {
            return null;
        }

        @Override
        public void detachWindowContextFromWindowContainer(IBinder clientToken) throws RemoteException {
        }

        @Override
        public boolean registerCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
            return false;
        }

        @Override
        public void unregisterCrossWindowBlurEnabledListener(ICrossWindowBlurEnabledListener listener) throws RemoteException {
        }

        @Override
        public boolean isTaskSnapshotSupported() throws RemoteException {
            return false;
        }

        @Override
        public int getImeDisplayId() throws RemoteException {
            return 0;
        }

        @Override
        public void setTaskSnapshotEnabled(boolean enabled) throws RemoteException {
        }

        @Override
        public void setTaskTransitionSpec(TaskTransitionSpec spec) throws RemoteException {
        }

        @Override
        public void clearTaskTransitionSpec() throws RemoteException {
        }

        @Override
        public void registerTaskFpsCallback(int taskId, ITaskFpsCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterTaskFpsCallback(ITaskFpsCallback listener) throws RemoteException {
        }

        @Override
        public Bitmap snapshotTaskForRecents(int taskId) throws RemoteException {
            return null;
        }

        @Override
        public void setRecentsAppBehindSystemBars(boolean behindSystemBars) throws RemoteException {
        }

        @Override
        public int getLetterboxBackgroundColorInArgb() throws RemoteException {
            return 0;
        }

        @Override
        public boolean isLetterboxBackgroundMultiColored() throws RemoteException {
            return false;
        }

        @Override
        public void captureDisplay(int displayId, ScreenCapture.CaptureArgs captureArgs, ScreenCapture.ScreenCaptureListener listener) throws RemoteException {
        }

        @Override
        public boolean isGlobalKey(int keyCode) throws RemoteException {
            return false;
        }

        @Override
        public boolean addToSurfaceSyncGroup(IBinder syncGroupToken, boolean parentSyncGroupMerge, ISurfaceSyncGroupCompletedListener completedListener, AddToSurfaceSyncGroupResult addToSurfaceSyncGroupResult) throws RemoteException {
            return false;
        }

        @Override
        public void markSurfaceSyncGroupReady(IBinder syncGroupToken) throws RemoteException {
        }

        @Override
        public List<ComponentName> notifyScreenshotListeners(int displayId) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

