/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.util.proto.ProtoOutputStream;
import android.view.InputEvent;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;

public class ImeFocusController {
    private static final boolean DEBUG = false;
    private static final String TAG = "ImeFocusController";
    private final ViewRootImpl mViewRootImpl;
    private boolean mHasImeFocus = false;
    private InputMethodManagerDelegate mDelegate;

    ImeFocusController(ViewRootImpl viewRootImpl) {
        this.mViewRootImpl = viewRootImpl;
    }

    private InputMethodManagerDelegate getImmDelegate() {
        if (this.mDelegate == null) {
            this.mDelegate = this.mViewRootImpl.mContext.getSystemService(InputMethodManager.class).getDelegate();
        }
        return this.mDelegate;
    }

    void onMovedToDisplay() {
        this.mDelegate = null;
    }

    void onTraversal(boolean hasWindowFocus, WindowManager.LayoutParams windowAttribute) {
        boolean hasImeFocus = WindowManager.LayoutParams.mayUseInputMethod(windowAttribute.flags);
        if (!hasWindowFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            return;
        }
        if (hasImeFocus == this.mHasImeFocus) {
            return;
        }
        this.mHasImeFocus = hasImeFocus;
        if (this.mHasImeFocus) {
            this.getImmDelegate().onPreWindowGainedFocus(this.mViewRootImpl);
            View focusedView = this.mViewRootImpl.mView.findFocus();
            View viewForWindowFocus = focusedView != null ? focusedView : this.mViewRootImpl.mView;
            this.getImmDelegate().onPostWindowGainedFocus(viewForWindowFocus, windowAttribute);
        }
    }

    void onPreWindowFocus(boolean hasWindowFocus, WindowManager.LayoutParams windowAttribute) {
        this.mHasImeFocus = WindowManager.LayoutParams.mayUseInputMethod(windowAttribute.flags);
        if (!hasWindowFocus || !this.mHasImeFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            if (!hasWindowFocus) {
                this.getImmDelegate().onWindowLostFocus(this.mViewRootImpl);
            }
        } else {
            this.getImmDelegate().onPreWindowGainedFocus(this.mViewRootImpl);
        }
    }

    void onPostWindowFocus(View focusedView, boolean hasWindowFocus, WindowManager.LayoutParams windowAttribute) {
        if (!hasWindowFocus || !this.mHasImeFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            return;
        }
        View viewForWindowFocus = focusedView != null ? focusedView : this.mViewRootImpl.mView;
        this.getImmDelegate().onPostWindowGainedFocus(viewForWindowFocus, windowAttribute);
    }

    void onScheduledCheckFocus() {
        this.getImmDelegate().onScheduledCheckFocus(this.mViewRootImpl);
    }

    void onViewFocusChanged(View view, boolean hasFocus) {
        this.getImmDelegate().onViewFocusChanged(view, hasFocus);
    }

    void onViewDetachedFromWindow(View view) {
        this.getImmDelegate().onViewDetachedFromWindow(view, this.mViewRootImpl);
    }

    void onWindowDismissed() {
        this.getImmDelegate().onWindowDismissed(this.mViewRootImpl);
        this.mHasImeFocus = false;
    }

    private static boolean isInLocalFocusMode(WindowManager.LayoutParams windowAttribute) {
        return (windowAttribute.flags & 0x10000000) != 0;
    }

    int onProcessImeInputStage(Object token, InputEvent event, WindowManager.LayoutParams windowAttribute, InputMethodManager.FinishedInputEventCallback callback) {
        if (!this.mHasImeFocus || ImeFocusController.isInLocalFocusMode(windowAttribute)) {
            return 0;
        }
        InputMethodManager imm = this.mViewRootImpl.mContext.getSystemService(InputMethodManager.class);
        if (imm == null) {
            return 0;
        }
        return imm.dispatchInputEvent(event, token, callback, this.mViewRootImpl.mHandler);
    }

    boolean hasImeFocus() {
        return this.mHasImeFocus;
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10800000001L, this.mHasImeFocus);
        proto.end(token);
    }

    public static interface InputMethodManagerDelegate {
        public void onPreWindowGainedFocus(ViewRootImpl var1);

        public void onPostWindowGainedFocus(View var1, WindowManager.LayoutParams var2);

        public void onWindowLostFocus(ViewRootImpl var1);

        public void onViewFocusChanged(View var1, boolean var2);

        public void onScheduledCheckFocus(ViewRootImpl var1);

        public void onViewDetachedFromWindow(View var1, ViewRootImpl var2);

        public void onWindowDismissed(ViewRootImpl var1);
    }
}

