/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.os.IBinder;
import android.os.Process;
import android.os.Trace;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsController;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.WindowInsets;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.inputmethod.ImeTracing;
import java.util.function.Supplier;

public class ImeInsetsSourceConsumer
extends InsetsSourceConsumer {
    private boolean mHasPendingRequest;
    private boolean mIsRequestedVisibleAwaitingControl;

    public ImeInsetsSourceConsumer(int id2, InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        super(id2, WindowInsets.Type.ime(), state, transactionSupplier, controller);
    }

    @Override
    public boolean onAnimationStateChanged(boolean running) {
        if (!running) {
            ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#onAnimationFinished", this.mController.getHost().getInputMethodManager(), null);
        }
        boolean insetsChanged = super.onAnimationStateChanged(running);
        if (!this.isShowRequested()) {
            this.mIsRequestedVisibleAwaitingControl = false;
            if (!running && !this.mHasPendingRequest) {
                this.notifyHidden(null);
                this.removeSurface();
            }
        }
        this.mHasPendingRequest = false;
        return insetsChanged;
    }

    @Override
    public void onWindowFocusGained(boolean hasViewFocus) {
        super.onWindowFocusGained(hasViewFocus);
        this.getImm().registerImeConsumer(this);
        if ((this.mController.getRequestedVisibleTypes() & this.getType()) != 0 && this.getControl() == null) {
            this.mIsRequestedVisibleAwaitingControl = true;
        }
    }

    @Override
    public void onWindowFocusLost() {
        super.onWindowFocusLost();
        this.getImm().unregisterImeConsumer(this);
        this.mIsRequestedVisibleAwaitingControl = false;
    }

    @Override
    public boolean applyLocalVisibilityOverride() {
        ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#applyLocalVisibilityOverride", this.mController.getHost().getInputMethodManager(), null);
        return super.applyLocalVisibilityOverride();
    }

    @Override
    public int requestShow(boolean fromIme, ImeTracker.Token statsToken) {
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#requestShow", this.mController.getHost().getInputMethodManager(), null);
        }
        this.onShowRequested();
        ImeTracker.forLogging().onProgress(statsToken, 36);
        if (this.getControl() == null) {
            this.mIsRequestedVisibleAwaitingControl = true;
        }
        if (fromIme || this.mState.isSourceOrDefaultVisible(this.getId(), this.getType()) && this.getControl() != null) {
            return 0;
        }
        return this.getImm().requestImeShow(this.mController.getHost().getWindowToken(), statsToken) ? 1 : 2;
    }

    @Override
    void requestHide(boolean fromIme, ImeTracker.Token statsToken) {
        if (!fromIme) {
            this.notifyHidden(statsToken);
        }
        if (this.mAnimationState == 1) {
            this.mHasPendingRequest = true;
        }
    }

    private void notifyHidden(ImeTracker.Token statsToken) {
        if (statsToken == null || this.getControl() != null) {
            statsToken = ImeTracker.forLogging().onRequestHide(null, Process.myUid(), 2, 28);
        }
        ImeTracker.forLogging().onProgress(statsToken, 38);
        this.getImm().notifyImeHidden(this.mController.getHost().getWindowToken(), statsToken);
        this.mIsRequestedVisibleAwaitingControl = false;
        Trace.asyncTraceEnd(8L, "IC.hideRequestFromApi", 0);
    }

    @Override
    public void removeSurface() {
        IBinder window = this.mController.getHost().getWindowToken();
        if (window != null) {
            this.getImm().removeImeSurface(window);
        }
    }

    @Override
    public boolean setControl(InsetsSourceControl control, int[] showTypes, int[] hideTypes) {
        ImeTracing.getInstance().triggerClientDump("ImeInsetsSourceConsumer#setControl", this.mController.getHost().getInputMethodManager(), null);
        if (!super.setControl(control, showTypes, hideTypes)) {
            return false;
        }
        if (control == null && !this.mIsRequestedVisibleAwaitingControl) {
            this.mController.setRequestedVisibleTypes(0, this.getType());
            this.removeSurface();
        }
        if (control != null) {
            this.mIsRequestedVisibleAwaitingControl = false;
        }
        return true;
    }

    @Override
    protected boolean isRequestedVisibleAwaitingControl() {
        return super.isRequestedVisibleAwaitingControl() || this.mIsRequestedVisibleAwaitingControl;
    }

    @Override
    public void onPerceptible(boolean perceptible) {
        super.onPerceptible(perceptible);
        IBinder window = this.mController.getHost().getWindowToken();
        if (window != null) {
            this.getImm().reportPerceptible(window, perceptible);
        }
    }

    @Override
    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        super.dumpDebug(proto, 0x10B00000001L);
        proto.write(1133871366147L, this.mIsRequestedVisibleAwaitingControl);
        proto.write(1133871366150L, this.mHasPendingRequest);
        proto.end(token);
    }

    public void onShowRequested() {
        if (this.mAnimationState == 2) {
            this.mHasPendingRequest = true;
        }
    }

    private InputMethodManager getImm() {
        return this.mController.getHost().getInputMethodManager();
    }
}

