/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.view.IInputMonitorHost;
import android.view.InputChannel;
import android.view.SurfaceControl;
import com.android.internal.util.AnnotationValidations;

public class InputMonitor
implements Parcelable {
    private static final String TAG = "InputMonitor";
    private static final boolean DEBUG = false;
    private final InputChannel mInputChannel;
    private final IInputMonitorHost mHost;
    private final SurfaceControl mSurface;
    public static final Parcelable.Creator<InputMonitor> CREATOR = new Parcelable.Creator<InputMonitor>(){

        public InputMonitor[] newArray(int size) {
            return new InputMonitor[size];
        }

        @Override
        public InputMonitor createFromParcel(Parcel in) {
            return new InputMonitor(in);
        }
    };

    public void pilferPointers() {
        try {
            this.mHost.pilferPointers();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public void dispose() {
        this.mInputChannel.dispose();
        this.mSurface.release();
        try {
            this.mHost.dispose();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    public InputMonitor(InputChannel inputChannel, IInputMonitorHost host, SurfaceControl surface) {
        this.mInputChannel = inputChannel;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInputChannel);
        this.mHost = host;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHost);
        this.mSurface = surface;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSurface);
    }

    public InputChannel getInputChannel() {
        return this.mInputChannel;
    }

    public IInputMonitorHost getHost() {
        return this.mHost;
    }

    public SurfaceControl getSurface() {
        return this.mSurface;
    }

    public String toString() {
        return "InputMonitor { inputChannel = " + this.mInputChannel + ", host = " + this.mHost + ", surface = " + this.mSurface + " }";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeTypedObject(this.mInputChannel, flags);
        dest.writeStrongInterface(this.mHost);
        dest.writeTypedObject(this.mSurface, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    InputMonitor(Parcel in) {
        InputChannel inputChannel = in.readTypedObject(InputChannel.CREATOR);
        IInputMonitorHost host = IInputMonitorHost.Stub.asInterface(in.readStrongBinder());
        SurfaceControl surface = in.readTypedObject(SurfaceControl.CREATOR);
        this.mInputChannel = inputChannel;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInputChannel);
        this.mHost = host;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHost);
        this.mSurface = surface;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSurface);
    }

    @Deprecated
    private void __metadata() {
    }
}

