/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Matrix;
import android.graphics.Region;
import android.os.IBinder;
import android.view.IWindow;
import android.view.InputApplicationHandle;
import android.view.SurfaceControl;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public class InputWindowHandle {
    private long ptr;
    public InputApplicationHandle inputApplicationHandle;
    public IBinder token;
    private IBinder windowToken;
    private IWindow window;
    public String name;
    public int layoutParamsFlags;
    public int layoutParamsType;
    public long dispatchingTimeoutMillis;
    public int frameLeft;
    public int frameTop;
    public int frameRight;
    public int frameBottom;
    public int surfaceInset;
    public float scaleFactor;
    public final Region touchableRegion = new Region();
    public int inputConfig;
    public int touchOcclusionMode = 0;
    public int ownerPid;
    public int ownerUid;
    public String packageName;
    public int displayId;
    public WeakReference<SurfaceControl> touchableRegionSurfaceControl = new WeakReference<Object>(null);
    public boolean replaceTouchableRegionWithCrop;
    public Matrix transform;
    public IBinder focusTransferTarget;

    private void nativeDispose() {
        OverrideMethod.invokeV("android.view.InputWindowHandle#nativeDispose()V", true, this);
    }

    public InputWindowHandle(InputApplicationHandle inputApplicationHandle, int displayId) {
        this.inputApplicationHandle = inputApplicationHandle;
        this.displayId = displayId;
    }

    public InputWindowHandle(InputWindowHandle other) {
        this.ptr = 0L;
        this.inputApplicationHandle = new InputApplicationHandle(other.inputApplicationHandle);
        this.token = other.token;
        this.windowToken = other.windowToken;
        this.window = other.window;
        this.name = other.name;
        this.layoutParamsFlags = other.layoutParamsFlags;
        this.layoutParamsType = other.layoutParamsType;
        this.dispatchingTimeoutMillis = other.dispatchingTimeoutMillis;
        this.frameLeft = other.frameLeft;
        this.frameTop = other.frameTop;
        this.frameRight = other.frameRight;
        this.frameBottom = other.frameBottom;
        this.surfaceInset = other.surfaceInset;
        this.scaleFactor = other.scaleFactor;
        this.touchableRegion.set(other.touchableRegion);
        this.inputConfig = other.inputConfig;
        this.touchOcclusionMode = other.touchOcclusionMode;
        this.ownerPid = other.ownerPid;
        this.ownerUid = other.ownerUid;
        this.packageName = other.packageName;
        this.displayId = other.displayId;
        this.touchableRegionSurfaceControl = other.touchableRegionSurfaceControl;
        this.replaceTouchableRegionWithCrop = other.replaceTouchableRegionWithCrop;
        if (other.transform != null) {
            this.transform = new Matrix();
            this.transform.set(other.transform);
        }
        this.focusTransferTarget = other.focusTransferTarget;
    }

    public String toString() {
        return (this.name != null ? this.name : "") + ", frame=[" + this.frameLeft + "," + this.frameTop + "," + this.frameRight + "," + this.frameBottom + "]" + ", touchableRegion=" + this.touchableRegion + ", scaleFactor=" + this.scaleFactor + ", transform=" + this.transform + ", windowToken=" + this.windowToken + ", displayId=" + this.displayId + ", isClone=" + ((this.inputConfig & 0x10000) != 0);
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeDispose();
        }
        finally {
            super.finalize();
        }
    }

    public void replaceTouchableRegionWithCrop(SurfaceControl bounds) {
        this.setTouchableRegionCrop(bounds);
        this.replaceTouchableRegionWithCrop = true;
    }

    public void setTouchableRegionCrop(SurfaceControl bounds) {
        this.touchableRegionSurfaceControl = new WeakReference<SurfaceControl>(bounds);
    }

    public void setWindowToken(IWindow iwindow) {
        this.windowToken = iwindow.asBinder();
        this.window = iwindow;
    }

    public IBinder getWindowToken() {
        return this.windowToken;
    }

    public IWindow getWindow() {
        if (this.window != null) {
            return this.window;
        }
        this.window = IWindow.Stub.asInterface(this.windowToken);
        return this.window;
    }

    public void setInputConfig(int inputConfig, boolean value) {
        if (value) {
            this.inputConfig |= inputConfig;
            return;
        }
        this.inputConfig &= ~inputConfig;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InputConfigFlags {
    }
}

