/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.animation.AnimationHandler;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.ActivityThread;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.Trace;
import android.util.IntArray;
import android.util.Log;
import android.util.Pair;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import android.view.ImeInsetsSourceConsumer;
import android.view.InsetsAnimationControlCallbacks;
import android.view.InsetsAnimationControlImpl;
import android.view.InsetsAnimationControlRunner;
import android.view.InsetsAnimationThreadControlRunner;
import android.view.InsetsResizeAnimationRunner;
import android.view.InsetsSource;
import android.view.InsetsSourceConsumer;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InternalInsetsAnimationController;
import android.view.SurfaceControl;
import android.view.SyncRtSurfaceTransactionApplier;
import android.view.ViewRootImpl;
import android.view.WindowInsets;
import android.view.WindowInsetsAnimation;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import android.view.inputmethod.ImeTracker;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.graphics.SfVsyncFrameCallbackProvider;
import com.android.internal.inputmethod.ImeTracing;
import com.android.internal.util.function.TriFunction;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class InsetsController
implements WindowInsetsController,
InsetsAnimationControlCallbacks {
    private int mTypesBeingCancelled;
    private static final String TAG = "InsetsController";
    private static final int ANIMATION_DURATION_MOVE_IN_MS = 275;
    private static final int ANIMATION_DURATION_MOVE_OUT_MS = 340;
    private static final int ANIMATION_DURATION_FADE_IN_MS = 500;
    private static final int ANIMATION_DURATION_FADE_OUT_MS = 1500;
    public static final int ANIMATION_DURATION_RESIZE = 300;
    private static final int ANIMATION_DELAY_DIM_MS = 500;
    private static final int ANIMATION_DURATION_SYNC_IME_MS = 285;
    private static final int ANIMATION_DURATION_UNSYNC_IME_MS = 200;
    private static final int PENDING_CONTROL_TIMEOUT_MS = 2000;
    private static final Interpolator SYSTEM_BARS_INSETS_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    private static final Interpolator SYSTEM_BARS_ALPHA_INTERPOLATOR = new PathInterpolator(0.3f, 0.0f, 1.0f, 1.0f);
    private static final Interpolator SYSTEM_BARS_DIM_INTERPOLATOR = alphaFraction -> {
        float fraction2 = 1.0f - alphaFraction;
        float fractionDelay = 0.33333334f;
        if (fraction2 <= 0.33333334f) {
            return 1.0f;
        }
        float innerFraction = (fraction2 - 0.33333334f) / 0.6666666f;
        return 1.0f - SYSTEM_BARS_ALPHA_INTERPOLATOR.getInterpolation(innerFraction);
    };
    private static final Interpolator SYNC_IME_INTERPOLATOR = new PathInterpolator(0.2f, 0.0f, 0.0f, 1.0f);
    private static final Interpolator LINEAR_OUT_SLOW_IN_INTERPOLATOR = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    private static final Interpolator FAST_OUT_LINEAR_IN_INTERPOLATOR = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator RESIZE_INTERPOLATOR = new LinearInterpolator();
    private static final int FLOATING_IME_BOTTOM_INSET_DP = -80;
    private static final int ID_CAPTION_BAR = InsetsSource.createId(null, 0, WindowInsets.Type.captionBar());
    static final boolean DEBUG = false;
    static final boolean WARN = false;
    public static final int LAYOUT_INSETS_DURING_ANIMATION_SHOWN = 0;
    public static final int LAYOUT_INSETS_DURING_ANIMATION_HIDDEN = 1;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_NONE = -1;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_SHOW = 0;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_HIDE = 1;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_USER = 2;
    @VisibleForTesting
    public static final int ANIMATION_TYPE_RESIZE = 3;
    private static TypeEvaluator<Insets> sEvaluator = (fraction2, startValue, endValue) -> Insets.of((int)((float)startValue.left + fraction2 * (float)(endValue.left - startValue.left)), (int)((float)startValue.top + fraction2 * (float)(endValue.top - startValue.top)), (int)((float)startValue.right + fraction2 * (float)(endValue.right - startValue.right)), (int)((float)startValue.bottom + fraction2 * (float)(endValue.bottom - startValue.bottom)));
    private WindowInsetsAnimationControlListener mLoggingListener;
    private final ImeTracker.InputMethodJankContext mJankContext = new ImeTracker.InputMethodJankContext(){

        @Override
        public Context getDisplayContext() {
            return InsetsController.this.mHost != null ? InsetsController.this.mHost.getRootViewContext() : null;
        }

        @Override
        public SurfaceControl getTargetSurfaceControl() {
            InsetsSourceControl imeSourceControl = InsetsController.this.getImeSourceConsumer().getControl();
            return imeSourceControl != null ? imeSourceControl.getLeash() : null;
        }

        @Override
        public String getHostPackageName() {
            return InsetsController.this.mHost != null ? InsetsController.this.mHost.getRootViewContext().getPackageName() : null;
        }
    };
    private final InsetsState mState = new InsetsState();
    private final InsetsState mLastDispatchedState = new InsetsState();
    private final Rect mFrame = new Rect();
    private final TriFunction<InsetsController, Integer, Integer, InsetsSourceConsumer> mConsumerCreator;
    private final SparseArray<InsetsSourceConsumer> mSourceConsumers = new SparseArray();
    private final InsetsSourceConsumer mImeSourceConsumer;
    private final Host mHost;
    private final Handler mHandler;
    private final SparseArray<InsetsSourceControl> mTmpControlArray = new SparseArray();
    private final ArrayList<RunningAnimation> mRunningAnimations = new ArrayList();
    private WindowInsets mLastInsets;
    private boolean mAnimCallbackScheduled;
    private final Runnable mAnimCallback;
    private PendingControlRequest mPendingImeControlRequest;
    private int mWindowType;
    private int mLastLegacySoftInputMode;
    private int mLastLegacyWindowFlags;
    private int mLastLegacySystemUiFlags;
    private int mLastWindowingMode;
    private boolean mStartingAnimation;
    private int mCaptionInsetsHeight = 0;
    private boolean mAnimationsDisabled;
    private boolean mCompatSysUiVisibilityStaled;
    private final Runnable mPendingControlTimeout = this::abortPendingImeControlRequest;
    private final ArrayList<WindowInsetsController.OnControllableInsetsChangedListener> mControllableInsetsChangedListeners = new ArrayList();
    private int mLastStartedAnimTypes;
    private int mDisabledUserAnimationInsetsTypes;
    private int mExistingTypes = 0;
    private int mVisibleTypes = WindowInsets.Type.defaultVisible();
    private int mRequestedVisibleTypes = WindowInsets.Type.defaultVisible();
    private int mReportedRequestedVisibleTypes = WindowInsets.Type.defaultVisible();
    private int mControllableTypes;
    private final Runnable mInvokeControllableInsetsChangedListeners = this::invokeControllableInsetsChangedListeners;
    private final InsetsState.OnTraverseCallbacks mRemoveGoneSources = new InsetsState.OnTraverseCallbacks(){
        private final IntArray mPendingRemoveIndexes = new IntArray();

        @Override
        public void onIdNotFoundInState2(int index1, InsetsSource source1) {
            if (!ViewRootImpl.CAPTION_ON_SHELL && source1.getType() == WindowInsets.Type.captionBar()) {
                return;
            }
            this.mPendingRemoveIndexes.add(index1);
        }

        @Override
        public void onFinish(InsetsState state1, InsetsState state2) {
            for (int i = this.mPendingRemoveIndexes.size() - 1; i >= 0; --i) {
                state1.removeSourceAt(this.mPendingRemoveIndexes.get(i));
            }
            this.mPendingRemoveIndexes.clear();
        }
    };
    private final InsetsState.OnTraverseCallbacks mStartResizingAnimationIfNeeded = new InsetsState.OnTraverseCallbacks(){
        private int mTypes;
        private InsetsState mToState;

        @Override
        public void onStart(InsetsState state1, InsetsState state2) {
            this.mTypes = 0;
            this.mToState = null;
        }

        @Override
        public void onIdMatch(InsetsSource source1, InsetsSource source2) {
            int type = source1.getType();
            if ((type & WindowInsets.Type.systemBars()) == 0 || !source1.isVisible() || !source2.isVisible() || source1.getFrame().equals(source2.getFrame()) || !Rect.intersects(InsetsController.this.mFrame, source1.getFrame()) && !Rect.intersects(InsetsController.this.mFrame, source2.getFrame())) {
                return;
            }
            this.mTypes |= type;
            if (this.mToState == null) {
                this.mToState = new InsetsState();
            }
            this.mToState.addSource(new InsetsSource(source2));
        }

        @Override
        public void onFinish(InsetsState state1, InsetsState state2) {
            if (this.mTypes == 0) {
                return;
            }
            InsetsController.this.cancelExistingControllers(this.mTypes);
            InsetsResizeAnimationRunner runner = new InsetsResizeAnimationRunner(InsetsController.this.mFrame, state1, this.mToState, RESIZE_INTERPOLATOR, 300L, this.mTypes, InsetsController.this);
            InsetsController.this.mRunningAnimations.add(new RunningAnimation(runner, runner.getAnimationType()));
        }
    };

    public InsetsController(Host host) {
        this(host, (controller, id2, type) -> {
            if (type == WindowInsets.Type.ime()) {
                return new ImeInsetsSourceConsumer((int)id2, controller.mState, SurfaceControl.Transaction::new, (InsetsController)controller);
            }
            return new InsetsSourceConsumer((int)id2, (int)type, controller.mState, SurfaceControl.Transaction::new, (InsetsController)controller);
        }, host.getHandler());
    }

    @VisibleForTesting
    public InsetsController(Host host, TriFunction<InsetsController, Integer, Integer, InsetsSourceConsumer> consumerCreator, Handler handler) {
        this.mHost = host;
        this.mConsumerCreator = consumerCreator;
        this.mHandler = handler;
        this.mAnimCallback = () -> {
            this.mAnimCallbackScheduled = false;
            if (this.mRunningAnimations.isEmpty()) {
                return;
            }
            ArrayList<WindowInsetsAnimation> runningAnimations = new ArrayList<WindowInsetsAnimation>();
            ArrayList<WindowInsetsAnimation> finishedAnimations = new ArrayList<WindowInsetsAnimation>();
            InsetsState state = new InsetsState(this.mState, true);
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
                InsetsAnimationControlRunner runner = runningAnimation.runner;
                if (!(runner instanceof WindowInsetsAnimationController)) continue;
                if (runningAnimation.startDispatched) {
                    runningAnimations.add(runner.getAnimation());
                }
                if (!((InternalInsetsAnimationController)((Object)runner)).applyChangeInsets(state)) continue;
                finishedAnimations.add(runner.getAnimation());
            }
            WindowInsets insets = state.calculateInsets(this.mFrame, this.mState, this.mLastInsets.isRound(), this.mLastInsets.shouldAlwaysConsumeSystemBars(), this.mLastLegacySoftInputMode, this.mLastLegacyWindowFlags, this.mLastLegacySystemUiFlags, this.mWindowType, this.mLastWindowingMode, null);
            this.mHost.dispatchWindowInsetsAnimationProgress(insets, Collections.unmodifiableList(runningAnimations));
            for (int i = finishedAnimations.size() - 1; i >= 0; --i) {
                this.dispatchAnimationEnd((WindowInsetsAnimation)finishedAnimations.get(i));
            }
        };
        this.mImeSourceConsumer = this.getSourceConsumer(InsetsSource.ID_IME, WindowInsets.Type.ime());
    }

    @VisibleForTesting
    public void onFrameChanged(Rect frame) {
        if (this.mFrame.equals(frame)) {
            return;
        }
        this.mHost.notifyInsetsChanged();
        this.mFrame.set(frame);
    }

    @Override
    public InsetsState getState() {
        return this.mState;
    }

    @Override
    public int getRequestedVisibleTypes() {
        return this.mRequestedVisibleTypes;
    }

    public InsetsState getLastDispatchedState() {
        return this.mLastDispatchedState;
    }

    @VisibleForTesting
    public boolean onStateChanged(InsetsState state) {
        boolean stateChanged = false;
        if (!ViewRootImpl.CAPTION_ON_SHELL) {
            stateChanged = !this.mState.equals(state, true, false) || this.captionInsetsUnchanged();
        } else {
            boolean bl = stateChanged = !this.mState.equals(state, false, false);
        }
        if (!stateChanged && this.mLastDispatchedState.equals(state)) {
            return false;
        }
        this.mLastDispatchedState.set(state, true);
        InsetsState lastState = new InsetsState(this.mState, true);
        this.updateState(state);
        this.applyLocalVisibilityOverride();
        this.updateCompatSysUiVisibility();
        if (!this.mState.equals(lastState, false, true)) {
            this.mHost.notifyInsetsChanged();
            if (lastState.getDisplayFrame().equals(this.mState.getDisplayFrame())) {
                InsetsState.traverse(lastState, this.mState, this.mStartResizingAnimationIfNeeded);
            }
        }
        return true;
    }

    private void updateState(InsetsState newState) {
        this.mState.set(newState, 0);
        int existingTypes = 0;
        int visibleTypes = 0;
        int disabledUserAnimationTypes = 0;
        int[] cancelledUserAnimationTypes = new int[]{0};
        int size = newState.sourceSize();
        for (int i = 0; i < size; ++i) {
            InsetsSourceConsumer consumer;
            InsetsSource source = newState.sourceAt(i);
            int type = source.getType();
            int animationType = this.getAnimationType(type);
            if (!source.isUserControllable()) {
                disabledUserAnimationTypes |= type;
                if (animationType == 2) {
                    animationType = -1;
                    cancelledUserAnimationTypes[0] = cancelledUserAnimationTypes[0] | type;
                }
            }
            if ((consumer = this.mSourceConsumers.get(source.getId())) != null) {
                consumer.updateSource(source, animationType);
            } else {
                this.mState.addSource(source);
            }
            existingTypes |= type;
            if (!source.isVisible()) continue;
            visibleTypes |= type;
        }
        if (this.mVisibleTypes != (visibleTypes |= WindowInsets.Type.defaultVisible() & ~existingTypes)) {
            if (WindowInsets.Type.hasCompatSystemBars(this.mVisibleTypes ^ visibleTypes)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            this.mVisibleTypes = visibleTypes;
        }
        if (this.mExistingTypes != existingTypes) {
            if (WindowInsets.Type.hasCompatSystemBars(this.mExistingTypes ^ existingTypes)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            this.mExistingTypes = existingTypes;
        }
        InsetsState.traverse(this.mState, newState, this.mRemoveGoneSources);
        this.updateDisabledUserAnimationTypes(disabledUserAnimationTypes);
        if (cancelledUserAnimationTypes[0] != 0) {
            this.mHandler.post(() -> this.show(cancelledUserAnimationTypes[0]));
        }
    }

    private void updateDisabledUserAnimationTypes(int disabledUserAnimationTypes) {
        int diff = this.mDisabledUserAnimationInsetsTypes ^ disabledUserAnimationTypes;
        if (diff != 0) {
            for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
                InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
                if (consumer.getControl() == null || (consumer.getType() & diff) == 0) continue;
                this.mHandler.removeCallbacks(this.mInvokeControllableInsetsChangedListeners);
                this.mHandler.post(this.mInvokeControllableInsetsChangedListeners);
                break;
            }
            this.mDisabledUserAnimationInsetsTypes = disabledUserAnimationTypes;
        }
    }

    private boolean captionInsetsUnchanged() {
        if (ViewRootImpl.CAPTION_ON_SHELL) {
            return false;
        }
        InsetsSource source = this.mState.peekSource(ID_CAPTION_BAR);
        if (source == null && this.mCaptionInsetsHeight == 0) {
            return false;
        }
        return source == null || this.mCaptionInsetsHeight != source.getFrame().height();
    }

    @VisibleForTesting
    public WindowInsets calculateInsets(boolean isScreenRound, boolean alwaysConsumeSystemBars, int windowType, int windowingMode, int legacySoftInputMode, int legacyWindowFlags, int legacySystemUiFlags) {
        this.mWindowType = windowType;
        this.mLastWindowingMode = windowingMode;
        this.mLastLegacySoftInputMode = legacySoftInputMode;
        this.mLastLegacyWindowFlags = legacyWindowFlags;
        this.mLastLegacySystemUiFlags = legacySystemUiFlags;
        this.mLastInsets = this.mState.calculateInsets(this.mFrame, null, isScreenRound, alwaysConsumeSystemBars, legacySoftInputMode, legacyWindowFlags, legacySystemUiFlags, windowType, windowingMode, null);
        return this.mLastInsets;
    }

    public Insets calculateVisibleInsets(int windowType, int windowingMode, int softInputMode, int windowFlags) {
        return this.mState.calculateVisibleInsets(this.mFrame, windowType, windowingMode, softInputMode, windowFlags);
    }

    public void onControlsChanged(InsetsSourceControl[] activeControls) {
        int i;
        if (activeControls != null) {
            for (InsetsSourceControl activeControl : activeControls) {
                if (activeControl == null) continue;
                this.mTmpControlArray.put(activeControl.getId(), activeControl);
            }
        }
        int controllableTypes = 0;
        int consumedControlCount = 0;
        int[] showTypes = new int[1];
        int[] hideTypes = new int[1];
        for (i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            InsetsSourceControl control = this.mTmpControlArray.get(consumer.getId());
            if (control != null) {
                controllableTypes |= control.getType();
                ++consumedControlCount;
            }
            consumer.setControl(control, showTypes, hideTypes);
        }
        if (consumedControlCount != this.mTmpControlArray.size()) {
            for (i = this.mTmpControlArray.size() - 1; i >= 0; --i) {
                InsetsSourceControl control = this.mTmpControlArray.valueAt(i);
                this.getSourceConsumer(control.getId(), control.getType()).setControl(control, showTypes, hideTypes);
            }
        }
        if (this.mTmpControlArray.size() > 0) {
            for (i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                this.mRunningAnimations.get((int)i).runner.updateSurfacePosition(this.mTmpControlArray);
            }
        }
        this.mTmpControlArray.clear();
        int animatingTypes = this.invokeControllableInsetsChangedListeners();
        showTypes[0] = showTypes[0] & ~animatingTypes;
        hideTypes[0] = hideTypes[0] & ~animatingTypes;
        if (showTypes[0] != 0) {
            this.applyAnimation(showTypes[0], true, false, null);
        }
        if (hideTypes[0] != 0) {
            this.applyAnimation(hideTypes[0], false, false, null);
        }
        if (this.mControllableTypes != controllableTypes) {
            if (WindowInsets.Type.hasCompatSystemBars(this.mControllableTypes ^ controllableTypes)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            this.mControllableTypes = controllableTypes;
        }
        this.reportRequestedVisibleTypes();
    }

    @Override
    public void show(int types) {
        ImeTracker.Token statsToken = null;
        if ((types & WindowInsets.Type.ime()) != 0) {
            statsToken = ImeTracker.forLogging().onRequestShow(null, Process.myUid(), 1, 26);
        }
        this.show(types, false, statsToken);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void show(int types, boolean fromIme, ImeTracker.Token statsToken) {
        if ((types & WindowInsets.Type.ime()) != 0) {
            Log.d(TAG, "show(ime(), fromIme=" + fromIme + ")");
        }
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#show", this.mHost.getInputMethodManager(), null);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            Trace.asyncTraceBegin(8L, "IC.showRequestFromIme", 0);
        } else {
            Trace.asyncTraceBegin(8L, "IC.showRequestFromApi", 0);
            Trace.asyncTraceBegin(8L, "IC.showRequestFromApiToImeReady", 0);
        }
        if (fromIme && this.mPendingImeControlRequest != null) {
            if ((types & WindowInsets.Type.ime()) != 0) {
                ImeTracker.forLatency().onShown(statsToken, ActivityThread::currentApplication);
            }
            this.handlePendingControlRequest(statsToken);
            return;
        }
        int typesReady = 0;
        boolean imeVisible = this.mState.isSourceOrDefaultVisible(this.mImeSourceConsumer.getId(), WindowInsets.Type.ime());
        for (int type = 1; type <= 512; type <<= 1) {
            boolean alreadyAnimatingShow;
            if ((types & type) == 0) continue;
            int animationType = this.getAnimationType(type);
            boolean requestedVisible = (type & this.mRequestedVisibleTypes) != 0;
            boolean isIme = type == WindowInsets.Type.ime();
            boolean alreadyVisible = requestedVisible && (!isIme || imeVisible) && animationType == -1;
            boolean bl = alreadyAnimatingShow = animationType == 0;
            if (alreadyVisible || alreadyAnimatingShow) {
                if (!isIme) continue;
                ImeTracker.forLogging().onCancelled(statsToken, 32);
                continue;
            }
            if (fromIme && animationType == 2) {
                if (!isIme) continue;
                ImeTracker.forLogging().onFailed(statsToken, 32);
                continue;
            }
            if (isIme) {
                ImeTracker.forLogging().onProgress(statsToken, 32);
            }
            typesReady |= type;
        }
        if (fromIme && (typesReady & WindowInsets.Type.ime()) != 0) {
            ImeTracker.forLatency().onShown(statsToken, ActivityThread::currentApplication);
        }
        this.applyAnimation(typesReady, true, fromIme, statsToken);
    }

    private void handlePendingControlRequest(ImeTracker.Token statsToken) {
        PendingControlRequest pendingRequest = this.mPendingImeControlRequest;
        this.mPendingImeControlRequest = null;
        this.mHandler.removeCallbacks(this.mPendingControlTimeout);
        this.controlAnimationUnchecked(pendingRequest.types, pendingRequest.cancellationSignal, pendingRequest.listener, null, true, pendingRequest.durationMs, pendingRequest.interpolator, pendingRequest.animationType, pendingRequest.layoutInsetsDuringAnimation, pendingRequest.useInsetsAnimationThread, statsToken);
    }

    @Override
    public void hide(int types) {
        ImeTracker.Token statsToken = null;
        if ((types & WindowInsets.Type.ime()) != 0) {
            statsToken = ImeTracker.forLogging().onRequestHide(null, Process.myUid(), 2, 28);
        }
        this.hide(types, false, statsToken);
    }

    @VisibleForTesting
    public void hide(int types, boolean fromIme, ImeTracker.Token statsToken) {
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#hide", this.mHost.getInputMethodManager(), null);
            Trace.asyncTraceBegin(8L, "IC.hideRequestFromIme", 0);
        } else {
            Trace.asyncTraceBegin(8L, "IC.hideRequestFromApi", 0);
        }
        int typesReady = 0;
        boolean hasImeRequestedHidden = false;
        boolean hadPendingImeControlRequest = this.mPendingImeControlRequest != null;
        for (int type = 1; type <= 512; type <<= 1) {
            boolean isImeAnimation;
            if ((types & type) == 0) continue;
            int animationType = this.getAnimationType(type);
            boolean requestedVisible = (type & this.mRequestedVisibleTypes) != 0;
            boolean bl = isImeAnimation = type == WindowInsets.Type.ime();
            if (this.mPendingImeControlRequest != null && !requestedVisible) {
                this.mPendingImeControlRequest.types &= ~type;
                if (this.mPendingImeControlRequest.types == 0) {
                    this.abortPendingImeControlRequest();
                }
            }
            if (isImeAnimation && !requestedVisible && animationType == -1) {
                hasImeRequestedHidden = true;
                if (hadPendingImeControlRequest || this.getImeSourceConsumer().isRequestedVisibleAwaitingControl()) {
                    this.getImeSourceConsumer().requestHide(fromIme, statsToken);
                }
            }
            if (!requestedVisible && animationType == -1 || animationType == 1) {
                if (!isImeAnimation) continue;
                ImeTracker.forLogging().onCancelled(statsToken, 32);
                continue;
            }
            if (isImeAnimation) {
                ImeTracker.forLogging().onProgress(statsToken, 32);
            }
            typesReady |= type;
        }
        if (hasImeRequestedHidden && this.mPendingImeControlRequest != null) {
            this.handlePendingControlRequest(statsToken);
            this.getImeSourceConsumer().removeSurface();
        }
        this.applyAnimation(typesReady, false, fromIme, statsToken);
    }

    @Override
    public void controlWindowInsetsAnimation(int types, long durationMillis, Interpolator interpolator2, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener) {
        this.controlWindowInsetsAnimation(types, cancellationSignal, listener, false, durationMillis, interpolator2, 2);
    }

    private void controlWindowInsetsAnimation(int types, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, boolean fromIme, long durationMs, Interpolator interpolator2, int animationType) {
        if ((this.mState.calculateUncontrollableInsetsFromFrame(this.mFrame) & types) != 0) {
            listener.onCancelled(null);
            return;
        }
        if (fromIme) {
            ImeTracing.getInstance().triggerClientDump("InsetsController#controlWindowInsetsAnimation", this.mHost.getInputMethodManager(), null);
        }
        this.controlAnimationUnchecked(types, cancellationSignal, listener, this.mFrame, fromIme, durationMs, interpolator2, animationType, this.getLayoutInsetsDuringAnimationMode(types), false, null);
    }

    private void controlAnimationUnchecked(int types, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, Rect frame, boolean fromIme, long durationMs, Interpolator interpolator2, int animationType, int layoutInsetsDuringAnimation, boolean useInsetsAnimationThread, ImeTracker.Token statsToken) {
        boolean visible = layoutInsetsDuringAnimation == 0;
        this.setRequestedVisibleTypes(visible ? types : 0, types);
        this.controlAnimationUncheckedInner(types, cancellationSignal, listener, frame, fromIme, durationMs, interpolator2, animationType, layoutInsetsDuringAnimation, useInsetsAnimationThread, statsToken);
        this.reportRequestedVisibleTypes();
    }

    private void controlAnimationUncheckedInner(int types, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListener listener, Rect frame, boolean fromIme, long durationMs, Interpolator interpolator2, int animationType, int layoutInsetsDuringAnimation, boolean useInsetsAnimationThread, ImeTracker.Token statsToken) {
        InsetsAnimationControlRunner runner;
        ImeTracker.forLogging().onProgress(statsToken, 33);
        if ((types & this.mTypesBeingCancelled) != 0) {
            boolean monitoredAnimation;
            boolean bl = monitoredAnimation = animationType == 0 || animationType == 1;
            if (monitoredAnimation && (types & WindowInsets.Type.ime()) != 0) {
                if (animationType == 0) {
                    ImeTracker.forLatency().onShowCancelled(statsToken, 40, ActivityThread::currentApplication);
                } else {
                    ImeTracker.forLatency().onHideCancelled(statsToken, 40, ActivityThread::currentApplication);
                }
            }
            throw new IllegalStateException("Cannot start a new insets animation of " + WindowInsets.Type.toString(types) + " while an existing " + WindowInsets.Type.toString(this.mTypesBeingCancelled) + " is being cancelled.");
        }
        if (animationType == 2) {
            int disabledTypes = types & this.mDisabledUserAnimationInsetsTypes;
            types &= ~this.mDisabledUserAnimationInsetsTypes;
            if ((disabledTypes & WindowInsets.Type.ime()) != 0) {
                ImeTracker.forLogging().onFailed(statsToken, 34);
                if (fromIme && !this.mState.isSourceOrDefaultVisible(this.mImeSourceConsumer.getId(), WindowInsets.Type.ime())) {
                    this.setRequestedVisibleTypes(0, WindowInsets.Type.ime());
                    if (this.mImeSourceConsumer.onAnimationStateChanged(false)) {
                        this.notifyVisibilityChanged();
                    }
                }
            }
        }
        if (types == 0) {
            listener.onCancelled(null);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            return;
        }
        ImeTracker.forLogging().onProgress(statsToken, 34);
        this.mLastStartedAnimTypes |= types;
        SparseArray<InsetsSourceControl> controls = new SparseArray<InsetsSourceControl>();
        Pair<Integer, Boolean> typesReadyPair = this.collectSourceControls(fromIme, types, controls, animationType, statsToken);
        int typesReady = (Integer)typesReadyPair.first;
        boolean imeReady = (Boolean)typesReadyPair.second;
        if (!imeReady) {
            PendingControlRequest request;
            this.abortPendingImeControlRequest();
            this.mPendingImeControlRequest = request = new PendingControlRequest(types, listener, durationMs, interpolator2, animationType, layoutInsetsDuringAnimation, cancellationSignal, useInsetsAnimationThread);
            this.mHandler.postDelayed(this.mPendingControlTimeout, 2000L);
            if (cancellationSignal != null) {
                cancellationSignal.setOnCancelListener(() -> {
                    if (this.mPendingImeControlRequest == request) {
                        this.abortPendingImeControlRequest();
                    }
                });
            }
            this.setRequestedVisibleTypes(this.mReportedRequestedVisibleTypes, types);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
            if (!fromIme) {
                Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            }
            return;
        }
        if (typesReady == 0) {
            listener.onCancelled(null);
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
            if (!fromIme) {
                Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            }
            return;
        }
        this.cancelExistingControllers(typesReady);
        InsetsAnimationControlRunner insetsAnimationControlRunner = runner = useInsetsAnimationThread ? new InsetsAnimationThreadControlRunner(controls, frame, this.mState, listener, typesReady, this, durationMs, interpolator2, animationType, layoutInsetsDuringAnimation, this.mHost.getTranslator(), this.mHost.getHandler(), statsToken) : new InsetsAnimationControlImpl(controls, frame, this.mState, listener, typesReady, this, durationMs, interpolator2, animationType, layoutInsetsDuringAnimation, this.mHost.getTranslator(), statsToken);
        if ((typesReady & WindowInsets.Type.ime()) != 0) {
            ImeTracing.getInstance().triggerClientDump("InsetsAnimationControlImpl", this.mHost.getInputMethodManager(), null);
            if (animationType == 1) {
                ImeTracker.forLatency().onHidden(statsToken, ActivityThread::currentApplication);
            }
        }
        ImeTracker.forLogging().onProgress(statsToken, 39);
        this.mRunningAnimations.add(new RunningAnimation(runner, animationType));
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(() -> this.cancelAnimation(runner, true));
        } else {
            Trace.asyncTraceBegin(8L, "IC.pendingAnim", 0);
        }
        this.onAnimationStateChanged(types, true);
        if (fromIme) {
            switch (animationType) {
                case 0: {
                    Trace.asyncTraceEnd(8L, "IC.showRequestFromIme", 0);
                    break;
                }
                case 1: {
                    Trace.asyncTraceEnd(8L, "IC.hideRequestFromIme", 0);
                }
            }
        } else if (animationType == 1) {
            Trace.asyncTraceEnd(8L, "IC.hideRequestFromApi", 0);
        }
    }

    @Override
    public void setSystemDrivenInsetsAnimationLoggingListener(WindowInsetsAnimationControlListener listener) {
        this.mLoggingListener = listener;
    }

    private Pair<Integer, Boolean> collectSourceControls(boolean fromIme, int types, SparseArray<InsetsSourceControl> controls, int animationType, ImeTracker.Token statsToken) {
        ImeTracker.forLogging().onProgress(statsToken, 35);
        int typesReady = 0;
        boolean imeReady = true;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceControl control;
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if ((consumer.getType() & types) == 0) continue;
            boolean show = animationType == 0 || animationType == 2;
            boolean canRun = true;
            if (show) {
                switch (consumer.requestShow(fromIme, statsToken)) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        imeReady = false;
                        break;
                    }
                    case 2: {
                        canRun = false;
                        this.setRequestedVisibleTypes(0, consumer.getType());
                    }
                }
            } else {
                consumer.requestHide(fromIme, statsToken);
            }
            if (!canRun || (control = consumer.getControl()) == null || control.getLeash() == null) continue;
            controls.put(control.getId(), new InsetsSourceControl(control));
            typesReady |= consumer.getType();
        }
        return new Pair<Integer, Boolean>(typesReady, imeReady);
    }

    private int getLayoutInsetsDuringAnimationMode(int types) {
        return (this.mRequestedVisibleTypes & types) != types ? 0 : 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelExistingControllers(int types) {
        int originalmTypesBeingCancelled = this.mTypesBeingCancelled;
        this.mTypesBeingCancelled |= types;
        try {
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                InsetsAnimationControlRunner control = this.mRunningAnimations.get((int)i).runner;
                if ((control.getTypes() & types) == 0) continue;
                this.cancelAnimation(control, true);
            }
            if ((types & WindowInsets.Type.ime()) != 0) {
                this.abortPendingImeControlRequest();
            }
        }
        finally {
            this.mTypesBeingCancelled = originalmTypesBeingCancelled;
        }
    }

    private void abortPendingImeControlRequest() {
        if (this.mPendingImeControlRequest != null) {
            this.mPendingImeControlRequest.listener.onCancelled(null);
            this.mPendingImeControlRequest = null;
            this.mHandler.removeCallbacks(this.mPendingControlTimeout);
        }
    }

    @Override
    @VisibleForTesting
    public void notifyFinished(InsetsAnimationControlRunner runner, boolean shown) {
        this.setRequestedVisibleTypes(shown ? runner.getTypes() : 0, runner.getTypes());
        this.cancelAnimation(runner, false);
        if (runner.getAnimationType() == 3) {
            return;
        }
        ImeTracker.Token statsToken = runner.getStatsToken();
        if (shown) {
            ImeTracker.forLogging().onProgress(statsToken, 41);
            ImeTracker.forLogging().onShown(statsToken);
        } else {
            ImeTracker.forLogging().onProgress(statsToken, 42);
            ImeTracker.forLogging().onHidden(statsToken);
        }
        this.reportRequestedVisibleTypes();
    }

    @Override
    public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... params) {
        this.mHost.applySurfaceParams(params);
    }

    void notifyControlRevoked(InsetsSourceConsumer consumer) {
        int type = consumer.getType();
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner control = this.mRunningAnimations.get((int)i).runner;
            control.notifyControlRevoked(type);
            if (control.getControllingTypes() != 0) continue;
            this.cancelAnimation(control, true);
        }
        if (type == WindowInsets.Type.ime()) {
            this.abortPendingImeControlRequest();
        }
        if (consumer.getType() != WindowInsets.Type.ime()) {
            this.mSourceConsumers.remove(consumer.getId());
        }
    }

    private void cancelAnimation(InsetsAnimationControlRunner control, boolean invokeCallback) {
        if (invokeCallback) {
            ImeTracker.forLogging().onCancelled(control.getStatsToken(), 40);
            control.cancel();
        } else {
            ImeTracker.forLogging().onProgress(control.getStatsToken(), 40);
        }
        int removedTypes = 0;
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
            if (runningAnimation.runner != control) continue;
            this.mRunningAnimations.remove(i);
            removedTypes = control.getTypes();
            if (!invokeCallback) break;
            this.dispatchAnimationEnd(runningAnimation.runner.getAnimation());
            break;
        }
        this.onAnimationStateChanged(removedTypes, false);
    }

    private void onAnimationStateChanged(int types, boolean running) {
        boolean insetsChanged = false;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if ((consumer.getType() & types) == 0) continue;
            insetsChanged |= consumer.onAnimationStateChanged(running);
        }
        if (insetsChanged) {
            this.notifyVisibilityChanged();
        }
    }

    private void applyLocalVisibilityOverride() {
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            consumer.applyLocalVisibilityOverride();
        }
    }

    @VisibleForTesting
    public InsetsSourceConsumer getSourceConsumer(int id2, int type) {
        InsetsSourceConsumer consumer = this.mSourceConsumers.get(id2);
        if (consumer != null) {
            return consumer;
        }
        if (type == WindowInsets.Type.ime() && this.mImeSourceConsumer != null) {
            this.mSourceConsumers.remove(this.mImeSourceConsumer.getId());
            consumer = this.mImeSourceConsumer;
            consumer.setId(id2);
        } else {
            consumer = this.mConsumerCreator.apply(this, id2, type);
        }
        this.mSourceConsumers.put(id2, consumer);
        return consumer;
    }

    @VisibleForTesting
    public InsetsSourceConsumer getImeSourceConsumer() {
        return this.mImeSourceConsumer;
    }

    void notifyVisibilityChanged() {
        this.mHost.notifyInsetsChanged();
    }

    public void updateCompatSysUiVisibility() {
        if (this.mCompatSysUiVisibilityStaled) {
            this.mCompatSysUiVisibilityStaled = false;
            this.mHost.updateCompatSysUiVisibility(this.mVisibleTypes, this.mRequestedVisibleTypes, this.mControllableTypes | ~this.mExistingTypes);
        }
    }

    public void onWindowFocusGained(boolean hasViewFocused) {
        this.mImeSourceConsumer.onWindowFocusGained(hasViewFocused);
    }

    public void onWindowFocusLost() {
        this.mImeSourceConsumer.onWindowFocusLost();
    }

    @VisibleForTesting
    public int getAnimationType(int type) {
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner control = this.mRunningAnimations.get((int)i).runner;
            if (!control.controlsType(type)) continue;
            return this.mRunningAnimations.get((int)i).type;
        }
        return -1;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void setRequestedVisibleTypes(int visibleTypes, int mask) {
        int requestedVisibleTypes = this.mRequestedVisibleTypes & ~mask | visibleTypes & mask;
        if (this.mRequestedVisibleTypes != requestedVisibleTypes) {
            this.mRequestedVisibleTypes = requestedVisibleTypes;
        }
    }

    private void reportRequestedVisibleTypes() {
        if (this.mReportedRequestedVisibleTypes != this.mRequestedVisibleTypes) {
            int diff = this.mRequestedVisibleTypes ^ this.mReportedRequestedVisibleTypes;
            if (WindowInsets.Type.hasCompatSystemBars(diff)) {
                this.mCompatSysUiVisibilityStaled = true;
            }
            this.mReportedRequestedVisibleTypes = this.mRequestedVisibleTypes;
            this.mHost.updateRequestedVisibleTypes(this.mReportedRequestedVisibleTypes);
        }
        this.updateCompatSysUiVisibility();
    }

    @VisibleForTesting
    public void applyAnimation(int types, boolean show, boolean fromIme, ImeTracker.Token statsToken) {
        InsetsSourceControl imeControl;
        boolean skipAnim = false;
        if ((types & WindowInsets.Type.ime()) != 0 && (imeControl = this.mImeSourceConsumer.getControl()) != null) {
            skipAnim = imeControl.getAndClearSkipAnimationOnce() && show && this.mImeSourceConsumer.hasViewFocusWhenWindowFocusGain();
        }
        this.applyAnimation(types, show, fromIme, skipAnim, statsToken);
    }

    @VisibleForTesting
    public void applyAnimation(int types, boolean show, boolean fromIme, boolean skipAnim, ImeTracker.Token statsToken) {
        if (types == 0) {
            Trace.asyncTraceEnd(8L, "IC.showRequestFromApi", 0);
            if (!fromIme) {
                Trace.asyncTraceEnd(8L, "IC.showRequestFromApiToImeReady", 0);
            }
            return;
        }
        boolean hasAnimationCallbacks = this.mHost.hasAnimationCallbacks();
        InternalAnimationControlListener listener = new InternalAnimationControlListener(show, hasAnimationCallbacks, types, this.mHost.getSystemBarsBehavior(), skipAnim || this.mAnimationsDisabled, this.mHost.dipToPx(-80), this.mLoggingListener, this.mJankContext);
        this.controlAnimationUnchecked(types, null, listener, null, fromIme, listener.getDurationMs(), listener.getInsetsInterpolator(), show ? 0 : 1, show ? 0 : 1, !hasAnimationCallbacks, statsToken);
    }

    @VisibleForTesting
    public void cancelExistingAnimations() {
        this.cancelExistingControllers(WindowInsets.Type.all());
    }

    void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.println("InsetsController:");
        this.mState.dump(prefix + "  ", pw);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        this.mState.dumpDebug(proto, 0x10B00000001L);
        for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
            InsetsAnimationControlRunner runner = this.mRunningAnimations.get((int)i).runner;
            runner.dumpDebug(proto, 0x20B00000002L);
        }
        proto.end(token);
    }

    @Override
    @VisibleForTesting
    public <T extends InsetsAnimationControlRunner & InternalInsetsAnimationController> void startAnimation(T runner, WindowInsetsAnimationControlListener listener, int types, WindowInsetsAnimation animation, WindowInsetsAnimation.Bounds bounds) {
        this.mHost.dispatchWindowInsetsAnimationPrepare(animation);
        this.mHost.addOnPreDrawRunnable(() -> {
            if (((WindowInsetsAnimationController)((Object)runner)).isCancelled()) {
                return;
            }
            Trace.asyncTraceBegin(8L, "InsetsAnimation: " + WindowInsets.Type.toString(types), types);
            for (int i = this.mRunningAnimations.size() - 1; i >= 0; --i) {
                RunningAnimation runningAnimation = this.mRunningAnimations.get(i);
                if (runningAnimation.runner != runner) continue;
                runningAnimation.startDispatched = true;
            }
            Trace.asyncTraceEnd(8L, "IC.pendingAnim", 0);
            this.mHost.dispatchWindowInsetsAnimationStart(animation, bounds);
            this.mStartingAnimation = true;
            ((InternalInsetsAnimationController)((Object)runner)).setReadyDispatched(true);
            listener.onReady((WindowInsetsAnimationController)((Object)runner), types);
            this.mStartingAnimation = false;
        });
    }

    @VisibleForTesting
    public void dispatchAnimationEnd(WindowInsetsAnimation animation) {
        Trace.asyncTraceEnd(8L, "InsetsAnimation: " + WindowInsets.Type.toString(animation.getTypeMask()), animation.getTypeMask());
        this.mHost.dispatchWindowInsetsAnimationEnd(animation);
    }

    @Override
    @VisibleForTesting
    public void scheduleApplyChangeInsets(InsetsAnimationControlRunner runner) {
        if (this.mStartingAnimation || runner.getAnimationType() == 2) {
            this.mAnimCallback.run();
            this.mAnimCallbackScheduled = false;
            return;
        }
        if (!this.mAnimCallbackScheduled) {
            this.mHost.postInsetsAnimationCallback(this.mAnimCallback);
            this.mAnimCallbackScheduled = true;
        }
    }

    @Override
    public void setSystemBarsAppearance(int appearance, int mask) {
        this.mHost.setSystemBarsAppearance(appearance, mask);
    }

    @Override
    public int getSystemBarsAppearance() {
        if (!this.mHost.isSystemBarsAppearanceControlled()) {
            return 0;
        }
        return this.mHost.getSystemBarsAppearance();
    }

    @Override
    public void setCaptionInsetsHeight(int height) {
        if (ViewRootImpl.CAPTION_ON_SHELL) {
            return;
        }
        if (this.mCaptionInsetsHeight != height) {
            this.mCaptionInsetsHeight = height;
            if (this.mCaptionInsetsHeight != 0) {
                this.mState.getOrCreateSource(ID_CAPTION_BAR, WindowInsets.Type.captionBar()).setFrame(this.mFrame.left, this.mFrame.top, this.mFrame.right, this.mFrame.top + this.mCaptionInsetsHeight);
            } else {
                this.mState.removeSource(ID_CAPTION_BAR);
            }
            this.mHost.notifyInsetsChanged();
        }
    }

    @Override
    public void setSystemBarsBehavior(int behavior) {
        this.mHost.setSystemBarsBehavior(behavior);
    }

    @Override
    public int getSystemBarsBehavior() {
        if (!this.mHost.isSystemBarsBehaviorControlled()) {
            return 0;
        }
        return this.mHost.getSystemBarsBehavior();
    }

    @Override
    public void setAnimationsDisabled(boolean disable) {
        this.mAnimationsDisabled = disable;
    }

    private int calculateControllableTypes() {
        int result = 0;
        for (int i = this.mSourceConsumers.size() - 1; i >= 0; --i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            InsetsSource source = this.mState.peekSource(consumer.getId());
            if (consumer.getControl() == null || source == null || !source.isUserControllable()) continue;
            result |= consumer.getType();
        }
        return result & ~this.mState.calculateUncontrollableInsetsFromFrame(this.mFrame);
    }

    private int invokeControllableInsetsChangedListeners() {
        this.mHandler.removeCallbacks(this.mInvokeControllableInsetsChangedListeners);
        this.mLastStartedAnimTypes = 0;
        int types = this.calculateControllableTypes();
        int size = this.mControllableInsetsChangedListeners.size();
        for (int i = 0; i < size; ++i) {
            this.mControllableInsetsChangedListeners.get(i).onControllableInsetsChanged(this, types);
        }
        return this.mLastStartedAnimTypes;
    }

    @Override
    public void addOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        Objects.requireNonNull(listener);
        this.mControllableInsetsChangedListeners.add(listener);
        listener.onControllableInsetsChanged(this, this.calculateControllableTypes());
    }

    @Override
    public void removeOnControllableInsetsChangedListener(WindowInsetsController.OnControllableInsetsChangedListener listener) {
        Objects.requireNonNull(listener);
        this.mControllableInsetsChangedListeners.remove(listener);
    }

    @Override
    public void releaseSurfaceControlFromRt(SurfaceControl sc) {
        this.mHost.releaseSurfaceControlFromRt(sc);
    }

    @Override
    public void reportPerceptible(int types, boolean perceptible) {
        int size = this.mSourceConsumers.size();
        for (int i = 0; i < size; ++i) {
            InsetsSourceConsumer consumer = this.mSourceConsumers.valueAt(i);
            if ((consumer.getType() & types) == 0) continue;
            consumer.onPerceptible(perceptible);
        }
    }

    Host getHost() {
        return this.mHost;
    }

    public static interface Host {
        public Handler getHandler();

        public void notifyInsetsChanged();

        public void dispatchWindowInsetsAnimationPrepare(WindowInsetsAnimation var1);

        public WindowInsetsAnimation.Bounds dispatchWindowInsetsAnimationStart(WindowInsetsAnimation var1, WindowInsetsAnimation.Bounds var2);

        public WindowInsets dispatchWindowInsetsAnimationProgress(WindowInsets var1, List<WindowInsetsAnimation> var2);

        public void dispatchWindowInsetsAnimationEnd(WindowInsetsAnimation var1);

        public void applySurfaceParams(SyncRtSurfaceTransactionApplier.SurfaceParams ... var1);

        default public void updateCompatSysUiVisibility(int visibleTypes, int requestedVisibleTypes, int controllableTypes) {
        }

        public void updateRequestedVisibleTypes(int var1);

        public boolean hasAnimationCallbacks();

        public void setSystemBarsAppearance(int var1, int var2);

        public int getSystemBarsAppearance();

        default public boolean isSystemBarsAppearanceControlled() {
            return false;
        }

        public void setSystemBarsBehavior(int var1);

        public int getSystemBarsBehavior();

        default public boolean isSystemBarsBehaviorControlled() {
            return false;
        }

        public void releaseSurfaceControlFromRt(SurfaceControl var1);

        public void addOnPreDrawRunnable(Runnable var1);

        public void postInsetsAnimationCallback(Runnable var1);

        public InputMethodManager getInputMethodManager();

        public String getRootViewTitle();

        default public Context getRootViewContext() {
            return null;
        }

        public int dipToPx(int var1);

        public IBinder getWindowToken();

        default public CompatibilityInfo.Translator getTranslator() {
            return null;
        }
    }

    private static class RunningAnimation {
        final InsetsAnimationControlRunner runner;
        final int type;
        boolean startDispatched;

        RunningAnimation(InsetsAnimationControlRunner runner, int type) {
            this.runner = runner;
            this.type = type;
        }
    }

    private static class PendingControlRequest {
        int types;
        final WindowInsetsAnimationControlListener listener;
        final long durationMs;
        final Interpolator interpolator;
        final int animationType;
        final int layoutInsetsDuringAnimation;
        final CancellationSignal cancellationSignal;
        final boolean useInsetsAnimationThread;

        PendingControlRequest(int types, WindowInsetsAnimationControlListener listener, long durationMs, Interpolator interpolator2, int animationType, int layoutInsetsDuringAnimation, CancellationSignal cancellationSignal, boolean useInsetsAnimationThread) {
            this.types = types;
            this.listener = listener;
            this.durationMs = durationMs;
            this.interpolator = interpolator2;
            this.animationType = animationType;
            this.layoutInsetsDuringAnimation = layoutInsetsDuringAnimation;
            this.cancellationSignal = cancellationSignal;
            this.useInsetsAnimationThread = useInsetsAnimationThread;
        }
    }

    public static class InternalAnimationControlListener
    implements WindowInsetsAnimationControlListener {
        private WindowInsetsAnimationController mController;
        private ValueAnimator mAnimator;
        private final boolean mShow;
        private final boolean mHasAnimationCallbacks;
        private final int mRequestedTypes;
        private final int mBehavior;
        private final long mDurationMs;
        private final boolean mDisable;
        private final int mFloatingImeBottomInset;
        private final WindowInsetsAnimationControlListener mLoggingListener;
        private final ImeTracker.InputMethodJankContext mInputMethodJankContext;
        private final ThreadLocal<AnimationHandler> mSfAnimationHandlerThreadLocal = new ThreadLocal<AnimationHandler>(){

            @Override
            protected AnimationHandler initialValue() {
                AnimationHandler handler = new AnimationHandler();
                handler.setProvider(new SfVsyncFrameCallbackProvider());
                return handler;
            }
        };

        public InternalAnimationControlListener(boolean show, boolean hasAnimationCallbacks, int requestedTypes, int behavior, boolean disable, int floatingImeBottomInset, WindowInsetsAnimationControlListener loggingListener, ImeTracker.InputMethodJankContext jankContext) {
            this.mShow = show;
            this.mHasAnimationCallbacks = hasAnimationCallbacks;
            this.mRequestedTypes = requestedTypes;
            this.mBehavior = behavior;
            this.mDurationMs = this.calculateDurationMs();
            this.mDisable = disable;
            this.mFloatingImeBottomInset = floatingImeBottomInset;
            this.mLoggingListener = loggingListener;
            this.mInputMethodJankContext = jankContext;
        }

        @Override
        public void onReady(WindowInsetsAnimationController controller, int types) {
            this.mController = controller;
            if (this.mLoggingListener != null) {
                this.mLoggingListener.onReady(controller, types);
            }
            if (this.mDisable) {
                this.onAnimationFinish();
                return;
            }
            this.mAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mAnimator.setDuration(this.mDurationMs);
            this.mAnimator.setInterpolator(new LinearInterpolator());
            Insets hiddenInsets = controller.getHiddenStateInsets();
            hiddenInsets = controller.hasZeroInsetsIme() ? Insets.of(hiddenInsets.left, hiddenInsets.top, hiddenInsets.right, this.mFloatingImeBottomInset) : hiddenInsets;
            Insets start = this.mShow ? hiddenInsets : controller.getShownStateInsets();
            Insets end = this.mShow ? controller.getShownStateInsets() : hiddenInsets;
            Interpolator insetsInterpolator = this.getInsetsInterpolator();
            Interpolator alphaInterpolator = this.getAlphaInterpolator();
            this.mAnimator.addUpdateListener(animation -> {
                float rawFraction = animation.getAnimatedFraction();
                float alphaFraction = this.mShow ? rawFraction : 1.0f - rawFraction;
                float insetsFraction = insetsInterpolator.getInterpolation(rawFraction);
                controller.setInsetsAndAlpha(sEvaluator.evaluate(insetsFraction, start, end), alphaInterpolator.getInterpolation(alphaFraction), rawFraction);
            });
            this.mAnimator.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    if (mInputMethodJankContext == null) {
                        return;
                    }
                    ImeTracker.forJank().onRequestAnimation(mInputMethodJankContext, mShow ? 0 : 1, !mHasAnimationCallbacks);
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    if (mInputMethodJankContext == null) {
                        return;
                    }
                    ImeTracker.forJank().onCancelAnimation();
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    this.onAnimationFinish();
                    if (mInputMethodJankContext == null) {
                        return;
                    }
                    ImeTracker.forJank().onFinishAnimation();
                }
            });
            if (!this.mHasAnimationCallbacks) {
                this.mAnimator.setAnimationHandler(this.mSfAnimationHandlerThreadLocal.get());
            }
            this.mAnimator.start();
        }

        @Override
        public void onFinished(WindowInsetsAnimationController controller) {
            if (this.mLoggingListener != null) {
                this.mLoggingListener.onFinished(controller);
            }
        }

        @Override
        public void onCancelled(WindowInsetsAnimationController controller) {
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
            if (this.mLoggingListener != null) {
                this.mLoggingListener.onCancelled(controller);
            }
        }

        protected Interpolator getInsetsInterpolator() {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks) {
                    return SYNC_IME_INTERPOLATOR;
                }
                if (this.mShow) {
                    return LINEAR_OUT_SLOW_IN_INTERPOLATOR;
                }
                return FAST_OUT_LINEAR_IN_INTERPOLATOR;
            }
            if (this.mBehavior == 2) {
                return SYSTEM_BARS_INSETS_INTERPOLATOR;
            }
            return input -> this.mShow ? 1.0f : 0.0f;
        }

        Interpolator getAlphaInterpolator() {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks) {
                    return input -> 1.0f;
                }
                if (this.mShow) {
                    return input -> Math.min(1.0f, 2.0f * input);
                }
                return FAST_OUT_LINEAR_IN_INTERPOLATOR;
            }
            if (this.mBehavior == 2) {
                return input -> 1.0f;
            }
            if (this.mShow) {
                return SYSTEM_BARS_ALPHA_INTERPOLATOR;
            }
            return SYSTEM_BARS_DIM_INTERPOLATOR;
        }

        protected void onAnimationFinish() {
            this.mController.finish(this.mShow);
        }

        public long getDurationMs() {
            return this.mDurationMs;
        }

        private long calculateDurationMs() {
            if ((this.mRequestedTypes & WindowInsets.Type.ime()) != 0) {
                if (this.mHasAnimationCallbacks) {
                    return 285L;
                }
                return 200L;
            }
            if (this.mBehavior == 2) {
                return this.mShow ? 275L : 340L;
            }
            return this.mShow ? 500L : 1500L;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnimationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LayoutInsetsDuringAnimation {
    }
}

