/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.util.proto.ProtoOutputStream;
import android.view.InsetsController;
import android.view.InsetsSource;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.SurfaceControl;
import android.view.WindowInsets;
import android.view.inputmethod.ImeTracker;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.function.Supplier;

public class InsetsSourceConsumer {
    protected static final int ANIMATION_STATE_NONE = 0;
    protected static final int ANIMATION_STATE_SHOW = 1;
    protected static final int ANIMATION_STATE_HIDE = 2;
    protected int mAnimationState = 0;
    protected final InsetsController mController;
    protected final InsetsState mState;
    private int mId;
    private final int mType;
    private static final String TAG = "InsetsSourceConsumer";
    private final Supplier<SurfaceControl.Transaction> mTransactionSupplier;
    private InsetsSourceControl mSourceControl;
    private boolean mHasWindowFocus;
    private boolean mHasViewFocusWhenWindowFocusGain;
    private Rect mPendingFrame;
    private Rect mPendingVisibleFrame;

    public InsetsSourceConsumer(int id2, int type, InsetsState state, Supplier<SurfaceControl.Transaction> transactionSupplier, InsetsController controller) {
        this.mId = id2;
        this.mType = type;
        this.mState = state;
        this.mTransactionSupplier = transactionSupplier;
        this.mController = controller;
    }

    public boolean setControl(InsetsSourceControl control, int[] showTypes, int[] hideTypes) {
        if (Objects.equals(this.mSourceControl, control)) {
            if (this.mSourceControl != null && this.mSourceControl != control) {
                this.mSourceControl.release(SurfaceControl::release);
                this.mSourceControl = control;
            }
            return false;
        }
        InsetsSourceControl lastControl = this.mSourceControl;
        this.mSourceControl = control;
        if (control != null) {
            // empty if block
        }
        if (this.mSourceControl == null) {
            boolean serverVisible;
            this.mController.notifyControlRevoked(this);
            InsetsSource localSource = this.mState.peekSource(this.mId);
            InsetsSource serverSource = this.mController.getLastDispatchedState().peekSource(this.mId);
            boolean localVisible = localSource != null && localSource.isVisible();
            boolean bl = serverVisible = serverSource != null && serverSource.isVisible();
            if (localSource != null) {
                localSource.setVisible(serverVisible);
            }
            if (localVisible != serverVisible) {
                this.mController.notifyVisibilityChanged();
            }
        } else {
            boolean requestedVisible = this.isRequestedVisibleAwaitingControl();
            SurfaceControl oldLeash = lastControl != null ? lastControl.getLeash() : null;
            SurfaceControl newLeash = control.getLeash();
            if (!(newLeash == null || oldLeash != null && newLeash.isSameSurface(oldLeash) || requestedVisible == control.isInitiallyVisible())) {
                if (requestedVisible) {
                    showTypes[0] = showTypes[0] | this.mType;
                } else {
                    hideTypes[0] = hideTypes[0] | this.mType;
                }
            } else {
                if (this.applyLocalVisibilityOverride()) {
                    this.mController.notifyVisibilityChanged();
                }
                if (this.mController.getAnimationType(this.mType) == -1) {
                    this.applyRequestedVisibilityToControl();
                }
                if (!requestedVisible && lastControl == null) {
                    this.removeSurface();
                }
            }
        }
        if (lastControl != null) {
            lastControl.release(SurfaceControl::release);
        }
        return true;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public InsetsSourceControl getControl() {
        return this.mSourceControl;
    }

    protected boolean isRequestedVisibleAwaitingControl() {
        return (this.mController.getRequestedVisibleTypes() & this.mType) != 0;
    }

    int getId() {
        return this.mId;
    }

    void setId(int id2) {
        this.mId = id2;
    }

    int getType() {
        return this.mType;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean onAnimationStateChanged(boolean running) {
        boolean cancelledForNewAnimation;
        boolean insetsChanged = false;
        if (!running && this.mPendingFrame != null) {
            InsetsSource source = this.mState.peekSource(this.mId);
            if (source != null) {
                source.setFrame(this.mPendingFrame);
                source.setVisibleFrame(this.mPendingVisibleFrame);
                insetsChanged = true;
            }
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
        }
        boolean showRequested = this.isShowRequested();
        boolean bl = !running && showRequested ? this.mAnimationState == 2 : (cancelledForNewAnimation = this.mAnimationState == 1);
        int n = running ? (showRequested ? 1 : 2) : (this.mAnimationState = 0);
        if (!cancelledForNewAnimation) {
            insetsChanged |= this.applyLocalVisibilityOverride();
        }
        return insetsChanged;
    }

    protected boolean isShowRequested() {
        return (this.mController.getRequestedVisibleTypes() & this.getType()) != 0;
    }

    public void onWindowFocusGained(boolean hasViewFocus) {
        this.mHasWindowFocus = true;
        this.mHasViewFocusWhenWindowFocusGain = hasViewFocus;
    }

    public void onWindowFocusLost() {
        this.mHasWindowFocus = false;
    }

    boolean hasViewFocusWhenWindowFocusGain() {
        return this.mHasViewFocusWhenWindowFocusGain;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public boolean applyLocalVisibilityOverride() {
        boolean requestedVisible;
        InsetsSource source = this.mState.peekSource(this.mId);
        if (source == null) {
            return false;
        }
        boolean bl = requestedVisible = (this.mController.getRequestedVisibleTypes() & this.mType) != 0;
        if (this.mSourceControl == null) {
            return false;
        }
        if (source.isVisible() == requestedVisible) {
            return false;
        }
        source.setVisible(requestedVisible);
        return true;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public int requestShow(boolean fromController, ImeTracker.Token statsToken) {
        return 0;
    }

    void requestHide(boolean fromController, ImeTracker.Token statsToken) {
    }

    public void onPerceptible(boolean perceptible) {
    }

    public void removeSurface() {
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public void updateSource(InsetsSource newSource, int animationType) {
        InsetsSource source = this.mState.peekSource(this.mId);
        if (source == null || animationType == -1 || source.getFrame().equals(newSource.getFrame())) {
            this.mPendingFrame = null;
            this.mPendingVisibleFrame = null;
            this.mState.addSource(newSource);
            return;
        }
        newSource = new InsetsSource(newSource);
        this.mPendingFrame = new Rect(newSource.getFrame());
        this.mPendingVisibleFrame = newSource.getVisibleFrame() != null ? new Rect(newSource.getVisibleFrame()) : null;
        newSource.setFrame(source.getFrame());
        newSource.setVisibleFrame(source.getVisibleFrame());
        this.mState.addSource(newSource);
    }

    private void applyRequestedVisibilityToControl() {
        if (this.mSourceControl == null || this.mSourceControl.getLeash() == null) {
            return;
        }
        boolean requestedVisible = (this.mController.getRequestedVisibleTypes() & this.mType) != 0;
        try (SurfaceControl.Transaction t = this.mTransactionSupplier.get();){
            if (requestedVisible) {
                t.show(this.mSourceControl.getLeash());
            } else {
                t.hide(this.mSourceControl.getLeash());
            }
            t.setAlpha(this.mSourceControl.getLeash(), requestedVisible ? 1.0f : 0.0f);
            t.apply();
        }
        this.onPerceptible(requestedVisible);
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, WindowInsets.Type.toString(this.mType));
        proto.write(1133871366146L, this.mHasWindowFocus);
        proto.write(1133871366147L, this.isShowRequested());
        if (this.mSourceControl != null) {
            this.mSourceControl.dumpDebug(proto, 1146756268036L);
        }
        if (this.mPendingFrame != null) {
            this.mPendingFrame.dumpDebug(proto, 1146756268037L);
        }
        if (this.mPendingVisibleFrame != null) {
            this.mPendingVisibleFrame.dumpDebug(proto, 1146756268038L);
        }
        proto.write(1120986464263L, this.mAnimationState);
        proto.end(token);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ShowResult {
        public static final int SHOW_IMMEDIATELY = 0;
        public static final int IME_SHOW_DELAYED = 1;
        public static final int IME_SHOW_FAILED = 2;
    }
}

