/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Insets;
import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import android.view.SurfaceControl;
import android.view.WindowInsets;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.function.Consumer;

public class InsetsSourceControl
implements Parcelable {
    private final int mId;
    private final int mType;
    private final SurfaceControl mLeash;
    private final boolean mInitiallyVisible;
    private final Point mSurfacePosition;
    private Insets mInsetsHint;
    private boolean mSkipAnimationOnce;
    private int mParcelableFlags;
    public static final Parcelable.Creator<InsetsSourceControl> CREATOR = new Parcelable.Creator<InsetsSourceControl>(){

        @Override
        public InsetsSourceControl createFromParcel(Parcel in) {
            return new InsetsSourceControl(in);
        }

        public InsetsSourceControl[] newArray(int size) {
            return new InsetsSourceControl[size];
        }
    };

    public InsetsSourceControl(int id2, int type, SurfaceControl leash, boolean initiallyVisible, Point surfacePosition, Insets insetsHint) {
        this.mId = id2;
        this.mType = type;
        this.mLeash = leash;
        this.mInitiallyVisible = initiallyVisible;
        this.mSurfacePosition = surfacePosition;
        this.mInsetsHint = insetsHint;
    }

    public InsetsSourceControl(InsetsSourceControl other) {
        this.mId = other.mId;
        this.mType = other.mType;
        this.mLeash = other.mLeash != null ? new SurfaceControl(other.mLeash, "InsetsSourceControl") : null;
        this.mInitiallyVisible = other.mInitiallyVisible;
        this.mSurfacePosition = new Point(other.mSurfacePosition);
        this.mInsetsHint = other.mInsetsHint;
        this.mSkipAnimationOnce = other.getAndClearSkipAnimationOnce();
    }

    public InsetsSourceControl(Parcel in) {
        this.mId = in.readInt();
        this.mType = in.readInt();
        this.mLeash = in.readTypedObject(SurfaceControl.CREATOR);
        this.mInitiallyVisible = in.readBoolean();
        this.mSurfacePosition = in.readTypedObject(Point.CREATOR);
        this.mInsetsHint = in.readTypedObject(Insets.CREATOR);
        this.mSkipAnimationOnce = in.readBoolean();
    }

    public int getId() {
        return this.mId;
    }

    public int getType() {
        return this.mType;
    }

    public SurfaceControl getLeash() {
        return this.mLeash;
    }

    public boolean isInitiallyVisible() {
        return this.mInitiallyVisible;
    }

    public boolean setSurfacePosition(int left, int top) {
        if (this.mSurfacePosition.equals(left, top)) {
            return false;
        }
        this.mSurfacePosition.set(left, top);
        return true;
    }

    public Point getSurfacePosition() {
        return this.mSurfacePosition;
    }

    public void setInsetsHint(Insets insets) {
        this.mInsetsHint = insets;
    }

    public void setInsetsHint(int left, int top, int right, int bottom) {
        this.mInsetsHint = Insets.of(left, top, right, bottom);
    }

    public Insets getInsetsHint() {
        return this.mInsetsHint;
    }

    public void setSkipAnimationOnce(boolean skipAnimation) {
        this.mSkipAnimationOnce = skipAnimation;
    }

    public boolean getAndClearSkipAnimationOnce() {
        boolean result = this.mSkipAnimationOnce;
        this.mSkipAnimationOnce = false;
        return result;
    }

    public void setParcelableFlags(int parcelableFlags) {
        this.mParcelableFlags = parcelableFlags;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mId);
        dest.writeInt(this.mType);
        dest.writeTypedObject(this.mLeash, this.mParcelableFlags);
        dest.writeBoolean(this.mInitiallyVisible);
        dest.writeTypedObject(this.mSurfacePosition, this.mParcelableFlags);
        dest.writeTypedObject(this.mInsetsHint, this.mParcelableFlags);
        dest.writeBoolean(this.mSkipAnimationOnce);
    }

    public void release(Consumer<SurfaceControl> surfaceReleaseConsumer) {
        if (this.mLeash != null) {
            surfaceReleaseConsumer.accept(this.mLeash);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsetsSourceControl that = (InsetsSourceControl)o;
        SurfaceControl thatLeash = that.mLeash;
        return this.mId == that.mId && this.mType == that.mType && (this.mLeash == thatLeash || this.mLeash != null && thatLeash != null && this.mLeash.isSameSurface(thatLeash)) && this.mInitiallyVisible == that.mInitiallyVisible && this.mSurfacePosition.equals(that.mSurfacePosition) && this.mInsetsHint.equals(that.mInsetsHint) && this.mSkipAnimationOnce == that.mSkipAnimationOnce;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mType, this.mLeash, this.mInitiallyVisible, this.mSurfacePosition, this.mInsetsHint, this.mSkipAnimationOnce);
    }

    public String toString() {
        return "InsetsSourceControl: {" + Integer.toHexString(this.mId) + " mType=" + WindowInsets.Type.toString(this.mType) + (this.mInitiallyVisible ? " initiallyVisible" : "") + " mSurfacePosition=" + this.mSurfacePosition + " mInsetsHint=" + this.mInsetsHint + (this.mSkipAnimationOnce ? " skipAnimationOnce" : "") + "}";
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("InsetsSourceControl mId=");
        pw.print(Integer.toHexString(this.mId));
        pw.print(" mType=");
        pw.print(WindowInsets.Type.toString(this.mType));
        pw.print(" mLeash=");
        pw.print(this.mLeash);
        pw.print(" mInitiallyVisible=");
        pw.print(this.mInitiallyVisible);
        pw.print(" mSurfacePosition=");
        pw.print(this.mSurfacePosition);
        pw.print(" mInsetsHint=");
        pw.print(this.mInsetsHint);
        pw.print(" mSkipAnimationOnce=");
        pw.print(this.mSkipAnimationOnce);
        pw.println();
    }

    public void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, WindowInsets.Type.toString(this.mType));
        long surfaceToken = proto.start(1146756268034L);
        proto.write(0x10500000001L, this.mSurfacePosition.x);
        proto.write(1120986464258L, this.mSurfacePosition.y);
        proto.end(surfaceToken);
        if (this.mLeash != null) {
            this.mLeash.dumpDebug(proto, 1146756268035L);
        }
        proto.end(token);
    }

    public static class Array
    implements Parcelable {
        private InsetsSourceControl[] mControls;
        public static final Parcelable.Creator<Array> CREATOR = new Parcelable.Creator<Array>(){

            @Override
            public Array createFromParcel(Parcel in) {
                return new Array(in);
            }

            public Array[] newArray(int size) {
                return new Array[size];
            }
        };

        public Array() {
        }

        public Array(Parcel in) {
            this.readFromParcel(in);
        }

        public void set(InsetsSourceControl[] controls) {
            this.mControls = controls;
        }

        public InsetsSourceControl[] get() {
            return this.mControls;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public void readFromParcel(Parcel in) {
            this.mControls = in.createTypedArray(CREATOR);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            out.writeTypedArray(this.mControls, flags);
        }
    }
}

