/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.app.WindowConfiguration;
import android.graphics.Insets;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import android.view.DisplayCutout;
import android.view.DisplayShape;
import android.view.InsetsSource;
import android.view.PrivacyIndicatorBounds;
import android.view.RoundedCorners;
import android.view.WindowInsets;
import com.android.internal.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.StringJoiner;

public class InsetsState
implements Parcelable {
    static final int ISIDE_LEFT = 0;
    static final int ISIDE_TOP = 1;
    static final int ISIDE_RIGHT = 2;
    static final int ISIDE_BOTTOM = 3;
    static final int ISIDE_FLOATING = 4;
    static final int ISIDE_UNKNOWN = 5;
    private final SparseArray<InsetsSource> mSources;
    private final Rect mDisplayFrame = new Rect();
    private final DisplayCutout.ParcelableWrapper mDisplayCutout = new DisplayCutout.ParcelableWrapper();
    private final Rect mRoundedCornerFrame = new Rect();
    private RoundedCorners mRoundedCorners = RoundedCorners.NO_ROUNDED_CORNERS;
    private PrivacyIndicatorBounds mPrivacyIndicatorBounds = new PrivacyIndicatorBounds();
    private DisplayShape mDisplayShape = DisplayShape.NONE;
    public static final Parcelable.Creator<InsetsState> CREATOR = new Parcelable.Creator<InsetsState>(){

        @Override
        public InsetsState createFromParcel(Parcel in) {
            return new InsetsState(in);
        }

        public InsetsState[] newArray(int size) {
            return new InsetsState[size];
        }
    };

    public InsetsState() {
        this.mSources = new SparseArray();
    }

    public InsetsState(InsetsState copy) {
        this(copy, false);
    }

    public InsetsState(InsetsState copy, boolean copySources) {
        this.mSources = new SparseArray(copy.mSources.size());
        this.set(copy, copySources);
    }

    public WindowInsets calculateInsets(Rect frame, InsetsState ignoringVisibilityState, boolean isScreenRound, boolean alwaysConsumeSystemBars, int legacySoftInputMode, int legacyWindowFlags, int legacySystemUiFlags, int windowType, @WindowConfiguration.WindowingMode int windowingMode, SparseIntArray idSideMap) {
        Insets[] typeInsetsMap = new Insets[10];
        Insets[] typeMaxInsetsMap = new Insets[10];
        boolean[] typeVisibilityMap = new boolean[10];
        Rect relativeFrame = new Rect(frame);
        Rect relativeFrameMax = new Rect(frame);
        int suppressScrimTypes = 0;
        for (int i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource ignoringVisibilitySource;
            InsetsSource source = this.mSources.valueAt(i);
            if ((source.getFlags() & 1) != 0) {
                suppressScrimTypes |= source.getType();
            }
            this.processSource(source, relativeFrame, false, typeInsetsMap, idSideMap, typeVisibilityMap);
            if (source.getType() == WindowInsets.Type.ime()) continue;
            InsetsSource insetsSource = ignoringVisibilitySource = ignoringVisibilityState != null ? ignoringVisibilityState.peekSource(source.getId()) : source;
            if (ignoringVisibilitySource == null) continue;
            this.processSource(ignoringVisibilitySource, relativeFrameMax, true, typeMaxInsetsMap, null, null);
        }
        int softInputAdjustMode = legacySoftInputMode & 0xF0;
        int compatInsetsTypes = WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout();
        if (softInputAdjustMode == 16) {
            compatInsetsTypes |= WindowInsets.Type.ime();
        }
        if ((legacyWindowFlags & 0x400) != 0) {
            compatInsetsTypes &= ~WindowInsets.Type.statusBars();
        }
        if (InsetsState.clearsCompatInsets(windowType, legacyWindowFlags, windowingMode) && !alwaysConsumeSystemBars) {
            compatInsetsTypes = 0;
        }
        return new WindowInsets(typeInsetsMap, typeMaxInsetsMap, typeVisibilityMap, isScreenRound, alwaysConsumeSystemBars, suppressScrimTypes, this.calculateRelativeCutout(frame), this.calculateRelativeRoundedCorners(frame), this.calculateRelativePrivacyIndicatorBounds(frame), this.calculateRelativeDisplayShape(frame), compatInsetsTypes, (legacySystemUiFlags & 0x100) != 0);
    }

    private DisplayCutout calculateRelativeCutout(Rect frame) {
        DisplayCutout raw2 = this.mDisplayCutout.get();
        if (this.mDisplayFrame.equals(frame)) {
            return raw2;
        }
        if (frame == null) {
            return DisplayCutout.NO_CUTOUT;
        }
        int insetLeft = frame.left - this.mDisplayFrame.left;
        int insetTop = frame.top - this.mDisplayFrame.top;
        int insetRight = this.mDisplayFrame.right - frame.right;
        int insetBottom = this.mDisplayFrame.bottom - frame.bottom;
        if (insetLeft >= raw2.getSafeInsetLeft() && insetTop >= raw2.getSafeInsetTop() && insetRight >= raw2.getSafeInsetRight() && insetBottom >= raw2.getSafeInsetBottom()) {
            return DisplayCutout.NO_CUTOUT;
        }
        return raw2.inset(insetLeft, insetTop, insetRight, insetBottom);
    }

    private RoundedCorners calculateRelativeRoundedCorners(Rect frame) {
        if (frame == null) {
            return RoundedCorners.NO_ROUNDED_CORNERS;
        }
        Rect roundedCornerFrame = new Rect(this.mRoundedCornerFrame);
        for (int i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource source = this.mSources.valueAt(i);
            if (!source.insetsRoundedCornerFrame()) continue;
            Insets insets = source.calculateInsets(roundedCornerFrame, false);
            roundedCornerFrame.inset(insets);
        }
        if (!roundedCornerFrame.isEmpty() && !roundedCornerFrame.equals(this.mDisplayFrame)) {
            return this.mRoundedCorners.insetWithFrame(frame, roundedCornerFrame);
        }
        if (this.mDisplayFrame.equals(frame)) {
            return this.mRoundedCorners;
        }
        int insetLeft = frame.left - this.mDisplayFrame.left;
        int insetTop = frame.top - this.mDisplayFrame.top;
        int insetRight = this.mDisplayFrame.right - frame.right;
        int insetBottom = this.mDisplayFrame.bottom - frame.bottom;
        return this.mRoundedCorners.inset(insetLeft, insetTop, insetRight, insetBottom);
    }

    private PrivacyIndicatorBounds calculateRelativePrivacyIndicatorBounds(Rect frame) {
        if (this.mDisplayFrame.equals(frame)) {
            return this.mPrivacyIndicatorBounds;
        }
        if (frame == null) {
            return null;
        }
        int insetLeft = frame.left - this.mDisplayFrame.left;
        int insetTop = frame.top - this.mDisplayFrame.top;
        int insetRight = this.mDisplayFrame.right - frame.right;
        int insetBottom = this.mDisplayFrame.bottom - frame.bottom;
        return this.mPrivacyIndicatorBounds.inset(insetLeft, insetTop, insetRight, insetBottom);
    }

    private DisplayShape calculateRelativeDisplayShape(Rect frame) {
        if (this.mDisplayFrame.equals(frame)) {
            return this.mDisplayShape;
        }
        if (frame == null) {
            return DisplayShape.NONE;
        }
        return this.mDisplayShape.setOffset(-frame.left, -frame.top);
    }

    public Insets calculateInsets(Rect frame, int types, boolean ignoreVisibility) {
        Insets insets = Insets.NONE;
        for (int i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource source = this.mSources.valueAt(i);
            if ((source.getType() & types) == 0) continue;
            insets = Insets.max(source.calculateInsets(frame, ignoreVisibility), insets);
        }
        return insets;
    }

    public Insets calculateInsets(Rect frame, int types, int requestedVisibleTypes) {
        Insets insets = Insets.NONE;
        for (int i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource source = this.mSources.valueAt(i);
            if ((source.getType() & types & requestedVisibleTypes) == 0) continue;
            insets = Insets.max(source.calculateInsets(frame, true), insets);
        }
        return insets;
    }

    public Insets calculateVisibleInsets(Rect frame, int windowType, int windowingMode, int softInputMode, int windowFlags) {
        if (InsetsState.clearsCompatInsets(windowType, windowFlags, windowingMode)) {
            return Insets.NONE;
        }
        int softInputAdjustMode = softInputMode & 0xF0;
        int visibleInsetsTypes = softInputAdjustMode != 48 ? WindowInsets.Type.systemBars() | WindowInsets.Type.ime() : WindowInsets.Type.systemBars();
        Insets insets = Insets.NONE;
        for (int i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource source = this.mSources.valueAt(i);
            if ((source.getType() & visibleInsetsTypes) == 0) continue;
            insets = Insets.max(source.calculateVisibleInsets(frame), insets);
        }
        return insets;
    }

    public int calculateUncontrollableInsetsFromFrame(Rect frame) {
        int blocked = 0;
        for (int i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource source = this.mSources.valueAt(i);
            if (InsetsState.canControlSource(frame, source)) continue;
            blocked |= source.getType();
        }
        return blocked;
    }

    private static boolean canControlSource(Rect frame, InsetsSource source) {
        Insets insets = source.calculateInsets(frame, true);
        Rect sourceFrame = source.getFrame();
        int sourceWidth = sourceFrame.width();
        int sourceHeight = sourceFrame.height();
        return insets.left == sourceWidth || insets.right == sourceWidth || insets.top == sourceHeight || insets.bottom == sourceHeight;
    }

    private void processSource(InsetsSource source, Rect relativeFrame, boolean ignoreVisibility, Insets[] typeInsetsMap, SparseIntArray idSideMap, boolean[] typeVisibilityMap) {
        Insets insets = source.calculateInsets(relativeFrame, ignoreVisibility);
        int type = source.getType();
        this.processSourceAsPublicType(source, typeInsetsMap, idSideMap, typeVisibilityMap, insets, type);
        if (type == 32) {
            this.processSourceAsPublicType(source, typeInsetsMap, idSideMap, typeVisibilityMap, insets, 16);
        }
        if (type == 4) {
            this.processSourceAsPublicType(source, typeInsetsMap, idSideMap, typeVisibilityMap, insets, 16);
            this.processSourceAsPublicType(source, typeInsetsMap, idSideMap, typeVisibilityMap, insets, 32);
            this.processSourceAsPublicType(source, typeInsetsMap, idSideMap, typeVisibilityMap, insets, 64);
        }
    }

    private void processSourceAsPublicType(InsetsSource source, Insets[] typeInsetsMap, SparseIntArray idSideMap, boolean[] typeVisibilityMap, Insets insets, int type) {
        int insetSide;
        int index = WindowInsets.Type.indexOf(type);
        Insets existing = typeInsetsMap[index];
        typeInsetsMap[index] = existing == null ? insets : Insets.max(existing, insets);
        if (typeVisibilityMap != null) {
            typeVisibilityMap[index] = source.isVisible();
        }
        if (idSideMap != null && (insetSide = InsetsState.getInsetSide(insets)) != 5) {
            idSideMap.put(source.getId(), insetSide);
        }
    }

    static int getInsetSide(Insets insets) {
        if (Insets.NONE.equals(insets)) {
            return 4;
        }
        if (insets.left != 0) {
            return 0;
        }
        if (insets.top != 0) {
            return 1;
        }
        if (insets.right != 0) {
            return 2;
        }
        if (insets.bottom != 0) {
            return 3;
        }
        return 5;
    }

    public InsetsSource getOrCreateSource(int id2, int type) {
        InsetsSource source = this.mSources.get(id2);
        if (source != null) {
            return source;
        }
        source = new InsetsSource(id2, type);
        this.mSources.put(id2, source);
        return source;
    }

    public InsetsSource peekSource(int id2) {
        return this.mSources.get(id2);
    }

    public int sourceIdAt(int index) {
        return this.mSources.keyAt(index);
    }

    public InsetsSource sourceAt(int index) {
        return this.mSources.valueAt(index);
    }

    public int sourceSize() {
        return this.mSources.size();
    }

    public boolean isSourceOrDefaultVisible(int id2, int type) {
        InsetsSource source = this.mSources.get(id2);
        return source != null ? source.isVisible() : (type & WindowInsets.Type.defaultVisible()) != 0;
    }

    public void setDisplayFrame(Rect frame) {
        this.mDisplayFrame.set(frame);
    }

    public Rect getDisplayFrame() {
        return this.mDisplayFrame;
    }

    public void setDisplayCutout(DisplayCutout cutout) {
        this.mDisplayCutout.set(cutout);
    }

    public DisplayCutout getDisplayCutout() {
        return this.mDisplayCutout.get();
    }

    public void getDisplayCutoutSafe(Rect outBounds) {
        outBounds.set(-100000, -100000, 100000, 100000);
        DisplayCutout cutout = this.mDisplayCutout.get();
        Rect displayFrame = this.mDisplayFrame;
        if (!cutout.isEmpty()) {
            if (cutout.getSafeInsetLeft() > 0) {
                outBounds.left = displayFrame.left + cutout.getSafeInsetLeft();
            }
            if (cutout.getSafeInsetTop() > 0) {
                outBounds.top = displayFrame.top + cutout.getSafeInsetTop();
            }
            if (cutout.getSafeInsetRight() > 0) {
                outBounds.right = displayFrame.right - cutout.getSafeInsetRight();
            }
            if (cutout.getSafeInsetBottom() > 0) {
                outBounds.bottom = displayFrame.bottom - cutout.getSafeInsetBottom();
            }
        }
    }

    public void setRoundedCorners(RoundedCorners roundedCorners) {
        this.mRoundedCorners = roundedCorners;
    }

    public RoundedCorners getRoundedCorners() {
        return this.mRoundedCorners;
    }

    public void setRoundedCornerFrame(Rect frame) {
        this.mRoundedCornerFrame.set(frame);
    }

    public void setPrivacyIndicatorBounds(PrivacyIndicatorBounds bounds) {
        this.mPrivacyIndicatorBounds = bounds;
    }

    public PrivacyIndicatorBounds getPrivacyIndicatorBounds() {
        return this.mPrivacyIndicatorBounds;
    }

    public void setDisplayShape(DisplayShape displayShape) {
        this.mDisplayShape = displayShape;
    }

    public DisplayShape getDisplayShape() {
        return this.mDisplayShape;
    }

    public void removeSource(int id2) {
        this.mSources.delete(id2);
    }

    public void removeSourceAt(int index) {
        this.mSources.removeAt(index);
    }

    public void setSourceVisible(int id2, boolean visible) {
        InsetsSource source = this.mSources.get(id2);
        if (source != null) {
            source.setVisible(visible);
        }
    }

    public void scale(float scale) {
        this.mDisplayFrame.scale(scale);
        this.mDisplayCutout.scale(scale);
        this.mRoundedCorners = this.mRoundedCorners.scale(scale);
        this.mRoundedCornerFrame.scale(scale);
        this.mPrivacyIndicatorBounds = this.mPrivacyIndicatorBounds.scale(scale);
        this.mDisplayShape = this.mDisplayShape.setScale(scale);
        for (int i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource source = this.mSources.valueAt(i);
            source.getFrame().scale(scale);
            Rect visibleFrame = source.getVisibleFrame();
            if (visibleFrame == null) continue;
            visibleFrame.scale(scale);
        }
    }

    public void set(InsetsState other) {
        this.set(other, false);
    }

    public void set(InsetsState other, boolean copySources) {
        this.mDisplayFrame.set(other.mDisplayFrame);
        this.mDisplayCutout.set(other.mDisplayCutout);
        this.mRoundedCorners = other.getRoundedCorners();
        this.mRoundedCornerFrame.set(other.mRoundedCornerFrame);
        this.mPrivacyIndicatorBounds = other.getPrivacyIndicatorBounds();
        this.mDisplayShape = other.getDisplayShape();
        this.mSources.clear();
        int size = other.mSources.size();
        for (int i = 0; i < size; ++i) {
            InsetsSource otherSource = other.mSources.valueAt(i);
            this.mSources.append(otherSource.getId(), copySources ? new InsetsSource(otherSource) : otherSource);
        }
    }

    public void set(InsetsState other, int types) {
        int i;
        this.mDisplayFrame.set(other.mDisplayFrame);
        this.mDisplayCutout.set(other.mDisplayCutout);
        this.mRoundedCorners = other.getRoundedCorners();
        this.mRoundedCornerFrame.set(other.mRoundedCornerFrame);
        this.mPrivacyIndicatorBounds = other.getPrivacyIndicatorBounds();
        this.mDisplayShape = other.getDisplayShape();
        if (types == 0) {
            return;
        }
        for (i = this.mSources.size() - 1; i >= 0; --i) {
            InsetsSource source = this.mSources.valueAt(i);
            if ((source.getType() & types) == 0) continue;
            this.mSources.removeAt(i);
        }
        for (i = other.mSources.size() - 1; i >= 0; --i) {
            InsetsSource otherSource = other.mSources.valueAt(i);
            if ((otherSource.getType() & types) == 0) continue;
            this.mSources.put(otherSource.getId(), otherSource);
        }
    }

    public void addSource(InsetsSource source) {
        this.mSources.put(source.getId(), source);
    }

    public static boolean clearsCompatInsets(int windowType, int windowFlags, int windowingMode) {
        return (windowFlags & 0x200) != 0 && windowType != 2013 && windowType != 2010 && !WindowConfiguration.inMultiWindowMode(windowingMode);
    }

    public void dump(String prefix, PrintWriter pw) {
        String newPrefix = prefix + "  ";
        pw.println(prefix + "InsetsState");
        pw.println(newPrefix + "mDisplayFrame=" + this.mDisplayFrame);
        pw.println(newPrefix + "mDisplayCutout=" + this.mDisplayCutout.get());
        pw.println(newPrefix + "mRoundedCorners=" + this.mRoundedCorners);
        pw.println(newPrefix + "mRoundedCornerFrame=" + this.mRoundedCornerFrame);
        pw.println(newPrefix + "mPrivacyIndicatorBounds=" + this.mPrivacyIndicatorBounds);
        pw.println(newPrefix + "mDisplayShape=" + this.mDisplayShape);
        int size = this.mSources.size();
        for (int i = 0; i < size; ++i) {
            this.mSources.valueAt(i).dump(newPrefix + "  ", pw);
        }
    }

    void dumpDebug(ProtoOutputStream proto, long fieldId) {
        long token = proto.start(fieldId);
        InsetsSource source = this.mSources.get(InsetsSource.ID_IME);
        if (source != null) {
            source.dumpDebug(proto, 2246267895809L);
        }
        this.mDisplayFrame.dumpDebug(proto, 1146756268034L);
        this.mDisplayCutout.get().dumpDebug(proto, 1146756268035L);
        proto.end(token);
    }

    public boolean equals(Object o) {
        return this.equals(o, false, false);
    }

    @VisibleForTesting
    public boolean equals(Object o, boolean excludingCaptionInsets, boolean excludeInvisibleImeFrames) {
        int thatIndex;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InsetsState state = (InsetsState)o;
        if (!(this.mDisplayFrame.equals(state.mDisplayFrame) && this.mDisplayCutout.equals(state.mDisplayCutout) && this.mRoundedCorners.equals(state.mRoundedCorners) && this.mRoundedCornerFrame.equals(state.mRoundedCornerFrame) && this.mPrivacyIndicatorBounds.equals(state.mPrivacyIndicatorBounds) && this.mDisplayShape.equals(state.mDisplayShape))) {
            return false;
        }
        SparseArray<InsetsSource> thisSources = this.mSources;
        SparseArray<InsetsSource> thatSources = state.mSources;
        if (!excludingCaptionInsets && !excludeInvisibleImeFrames) {
            return thisSources.contentEquals(thatSources);
        }
        int thisSize = thisSources.size();
        int thatSize = thatSources.size();
        int thisIndex = 0;
        for (thatIndex = 0; thisIndex < thisSize && thatIndex < thatSize; ++thisIndex, ++thatIndex) {
            InsetsSource thisSource = thisSources.valueAt(thisIndex);
            while (thisSource != null && (excludingCaptionInsets && thisSource.getType() == WindowInsets.Type.captionBar() || excludeInvisibleImeFrames && thisSource.getType() == WindowInsets.Type.ime() && !thisSource.isVisible())) {
                thisSource = ++thisIndex < thisSize ? thisSources.valueAt(thisIndex) : null;
            }
            InsetsSource thatSource = thatSources.valueAt(thatIndex);
            while (thatSource != null && (excludingCaptionInsets && thatSource.getType() == WindowInsets.Type.captionBar() || excludeInvisibleImeFrames && thatSource.getType() == WindowInsets.Type.ime() && !thatSource.isVisible())) {
                thatSource = ++thatIndex < thatSize ? thatSources.valueAt(thatIndex) : null;
            }
            if (Objects.equals(thisSource, thatSource)) continue;
            return false;
        }
        return thisIndex >= thisSize && thatIndex >= thatSize;
    }

    public int hashCode() {
        return Objects.hash(this.mDisplayFrame, this.mDisplayCutout, this.mSources.contentHashCode(), this.mRoundedCorners, this.mPrivacyIndicatorBounds, this.mRoundedCornerFrame, this.mDisplayShape);
    }

    public InsetsState(Parcel in) {
        this.mSources = this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        this.mDisplayFrame.writeToParcel(dest, flags);
        this.mDisplayCutout.writeToParcel(dest, flags);
        dest.writeTypedObject(this.mRoundedCorners, flags);
        this.mRoundedCornerFrame.writeToParcel(dest, flags);
        dest.writeTypedObject(this.mPrivacyIndicatorBounds, flags);
        dest.writeTypedObject(this.mDisplayShape, flags);
        int size = this.mSources.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dest.writeTypedObject(this.mSources.valueAt(i), flags);
        }
    }

    public SparseArray<InsetsSource> readFromParcel(Parcel in) {
        SparseArray<InsetsSource> sources;
        this.mDisplayFrame.readFromParcel(in);
        this.mDisplayCutout.readFromParcel(in);
        this.mRoundedCorners = in.readTypedObject(RoundedCorners.CREATOR);
        this.mRoundedCornerFrame.readFromParcel(in);
        this.mPrivacyIndicatorBounds = in.readTypedObject(PrivacyIndicatorBounds.CREATOR);
        this.mDisplayShape = in.readTypedObject(DisplayShape.CREATOR);
        int size = in.readInt();
        if (this.mSources == null) {
            sources = new SparseArray(size);
        } else {
            sources = this.mSources;
            sources.clear();
        }
        for (int i = 0; i < size; ++i) {
            InsetsSource source = in.readTypedObject(InsetsSource.CREATOR);
            sources.append(source.getId(), source);
        }
        return sources;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ");
        int size = this.mSources.size();
        for (int i = 0; i < size; ++i) {
            joiner.add(this.mSources.valueAt(i).toString());
        }
        return "InsetsState: {mDisplayFrame=" + this.mDisplayFrame + ", mDisplayCutout=" + this.mDisplayCutout + ", mRoundedCorners=" + this.mRoundedCorners + "  mRoundedCornerFrame=" + this.mRoundedCornerFrame + ", mPrivacyIndicatorBounds=" + this.mPrivacyIndicatorBounds + ", mDisplayShape=" + this.mDisplayShape + ", mSources= { " + joiner + " }";
    }

    public static void traverse(InsetsState state1, InsetsState state2, OnTraverseCallbacks cb) {
        int index2;
        cb.onStart(state1, state2);
        int size1 = state1.sourceSize();
        int size2 = state2.sourceSize();
        int index1 = 0;
        for (index2 = 0; index1 < size1 && index2 < size2; ++index1, ++index2) {
            int id1 = state1.sourceIdAt(index1);
            int id2 = state2.sourceIdAt(index2);
            while (id1 != id2) {
                if (id1 < id2) {
                    cb.onIdNotFoundInState2(index1, state1.sourceAt(index1));
                    if (++index1 >= size1) break;
                    id1 = state1.sourceIdAt(index1);
                    continue;
                }
                cb.onIdNotFoundInState1(index2, state2.sourceAt(index2));
                if (++index2 >= size2) break;
                id2 = state2.sourceIdAt(index2);
            }
            if (index1 >= size1 || index2 >= size2) break;
            InsetsSource source1 = state1.sourceAt(index1);
            InsetsSource source2 = state2.sourceAt(index2);
            cb.onIdMatch(source1, source2);
        }
        while (index2 < size2) {
            cb.onIdNotFoundInState1(index2, state2.sourceAt(index2));
            ++index2;
        }
        while (index1 < size1) {
            cb.onIdNotFoundInState2(index1, state1.sourceAt(index1));
            ++index1;
        }
        cb.onFinish(state1, state2);
    }

    public static interface OnTraverseCallbacks {
        default public void onStart(InsetsState state1, InsetsState state2) {
        }

        default public void onIdMatch(InsetsSource source1, InsetsSource source2) {
        }

        default public void onIdNotFoundInState1(int index2, InsetsSource source2) {
        }

        default public void onIdNotFoundInState2(int index1, InsetsSource source1) {
        }

        default public void onFinish(InsetsState state1, InsetsState state2) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalInsetsSide {
    }
}

